(*  
   File:        ToyVCGtest.ML
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGtest7.thy,v 1.1 2003/06/24 23:21:37 da Exp $

   More tests of the VCG (ping).
   
*)

theory ToyVCGtest7 = ToyVCG0 + ToyPrelude + ToyHLbasic0:

section {* Testing the VCGen *}

subsection {* ping example *}

(* --------------------------------------------------------------------------- *)
(* Code                                                                        *)
(* --------------------------------------------------------------------------- *)

(*
  class PingClass = field Pong pong  
               field int count
               method ping () { count := count -1; 
                                if count > 0  PingClass.ping() else return ()
*)

locale ping_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   z1        :: iname
    and	   q         :: iname
    and	   zero      :: iname
    and    l1        :: locn
    and    N         :: nat
    and    T         :: nat
    and	   count     :: ifldname
    and	   pingfn    :: funame
    and    PingClass :: cname 
    and	   pingBody  :: expr
  defines "pingBody \<equiv>  LET 
                m  = self\<bullet>count ;
                n  = m :-- ;
                z1 = self\<bullet>count := n ; 
                zero = 0\<^sup>z ;
                q = n :> zero
              IN
                IF q 
                  THEN CALL pingfn
                  ELSE n\<^sup>I
              END"
  assumes  pingfnbody:  "funtable pingfn = pingBody"
      and  vardistinct: "distinct [m,n,q,zero]"
      and  pingClass:   "classtable PingClass = \<lparr> iflds = [count], rflds = [], meths = \<lambda> mn. K mn \<rparr>"
      and  pingwfmeasure: "fun_wfmeasure_table pingfn = inv_image less_than (\<lambda> s. nat (get_ivar s n))"

declare (in ping_example) pingfnbody [simp]
declare (in ping_example) pingBody_def [simp]

lemma (in ping_example) 
   "\<Turnstile> {(z,s). 0 < (z<n>) \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> 
          s\<lless>l1\<ggreater> = Some (PingClass, emptyi(count:=(z<n>)), emptyr)}	
	pingBody
      {(z,s,v). v = IVal 0}"
apply (insert vardistinct)
apply simp
apply hoare2_simp
apply (tactic {* all_tac *})
(*
apply auto
False 
oops
*)
defer 1
apply (rule_tac x="l1" in exI)
apply (rule conjI)
defer 1
apply (rule_tac x="SwapClass" in exI)
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply rule
apply clarsimp
defer 1 
apply rule
apply rule
apply clarsimp
defer 1
apply (rule_tac x="SwapClass" in exI)
apply (rule_tac x="emptyi(count:=(z<n>))" in exI)
apply (rule_tac x="emptyr" in exI)
apply rule
apply clarsimp
defer 1
apply rule
defer 1
apply (simp add: inv_image_def)
defer 1
apply rule
apply rule
apply clarsimp
defer 1
apply (rule_tac x="l1" in exI)
apply rule
apply clarsimp
defer 1
apply (rule_tac x="SwapClass" in exI)
apply (rule_tac x="emptyi(count:=(z<n>))" in exI)
apply (rule_tac x="emptyr" in exI)
apply rule
defer 1
apply rule
defer 1
apply auto
oops

lemma (in ping_example) 
   "\<Turnstile> {((z::int),s). 0 < z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> 
          s\<lless>l1\<ggreater> = Some (PingClass, emptyi(count:=z), emptyr)}	
	pingBody
      {((z::int),s,v). v = IVal 0}"
apply (insert vardistinct)
apply simp
apply hoare_rec_simp
apply clarsimp
oops

end