(*  
   File:        ToyVCGtest4.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGtest4.thy,v 1.1 2003/06/24 23:24:20 da Exp $

   More tests of the VCG (factorial). 
*)

theory ToyVCGtest4 = ToyVCG1 + ToyPrelude + ToyHLbasic1:

section {* Testing the VCGen: factorial *}

consts facspec :: "nat \<Rightarrow> nat"
primrec (* recdef   facspec "measure (\<lambda> n. n)" *)
 "facspec 0 = (1::nat)"
 "facspec (Suc n) = (facspec n) * (Suc n)"

(*
consts facspec_int :: "int \<Rightarrow> int"
recdef facspec_int "measure (\<lambda> n. n)"
 "facspec_int = \<lambda> n . if (0 < n) then (n * (facspec_int (n - 1))) else (1::int)"
*)

locale fac_example =
 fixes n :: iname
  and  m :: iname
  and  q :: iname
  and  fac ::funame
  and  facBody :: expr
defines 
"facBody \<equiv> LET 
              m = m :* n ;
              n = n :-- ;
              q = n :0?
            IN 
              IF q
                THEN m\<^sup>I
                ELSE (CALL fac)
            END"
assumes vardistinct:   "distinct [n,m,q]"
    and bonzo22:       "m \<noteq> n" 
    and fac_fnbody:    "funtable fac == facBody"
    and fac_wfmeasure: "fun_wfmeasure_table fac == inv_image less_than (\<lambda>s . nat (s<n>))"
    and fac_preinv:  "fun_preassn_table fac == {(z,s). 0 < z<m> \<and> 0 < z<n> \<and> s<m>=z<m> \<and> s<n>=z<n>}"
    and fac_postinv: "fun_postassn_table fac == {(z,s,v). v = IVal ((z<m>) * (int (facspec (nat (z<n>)))))}"

declare (in fac_example) fac_preinv    [simp]
declare (in fac_example) fac_postinv   [simp]
declare (in fac_example) fac_fnbody    [simp]
declare (in fac_example) facBody_def   [simp]
declare (in fac_example) fac_wfmeasure [simp]

subsubsection {* concrete input *}

(*
lemma (in fac_example) 
   "[| \<Turnstile> (fun_preassn_table fac) (CALL fac) (fun_postassn_table fac) |] ==>
    \<Turnstile> {(z,s). s<n> = 5 \<and> s<m> = 1}
	facBody
      {(z,s,v). v = IVal (int 120)}"
apply (insert vardistinct)
apply simp
apply hoare_rec
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
oops
*)

(* concrete input *)
(*
lemma (in fac_example) 
   "\<Turnstile> {(z,s). s<n> = 5 \<and> s<m> = 1}
	facBody
      {(z,s,v). v = IVal (int 120)}"
apply (insert vardistinct)
apply (insert bonzo22)
apply simp
apply hoare_simp
apply auto
*)
(*
apply hoare_step
defer 1
apply hoare_step
defer 1
apply hoare_step
defer 1
apply hoare_step
defer 1
apply hoare_step
apply simp
defer 1
defer 1
defer 1
apply hoare_step
apply simp
defer 1
apply hoare_step
defer 1
defer 1
apply hoare_step
apply auto
*)

lemma (in fac_example) 
 bonzo13: "wf (inv_image less_than (\<lambda>s. nat (s<n>)))"
by (rule wf_inv_image, rule wf_less_than)

lemma (in fac_example) 
   "[| \<Turnstile> (fun_preassn_table fac) (CALL fac) (fun_postassn_table fac) |] ==>
    relTakestimelt (emptyState (|istore := (fun_upd (istore emptyState) n 5)|))	99 facBody"
apply (insert vardistinct)
apply (simp add: relTakestimelt_def)
apply hoare_rec_simp
oops

lemma (in fac_example) 
   "relTakestimelt (emptyState (|istore := (fun_upd (istore emptyState) n 5)|))	99 facBody"
apply (insert vardistinct)
apply (simp add: relTakestimelt_def)
apply hoare_simp
apply auto
defer 1
(* apply (simp add: inv_image_def less_than_def pred_nat_def trancl_def rel_comp_def) *)
oops
(* leaves a false equality over entire states behind *)

subsubsection {* abstracted over input *}

(* 
 stupid lemmas needed for nat-int conversion
 unproven so far
*)

lemma (in fac_example) bonzo_1066:
 "[| 0 < N ; 0 < M |] ==>
  M * N * int (facspec (nat (N - 1))) = M * int (facspec (nat N))"
sorry

lemma (in fac_example) bonzo_1067:
 "[| 0 < (N::int) ; 0 < M |] ==> 0 < M * N"
sorry

lemma (in fac_example) bonzo_1068:
 "[| 0 < (N::int) ; N - 1 \<noteq> 0 |] ==> 0 < N - 1"

apply arith
done

lemma (in fac_example) fact_is_cool2:
   "\<Turnstile> {(z,s). 0 < z<n> \<and> s<n> = z<n> \<and> s<m> = z<m> \<and> 0 < z<m>}
	(CALL fac)
      {(z,s,v). v = IVal ((z<m>) * int (facspec (nat (z<n>))))}"
apply (insert vardistinct bonzo22)
apply simp
apply hoare1_simp
apply auto
apply (erule_tac x="tickn 14
                     (ivarupdate
                      (ivarupdate (ivarupdate (incrcallcount s') m ((z<m>) * (z<n>))) n
                       (z<n> - 1))
                      q 0)" in allE)
apply clarsimp
defer 1
apply (rule_tac x="tickn 14
                     (ivarupdate
                      (ivarupdate (ivarupdate (incrcallcount s') m ((z<m>) * (z<n>))) n
                       (z<n> - 1))
                      q 0)" in exI)
apply clarsimp
apply (rule_tac x="tickn 14
                     (ivarupdate
                      (ivarupdate (ivarupdate (incrcallcount s') m ((z<m>) * (z<n>))) n
                       (z<n> - 1))
                      q 0)" in exI)
apply clarsimp
apply rule
apply (rotate_tac 1)
apply (erule thin_rl)
apply (simp add: bonzo_1068)
apply rule
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (simp add: bonzo_1067)
apply (simp add: inv_image_def)
apply (subgoal_tac "(tickn 14
             (ivarupdate
               (ivarupdate (ivarupdate (incrcallcount s') m ((z<m>) * (z<n>))) n
                 (z<n> - 1))
               q 0),
            s')
           \<in> inv_image less_than (\<lambda> s. nat (s<n>))")
apply (drule mp)
apply clarsimp
apply rule
apply (simp add: bonzo_1068)
apply (simp add: bonzo_1067)
apply (simp add: bonzo_1066)
apply (simp add: inv_image_def)
done
(* hurrayy *)

lemma (in fac_example) 
   "\<Turnstile> {(z,s). 0 < z<n> \<and> s<n> = z<n> \<and> s<m> = z<m> \<and> 0 < z<m>}
	(CALL fac)
      {(z,s,v). v = IVal ((z<m>) * int (facspec (nat (z<n>))))}"
apply (insert vardistinct bonzo22)
apply simp
apply hoare2_simp
(* 
apply (tactic {* all_tac *})
apply auto
done
*)
(*
defer 1
apply (rotate_tac -1)
apply (erule_tac x="a" in allE)
apply (rotate_tac -1)
apply (erule_tac x="v" in allE)
apply fastsimp
oops
*)
(*
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
defer 1
*)
(*
apply (tactic {* assume_tac 1 *})
ORELSE
*)
oops

(*
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HSP") 1 *})
apply (tactic {* rtac (thm "HKleymanAdapt") 1 *})
apply (tactic {* rtac (thm "HCall0") 1 *})
apply (tactic {* rtac allI 1 *})
apply simp
apply hoare2_simp
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply (tactic {* assume_tac 1 *})
*)
(* ORELSE 
apply (tactic {* rtac (thm "HSP") 1 *})
apply (tactic {* rtac (thm "HKleymanAdapt1") 1 *})
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HCall0") 1 *})
apply (tactic {* rtac allI 1 *})
apply simp
*)
(*
defer 1
apply (rule subsetI)
apply simp
defer 1
apply hoare2_step
defer 1
apply hoare2_step
apply hoare2_step
apply hoare2_step
apply clarsimp
apply auto
oops
*)

(*
apply (tactic {* trace_goalno_tac (rtac (thm "HKleymanAdapt")) 1 *})
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* trace_goalno_tac (rtac (thm "HCall0")) 1 *})
apply (tactic {* rtac allI 1 *})
*)

(* VCG w/ inv *)
lemma (in fac_example) fact_is_cool:
   "[| \<Turnstile> fun_preassn_table fac CALL fac fun_postassn_table fac |] ==>
    \<Turnstile> {(z,s). 0 < z<n> \<and> s<n> = z<n> \<and> s<m> = 1}
	facBody
      {(z,s,v). v = IVal (int (facspec (nat (z<n>))))}"
apply (insert vardistinct bonzo22)
apply simp
apply hoare_rec_simp
apply auto
defer 1
apply (erule thin_rl)
oops
(*
apply (rule_tac x="ivarupdate (ivarupdate a m (a<n>)) n (a<n> - 1)" in exI)
apply auto
defer 1
apply arith
(* both subgoals should be true; remains to be proven
   needs right nat<->int rules to make it finish *)
oops
*)
(* JUNK
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
*)
(* apply hoare_rec_step *)
(* apply (tactic {* HoareInst "HCallAux0" "Q'" "fun_postassn_table" 1 *}) *)
(* apply (tactic {* res_inst_tac [("Q'","fun_postassn_table fac")] (thm "HCallAux0") 1 *})*)
(*
apply (tactic {* resolve_tac [(thm "HCallAux0")] 1 *})
apply (tactic {* instantiate_tac [("Q'10","fun_postassn_table fac")] *})
*)
(* apply hoare_rec_step *)

section {* \texttt{count} *}

constdefs iszero::"int \<Rightarrow> int"
"iszero x == (if x = 0 then 1 else 0)"

locale count_example =
(*fun countdown(n) = let n = n -1
                     in if n=0 then 0 else countdown(n) end
 *)
  fixes    m :: iname
    and	   n :: iname
    and	   b :: iname
    and	   countfn    :: funame
    and	   countfnbdy :: expr
  defines  "countfnbdy == LET m = expr.Int 1;
			      n = Primop (% x y. x-y) n m;
			      b = Primop (% x y. if x = 0 then 1 else 0) n n 
			   IN 

			      IF b THEN expr.Int 0 ELSE CALL countfn 
  			   END"
  assumes  countfnbdy[simp]:  "funtable countfn = countfnbdy"
      and  wfmeasure [simp]:  "fun_wfmeasure_table countfn = inv_image less_than (\<lambda> s. nat (get_ivar s n))"
      and  vardistinct:       "distinct [n,m,b]"
      and  count_preinv: "fun_preassn_table countfn == {(z,s). 0 < z<n> \<and> z<n> = s<n>}"
      and  count_postinv: "fun_postassn_table countfn == {(z,s,v). v=IVal 1 \<and> (s<n>=1)}"

declare (in count_example) countfnbdy_def [simp]  (* unfold def *)
declare (in count_example) count_preinv [simp]
declare (in count_example) count_postinv [simp]

lemma (in count_example) 
   "\<Turnstile> {(z,s). 0 < (s<n>)}	
	(CALL countfn) 
      {(z,s,v). v=IVal 0 \<and> (s<n>=0)}"
apply (insert vardistinct)
apply hoare2_simp
(* single-stepping through a CALL 
apply (rule "HSP")
apply (tactic {* rtac (thm "HKleymanAdapt") 1 *})
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HCall0") 1 *})
apply (tactic {* rtac allI 1 *})
*)
apply (erule_tac thin_rl)  (* remove used IH assumption *)
apply rule				     (* conjI *)
apply rule				     (* impI *)
defer 1
apply clarsimp
apply rule				     (* conjI *)
apply rule				     (* impI *)
defer 1
apply rule				     (* conjI *)
defer 1
defer 1
apply clarsimp
apply (rule subsetI)
apply (rule_tac x="tickn 12
                   (ivarupdate
                     (ivarupdate (ivarupdate (incrcallcount s') m 1) n (s'<n> - 1)) b
                     0)" in exI)
apply arith				     (* arith *)
apply (simp add: inv_image_def)		     (* termination *)
apply (erule thin_rl, insert wfmeasure, simp)
apply (rule wf_inv_image, rule wf_less_than) (* WF measure *)
done

end
