(*  
   File:        ToyVCGtest3.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGtest3.thy,v 1.1 2003/06/24 23:25:29 da Exp $

   More tests of the VCG (dvd). 
*)

theory ToyVCGtest3 = ToyVCG0 + ToyPrelude + ToyHLbasic0:

section {* Testing the VCGen *}

subsection {* Hans-Wolfgang's ExDvD example *}

(*
  Example: dvd m n ... tests whether m divides n, using a running potential divisor
  Description: Direct recursion; will not terminate if m does not divide n
*)

(* doesn't work yet *)
(* needs different type for aux vars *)

locale dvd_example =
  fixes    mydvd :: funame
    and	   m  :: iname 
    and    n  :: iname 
    and    r  :: iname 
    and    x  :: iname 
    and    y  :: iname 
    and    z  :: iname
    and    q1 :: iname 
    and    q2 :: iname 
    and    q3 ::iname
    and	   even   :: mname
    and    FooClass :: cname
    and	   dvdBody :: expr
  defines "dvdBody \<equiv> 
             LET
               z  =  r :++  ;
               r  =  z\<^sup>I ;
               y  =  m :* r ; 
               q1 =  y :== n ;
               q2 =  r :== n ;
               q3 =  q1 :| q2 
             IN
               IF q3 
                 THEN q1\<^sup>I
                 ELSE CALL mydvd
             END"
  assumes  vardistinct:   "distinct [m,n,r,x,y,z,q1,q2,q3]"
      and  dvdfnbody:     "funtable mydvd = dvdBody"
      and  dvd_wfmeasure: "fun_wfmeasure_table mydvd = inv_image less_than (\<lambda> s . nat ((s<n>) - (s<r>)))" 
      and  dvd_preinv:    "fun_preassn_table mydvd = {(z,s). s<m>=z<m> \<and> s<n>=z<n> \<and> s<r>=z<r>}"
      and  dvd_postinv:   "fun_postassn_table mydvd = {(z,s,v). (\<exists> k. (z<r>) < k \<and> ((z<m>)*k = (z<n>)) \<longrightarrow> (v=IVal 1)) \<and> \<not> (\<exists> k. (z<r>) < k \<and> ((z<m>)*k = (z<n>)) \<longrightarrow> (v=IVal 0))}"


(*
      and  dvd_postinv:   "fun_postassn_table mydvd == {(z,s,v). (z<m>*z<r>=z<n>) \<longrightarrow> (v=IVal 1)) \<and> ((z<n> < z<m>*z<r>) \<longrightarrow> (v=IVal 0))}" 
*)
(*
      and  dvd_inv: "fun_assn_table mydvd = (
             {((M,N,R), s). s<m>=M \<and> s<n>=N \<and> s<r>=R},
             {((M,N,R), s, v). (((M*R)=N) \<longrightarrow> (v=IVal 1)) \<and> ((N<(M*R)) \<longrightarrow> (v=IVal 0))} )" 
*)
(*             {((M,N), s, v). v = IVal (b2i (M dvd N))} *)

declare (in dvd_example) dvdfnbody    [simp]
declare (in dvd_example) dvdBody_def  [simp]
(*
declare (in dvd_example) dvd_inv[simp]
*)
declare (in dvd_example) dvd_preinv   [simp]
declare (in dvd_example) dvd_postinv  [simp]

(* using hoare_rec to pull out the invariant *)
lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table mydvd) ;
       \<Turnstile> (fun_preassn_table mydvd) (CALL mydvd) (fun_postassn_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=2 \<and> s<n>=4 \<and> s<r>=1}	
      dvdBody
      {(z,s,v). v = IVal 1}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_rec_simp
done

(* hmm, fun_assn_table lookup should have been expanded by now *)
(* to single-step do this:
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
*)
(* apply hoare_rec_step *)
(*
apply (tactic {* res_inst_tac [("Q'" , "fun_postassn_table mydvd")] (thm "HCallAux0") 1  *})
apply (tactic {* res_inst_tac [( "P'" , "fun_preassn_table mydvd")] (thm  "HSP") 1 *})  
apply simp
*)
(* tables do not expand *)

(* petaQ
apply (simp add: dvd_preinv dvd_postinv dvdfnbody)
defer 1
defer 1
apply (rule allI)
apply (simp)
apply hoare_rec

apply (simp add: dvd_preinv dvd_postinv dvdfnbody)
apply (subgoal_tac "funtable mydvd = dvdBody")
apply (simp)
apply (subgoal_tac "fun_preassn_table mydvd = {((M,N,R), s). s<m>=M \<and> s<n>=N \<and> s<r>=R}")
apply (rotate_tac 2)
apply simp
apply assumption
defer 1
apply (simp add: dvd_inv dvdfnbody)
done
*)

(* use tactic w/o invariant *)
lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table mydvd) ;
       \<Turnstile> (fun_preassn_table mydvd) (CALL mydvd) (fun_postassn_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=2 \<and> s<n>=4 \<and> s<r>=1}	
      dvdBody
      {(z,s,v). v = IVal 1}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_simp
apply fastsimp
done
(* yes, 2 divides 4, big surprise *)

(* use tactic w/o invariant *)
lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table mydvd) ;
       \<Turnstile> (fun_preassn_table mydvd) (CALL mydvd) (fun_postassn_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=2 \<and> s<n>=4 \<and> s<r>=1}	
      dvdBody
      {(z,s,v). v = IVal 1}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_rec_simp
done
(* yes, 2 divides 4, big surprise *)

(* std *)
lemma (in dvd_example) 
   "\<Turnstile> {(z,s). s<m>=z<m> \<and> s<n>=z<n> \<and> z<m> < z<n> \<and> s<r>=1}	
      (CALL mydvd)
      {(z,s,v). ((z<m> dvd z<n>) --> v = IVal 0) \<and> (\<not> (z<m> dvd z<n>) --> v = IVal 0)}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
(* apply hoare3_simp *)
apply (tactic {* all_tac *})
(* apply hoare3_step *)
apply (tactic {* all_tac *})
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HSP") 1 *})
apply (tactic {* rtac (thm "HKleymanAdapt00") 1 *})
apply simp
apply hoare3_step
defer 1
apply hoare3_step
defer 1
apply hoare3_step
defer 1
apply hoare3_step
defer 1
apply hoare3_step
defer 1
apply hoare3_step
defer 1
apply hoare3_step
defer 1
apply (tactic {* all_tac *})
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HSP") 1 *})
apply (tactic {* rtac (thm "HKleymanAdapt00") 1 *})
apply simp
apply auto
(* body unfolded again; check why ind hyp didn't apply *)
oops

(* w/o invariant *)
lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table mydvd) ;
       \<forall> M R. \<Turnstile> (fun_preassn_table mydvd) (CALL mydvd) (fun_postassn_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=z<m> \<and> s<n>=z<m>+1 \<and> s<r>=1}	
      dvdBody
      {(z,s,v). v = IVal 0}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_rec_simp
oops

lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table const) ; wf (fun_wfmeasure_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=3 \<and> s<n>=4 \<and> s<r>=1}	
      dvdBody
      {(z,s,v). v = IVal 0}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_simp
defer 1
apply clarsimp
apply arith?
apply simp?
apply (rule conjI)
apply (rule impI)
apply (rule conjI)
defer 1
defer 1
apply (rule impI)
apply (rule conjI)
apply arith?
defer 1
apply (rule impI)
apply (rule conjI)
apply auto
(* False, bad *)
(* no, 3 does not divide 4, wow, we got to write a paper about this *)
oops

lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=3 \<and> s<n>=4 \<and> s<r>=1}	
      dvdBody
      {(z,s,v). v = IVal 1}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_simp
defer 1
apply fastsimp
apply (simp)
(* False, good! *)
oops

end
