(*  
   File:        $RCSfile: ToyVCGtest2.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGtest2.thy,v 1.1 2003/06/24 23:22:19 da Exp $

   Some tests of the VCG (decN).
*)

theory ToyVCGtest = ToyVCG0 + ToyPrelude + ToyHLbasic0:

section {* \texttt{decN}: decrement a field *}

locale decN_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   q         :: iname
    and	   zero      :: iname
    and    N         :: int    
    and	   decN      :: funame
    and	   decNBody  :: expr
    and    const     :: funame
    and	   constBody  :: expr
    and    constPreInv  :: "a_preassn"
    and    constPostInv :: "a_postassn"
  defines "decNBody \<equiv>  LET 
                m    = n :-- ;
                zero = 0\<^sup>z ;
                q    = n :> zero
              IN
                IF q 
                  THEN m\<^sup>I
                  ELSE zero\<^sup>I
              END"
  and     "constBody \<equiv> IVar n"
  and     "constPreInv == {(z, s). (s<n>) = (z<n>)}"
  and     "constPostInv == {(z, s, v). v = IVal (z<n>) \<and> (s<n>) = (z<n>)}"
  assumes  vardistinct: "distinct [n,m,zero,q]"
      (* function tables *)
      and  decN_fnbdy:  "funtable decN = decNBody"
      and  const_fnbdy: "funtable const = constBody "
      (* measures *)
      and  dec_wfmeasure: "fun_wfmeasure_table dec = inv_image less_than (the_ifld self (z<n>))"
      and  const_wfmeasure: "fun_wfmeasure_table const = {}"

declare (in decN_example) decNBody_def[simp]
declare (in decN_example) decN_fnbdy[simp]
declare (in decN_example) constBody_def[simp]
declare (in decN_example) const_fnbdy[simp]
declare (in decN_example) dec_wfmeasure[simp]
declare (in decN_example) const_wfmeasure[simp]

lemma (in decN_example) 
   "\<Turnstile> {(z,s). 0 < z<n> \<and> s<n> = z<n>}
      decNBody
      {(z,s,v). v = IVal ((z<n>) - 1) }"
apply (insert vardistinct)
apply (simp)
apply hoare2_simp
done

lemma (in decN_example) 
   "\<forall> N. \<Turnstile> {(z,s). 0 < z<n> \<and> s<n> = z<n>}
      decNBody
      {(z,s,v). v = IVal ((z<n>) - 1) }"
apply (insert vardistinct)
apply (rule allI)
apply (simp)
apply hoare_check_expr
apply hoare_simp
done

(* resource property *)
lemma (in decN_example) 
 "\<forall> T . \<Turnstile> {(z,s). clock s = clock z \<and> s<n> = z<n>} 
                decNBody
                {(z,s,v). clock s < (clock z)+99}"
apply (insert vardistinct)
apply (rule allI)
apply (simp)
apply hoare_simp
done
(* Note the shattering earth while producing this result *)

subsection {* const and dec after field manipulation *}

(* std: leaves subgoal behind *)
lemma (in decN_example) 
   "\<Turnstile> {(z, s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr)}
      LET
        n = 4\<^sup>z ; 
        z2 = (self\<bullet>count := n)
      IN
        CALL const
      END
      {(z,s,v). v = IVal 4}"
apply (insert vardistinct)
apply (simp)
apply hoare3_simp
apply (tactic {* all_tac *})
apply auto
oops

lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) |] 
    ==>
    \<Turnstile> {(z, s). s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := z), emptyr)}
      LET
        zi'1 = 4\<^sup>z ;
        zi'2 = (self\<bullet>count := z1'1)
      IN
        (CALL dec)
      END
      {(z,s,v). v = IVal 3}"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_rec_simp

end




