(*  
   File:        ToyVCGtest.ML
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGtest1.thy,v 1.1 2003/06/24 23:21:27 da Exp $

   More tests of the VCG (swap, count, dec3).
*)

theory ToyVCGtest1 = ToyVCG0 + ToyPrelude + ToyHLbasic0:

section {* Testing the VCGen *}

subsection {* \texttt{swap}: testing GetFi and PutFi *}

locale swap_example =
  fixes    m :: iname
    and	   n :: iname
    and	   q :: iname
    and	   z1 :: iname
    and	   z2 :: iname
    and	   lesser    :: ifldname
    and	   greater   :: ifldname
    and	   swap      :: funame
    and    SwapClass :: cname
    and	   swapBody  :: expr
    and    l1 :: locn
    and    M :: int    
    and    N :: int    
    and    M' :: int    
    and    N' :: int    
    and    curr_obj :: "int => int => obj"
  defines "swapBody \<equiv>  LET 
                m  = self\<bullet>lesser ;
                n  = self\<bullet>greater ;
                q  = m :> n
              IN
                IF q 
                  THEN LET
                         z1 = self\<bullet>lesser := n ; 
                         z2 = self\<bullet>greater := m 
                       IN
                         1\<^sup>z
                       END 
                  ELSE 0\<^sup>z
              END"
      and  "curr_obj x y == (SwapClass, (emptyi(lesser:=x))(greater:=y), emptyr)"
  assumes  swapfnbdy: "funtable swap = swapBody"
      and  swapClass: "classtable SwapClass = \<lparr> iflds = [lesser,greater], rflds = [], meths = \<lambda> mn. K mn \<rparr>"
      and  vardistinct: "distinct [m,n,q,z1,z2]"
      and  flddistinct: "distinct [lesser,greater]"

declare (in swap_example) swapBody_def [simp]
declare (in swap_example) swapfnbdy   [simp]

lemma (in swap_example) 
   "\<Turnstile> {(z,s). clock s = clock z \<and> N < M \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj M N)}	
	swapBody
      {(z,s,v). s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj N M) }"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def) (* unfold body *)
apply hoare2_simp
done

lemma (in swap_example) 
   "\<Turnstile> {(z,s). clock s = clock z \<and> N < M \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj M N)}	
	swapBody
      {(z,s,v). s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj N M) }"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def) (* unfold body *)
apply hoare_rec_simp
done

(* same as above but using short-hand notation for heap access *)
lemma (in swap_example) 
   "\<Turnstile> {(z,s). clock s = clock z \<and> N < M \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and>  s\<lless>l1\<ggreater> = Some (curr_obj M N)}	
	swapBody
      {(z,s,v). s\<lfloor>self\<rfloor> = Ref l1 \<and>  s\<lless>l1\<ggreater> = Some (curr_obj N M) }"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def) (* unfold body *)
apply hoare2_simp
done

(* using invariant version now *)
lemma (in swap_example) 
   "\<Turnstile> {(z,s). clock s = clock z \<and> N < M \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and>  s\<lless>l1\<ggreater> = Some (curr_obj M N)}	
	swapBody
      {(z,s,v). s\<lfloor>self\<rfloor> = Ref l1 \<and>  s\<lless>l1\<ggreater> = Some (curr_obj N M) }"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def) (* unfold body *)
apply hoare_rec_simp
done

(* case distinction in post-condition *)
lemma (in swap_example) 
   "\<Turnstile> {(z,s). clock s = clock z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj M N)}	
	swapBody
      {(z,s,v). s\<lfloor>self\<rfloor> = Ref l1 \<and> 
                (M<N \<longrightarrow> fmap_lookup (heap s) l1 = Some (curr_obj M N)) \<and> 
                (N<M \<longrightarrow> fmap_lookup (heap s) l1 = Some (curr_obj N M)) \<and> 
                (N=M \<longrightarrow> fmap_lookup (heap s) l1 = Some (curr_obj N N))}"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def)
apply hoare2_simp
done

subsection {* Example: \texttt{swapr} (unconditional swap of refs rather than ints) *}

locale swapr_example =
  fixes    m     :: rname
    and	   n     :: rname
    and	   z1     :: rname
    and	   z2     :: rname
    and	   foo   :: rfldname
    and	   bar   :: rfldname
    and	   swapr      :: funame
    and    SwaprClass :: cname
    and	   swaprBody  :: expr
    and    l1 :: locn
    and    M  :: ref
    and    N  :: ref
    and    M' :: ref
    and    N' :: ref
    and    curr_obj :: "ref => ref => obj"
  defines "swaprBody \<equiv>  LETR 
                m  = self\<bullet>foo ;
                n  = self\<bullet>bar  ;
                z1 = (self\<bullet>foo := n) ;
                z2 = (self\<bullet>bar := m)
              IN
                expr.Int 1
              END"
      and  "curr_obj x y == (SwaprClass, emptyi, (emptyr(foo:=x))(bar:=y))"
  assumes  swaprfnbdy: "funtable swap = swapBody"
      and  swapClass: "classtable SwaprClass = \<lparr> iflds = [], rflds = [foo,bar], meths = \<lambda> mn. K mn \<rparr>"
      and  vardistinct: "distinct [self,m,n,z1,z2]"
      and  flddistinct: "distinct [foo,bar]"

declare (in swapr_example) swaprBody_def [simp]
declare (in swapr_example) swaprfnbdy   [simp]

lemma (in swapr_example) 
   "\<Turnstile> {(z,s). s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj M N)}	
	swaprBody
      {(z,s,v). s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj N M) }"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def) (* unfold body *)
apply hoare2_simp
done

subsection {* Example: \texttt{swap2} (as swap but with 2 functions instead of nested lets *}

locale swap2_example =
  fixes    m   :: iname
    and	   n   :: iname
    and	   q   :: iname
    and	   z1  :: iname
    and	   z2  :: iname
    and	   lesser    :: ifldname
    and	   greater   :: ifldname
    and	   swap      :: funame
    and	   swap'fn   :: funame
    and    SwapClass :: cname
    and	   swapBody  :: expr
    and	   swap'Body :: expr
    and    l1 :: locn
    and    M  :: int    
    and    N  :: int    
    and    M' :: int    
    and    N' :: int    
    and    curr_obj :: "int => int => obj"
  defines "swapBody \<equiv>  LET 
                m  = self\<bullet>lesser ;
                n  = self\<bullet>greater ;
                q  = m :> n
              IN
                IF q 
                  THEN CALL swap'fn
                  ELSE 0\<^sup>z
              END"
      and "swap'Body \<equiv> LET
                         z1 = self\<bullet>lesser := n ; 
                         z2 = self\<bullet>greater := m 
                       IN
                         1\<^sup>z
                       END "
      and  "curr_obj x y == (SwapClass, (emptyi(lesser:=x))(greater:=y), emptyr)"
  assumes  swapfnbdy: "funtable swap = swapBody"
      and  swap'fnbdy: "funtable swap'fn = swap'Body"
      and  swap'wfmeasure: "fun_wfmeasure_table swap'fn = {}"
      and  swapClass: "classtable SwapClass = \<lparr> iflds = [lesser,greater], rflds = [], meths = \<lambda> mn. K mn \<rparr>"
      and  vardistinct: "distinct [m,n,q,z1,z2]"
      and  flddistinct: "distinct [lesser,greater]"
      and  swap'preinv: "fun_preassn_table swap'fn = {(z,s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s<m>=M \<and> s<n>=N}"
      and  swap'postinv: "fun_postassn_table swap'fn = {(z,s,v). v=IVal 1 \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> s<m>=M \<and> s<n>=N \<and> s\<lless>l1\<ggreater> = Some (curr_obj N M)}"

declare (in swap2_example) curr_obj_def [simp]
declare (in swap2_example) swapBody_def [simp]
declare (in swap2_example) swapfnbdy   [simp]
declare (in swap2_example) swap'Body_def [simp]
declare (in swap2_example) swap'fnbdy   [simp]
declare (in swap2_example) swap'wfmeasure [simp]
declare (in swap2_example) swap'preinv [simp]
declare (in swap2_example) swap'postinv [simp]

lemma (in swap2_example) 
   "\<Turnstile> {(z,s). N < M \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj M N)}	
	swapBody
      {(z,s,v). s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj N M) }"
apply (insert vardistinct flddistinct)
apply (simp) (*  add: curr_obj_def *) (* unfold body *)
apply hoare1_simp
defer 1
apply (rule_tac x="l1" in exI)
apply (rule conjI)
defer 1
apply (rule_tac x="SwapClass" in exI)
apply (rule_tac x="emptyi(lesser := M, greater := N)" in exI)
apply (rule_tac x="emptyr" in exI)
apply (rule conjI)
defer 1
apply (rule_tac x="l1" in exI)
apply (rule conjI)
defer 1
apply (rule_tac x="SwapClass" in exI)
apply (rule_tac x="emptyi(lesser := N, greater := N)" in exI)
apply (rule_tac x="emptyr" in exI)
apply clarsimp
apply (rule conjI)
defer 1
apply fastsimp
apply (rule subsetI)
apply auto
oops
(* False *)

end

lemma (in swap2_example) 
   "[| \<Turnstile> fun_preassn_table swap'fn CALL swap'fn fun_postassn_table swap'fn |]
    ==> 
    \<Turnstile> {(z::int,s). N < M \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj M N)}	
	swapBody
      {(z::int,s,v). s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj N M) }"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def) (* unfold body *)
apply hoare_rec_simp
apply clarsimp
done

lemma (in swap2_example) 
   "[| \<Turnstile> fun_preassn_table swap'fn CALL swap'fn fun_postassn_table swap'fn |]
    ==> 
    \<Turnstile> {(z::int,s). \<not> N < M \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj M N)}	
	swapBody
      {(z::int,s,v). s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj M N) }"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def) (* unfold body *)
(* apply hoare_rec_simp *)
(* apply clarsimp *)
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply clarsimp
apply hoare_rec_step
defer 1
defer 1
defer 1
apply hoare_rec_step
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply hoare_rec_step
apply clarsimp
apply simp
defer 1
apply simp
defer 1
apply clarsimp
defer 1
apply clarsimp
defer 1
apply clarsimp
defer 1
oops


(*
oops
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
(* apply (tactic {* HoareInst "HCallAux0" "Q'" "fun_postassn_table" 1 *}) *)
(* apply (tactic {* res_inst_tac [("Q'","fun_postassn_table swap'fn")] (thm "HCallAux0") 1 *}) *)
(* apply (tactic {* rtac (thm "HCallAux0") 1 *}) *)
(* apply (tactic {* instantiate_tac [("Q'17","fun_postassn_table swapfn")] *}) *)
apply hoare_rec_step
defer 1
apply simp
defer 1
apply simp
defer 1
apply hoare_rec_step
apply hoare_rec_step
apply simp
defer 1
apply hoare_rec_step
apply simp
apply hoare_rec_step
defer 1
apply clarsimp
defer 1
defer 1
apply clarsimp
defer 1
apply clarsimp
apply rule
prefer 4
oops
*)

subsection {* \texttt{inc}: simple recursion over variable with functions *}

constdefs iszero::"int \<Rightarrow> int"
"iszero x == (if x = 0 then 1 else 0)"

locale count_example =
(*fun countdown(n) = let n = n -1
                     in if n=0 then 0 else countdown(n) end
 *)
  fixes    m :: iname
    and	   n :: iname
    and	   b :: iname
    and	   countfn    :: funame
    and	   countfnbdy :: expr
  defines  "countfnbdy == LET m = expr.Int 1;
			      n = Primop (% x y. x-y) n m;
			      b = Primop (% x y. if x = 0 then 1 else 0) n n 
			   IN 

			      IF b THEN expr.Int 0 ELSE CALL countfn 
  			   END"
  assumes  countfnbdy[simp]:  "funtable countfn = countfnbdy"
      and  wfmeasure [simp]:  "fun_wfmeasure_table countfn = inv_image less_than (\<lambda> s. nat (get_ivar s n))"
      and  vardistinct:       "distinct [m,n,b]"
      and  count_preinv: "fun_preassn_table countfn == {((z::int),s). 0 < z \<and> z = s<n>}"
      and  count_postinv: "fun_postassn_table countfn == {((z::int),s,v). v=IVal 1 \<and> (s<n>=1)}"

declare (in count_example) countfnbdy_def [simp]  (* unfold def *)
declare (in count_example) count_preinv [simp]
declare (in count_example) count_postinv [simp]

lemma (in count_example) 
   "\<Turnstile> {(z,s). 0 < (s<n>)}	
	(CALL countfn) 
      {(z,s,v). v=IVal 0 \<and> (s<n>=0)}"
apply (insert vardistinct)
apply hoare_simp
apply (erule_tac thin_rl)  (* remove used IH assumption *)
apply rule				     (* conjI *)
apply arith				     (* arith *)
apply (simp add: inv_image_def)		     (* termination *)
apply (erule thin_rl, insert wfmeasure, simp)
apply (rule wf_inv_image, rule wf_less_than) (* WF measure *)
done

(* dec3 etc moved to ToyVCGtest0.thy *)

end

