(*  
   File:        ToyVCGtest.ML
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGtest0.thy,v 1.1 2003/06/24 23:22:09 da Exp $

   More tests of the VCG (dec3).
   
*)

theory ToyVCGtest0 = ToyVCG0 + ToyPrelude + ToyHLbasic0:

section {* Testing the VCGen *}

subsection {* dec3 (non-rec, but with a CALL in the ELSE branch) *}

consts the_locn :: "ref => locn"
primrec 
"the_locn (Ref l) = l"

constdefs the_ifld :: "rname => ifldname => state => nat"
"the_ifld x y s == nat ((fst (snd (the (fmap_lookup (heap s) (the_locn (s\<lfloor>x\<rfloor>)))))) y)"

locale dec3_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   z1        :: iname
    and	   z2        :: iname
    and	   i'1       :: iname
    and	   r'1       :: rname
    and	   q1        :: iname
    and	   zero      :: iname
    and	   zero'     :: iname
    and    l1        :: locn
    and    N         :: int    
    and    count     :: ifldname
    and	   dec       :: funame
    and    DecClass  :: cname 
    and	   decBody   :: expr
    and    const     :: funame
    and	   constBody  :: expr
    and    constPreInv  :: "a_preassn"
    and    constPostInv :: "a_postassn"
  defines "decBody \<equiv>  LET 
                m  = GetFi self count ;
                n  = Primop (\<lambda> x y . x - 1) m m ;
                z1 = PutFi self count n ; 
                zero = expr.Int 0 ;
                q1 = Primop (\<lambda> x y . if \<not> y<x then (1::int) else (0::int)) n zero
              IN
                IF q1 
                  THEN IVar zero
                  ELSE IVar n
              END"
  and     "constBody \<equiv> IVar n"
  and     "constPreInv == {(z, s). s<n> = z<n>}"
  and     "constPostInv == {(z, s, v). v = IVal (z<n>) \<and> s<n> = z<n>}"
  assumes  DecClass:    "classtable DecClass = \<lparr> iflds = [count], rflds = [], meths = \<lambda> mn. K mn \<rparr>"
      and  vardistinct: "distinct [m,n,z1,z2,i'1,q1,zero]"
      and  vardistinct': "distinct [zero,q1]"
      and  vardistinct'': "distinct [r'1]"
      (* function tables *)
      and  dec_fnbdy:   "funtable dec = decBody"
      and  const_fnbdy: "funtable const = constBody "
      (* measures *)
      and  dec_wfmeasure: "fun_wfmeasure_table dec = inv_image less_than (the_ifld self x)"
      and  const_wfmeasure: "fun_wfmeasure_table const = {}"
      (*
      and  const_inv: "fun_assn_table const = (
             {(z, s). s<n>=z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)},
             {(z, s, v). v = IVal z \<and> s<n>=z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and>
             s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)} )"
      *)
      (* invariants *)
      and  dec_preinv:  "fun_preassn_table dec == {(z, s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := z<n>), emptyr)}"
      and  dec_postinv: "fun_postassn_table dec == {(z, s, v). s\<lfloor>self\<rfloor> = Ref l1 \<and> v = IVal ((z<n>) - 1)}"
      and  const_preinv:  "fun_preassn_table const == constPreInv"
      and  const_postinv: "fun_postassn_table const == constPostInv"
      and  dec_inv_holds: "\<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec)"
      and  const_inv_holds: "\<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const)"

declare (in dec3_example) decBody_def[simp]
declare (in dec3_example) dec_fnbdy[simp]
declare (in dec3_example) constBody_def[simp]
declare (in dec3_example) const_fnbdy[simp]
declare (in dec3_example) dec_wfmeasure[simp]
declare (in dec3_example) dec_preinv[simp]
declare (in dec3_example) dec_postinv[simp]
declare (in dec3_example) const_preinv[simp]
declare (in dec3_example) const_postinv[simp]
declare (in dec3_example) constPreInv_def[simp]
declare (in dec3_example) constPostInv_def[simp]

(*
lemma  (in dec3_example) const_preinv_blessed:  "fun_preassn_table const = {(z, s). s<n> = z}"
apply (insert const_preinv)
apply simp
done

lemma (in dec3_example) const_postinv_blessed: "fun_postassn_table const = {(z, s, v). v = IVal z \<and> s<n> = z}"
apply (insert const_postinv)
apply simp
done
*)

lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z<n> \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal (z<n>)}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
(*
apply hoare_step
defer 1
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HCall0") 1 *})
apply (tactic {* rtac allI 1 *})
apply (simp) (* unfold body *)
apply hoare_step
defer 1
defer 1
apply hoare_step
apply clarsimp
*)
defer 1
defer 1
oops

(* all-in-one; std ... *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z<n> \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal (z<n>)}"
apply (insert vardistinct)
apply (simp)
apply hoare3_simp
done


(* single stepping; std ...
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z<n> \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal (z<n>)}"
apply (insert vardistinct)
apply (simp)
apply hoare_step
defer 1
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* (rtac (thm "HCall5")) 1 *})
apply (tactic {* rtac allI 1 *})
apply simp
apply hoare_step
defer 1
defer 1
defer 1
apply hoare_step
apply clarsimp
oops
*)
(* single stepping ...
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
apply hoare_simp
oops
*)
(*
lemma (in dec3_example) bonzo99:  "wf (fun_wfmeasure_table const)"
apply (insert const_wfmeasure, simp)
oops
*)

(* std single-step
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
apply hoare_step
defer 1
apply (tactic {* rtac (thm "HRecClockWF") 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HCall0") 1 *})
apply (tactic {* rtac allI 1 *})
apply clarsimp
apply hoare_step
defer 1
apply hoare_step
apply auto
oops
*)

(* rec is ok *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z<n> \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal (z<n>)}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
apply auto
done

(* rec1: leaves meta-variables over assertions behind; fails *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z<n> \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal (z<n>)}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec1_simp
apply auto
oops

(* --------------------------------------------------------------------------- *)

lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) ; 
       wf (fun_wfmeasure_table const) |] 
    ==>
    \<Turnstile> {((z::int), s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr) \<and> s<n>=4}
      LET
        z2 = (self\<bullet>count := n)
      IN
        CALL const
      END
      {((z::int),s,v). v = IVal 4 }"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_check_expr
apply hoare_step
defer 1
(* ... *)
(* CALL *)
apply (tactic {* rtac (thm "HRecClockWF") 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HCall0") 1 *})
apply (tactic {* rtac allI 1 *})
apply simp
apply hoare_step
defer 1
apply hoare_step
apply clarsimp
apply auto
oops



subsection {* dec proper *}

lemma (in dec3_example) 
   "\<lbrakk> \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) \<rbrakk>
    \<Longrightarrow>     
    \<Turnstile> {(z, s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := z), emptyr) \<and> 0<z}
      decBody
      {(z,s,v). v = IVal (z - 1)}"
apply (insert vardistinct vardistinct')
apply (simp)
apply hoare_rec_simp
done

lemma (in dec3_example) 
   "\<lbrakk> \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) \<rbrakk>
    \<Longrightarrow>     
    \<Turnstile> {(z, s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := z), emptyr) \<and> 0<z}
      decBody
      {(z,s,v). v = IVal (z - 1)}"
apply (insert vardistinct vardistinct')
apply (simp)
apply hoare_simp
done

subsection {* const after field manipulation *}

(* std: leaves subgoal behind *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) |] 
    ==>
    \<Turnstile> {(z, s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr)}
      LET
        n = 4\<^sup>z ; 
        z2 = (self\<bullet>count := n)
      IN
        CALL const
      END
      {(z,s,v). v = IVal 4}"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_simp
apply auto
oops

(* std: single stepping *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) ;
       wf (fun_wfmeasure_table const) |] 
    ==>
    \<Turnstile> {(z, s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr)}
      LET
        n = 4\<^sup>z ; 
        z2 = (self\<bullet>count := n)
      IN
        CALL const
      END
      {(z,s,v). v = IVal 4}"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_step
defer 1
apply hoare_step
defer 1
(* CALL *)
apply hoare_step
apply simp
apply hoare_step
defer 1
oops

(* rec: gets stuck on CALL; single-stepping ...  *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) |] 
    ==>
    \<Turnstile> {((z::int), s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr)}
      LET
        n = 4\<^sup>z ; 
        z2 = (self\<bullet>count := n)
      IN
        CALL const
      END
      {((z::int),s,v). v = IVal 4}"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_check_expr
apply hoare_rec_simp
apply auto
oops

(* rec: gets stuck on CALL; single-stepping ...  *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) ; 
       wf (fun_wfmeasure_table const) |] 
    ==>
    \<Turnstile> {((z::int), s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr) \<and> s<n>=4}
      LET
        z2 = (self\<bullet>count := n)
      IN
        CALL const
      END
      {((z::int),s,v). v = IVal 4 }"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_check_expr
apply hoare_simp
apply auto
oops


(* rec: gets stuck on CALL; single-stepping ...  *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) |] 
    ==>
    \<Turnstile> {((z::int), s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr) \<and> s<n>=4}
      LET
        z2 = (self\<bullet>count := n)
      IN
        CALL const
      END
      {((z::int),s,v). v = IVal 4 }"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_check_expr
apply hoare_rec_simp
apply auto
oops

(* rec: gets stuck on CALL; single-stepping ...  *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) |] 
    ==>
    \<Turnstile> {((z::int), s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr) \<and> s<n>=4}
      LET
        z2 = (self\<bullet>count := n)
      IN
        CALL const
      END
      {((z::int),s,v). v = IVal 4 }"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_check_expr
apply hoare_rec_step (* LET *)
defer 1
(* CALL *)
apply (tactic {* res_inst_tac [("Q'","fun_postassn_table const")] (thm "HCallAux0") 1 *})
(*
apply (tactic {* resolve_tac [(thm "HCallAux0")] 1 *})
apply (tactic {* instantiate_tac [("Q'3","fun_postassn_table const")] *})
apply (tactic {* rtac (thm "conjI") 1 *})
*)
apply (tactic {* simp_tac (simpset() addsimps [(thm "const_preinv_blessed"),(thm "const_postinv_blessed")]) 2 *})
apply (tactic {* simp_tac (simpset() addsimps [(thm "const_preinv_blessed"),(thm "const_postinv_blessed")]) 1 *})
apply (tactic {* rtac (thm "subsetI") 1 *})
defer 1
apply hoare_rec_step (* PutFi *)
apply clarsimp
oops

(* rec: gets stuck on CALL; single-stepping ...  *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) |] 
    ==>
    \<Turnstile> {((z::int), s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr)}
      LET
        n = 4\<^sup>z ; 
        z2 = (self\<bullet>count := n)
      IN
        CALL const
      END
      {((z::int),s,v). v = IVal 4 }"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_check_expr
apply hoare_rec_step (* LET *)
defer 1
apply hoare_rec_step (* LET *)
defer 1
(* CALL *)
apply hoare_rec_step 
(* apply (rename_tac "Qfoo" 1) *)
(*
apply (tactic {* resolve_tac [(thm "HCallAux0")] 1 *})
apply (tactic {* instantiate_tac [("Q'4","fun_postassn_table const")] *})
apply (tactic {* rtac (thm "conjI") 1 *})
*)
apply (tactic {* simp_tac (simpset() addsimps [(thm "const_preinv_blessed"),(thm "const_postinv_blessed")]) 2 *})
apply (tactic {* simp_tac (simpset() addsimps [(thm "const_preinv_blessed"),(thm "const_postinv_blessed")]) 1 *})
apply (tactic {* rtac (thm "subsetI") 1 *})
apply (simp)
defer 1
defer 1
apply hoare_check_expr
apply hoare_rec_step (* Int *)
apply simp
defer 1
apply hoare_check_expr
apply hoare_rec_step (* PutFi *)
defer 1
apply clarsimp
oops

(* crap
apply (rule HSP)
apply (rule HCallAux)
apply auto
apply (tactic {*    SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyHLbasic.hoare_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDef.expr.Call",_) $ Free(fnname,_) =>
		   (print ".. HoareInst for function " ^ fnname;
		    res_inst_tac [("P'","fun_preassn_table " ^ fnname)(*,("Q'","fun_postassn_table " ^ fnname)*)] (thm "HCallAux0") 1) 
                    (* (rtac (thm "HCallAux0")) 1) *)
	      | _ => (print ".. HoareInst: no match in inner case over expr" ; all_tac))
         | _ => (print ".. HoareInst: no match in outer case over concl" ; all_tac)
      end) 1 *})
apply (rule conjI)
defer 1
*)

(* rec: gets stuck on CALL; single-stepping ...  *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) |] 
    ==>
    \<Turnstile> {((z::int), s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr)}
      LET
        n = 4\<^sup>z ; 
        z2 = (self\<bullet>count := n)
      IN
        CALL const
      END
      {((z::int),s,v). v = IVal 4 }"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_check_expr
apply hoare_rec
oops

lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) |] 
    ==>
    \<Turnstile> {(z, s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr) \<and> s<n>=4}
      LET
        zi'1 = (self\<bullet>count := n)
      IN
        IVar zi'1
      END
      {(z,s,v). v = IVal 4}"
apply (insert vardistinct vardistinct'')
apply (simp)
(* apply hoare_rec1_simp *) (* OK *)
apply hoare_rec1_step (* LET *)
defer 1
apply hoare_rec1_step (* CALL *)
apply simp
apply hoare_rec1_step (* PutFi *)
apply clarsimp
done

(* crap
apply (rule_tac x="l1" in exI)
apply (rule_tac x="(DecClass, emptyi, emptyr)" in exI)
apply clarsimp
defer 1
apply (rule allI)+
apply (rule impI)
apply (rule allI)+
apply (rule impI)
apply clarsimp
defer 1
apply (rule subsetI)
defer 1
apply clarsimp
oops


apply (rule_tac x="DecClass" in exI)
apply (rule_tac x="emptyi" in exI)
apply (rule_tac x="emptyr" in exI)
apply (rule conjI)

apply auto


apply (rule HConseq)
apply (rule HCallAux)
apply clarsimp
apply (rule conjI)

apply hoare_rec_step (* CALL *)
*)


lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) |] 
    ==>
    \<Turnstile> {(z, s). s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := z), emptyr)}
      LET
        zi'1 = 4\<^sup>z ;
        zi'2 = (self\<bullet>count := z1'1)
      IN
        (CALL dec)
      END
      {(z,s,v). v = IVal 3}"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_rec_simp
defer 1
apply (tactic {* rtac (thm "subsetI") 1 *})
defer 1
oops


subsection {* const *}

(* using invariant to prove a weaker triple; done manually without tactic *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z}	
      (CALL const)
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
apply (rule HWC)
apply fastsimp
apply (tactic {* rtac subsetI 1 *})
apply clarsimp
done

(* tactic (w/ invariant) *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z}	
      (CALL const)
      {(z,s,v). v=IVal z}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
apply clarsimp
done

(* std *)
lemma (in dec3_example) 
   "[| wf (fun_wfmeasure_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z}	
      LET 
        zero' = expr.Int 0
      IN 
        CALL const
      END
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
apply hoare_simp
apply auto
oops

(* tactic w/o invariant; single stepping *)
lemma (in dec3_example) 
   "[| wf (fun_wfmeasure_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z}	
      LET 
        zero' = expr.Int 0
      IN 
        CALL const
      END
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
(* single stepping *)
(* LET *)
apply hoare_step
defer 1
(* CALL *)
apply hoare_step
apply simp
apply hoare_step
defer 1
apply assumption
apply hoare_step
apply clarsimp
apply auto
oops

(* tactic w/o invariant; single stepping *)
lemma (in dec3_example) 
   "[| wf (fun_wfmeasure_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z}	
      LET 
        zero' = expr.Int 0
      IN 
        CALL const
      END
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
(* single stepping *)
(* LET *)
apply hoare_step
defer 1
(* CALL *)
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HCall5") 1 *})
apply (tactic {* rtac allI 1 *})
apply simp
apply hoare_step
defer 1
apply (tactic {* rtac subsetI 1 *})
defer 1
apply assumption
apply hoare_step
apply clarsimp
apply auto
oops
(*
apply hoare_simp
apply clarsimp
oops
*)

(* tactic with invariants *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z}	
      LET 
        zero' = expr.Int 0
      IN 
        CALL const
      END
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
apply clarsimp
defer 1
oops

(* same if the CALL is nested in an IF *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z \<and> s<z1>=0}	
      IF z1
        THEN IVar n
        ELSE CALL const
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
done

(* same if the CALL is nested in an IF *)
lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
defer 1
oops

lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z  \<and> s<zero>=0}	
      LET 
        z1 = Primop (\<lambda> x y . if \<not> y<x then (1::int) else (0::int)) n zero
      IN 
       IF z1
        THEN CALL const
        ELSE IVar n
      END
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_step
apply simp
apply hoare_rec_step
apply simp
defer 1
apply hoare_rec_step
apply hoare_rec_step
apply (rule HWC)
apply hoare_rec_step
apply simp
apply (auto)
(* False *)
oops


subsection {* Hans-Wolfgang's ExDvD example *}

(*
  Example: dvd m n ... tests whether m divides n, using a running potential divisor
  Description: Direct recursion; will not terminate if m does not divide n
*)

locale dvd_example =
  fixes    mydvd :: funame
    and	   m :: iname and n :: iname and r :: iname 
    and    x :: iname and y :: iname and z :: iname
    and    rx :: iname 
    and    q1 :: iname and q2 :: iname and q3 ::iname and q4 ::iname 
    and    tt :: iname and ff :: iname
    and	   dummyarg :: iname and stat1 :: iname
    (*and	   l1     :: locn*)
    and	   even   :: mname
    and    FooClass :: cname
    and	   dvdBody :: expr
  defines "dvdBody \<equiv> 
             LET
               z  =  Primop INC_fct r r  ;
               r  =  expr.IVar z ;
               y  =  Primop MULT_fct m  r ; 
               q1 =  Primop EQ_fct y  n ;
               q2 =  Primop EQ_fct r  n ;
               q3 =  Primop OR_fct q1  q2 
             IN
               IF q3 
                 THEN expr.IVar q1
                 ELSE CALL mydvd
             END"
  assumes  vardistinct:   "distinct [m,n,r,x,y,z,rx,q1,q2,q3,tt,ff,dummyarg]"
      and  dvdfnbody:     "funtable mydvd = dvdBody"
      and  dvd_wfmeasure: "fun_wfmeasure_table mydvd = inv_image less_than (\<lambda>s . nat (s<m> - s<r>))" 
      and  dvd_preinv:    "fun_preassn3_table mydvd = {((M,N,R), s). s<m>=M \<and> s<n>=N \<and> s<r>=R}"
      and  dvd_postinv:   "fun_postassn3_table mydvd = {((M,N,R), s, v). (((M*R)=N) \<longrightarrow> (v=IVal 1)) \<and> ((N<(M*R)) \<longrightarrow> (v=IVal 0))}" 
(*
      and  dvd_inv: "fun_assn_table mydvd = (
             {((M,N,R), s). s<m>=M \<and> s<n>=N \<and> s<r>=R},
             {((M,N,R), s, v). (((M*R)=N) \<longrightarrow> (v=IVal 1)) \<and> ((N<(M*R)) \<longrightarrow> (v=IVal 0))} )" 
*)
(*             {((M,N), s, v). v = IVal (b2i (M dvd N))} *)

declare (in dvd_example) dvdfnbody[simp]
declare (in dvd_example) dvdBody_def[simp]
(*
declare (in dvd_example) dvd_inv[simp]
declare (in dvd_example) dvd_preinv[simp]
declare (in dvd_example) dvd_postinv[simp]
*)

(* using hoare_rec to pull out the invariant *)
lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=2 \<and> s<n>=4 \<and> s<r>=1}	
      dvdBody
      {(z,s,v). v = IVal 1}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_simp
(* hmm, fun_assn_table lookup should have been expanded by now *)
defer 1
defer 1
(* apply fastsimp *)
apply (rule allI)
apply (simp)
apply hoare_rec
apply (subgoal_tac "fun_postassn_table mydvd = {((M,N,R), s, v). (((M*R)=N) \<longrightarrow> (v=IVal 1)) \<and> ((N<(M*R)) \<longrightarrow> (v=IVal 0))}")
apply simp
apply (simp add: dvd_preinv dvd_postinv dvdfnbody)
apply (simp add: dvd_preinv dvd_postinv dvdfnbody)
apply (subgoal_tac "funtable mydvd = dvdBody")
apply (simp)
apply (subgoal_tac "fun_preassn_table mydvd = {((M,N,R), s). s<m>=M \<and> s<n>=N \<and> s<r>=R}")
apply (rotate_tac 2)
apply simp
apply assumption
defer 1
apply (simp add: dvd_inv dvdfnbody)
done


lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=2 \<and> s<n>=4 \<and> s<r>=1}	
      dvdBody
      {(z,s,v). v = IVal 1}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_simp
defer 1
(* ToDo: find something weaker than auto to complete *)
apply arith?
apply simp?
apply fastsimp
apply simp
oops
(* yes, 2 divides 4, big surprise *)

lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=3 \<and> s<n>=4 \<and> s<r>=1}	
             LET
               z  = INC_op r  ;
               r  = expr.IVar z ;
               y  = MULT_op m r ; 
               q1 = EQ_op y n ;
               q2 = EQ_op r y ;
               q3 = OR_op q1 q2 ;
               q4 = NOT_op q3  
             IN
               IF q4 
                 THEN CALL mydvd
                 ELSE expr.IVar q1
             END
      {(z,s,v). v = IVal 0}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_simp
defer 1
apply (fastsimp)
(* False *)
oops

lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table const) ; wf (fun_wfmeasure_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=3 \<and> s<n>=4 \<and> s<r>=1}	
      dvdBody
      {(z,s,v). v = IVal 0}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_simp
defer 1
apply fastsimp
apply simp
(* False, bad *)
(* no, 3 does not divide 4, wow, we got to write a paper about this *)
oops

lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=3 \<and> s<n>=4 \<and> s<r>=1}	
      dvdBody
      {(z,s,v). v = IVal 1}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_simp
defer 1
apply fastsimp
apply (simp)
(* False, good! *)
oops

(*
apply wishful_thinking
apply (rule conjI)
apply (rule impI)
apply (rule conjI)
apply (simp)
defer 1
apply (rule impI)
apply (rule conjI)
defer 1
apply (simp)
defer 1
apply (rule conjI)
apply (rule impI)
apply (rule conjI)
apply (simp)
defer 1
apply (rule impI)
apply (rule conjI)
apply (rule impI)
apply 
done
*)

lemma (in dvd_example) 
   "[| wf (fun_wfmeasure_table mydvd) |] ==>  
    \<Turnstile> {(z,s). s<m>=2 \<and> s<n>=7 \<and> s<r>=1}	
      dvdBody
      {(z,s,v). v = IVal 0}"
apply (insert vardistinct)
apply (simp add:dvdBody_def)
apply hoare_simp
defer 1
apply fastsimp
apply simp
oops

subsection {* even/odd example *}

locale evenodd_example =
(* Simulating the typical example
      even(x) = let fun even x = if x=0 then true else odd(x-1)
                    fun odd x = if x=0 then false else even(x-1)
                in even(x)
 *)
  fixes    x :: iname
    and    q :: iname
    and	   one :: iname
    and	   evenfn  :: funame
    and    oddfn   :: funame
    and	   evenbdy :: expr
    and    oddbdy  :: expr
  defines  "evenbdy == LET q = ISZERO_op x;
			   x = DEC_op x 
			   IN 
			      IF q THEN expr.Int 1 ELSE CALL oddfn
  			   END"
  defines  "oddbdy == LET  q = ISZERO_op x;
			   x = DEC_op x
			   IN 
			      IF q THEN expr.Int 0 ELSE CALL evenfn
  			   END"

  assumes  evenbdy:     "funtable evenfn = evenbdy"
      and  oddbdy:      "funtable oddfn = oddbdy"
      and  wfmeasure1:  "fun_wfmeasure_table evenfn = inv_image less_than (\<lambda> s. nat (get_ivar s x))"
      and  wfmeasure2:  "fun_wfmeasure_table oddfn = inv_image less_than (\<lambda> s. nat (get_ivar s x))"
      and  vardistinct: "distinct [one,q,x]"

declare (in evenodd_example) evenbdy [simp]
declare (in evenodd_example) oddbdy  [simp]
declare (in evenodd_example) evenbdy_def [simp]
declare (in evenodd_example) oddbdy_def  [simp]
declare (in evenodd_example) wfmeasure1 [simp]
declare (in evenodd_example) wfmeasure2 [simp]

lemma (in evenodd_example) 
   "\<Turnstile> {(z,s). 0 < z \<and> (s<x>=2*z)}	
	(CALL evenfn) 
      {(z,s,v). v=IVal 1}"
apply (insert vardistinct)
apply (simp add: evenbdy_def oddbdy_def)
apply hoare_simp
prefer 3
apply simp
apply auto
oops

end
