(*  
   File:	ToyProgs
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyProgs.thy,v 1.1 2003/06/24 23:25:40 da Exp $

   Some program syntax for ToyGrail. 
  
   IN PROGRESS

   Somewhat experimental.   A better approach might be to just concentrate
   on printing in Isabelle, and bolt on an external parser.  (That would 
   make things more comfortable by inserting coercions, etc, automatically).
*)

header {* Program syntax for ToyGrail. *}

theory ToyProgs = ToyGrailDef + ToyPrelude:

(* Allow a mixed up but hierarchical syntax *)

(* NB: mention of function args has no logical meaning *)

datatype prog = 
  Fun funame "iname list" "rname list" expr
| StaticMeth mname prog expr
| Meth mname prog expr
| Class cname "ifldname list" "rfldname list" prog
| IntDecs "iname list"
| RefDecs "rname list"
| Decs prog prog	("_; _" [200,201] 200)

(* NB: desirable improvement: replace lists below with syntactic idlist *)
syntax
 "_Fun"    :: "[id,id list,id list,expr] \<Rightarrow> prog"  ("(4FUN _ '(_;_') =\ _)"  [1000,1000,1000,1] 210)  
 "_Static" :: "[id,prog,expr] \<Rightarrow> prog"     ("(4STATIC METH _ '(') =\ _ INEXPR _ ENDMETH)" 210)
 "_Meth"   :: "[id,prog,expr] \<Rightarrow> prog"     ("(4METH _ '(') =\ _ INEXPR _ ENDMETH)" 210)
 "_Class"  :: "[id,ifldname list,rfldname list,prog] \<Rightarrow> prog"  
					   ("(4CLASS _ =\ IFIELDS _\ RFIELDS _\ _ ENDCLASS)" 210)
 "_StatClass" :: "[id,ifldname list,rfldname list,prog] \<Rightarrow> prog"  
					   ("(4CLASS _ =\ _ ENDCLASS)" 210)
 "_IntDecs" :: "'a list \<Rightarrow> prog"	   ("(INTVARS _)" [230] 220)
 "_RefDecs" :: "'a list \<Rightarrow> prog"	   ("(REFVARS _)" [230] 220)

(* parameter names are ignored in functions; lists of integer variables and ref variables are global *)
translations
 "STATIC METH m () = fundecs INEXPR exprn ENDMETH"    == "StaticMeth m fundecs exprn"
 "METH m () = fundecs INEXPR exprn ENDMETH"           == "Meth m fundecs exprn"
 "FUN f (iargs; rargs) = exprn"			      == "Fun f iargs rargs exprn" 
 "CLASS C = progm ENDCLASS"			      == "Class C [] [] progm"
 "CLASS C = IFIELDS ints RFIELDS refs progm ENDCLASS" == "Class C ints refs progm"
 "INTVARS intvs" == "IntDecs intvs" 
 "REFVARS intvs" == "RefDecs intvs" 

(* grammar checks:
 term "INTVARS [];; X"
 term "Y;; INTVARS []" 
 term "CLASS c = foo ENDCLASS;; INTVARS []"
*)



(* Extract the functions and classes declared in a program:
   CAREFUL!  The variables used must really be disjoint. *)

consts
 cnames_of_prog  :: "prog \<Rightarrow> cname list"
 mnames_of_prog  :: "prog \<Rightarrow> mname list"
 funames_of_prog :: "prog \<Rightarrow> funame list"
 inames_of_prog  :: "prog \<Rightarrow> iname list"
 rnames_of_prog  :: "prog \<Rightarrow> rname list"
primrec
 "cnames_of_prog (Fun f inames rnames expr)  = []"
 "cnames_of_prog (Meth m fundecs expr)       = cnames_of_prog fundecs"
 "cnames_of_prog (StaticMeth m fundecs expr) = cnames_of_prog fundecs"
 "cnames_of_prog (Class c ifls rfls methds)   = c#(cnames_of_prog methds)"
 "cnames_of_prog (IntDecs inms)		     = []"
 "cnames_of_prog (RefDecs rnms)	             = []"
 "cnames_of_prog (Decs ds1 ds2)	             = (cnames_of_prog ds1) @ (cnames_of_prog ds2)"
primrec
 "mnames_of_prog (Fun f inames rnames expr)  = []"
 "mnames_of_prog (Meth m fundecs expr)       = m#(mnames_of_prog fundecs)"
 "mnames_of_prog (StaticMeth m fundecs expr) = m#(mnames_of_prog fundecs)"
 "mnames_of_prog (Class c ifls rfls methds)  = mnames_of_prog methds"
 "mnames_of_prog (IntDecs inms)	      	     = []"
 "mnames_of_prog (RefDecs rnms)	      	     = []"
 "mnames_of_prog (Decs ds1 ds2)	      	     = (mnames_of_prog ds1) @ (mnames_of_prog ds2)"
primrec
 "funames_of_prog (Fun f inames rnames expr)  = [f]"
 "funames_of_prog (Meth m fundecs expr)       = funames_of_prog fundecs"
 "funames_of_prog (StaticMeth m fundecs expr) = funames_of_prog fundecs"
 "funames_of_prog (Class c ifls rfls methds)  = funames_of_prog methds"
 "funames_of_prog (IntDecs inms)	      = []"
 "funames_of_prog (RefDecs rnms)	      = []"
 "funames_of_prog (Decs ds1 ds2)	      = (funames_of_prog ds1) @ (funames_of_prog ds2)"
primrec
 "inames_of_prog (Fun f inames rnames expr)  = []"
 "inames_of_prog (Meth m fundecs expr)       = inames_of_prog fundecs"
 "inames_of_prog (StaticMeth m fundecs expr) = inames_of_prog fundecs"
 "inames_of_prog (Class c ifls rfls methds)  = inames_of_prog methds"
 "inames_of_prog (IntDecs inms)	      	     = inms"
 "inames_of_prog (RefDecs rnms)	      	     = []"
 "inames_of_prog (Decs ds1 ds2)	      	     = (inames_of_prog ds1) @ (inames_of_prog ds2)"
primrec
 "rnames_of_prog (Fun f inames rnames expr)  = []"
 "rnames_of_prog (Meth m fundecs expr)       = rnames_of_prog fundecs"
 "rnames_of_prog (StaticMeth m fundecs expr) = rnames_of_prog fundecs"
 "rnames_of_prog (Class c ifls rfls methds)  = rnames_of_prog methds"
 "rnames_of_prog (IntDecs inms)	      	     = []"
 "rnames_of_prog (RefDecs rnms)	      	     = rnms"
 "rnames_of_prog (Decs ds1 ds2)	      	     = (rnames_of_prog ds1) @ (rnames_of_prog ds2)"

(* Assertions about lookups in the three global tables *)
consts
 lookups_in_prog :: "prog \<Rightarrow> bool"
primrec
 "lookups_in_prog(Fun f inames rnames expr)  = (funtable f = expr)"
 "lookups_in_prog(Meth m fundecs expr)       = ((methtable m = expr) \<and> (lookups_in_prog fundecs))"
 "lookups_in_prog(StaticMeth m fundecs expr) = ((methtable m = expr) \<and> (lookups_in_prog fundecs))"
 (* NB: meths section of class table entry is a dummy, it's not used in formalization yet *)
 "lookups_in_prog(Class c ifls rfls methdecs) = 
		((classtable c = \<lparr> iflds = ifls, rflds = rfls, 
				    meths = \<lambda> mn. (({},{}),methtable mn) \<rparr>)
	      \<and> lookups_in_prog methdecs)"
 "lookups_in_prog(IntDecs inames) = True"
 "lookups_in_prog(RefDecs rnames) = True"
 "lookups_in_prog(Decs d1 d2)     = (lookups_in_prog d1 \<and> lookups_in_prog d2)"


constdefs
 trueInProg :: "prog \<Rightarrow> bool \<Rightarrow> bool"   ("_ \<triangleright> _" [0,999] 999)
 "trueInProg prog P \<equiv> 
    (distinct (funames_of_prog prog) \<and>
     distinct (cnames_of_prog prog) \<and>
     distinct (mnames_of_prog prog) \<and>
     distinct (inames_of_prog prog) \<and>
     distinct (rnames_of_prog prog) \<and>
     lookups_in_prog(prog)) \<longrightarrow> P"

end
