(*  
   File:	ToyPreludeTest
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyPreludeTest.thy,v 1.1 2003/06/24 23:18:26 da Exp $

   Basic tests on prelude functions.
*)

header {* Basic tests on prelude functions. *}

theory ToyPreludeTest = ToyPrelude + ToyHLbasic + ToyVCG:

constdefs i2b :: "int => bool"
 "i2b i == if (i=0) then True else False"
constdefs b2i :: "bool => int"
 "b2i b == if b then 1 else 0" 

constdefs foo_bin :: "((int => int => int) \<times> (int => int => int)) list"
 "foo_bin == 
   [(EQ_fct, 	 (% x y. b2i (x=y))),
    (NE_fct, 	 (% x y. b2i (x<y))),
    (LT_fct, 	 (% x y. b2i (x<y))),
    (GT_fct, 	 (% x y. b2i (y<x))),
    (LE_fct, 	 (% x y. b2i (\<not> (y<x)))),
    (GE_fct, 	 (% x y. b2i (\<not> (x<y)))),
    (PLUS_fct,   (% x y. (x + y))),
    (MINUS_fct,  (% x y. (x - y))),
    (MULT_fct,   (% x y. (x * y))),
    (ISZERO_fct, (% x y. b2i (x=0))),
    (NOTZERO_fct,(% x y. b2i (\<not> (x=0)))),
    (NOT_fct, 	 (% x y. b2i (\<not> (x=0)))),
    (DEC_fct, 	 (% x y. (x - 1))),
    (INC_fct, 	 (% x y. (x + 1))),
    (AND_fct, 	 (% x y. b2i ((i2b x) \<and> (i2b y)))),
    (OR_fct,     (% x y. b2i ((i2b x) \<or> (i2b y))))]"

locale test_primops =
    fixes m :: iname and n :: iname and x :: iname and y :: iname and z :: iname 
      and M :: int and N :: int
      and ok_triple_bin :: "(int => int => int) => (int => int => int) => bool"
  defines "ok_triple_bin bin_op sem_op \<equiv>  
             \<Turnstile> {(z,s). s<m>=M \<and> s<n>=N}	
      	      LET 
      	        x = Primop bin_op m n
      	      IN 
      	        IVar x
      	      END
      	      {(z,s,v). v = IVal (sem_op M N) }"
  assumes vardistinct: "distinct [m,n,x,y,z]"

declare (in test_primops)  ok_triple_bin_def[simp]
declare  foo_bin_def[simp]


lemma (in test_primops) bin_OK: "\<forall> z.  z = hd foo_bin --> ok_triple_bin (fst z) (snd z)"
apply (insert vardistinct)
apply (rule allI)
apply (rule impI)
apply (simp)
apply hoare_simp
apply (simp add: i2b_def b2i_def)
done
(* ToDo: proof \<forall> z \<in> set foo_bin *)

end
