(*  
   File:	ToyPrelude
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyPrelude.thy,v 1.1 2003/06/24 23:23:22 da Exp $

   Prelude (core libraries) for ToyGrail.
*)

header {* Prelude (core libraries) for ToyGrail. *}

theory ToyPrelude = ToyGrailDef:

section {* Basic primops *}

subsection {* semantic functions *}

constdefs AND_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "AND_fct == \<lambda> x y. x*y"
constdefs OR_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "OR_fct == \<lambda> x y. if (0<x+y) then 1 else 0"
constdefs NOT_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "NOT_fct == \<lambda> x y . if (x=0) then 1 else 0"

constdefs EQ_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "EQ_fct == \<lambda> x y. if x=y then 1 else 0"
constdefs NE_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "NE_fct == \<lambda> x y. if \<not> (x=y) then 1 else 0"
constdefs LT_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "LT_fct == \<lambda> x y. if x<y then 1 else 0"
constdefs GT_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "GT_fct == \<lambda> x y. if (y<x) then 1 else 0"
constdefs LE_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "LE_fct == \<lambda> x y. if \<not> (y<x) then 1 else 0"
constdefs GE_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "GE_fct == \<lambda> x y. if \<not> (x<y) then 1 else 0"

constdefs ISZERO_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "ISZERO_fct == \<lambda> x y . if (x=0) then 1 else 0"
constdefs NOTZERO_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "NOTZERO_fct == \<lambda> x y . if \<not> (x=0) then 1 else 0"

constdefs DEC_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "DEC_fct == \<lambda> x y . x - 1"
constdefs INC_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "INC_fct == \<lambda> x y . x+1"

constdefs PLUS_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "PLUS_fct == \<lambda> x y. x+y"
constdefs MINUS_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "MINUS_fct == \<lambda> x y. x - y" 
constdefs MULT_fct :: "int \<Rightarrow> int \<Rightarrow> int"
 "MULT_fct == \<lambda> x y. x*y"

declare AND_fct_def [simp]
declare OR_fct_def [simp]
declare NOT_fct_def [simp]

declare EQ_fct_def [simp]
declare NE_fct_def [simp]
declare LT_fct_def [simp]
declare GT_fct_def [simp]
declare LE_fct_def [simp]
declare GE_fct_def [simp]

declare ISZERO_fct_def [simp]
declare NOTZERO_fct_def [simp]

declare DEC_fct_def [simp]
declare INC_fct_def [simp]

declare PLUS_fct_def [simp]
declare MINUS_fct_def [simp]
declare MULT_fct_def [simp]

section {* Some handy shorthand syntax *}

syntax
 "primand"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl ":&" 60)
translations
 "n :& m" == "Primop AND_fct n m"

syntax
 "primor"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl ":|" 60)
translations
 "n :| m" == "Primop OR_fct  n m"

syntax
 "primnot"  :: "iname \<Rightarrow> expr"  (":\<not> _" [60] 61)
translations
 ":\<not> m" => "Primop NOT_fct m m"
 ":\<not> m" <= "Primop NOT_fct m z"


syntax
 "primeq"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl ":==" 60)
translations
 "n :== m" == "Primop EQ_fct  n m"

syntax
 "primne"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl ":!=" 60)
translations
 "n :!= m" == "Primop NE_fct  n m"

syntax
 "primgt"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl ":>" 60)
translations
 "n :> m" == "Primop GT_fct  n m"

syntax
 "primlt"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl ":<" 60)
translations
 "n :< m" == "Primop LT_fct  n m"

syntax
 "primge"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl ":>=" 60)
translations
 "n :>= m" == "Primop GE_fct  n m"

syntax
 "primle"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl ":<=" 60)
translations
 "n :<= m" == "Primop LE_fct  n m"


syntax
 "primiszero"  :: "iname \<Rightarrow> expr"  ("_ :0?" [60] 61)
translations
 "n :0?" => "Primop ISZERO_fct n n"
 "n :0?" <= "Primop ISZERO_fct n z"

syntax
 "priminc"  :: "iname \<Rightarrow> expr"  ("_ :++" [60] 61)
translations
 "m :++" => "Primop INC_fct m m"
 "m :++" <= "Primop INC_fct m z"

syntax
 "primdec"  :: "iname \<Rightarrow> expr"  ("_ :--" [60] 61)
translations
 "m :--" => "Primop DEC_fct m m"
 "m :--" <= "Primop DEC_fct m z"


syntax
 "primplus"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl ":+" 60)
translations
 "n :+ m" == "Primop PLUS_fct n m"

syntax
 "primminus"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl ":-" 60)
translations
 "n :- m" == "Primop MINUS_fct n m"

syntax
 "primmult"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl ":*" 60)
translations
 "n :* m" == "Primop MULT_fct n m"

section {* More Syntax stuff *}

syntax
 "num"  :: "'a \<Rightarrow> expr"  ("_\<^sup>z" [1000] 65)   (* did have \<int> here, but X-Sym bugs *)
translations
 "n\<^sup>z" == "expr.Int n"

syntax
 "mkIVar"  :: "iname \<Rightarrow> expr"  ("_\<^sup>I" [1000] 65)
translations
 "x\<^sup>I" == "expr.IVar x"

syntax
 "mkRVar"  :: "rname \<Rightarrow> expr"  ("_\<^sup>R" [1000] 65)
translations
 "x\<^sup>R" == "expr.rVar x"

section {* Constants *}

syntax
  tt :: expr
translations
 "tt" == "1\<^sup>z"

syntax
  ff :: expr
translations
 "ff" == "0\<^sup>z"

end
