(*  
   File:        ToyVCGtest.ML
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHWLtest.thy,v 1.1 2003/06/24 23:18:16 da Exp $

   Some tests of the VCG.
   
*)

theory ToyHWLtest = ToyHWL:

section {* Testing the VCGen *}

subsection {* \texttt{dec}: decrement a field *}

locale dec_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   z1        :: iname
    and	   q1        :: iname
    and	   zero      :: iname
    and    l1        :: locn
    and    N         :: int    
    and    count     :: ifldname
    and	   dec      :: funame
    and    DecClass :: cname 
    and	   decBody  :: expr
  defines "decBody \<equiv>  LET 
                m  = GetFi self count ;
                n  = Primop (\<lambda> x y . x - 1) m m ;
                z1 = PutFi self count n ; 
                zero = expr.Int 0 ;
                q1 = Primop (\<lambda> x y . if y<x then (1::int) else (0::int)) n zero
              IN
                IF q1 
                  THEN IVar zero
                  ELSE IVar z1
              END"
  assumes  DecClass:   "classtable DecClass = \<lparr> iflds = [count], rflds = [], meths = \<lambda> mn. K mn \<rparr>"
      and  vardistinct: "distinct [m,n,z1,q1,zero]"
      and  vardistinct': "zero ~= q1"
      and  dec_fnbdy:   "funtable dec = decBody"

declare (in dec_example) decBody_def[simp]
declare (in dec_example) dec_fnbdy[simp]

lemma (in dec_example) 
   "\<Turnstile> {(z,s). clock s = z \<and> 0 < N \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> 
        fmap_lookup (heap s) l1 = Some (DecClass, emptyi(count:=N), emptyr)}	
	decBody
      {(z,s,v). v = IVal 0 }"
apply (insert vardistinct, insert vardistinct')
apply (simp)
apply hoare_simp
done

lemma (in dec_example) 
   "[| wf (fun_wfmeasure_table dec) |] ==>  
    \<Turnstile> {(z,s). 0 < N \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> 
         s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count:=N), emptyr)}	
      (CALL dec)
      {(z,s,v). v = IVal 0 \<and>
         s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count:=(N - 1)), emptyr) }"
apply (insert vardistinct)
apply (simp)
apply (hoare_simp)
apply (assumption)
done

lemma (in dec_example) 
   "[| wf (fun_wfmeasure_table dec) |] ==>  
    \<Turnstile> {(z,s). 0 < N \<and> s<z1>=0 \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> 
         s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count:=N), emptyr)}	
      IF z1
        THEN IVar z1
        ELSE CALL dec
      {(z,s,v). v = IVal 0 \<and>
         s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count:=(N - 1)), emptyr) }"
apply (insert vardistinct)
apply (simp)
apply (hoare_simp)
defer 1
apply (rule_tac x="l1" in exI)
apply (rule conjI)
defer 1
apply (rule_tac x="DecClass" in exI)
apply (rule_tac x="emptyi(count := N - 1)" in exI)
apply (rule conjI)
apply (rule impI)
apply (rule conjI)
defer 1
apply (rule impI)
apply (rule conjI)
apply (rule_tac x="emptyr" in exI)
defer 1
apply (rule_tac x="l1" in exI)
apply (rule conjI)
defer 1
apply (rule_tac x="DecClass" in exI)
apply (rule_tac x="emptyi(count := N - 1)" in exI)
apply (rule_tac x="emptyr" in exI)
apply (rule conjI)
defer 1
apply (rule conjI)
defer 1
apply (simp)
defer 1
apply (rule impI)
apply (auto)
(* False *)
oops

subsection {* dec2 (non-rec, but with a CALL in the ELSE branch) *}

consts the_locn :: "ref => locn"
primrec 
"the_locn (Ref l) = l"

constdefs the_ifld :: "rname => ifldname => state => nat"
"the_ifld x y s == nat ((fst (snd (the (fmap_lookup (heap s) (the_locn (s\<lfloor>x\<rfloor>)))))) y)"

(*                    Ref r => nat (snd (the (fmap_lookup (heap s) r)) count) *)

locale dec2_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   z1        :: iname
    and	   q1        :: iname
    and	   zero      :: iname
    and	   zero'     :: iname
    and    l1        :: locn
    and    N         :: int    
    and    count     :: ifldname
    and	   dec      :: funame
    and    DecClass :: cname 
    and	   decBody  :: expr
    and    const     :: funame
    and	   constBody  :: expr
  defines "decBody \<equiv>  LET 
                m  = GetFi self count ;
                n  = Primop (\<lambda> x y . x - 1) m m ;
                z1 = PutFi self count n ; 
                zero = expr.Int 0 ;
                q1 = Primop (\<lambda> x y . if \<not> y<x then (1::int) else (0::int)) n zero
              IN
                IF q1 
                  THEN IVar zero
                  ELSE CALL const
              END"
  and     "constBody \<equiv>  IVar n"
  assumes  DecClass:   "classtable DecClass = \<lparr> iflds = [count], rflds = [], meths = \<lambda> mn. K mn \<rparr>"
      and  vardistinct: "distinct [m,n,z1,q1,zero,zero']"
      and  dec_fnbdy:   "funtable dec = dec2Body"
      and  const_fnbdy:   "funtable const = constBody "
      and  dec_wfmeasure: "fun_wfmeasure_table dec = inv_image less_than (the_ifld self x)"
      and  const_wfmeasure: "fun_wfmeasure_table const = inv_image less_than (\<lambda>s . nat (s<n>))"
      and  const_inv_pre: "(fst fun_assn_table) const = {(z, s). s<n>=N \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and>
             s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)}"
      and  const_inv_post: "(snd fun_assn_table) const = {(z, s, v).
             v = IVal N \<and> s<n>=N \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and>
             s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)}"
      and const_inv: "\<Turnstile> {(z, s). s<n>=N \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and>
             s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)} 
            constBody
            {(z, s, v).
             v = IVal N \<and> s<n>=N \<and>
             s\<lfloor>self\<rfloor> = Ref l1 \<and>
             s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)}"
(*       and const_inv: "\<Turnstile> ((fst fun_assn_table) const) CALL const ((snd fun_assn_table) const)" *)

declare (in dec2_example) decBody_def[simp]
declare (in dec2_example) dec_fnbdy[simp]
declare (in dec2_example) constBody_def[simp]
declare (in dec2_example) const_fnbdy[simp]
declare (in dec2_example) dec_wfmeasure[simp]

(* const alone is ok *)
lemma (in dec2_example) 
   "[| wf (fun_wfmeasure_table const) |] ==>  
    \<Turnstile> {(z,s). s<n>=N}	
      (CALL const)
      {(z,s,v). v = IVal N \<and> s<n>=N}"
apply (insert vardistinct)
apply (simp)
apply (hoare_simp)
done

(* LET alone is ok *)
lemma (in dec2_example) 
   "[| wf (fun_wfmeasure_table const) |] ==>  
    \<Turnstile> {(z,s). s<n>=N}	
      LET 
        zero' = expr.Int 0
      IN 
        IVar n
      END
      {(z,s,v). v = IVal N \<and> s<n>=N}"
apply (insert vardistinct)
apply (simp)
apply (hoare_simp)
done

(* combining both sucks *)
lemma (in dec2_example) 
   "[| wf (fun_wfmeasure_table const) |] ==>  
    \<Turnstile> {(z,s). 0 < N \<and> s<n>=N}	
      LET 
        zero' = expr.Int 0
      IN 
        CALL const
      END
      {(z,s,v). v = IVal N}"
apply (insert vardistinct)
apply (simp)
apply hoare_simp
apply (auto)
oops

(* same if the CALL is nested in an IF *)
lemma (in dec2_example) 
   "[| wf (fun_wfmeasure_table const) |] ==>  
    \<Turnstile> {(z,s). 0 < N \<and> s<n>=N \<and> s<z1>=0}	
      IF z1
        THEN IVar n
        ELSE CALL const
      {(z,s,v). v = IVal N}"
apply (insert vardistinct)
apply (simp)
apply hoare_simp
apply (auto)
oops

lemma (in dec2_example) 
   "[| wf (fun_wfmeasure_table const) |] ==>  
    \<Turnstile> {(z,s). s<n>=N}	
      LET 
        zero' = expr.Int 0
      IN 
        CALL const
      END
      {(z,s,v). v = IVal N}"
apply (insert vardistinct)
apply (simp)
(* doing it manually; no VCG for now *)
apply (rule HLet)
apply (rule HSP)
apply (rule HInt0)
apply (simp)
apply (rule subsetI)
(* done with let header; ?R1 is post-assn for body, after "system" work in let *)
defer 1
apply (rule HCall0)
apply (rule allI)
apply (simp)
apply (rule HSP)
apply (rule HVar0)
apply (rule subsetI)
apply (simp)
apply (auto)
(* False !? *)
oops

(* dropping from Hoare-level to foundational-level *)
(* apply (unfold hoare_valid_def)
apply (rule allI)+
apply simp
apply (rule impI)
apply (rule impI)
apply (rule allI)
apply (rule_tac x="0" in exI)
apply (rule conjI)
defer 1
defer 1
*)
(* incomplete but looks ok on this level *)
(*
apply (rule allI)+
apply (rule impI)
apply (rule allI)+
apply (rule impI)
apply simp
apply (rule conjI)
*)


lemma (in dec2_example) 
   "[| wf (fun_wfmeasure_table const) |] ==>  
    \<Turnstile> {(z,s). s<n>=N}	
      LET 
        zero' = expr.Int 0
      IN 
        CALL const
      END
      {(z,s,v). v = IVal N \<and> s<n>=N}"
apply (insert vardistinct)
apply (simp)
apply (hoare_simp)
apply (auto)
(* seems auto throws too much info away *)
oops

(* without the CALL it works fine *)
lemma (in dec2_example) 
   "[| wf (fun_wfmeasure_table const) |] ==>  
    \<Turnstile> {(z,s). s<n>=N}	
      LET 
        zero' = expr.Int 0
      IN 
        IVar n
      END
      {(z,s,v). v = IVal N \<and> s<n>=N}"
apply (insert vardistinct)
apply (simp)
apply hoare_simp_step  (* LET *)
defer 1
apply hoare_simp_step  (* IVar *)
apply hoare_simp_step  (* Int 0 *)
done

(* with the call we get stuck *)
lemma (in dec2_example) 
   "[| wf (fun_wfmeasure_table const) |] ==>  
    \<Turnstile> {(z,s). s<n>=N}	
      LET 
        zero' = expr.Int 0
      IN 
        CALL const
      END
      {(z,s,v). v = IVal N \<and> s<n>=N}"
apply (insert vardistinct)
apply (simp)
apply (hoare_simp)
defer 1
defer 1
apply (simp add: const_wfmeasure inv_image_def)
apply (erule thin_rl)
defer 1
defer 1
apply (auto)
(* again that s'<n> = N left to prove *)
oops

lemma (in dec2_example) 
   "[| wf (fun_wfmeasure_table dec) ; wf (fun_wfmeasure_table const) ; zero \<noteq> q1 |] ==>  
    \<Turnstile> {(z,s). clock s = z \<and> 0 < N \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> 
         s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count:=N), emptyr)}	
	decBody
      {(z,s,v). v = IVal (N - 1) }"
apply (insert vardistinct)
apply (simp)
apply (hoare_simp)
apply (auto)
oops

lemma (in dec2_example) 
   "[| wf (fun_wfmeasure_table dec) ; wf (fun_wfmeasure_table const) |] ==>  
    \<Turnstile> {(z,s). 0 < N \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> 
         s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count:=N), emptyr)}	
      decBody
      {(z,s,v). v = IVal (N - 1) \<and>
         s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count:=(N - 1)), emptyr) }"
apply (insert vardistinct)
apply (insert const_inv)
apply (simp add: const_inv)
apply (insert const_inv)
apply (rotate_tac -1)
apply (hoare_simp)
apply (auto)
oops

subsection {* \texttt{ping}: recursive CALL version *}

locale ping_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   z1        :: iname
    and	   q1        :: iname
    and	   zero      :: iname
    and    l1        :: locn
    and    N         :: nat    
    and    count     :: ifldname
    and	   ping      :: funame
    and    PingClass :: cname 
    and	   pingBody  :: expr
  defines "pingBody \<equiv>  LET 
                m  = GetFi self count ;
                n  = Primop (\<lambda> x y . x - 1) m m ;
                z1 = PutFi self count n ; 
                zero = expr.Int 0 ;
                q1 = Primop (\<lambda> x y . if \<not> y<x then (1::int) else (0::int)) n zero
              IN
                IF q1 
                  THEN IVar zero
                  ELSE CALL ping
              END"
  assumes  PingClass:   "classtable PingClass = \<lparr> iflds = [count], rflds = [], meths = \<lambda> mn. K mn \<rparr>"
      and  vardistinct: "distinct [m,n,z1,q1,zero]"
      and  pingfnbdy:   "funtable ping = pingBody"
      and  wfmeasure [simp]: "fun_wfmeasure_table ping = inv_image less_than (the_ifld self x)"
      (* and  wfmeasure [simp]:  "fun_wfmeasure_table countfn = inv_image less_than (\<lambda> s. snd (the (fmap_lookup (heap s) (case (s\<lfloor>self\<rfloor>) of Ref r => r))) count)" *)
      (* and  wfmeasure:   "fun_wfmeasure_table countfn = {(s1,s2). (s1<n>) < (s2<n>)}" *)

(*
constdefs (in ping_example) measure_by_ifld :: "rname => (state \<times>) state set"
"measure_by_ifld x == inv_image less_than (the_ifld self x)"
*)

declare (in ping_example) pingBody_def[simp]
declare (in ping_example) pingfnbdy[simp]

(* probably need more assumptions: many VCs don't simplify *)
lemma (in ping_example) 
   "[| wf (fun_wfmeasure_table ping) |] ==>  
    \<Turnstile> {(z,s). 0 < N \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> 
         s\<lless>l1\<ggreater> = Some (PingClass, emptyi(count:=(int N)), emptyr)}	
      (CALL ping)
      {(z,s,v). v = IVal 0 \<and>
         s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (PingClass, emptyi(count:=0), emptyr) }"
apply (insert vardistinct)
apply (simp)
apply hoare_simp
(* 2 subgoals, both VCs, hurray *)
(* Plan A: take VCs apart and check what's really needed to be proven *)
apply (rule conjI)
apply (rule impI)
apply (rule conjI)
oops

(*
apply (rule impI)
apply (rule conjI)
defer 1
apply (rule impI)
apply (rule conjI)
defer 1
apply (rule impI)
apply (rule conjI)
defer 1
apply (rule_tac x="l1" in exI)
apply (rule conjI)
defer 1
apply (rule_tac x="PingClass" in exI)
apply (rule_tac x="emptyi(count := N)" in exI)
apply (rule conjI)
apply (rule impI)
apply (rule conjI)
*)(* argh, that order-in-vardistinct problem again *)(*
defer 1
apply (rule impI)
apply (rule conjI)
apply (rule_tac x="emptyr" in exI)
apply (simp)
*)(* argh, lost the structure theorem on l1 *)(*
defer 1
apply (rule_tac x="l1" in exI)
apply (rule conjI)
apply simp
*)(* argh, lost the structure theorem on l1 *)(*
defer 1
*)(* instantiate components of the obj *)(*
apply (rule_tac x="PingClass" in exI)
apply (rule_tac x="emptyi(count := N)" in exI)
apply (rule_tac x="emptyr" in exI)
apply (simp)
*)(* argh, lost the structure theorem on l1 *)(*
defer 1
apply (rule impI)
apply (rule conjI)
apply (rule_tac x="emptyr" in exI)
*)(* argh, lost the structure theorem on l1 *)(*
defer 1
apply (rule_tac x="l1" in exI)
apply (rule conjI)
*)(* argh, lost the structure theorem on l1 *)(*
defer 1
apply (rule_tac x="PingClass" in exI)
apply (rule_tac x="emptyi(count := N)" in exI)
apply (rule_tac x="emptyr" in exI)
apply (rule conjI)
apply (simp)
*)(* argh, lost the structure theorem on l1 *)(*
defer 1
apply (simp)
apply (rule conjI)
apply (simp add: state_functions)
oops
*)
(* Plan B: use the sledgehammer *)
(* apply (auto) *)


lemma (in ping_example) 
   "[| wf (fun_wfmeasure_table ping) |] ==>  
    \<Turnstile> {(z,s). clock s = z \<and> 0 = N \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> 
        fmap_lookup (heap s) l1 = Some (PingClass, emptyi(count:=(int N)), emptyr)}	
	pingBody
      {(z,s,v). v = IVal 0 }"
apply (insert vardistinct)
apply (simp)
apply hoare_simp
(* this fails to expand the IF in the let body #$#$@ *)
(* apply (simp add: state_functions) *)
(**)
defer 1
oops


subsection {* \texttt{coast/pedal} example (mut-rec CALL) taken from~\cite{Nipkow-CSL02} *}

constdefs ISZERO :: "iname => expr"
 "ISZERO n == Primop (% x y. if x=0 then 1 else 0) n n"
constdefs DEC :: "iname => expr"
 "DEC n == Primop (% x y. x - 1) n n"
constdefs MYAND :: "iname => iname => expr"
 "MYAND m n == Primop (% x y. x*y) m n"
constdefs MYLT :: "iname => iname => expr"
 "MYLT m n == Primop (% x y. if x<y then 1 else 0) m n"

locale coast_pedal_example =
    fixes    m  :: iname
      and    n  :: iname
      and    q1 :: iname
      and    q2 :: iname
      and    q3 :: iname
      and    q4 :: iname
      and    q5 :: iname
      and    M :: int
      and    N :: int
      and pedal :: funame
      and coast :: funame
      and pedalBody :: expr
      and coastBody :: expr
  defines "pedalBody == LET
                         q1 = ISZERO n ;
                         q2 = ISZERO m ;
                         q3 = MYAND q1 q3
                       IN
                       	 IF q3 
                       	   THEN IVar q3 
                       	   ELSE LET
                       	          q4 = MYLT n m
                       	        IN
                       	          IF q4
                       	            THEN LET
                       	                   n = DEC n;
                       	                   m = DEC m
                       	                 IN 
                       	                   CALL coast
                       	                 END
                       	             ELSE LET
                       	                   n = DEC n
                       	                  IN 
                       	                   CALL pedal
                       	                  END
	                        END
                       END"
      and "coastBody == LET
                         q5 = MYLT n m
                       IN
                         IF q5
                           THEN LET
                                  m = DEC m
                                IN
                                  CALL coast
                                END
                           ELSE CALL pedal
                       END"
  assumes pedalfnbdy : "funtable pedal = pedalBody"
      and coastfnbdy : "funtable coast = coastBody"
      and vardistinct : "distinct [m,n,q1,q2,q3,q4,q5]"

      (* ToDo: use lexicographic ordering on (n,m) as measure
         and  wfmeasure [simp]:  "fun_wfmeasure_table countfn = inv_image less_than (\<lambda> s. nat (get_ivar s n))"*)

declare (in coast_pedal_example) pedalfnbdy [simp]  (* function body lookup *)
declare (in coast_pedal_example) coastfnbdy [simp]  (* function body lookup *)
declare (in coast_pedal_example) pedalBody_def [simp]  (* unfold function body *)
declare (in coast_pedal_example) coastBody_def [simp]  (* unfold function body *)
declare (in coast_pedal_example) ISZERO_def [simp]  (* unfold basic expr constructor *)
declare (in coast_pedal_example) MYAND_def [simp]   (* unfold basic expr constructor *)
declare (in coast_pedal_example) MYLT_def [simp]    (* unfold basic expr constructor *)

lemma (in coast_pedal_example) 
   "\<Turnstile> {(z,s). (s<m>=M) \<and> (s<n>=N) \<and> (0<N) \<and> (0<M)} 
	pedalBody
      {(z,s,v). (v = IVal 1) \<and> (s<m>=0) \<and> (s<n>=0)}"
apply (insert vardistinct)
apply (simp)
oops
(* apply hoare_simp*) (* loops *)

subsection {* ping (INVOKE version) *}

(*
locale example_ping =
  fixes    m :: iname
    and	   n :: iname
    and	   z1 :: iname
    and	   q1 :: iname
    and	   zero :: iname
    and	   dummyarg :: iname
    and	   count    :: ifldname
    and	   ping     :: mname
    and	   countfn  :: funame
    and    PingClass :: cname 
    and	   pingBody :: expr
  defines "pingBody \<equiv>  LET 
                m  = GetFi self count ;
                n  = Primop (\<lambda> x y . x - 1) m m ;
                z1 = PutFi self count n ; 
                zero = expr.Int 0 ;
                q1 = Primop (\<lambda> x y . if y<x then (1::int) else (0::int)) n zero
              IN
                IF q1 
                  THEN Invoke self ping dummyarg
                  ELSE Var z1
              END"
  assumes  PingClass: "classtable PingClass = \<lparr> flds = [count], meths = empty ( ping \<mapsto> ({m,n,z1,q1,zero}, pingBody) ) \<rparr>"
      and  vardistinct: "distinct [m,n,z1,q1,zero]"
*)
end

(* -- doing single stepping through the derivation *)
apply hoare_simp_step (* step 1 *)
defer 1
apply hoare_simp_step (* step 2 *)
defer 1
apply hoare_simp_step (* step 3 *)
defer 1
apply hoare_simp_step (* step 4 *)
defer 1
apply hoare_simp_step (* step 5 *)
defer 1
apply hoare_simp_step
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HCall0") 1 *})
apply (tactic {* rtac allI 1 *})
apply (simp)
(* body now unfolded *)
apply hoare_simp_step (* step 1 *)
defer 1
apply hoare_simp_step (* step 2 *)
defer 1
apply hoare_simp_step (* step 3 *)
defer 1
apply hoare_simp_step (* step 4 *)
defer 1
apply hoare_simp_step (* step 5 *)
defer 1
apply hoare_simp_step
(* at CALL again; we should be able to apply assumption now *)
apply (tactic {* (assume_tac 1) *})
apply hoare_simp_step (* IVar *)
defer 1
apply hoare_simp_step (* IVar *)
apply hoare_simp_step (* GetFi self count *)
(* needs simp *)
(* apply (tactic {* (BasicSimpTac tac 1) *} *)
defer 1
apply hoare_simp_step (* Primop *)
apply hoare_simp_step (* GetFi self count *)
apply hoare_simp_step (* Int 0 *)
apply hoare_simp_step (* Primop *)
apply hoare_simp_step (* GetFi self count *)
(* needs simp *)
defer 1
apply hoare_simp_step (* Primop *)
apply hoare_simp_step (* GetFi self count *)
apply hoare_simp_step (* Int 0 *)
apply hoare_simp_step (* Primop *)
(* wf-ness follows from assumption *)
apply (assumption)
(* -- now only VCs left *)
apply (auto)
(* False; petaQ!!!! *)
oops

(*ping*)
apply hoare_simp_step (* IF *)
(* the next step should introduce an ind hyp *)
apply hoare_simp_step (* IF *)
(* needs debugging to figure out where the VCG gets stuck *)
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HCall0") 1 *})
apply (tactic {* rtac allI 1 *})
(* apply (tactic {* rtac (thm "subset_refl") 1 *}) *)
(* apply (tactic {* BasicSimpTac all_tac 1 *}) *)
apply (simp)
apply hoare_simp
apply (fastsimp)
defer 1
apply simp
defer 1
apply (simp add: state_functions)
apply hoare_simp_step
apply (fastsimp)
apply hoare_simp_step
defer 1
apply hoare_simp_step
apply (fastsimp)


apply (rule HCall)

apply hoare_simp_step
apply (simp)

apply (simp add: state_functions)
*)
