(*  
   File:        ToyVCG.ML
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHWL.thy,v 1.1 2003/06/24 23:18:04 da Exp $

   Verification Condition Generator for ToyGrail.
   
   TODO:
     -- Improve efficiency of VCG
     -- Fixup documentation

*)

theory ToyHWL = ToyGrailDef + ToyHLbasic
files ("ToyHWL.ML"):

section {* VCGen *}

subsection {* Simplifications used in VCGen tactic below *}

text {* These simplifications are taken from Hoare/hoare.ML and need changes
to fit with our stuff. Basic simplifications on sets should be still useful,
though *}

(*****************************************************************************)
(** Simplifying:                                                            **)
(** Some useful lemmata, lists and simplification tactics to control which  **)
(** theorems are used to simplify at each moment, so that the original      **)
(** input does not suffer any unexpected transformation                     **)
(*****************************************************************************)

lemma Compl_Collect: "-(Collect b) = {x. ~(b x)}"
by (fast)


subsection {* Tactic for the generation of the verification conditions *} 

text {* @{text "HoareRuleTac"} is the VCGen tactic. 
This tactic doesn't use @{text "WlpTac"} since there is no explicit
sequencing construct.
It uses the lemmas in ToyHLbasic directly. The example tactic in HoareParallel
encodes rule of consequence directly in the syntax-direct rules. I suppose we 
need more applications of HSP etc in this tactic.
*}

text {* Our master plan of handling recursive functions/methods:

\begin{enumerate}
\item Try applying assumption (if we have ind hypo on fct in assumptions already)
\item Apply HRec or HRecWF (the latter is more flexible and probably better)
   WIth HRecWF, this needs to instantiate a measure. Maybe assume that we have
   a table mapping fnames to measures and get it from there.
   (similar to the assertion table we need anyway)
\item Apply HCall
\item Unfold the body of the function. Maybe feed the funtable directly to simplifier.
*} 

use "ToyVCG.ML";

method_setup hoare = {*
  Method.no_args
    (Method.SIMPLE_METHOD' HEADGOAL (hoare_tac (K all_tac) ))  *}
  "ToyGrail verification condition generator"

method_setup hoare_simp = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      hoare_tac (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)) 1))  *}
  "ToyGrail verification condition generator plus simplification"

method_setup hoare_arith = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      hoare_tac (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)
		 ORELSE' arith_tac) 1))  *}
  "ToyGrail verification condition generator plus simplification and arithmetic"

method_setup hoare_step = {*
  Method.no_args
    (Method.SIMPLE_METHOD' HEADGOAL (hoare_step_tac (K all_tac))) *}
  "ToyGrail verification condition generator, single step"

method_setup hoare_simp_step = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      hoare_step_tac (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)) 1))  *}
  "ToyGrail verification condition generator plus simplification, single step"






end

