(*  
   File:	ToyHLproc.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLproc.thy,v 1.1 2003/03/14 12:18:02 da Exp $
   Status:      [ IN DEVELOPMENT // MAYBE OBSOLETE ]

   Rules for recursive procedures and methods rules, with test examples.

   TODO:
     - Synchronise this with addition of HRec rules in ToyHLbasic now.
     - Perhaps skip validity in context until we define the 
       proof system proper?
*)   

header {* Hoare logic for Toy Grail: Procedure Rules *}

theory ToyHLproc = ToyHLbasic:

text {* This theory introduces rules for reasoning about
  functions and methods. *}

(*********************************************************************************)

section {* Validity within a context *}

text {* We formalise contextual validity, following Nipkow. 
  A context is a set of hoare triples. *}

types
  'a etriple  = "'a preassn \<times> expr \<times> 'a postassn"

constdefs set_valid :: "('a etriple) set \<Rightarrow> bool"   ("\<parallel>= _" 50)
   "\<parallel>= C  \<equiv> \<forall> (P,e,Q) \<in> C. \<Turnstile> P e Q"

constdefs conseqset_valid :: "('a etriple) set \<Rightarrow> ('a etriple) set \<Rightarrow> bool"   ("_ \<parallel>= _" 51)
   "C \<parallel>= D  \<equiv> (\<parallel>= C) \<longrightarrow> (\<parallel>= D)"

(* IDEA: think of having a map from function names to pre,post pairs here instead. *)

lemma HDropCtxt: "(\<Turnstile> P e Q) \<Longrightarrow> ({} \<parallel>= {(P,e,Q)})"
by (unfold set_valid_def conseqset_valid_def, fastsimp)

lemma HLiftCtxt: "({} \<parallel>= {(P,e,Q)}) \<Longrightarrow> (\<Turnstile> P e Q)"
by (unfold set_valid_def conseqset_valid_def, fastsimp)

lemma HSet: "(\<forall> (P,e,Q)\<in> D. (C \<parallel>= {(P,e,Q)}))  \<longrightarrow> (C \<parallel>= D)"
by (unfold set_valid_def conseqset_valid_def, auto)

lemma HSingle: "\<lbrakk> C \<parallel>= D ; (P,e,Q) \<in> D \<rbrakk> \<Longrightarrow> (C \<parallel>= {(P,e,Q)})"
by (unfold set_valid_def conseqset_valid_def, fastsimp)

lemma HEmptyCtxt: "({} \<parallel>= {(P, e, Q)}) \<Longrightarrow>  (\<Turnstile> P e Q)"
by (unfold set_valid_def conseqset_valid_def, fastsimp)


subsection {* HCallWF --- using a well-founded ordering *}

text {* The locale defines a definition HoareS which is the 
  abstraction of validity of a Hoare triple over the starting state. *}

(*
locale hcall =
 fixes HoareS  :: "state \<Rightarrow> 'a preassn \<Rightarrow> expr \<Rightarrow> 'a postassn \<Rightarrow> bool"
 defines "HoareS s P e Q ==  \<forall> v t. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> 
		 	       (\<forall> z. (z,s)\<in> P \<longrightarrow> (z,t,v)\<in> Q)"
*)

constdefs HoareS  :: "state \<Rightarrow> 'a preassn \<Rightarrow> expr \<Rightarrow> 'a postassn \<Rightarrow> bool"
  "HoareS s P e Q ==  \<forall> v t. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> 
		 	       (\<forall> z. (z,s)\<in> P \<longrightarrow> (z,t,v)\<in> Q)"

lemma HoareStriple: "(\<Turnstile> P e Q) = (\<forall> s. HoareS s P e Q)"
by (unfold hoare_valid_def HoareS_def, auto)

lemma hoareSss: "(\<forall>s. (s, s') \<in> r \<longrightarrow> HoareS s P (CALL f) Q)  = 
           (\<Turnstile> {(z,s).(z,s)\<in> P \<and> (s,s')\<in> r} (CALL f) Q)"
apply (simp add: HoareS_def hoare_valid_def)
apply (auto)
done

lemma mywf: 
"\<lbrakk> wf r; \<forall> s'. 
           (\<forall> s. (s,s')\<in> r \<longrightarrow> HoareS s P e Q) \<longrightarrow> HoareS s' P e Q \<rbrakk>
 \<Longrightarrow> (\<Turnstile> P e Q)"
apply (rule HoareStriple [THEN iffD2])
apply (rule)
apply (rule_tac a = "s" and P = "\<lambda> s. HoareS s P e Q" in wf_induct)
apply (assumption)
apply (erule_tac x="x" in allE)
apply (auto)
done

lemma hoareSs: "(\<Turnstile> untickuncall {(z, s). (z, s) \<in> P \<and> s = s'} (funtable f) Q)
		           \<Longrightarrow>  HoareS s' P (CALL f) Q"
apply (simp add: HoareS_def hoare_valid_def untickuncall_def)
apply (auto elim!: evalCall_cases)
done


text {* HCallSingleRecWF establishes validity for a singly-recursive
  function, using a well-founded ordering on states.
  (This is usually for total correctness; it guarantees termination). *}


(* FIXME: proof of this might be cleaned up a bit, or converted to Isar *)
lemma HCallSingleRecWF: 
 "\<lbrakk> wf r;
    \<forall> s'. {({(z,s).(z,s)\<in> P \<and> (s,s')\<in> r},CALL f,Q)} 
             \<parallel>= {(untickuncall {(z,s).(z,s)\<in> P \<and> s=s'}, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply (simp add: conseqset_valid_def set_valid_def)
apply (erule mywf)
apply (auto)
apply (erule allE)
apply (rule hoareSs)
apply (erule mp)
apply (rule hoareSss [THEN iffD1], assumption)
done


subsection {* HCallRec *}

(* Let's try lifting the last rule using the well-founded ordering
   on states given by the clock itself. *)

(*
lemma "clock s < clock s' \<Longrightarrow> (s, s') \<in> inv_image less_than clock"
apply (simp add: inv_image_def less_than_def)
*)

lemma HCallSingleRecclock: 
 "\<lbrakk> \<forall> s'. {({(z,s).(z,s)\<in> P \<and> (clock s < clock s')},CALL f,Q)} 
           \<parallel>= {(untickuncall {(z,s).(z,s)\<in> P \<and> s=s'}, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply (rule_tac r="inv_image less_than (clock::state\<Rightarrow>nat)" in HCallSingleRecWF)
apply (rule wf_inv_image, rule wf_less_than)
apply (simp add: conseqset_valid_def set_valid_def)
apply (simp add: inv_image_def)
done

(*some more measures -- most of the measures are only weakly monotone for our opSem!*)
lemma HCallSingleRecLengthFramestack: 
 "\<lbrakk> \<forall> s'. {({(z,s).(z,s)\<in> P \<and> (length (framestack s) < length (framestack s'))},CALL f,Q)} 
           \<parallel>= {(untickuncall {(z,s).(z,s)\<in> P \<and> s=s'}, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply (rule_tac r="inv_image less_than (length o framestack::state\<Rightarrow>nat)" in HCallSingleRecWF)
apply (rule wf_inv_image, rule wf_less_than)
apply (simp add: conseqset_valid_def set_valid_def)
apply (simp add: inv_image_def)
done

lemma HCallSingleMaxstack: 
 "\<lbrakk> \<forall> s'. {({(z,s).(z,s)\<in> P \<and> (maxstack s < maxstack s')},CALL f,Q)} 
           \<parallel>= {(untickuncall {(z,s).(z,s)\<in> P \<and> s=s'}, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply (rule_tac r="inv_image less_than (maxstack::state\<Rightarrow>nat)" in HCallSingleRecWF)
apply (rule wf_inv_image, rule wf_less_than)
apply (simp add: conseqset_valid_def set_valid_def)
apply (simp add: inv_image_def)
done

lemma HCallSingleCallcount: 
 "\<lbrakk> \<forall> s'. {({(z,s).(z,s)\<in> P \<and> (callcount s < callcount s')},CALL f,Q)} 
           \<parallel>= {(untickuncall {(z,s).(z,s)\<in> P \<and> s=s'}, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply (rule_tac r="inv_image less_than (callcount::state\<Rightarrow>nat)" in HCallSingleRecWF)
apply (rule wf_inv_image, rule wf_less_than)
apply (simp add: conseqset_valid_def set_valid_def)
apply (simp add: inv_image_def)
done

lemma HCallSingleInvokecount: 
 "\<lbrakk> \<forall> s'. {({(z,s).(z,s)\<in> P \<and> (invokecount s < invokecount s')},CALL f,Q)} 
           \<parallel>= {(untickuncall {(z,s).(z,s)\<in> P \<and> s=s'}, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply (rule_tac r="inv_image less_than (invokecount::state\<Rightarrow>nat)" in HCallSingleRecWF)
apply (rule wf_inv_image, rule wf_less_than)
apply (simp add: conseqset_valid_def set_valid_def)
apply (simp add: inv_image_def)
done

constdefs subset :: "(('a set) \<times> ('a set)) set"
"subset == {(A,B) . A < B}"

lemma HCallSingleRecDomHeap: 
 "\<lbrakk> \<forall> s'. {({(z,s).(z,s)\<in> P \<and> (dom (heap s) < dom (heap s'))},CALL f,Q)} 
           \<parallel>= {(untickuncall {(z,s).(z,s)\<in> P \<and> s=s'}, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply (rule_tac r="inv_image subset (dom  o heap::state\<Rightarrow>(nat set))" in HCallSingleRecWF)
apply (rule wf_inv_image dom_def subset_def)
prefer 2
(*apply( rule wf_subset)*)
apply (simp add: conseqset_valid_def set_valid_def dom_def)
apply (simp add: inv_image_def dom_def subset_def)
apply(rule wf_subset)
apply(auto)
apply(simp add: dom_def subset_def)
(*should succeed for finite heaps! measure is size*)
sorry

(*
lemma HConseqProc: "\<lbrakk> \<Turnstile> P' e Q'; 
		       \<forall> s t v. 
		        (\<forall> z. (z,s)\<in> P' \<longrightarrow> (z,t,v)\<in> Q')
			\<longrightarrow>
		        (\<forall> z. (z,s)\<in> P \<longrightarrow> (z,t,v)\<in> Q) \<rbrakk>
		   \<Longrightarrow> \<Turnstile> P e Q"
*)

lemma clock_mono_rl [simp] : "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> clock s < clock t"
apply (rule clock_mono [THEN mp])
apply (assumption)
done

(* NB: type constraint below is crucial: otherwise unification fails between
   state record and state with additional fields. *)
lemma foo: "\<forall> s'::state. \<Turnstile> {(z, s). (z, s) \<in> P \<and> clock s < clock s'} e Q \<Longrightarrow> \<Turnstile> P e Q"
apply (simp add: hoare_valid_def)
apply (clarify)
apply (rename_tac s1 t1 v1 z1)
apply (erule_tac x="t1" in allE)
apply (erule_tac x="s1" in allE)
apply (erule_tac x="t1" in allE)
apply (erule_tac x="v1" in allE)
apply (auto)
done

lemma foo2: "\<Turnstile> {(z, s). (z, s) \<in> P \<and> clock s < clock s'} e Q \<Longrightarrow> \<Turnstile> P e Q"
apply (simp add: hoare_valid_def)
apply (clarify)
apply (rename_tac s1 t1 v1 z1)
apply (erule_tac x="s1" in allE)
apply (erule_tac x="t1" in allE)
apply (erule_tac x="v1" in allE)
apply (auto)
sorry

(*
lemma bar: "\<And>s'::state. \<Turnstile> {(z, s). (z, s) \<in> P \<and> clock s < clock s'} e Q \<Longrightarrow> \<Turnstile> P e Q"
apply (rule foo)
apply (auto)
*)

lemma bar: "\<forall> s'::state. (\<Turnstile> {(z, s). (z, s) \<in> P \<and> clock s < clock s'} CALL f Q) \<longrightarrow>
             (\<Turnstile> untickuncall {(z, s). (z, s) \<in> P \<and> s = s'} funtable f Q) \<longrightarrow>
             (\<Turnstile> P CALL f Q) \<longrightarrow>  (\<Turnstile> untickuncall P funtable f Q)"
sorry


lemma HCallSingleRec: 
 "\<lbrakk> {(P,CALL f,Q)} \<parallel>= {(untickuncall P, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply (rule HCallSingleRecclock)
apply (simp add: conseqset_valid_def set_valid_def)
apply (clarify)
(*
 1. \<And>s'. \<lbrakk>\<Turnstile> P CALL f Q \<longrightarrow> \<Turnstile> untickuncall P funtable f Q;
            \<Turnstile> {(z, s). (z, s) \<in> P \<and> clock s < clock s'} CALL f Q\<rbrakk>
         \<Longrightarrow> \<Turnstile> untickuncall {(z, s). (z, s) \<in> P \<and> s = s'} funtable f Q
*)
apply (rule HSP)
apply (erule mp)
apply (rule HSP, assumption)
prefer 2
apply (simp add: untickuncall_def)
apply (fastsimp)   (* proves all s'.
			untickuncall {(z, s). (z, s) \<in> P \<and> s = s'} \<subseteq> untickuncall P *)
sorry
(*
apply (erule mp)
apply (simp add: hoare_valid_def)
apply (blast)
apply (simp add: inv_image_def)
done
*)

(*
lemma "(\<Turnstile> P e Q) \<Longrightarrow> (\<forall> s'. \<Turnstile> {(z,s).(z,s)\<in> P \<and> (clock s < clock s')} e Q)"
apply (rule hoareSss [THEN iffD1], assumption)
apply (rule)

apply (rule 
apply , unfold hoare_valid_def)
apply 
lemma HExAll:  "(\<Turnstile> {(z,s).  \<exists> t. P t z s} e Q) =  (\<forall> t. \<Turnstile> {(z,s). P t z s} e Q)"
by (simp add: hoare_valid_def, blast)


apply
{(,CALL f,Q)} 



lemma "\<Turnstile> {(z, s). (z, s) \<in> P \<and> clock s < clock s'} CALL f Q \<Longrightarrow> \<Turnstile> P CALL f Q"

lemma "clock s < clock s'\<Turnstile> untickuncall P funtable f Q \<Longrightarrow> 
       \<Turnstile> untickuncall {(z, s). (z, s) \<in> P \<and> s = s'} funtable f Q"
*)


lemma HCallSingleRecDomStore: 
 "\<lbrakk> \<forall> s'. {({(z,s).(z,s)\<in> P \<and> (dom (store s) < dom (store s'))},CALL f,Q)} 
           \<parallel>= {(untickuncall {(z,s).(z,s)\<in> P \<and> s=s'}, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply (rule_tac r="inv_image subset (dom  o store::state\<Rightarrow>(vname set))" in HCallSingleRecWF)
apply (rule wf_inv_image dom_def subset_def)
prefer 2
apply (simp add: conseqset_valid_def set_valid_def dom_def)
apply (simp add: inv_image_def dom_def subset_def)
apply(rule wf_subset)
apply(auto)
apply(simp add: dom_def subset_def)
(* should succeed for stores with finite domain! measure is size *)
sorry

(*third rule on page 8 of HLfRPaUN)*)
(*is the quantification over v in the second condition correct?*)
lemma totalCons:"
 \<lbrakk> C \<parallel>= {(P', e, Q')};
    \<forall> s t v. ((\<forall> z. ((z,s)\<in> P' \<longrightarrow> (z,t,v) \<in> Q')) \<longrightarrow> (\<forall> z. ((z,s)\<in> P \<longrightarrow> (z,t,v) \<in> Q)));
    \<forall> s . ((\<exists> z. (z,s) \<in> P) \<longrightarrow> (\<exists> z. (z,s) \<in> P')) \<rbrakk>
   \<Longrightarrow> (C \<parallel>= {(P, e, Q)})"
apply (simp add: conseqset_valid_def set_valid_def)
apply (auto)
apply(simp add: hoare_valid_def)
apply(auto)
apply (erule_tac x = "s" in allE)
apply(auto)
done
(*
the last step may be replaced by
apply (erule_tac x = "s" in allE)
apply (erule_tac x = "s" in allE)
apply (erule_tac x = "t" in allE)
apply (erule_tac x = "t" in allE)
apply (erule_tac x = "v" in allE)
apply (erule_tac x = "v" in allE)
apply(simp)
*)

(*fifth rule on page 5 of HLfRPaUN)*)
(*is the quantification over v in the second condition correct?*)
lemma partialCons:
  "\<lbrakk> C \<parallel>= {(P', e, Q')};
    \<forall> s t v. ((\<forall> z. ((z,s)\<in> P' \<longrightarrow> (z,t,v) \<in> Q')) \<longrightarrow> (\<forall> z. ((z,s)\<in> P \<longrightarrow> (z,t,v) \<in> Q))) \<rbrakk>
   \<Longrightarrow> (C \<parallel>= {(P, e, Q)})"
apply (simp add: conseqset_valid_def set_valid_def)
apply (auto)
apply(simp add: hoare_valid_def)
apply(auto)
apply (erule_tac x = "s" in allE)
apply(auto)
done
  
constdefs
  takestimeltTriple :: "nat \<Rightarrow> 'a preassn \<Rightarrow> expr \<Rightarrow> 'a postassn \<Rightarrow> bool"
 "takestimeltTriple n P e Q  \<equiv> 
       \<Turnstile> {((z,cz),s). (z,s)\<in>P \<and> clock s = cz} 
            e 
         {((z,cz),s,v). (z,s,v)\<in>Q \<and> clock s < cz+n}"

lemma 
 "\<lbrakk> {(P,CALL f,Q)} 
           \<parallel>= {(untickuncall {(z,s).(z,s)\<in> P}, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply (simp add: conseqset_valid_def set_valid_def untickuncall_def)
apply (auto)
prefer 2
apply(simp add: hoare_valid_def)
apply(auto)
apply(erule evalexpr.elims)
apply(simp_all)
apply(clarsimp)
apply (erule_tac x = "tickn (Suc 0) (incrcallcount sa)" in allE)
apply (erule_tac x = "s1" in allE)
apply (erule_tac x = "rtv" in allE)
apply(simp)
apply (erule_tac x = "z" in allE)
apply(auto)
(*this is the deferred goal -- probably the auto above should not have been applied*)
sorry

lemma SimpleCall:
  "\<lbrakk>{} \<parallel>= {(untickuncall P, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply (simp add: conseqset_valid_def untickuncall_def set_valid_def)
apply(simp add: hoare_valid_def)
apply(auto)
apply(erule evalexpr.elims)
apply(simp_all)
apply(clarsimp)
apply (erule_tac x = "tickn (Suc 0) (incrcallcount sa)" in allE)
apply (erule_tac x = "s1" in allE)
apply (erule_tac x = "rtv" in allE)
apply(simp)
apply (erule_tac x = "z" in allE)
apply(auto)
done

lemma MONO: "(C \<parallel>= {(P,CALL f,Q)} \<and> C \<subseteq> D) \<longrightarrow> C \<parallel>= {(P,CALL f,Q)}"
apply(auto)
done

lemma "\<lbrakk> {(P,CALL f,Q)} \<parallel>= {(untickuncall P, funtable f, Q)} \<rbrakk>
   \<Longrightarrow> ({} \<parallel>= {(P, CALL f, Q)})"
apply(insert SimpleCall [of P f Q])
apply(insert MONO [of "{}" "P" "f" "Q" "{(P, CALL f,Q)}"])
apply(simp)
sorry


lemma HCallSingleRec0: 
 "(takestimeltTriple 0 P (CALL f) Q \<longrightarrow> takestimeltTriple 0 (untickuncall P) (funtable f) Q)
  \<longrightarrow> takestimeltTriple 0 (untickuncall P) (CALL f) Q"
apply (unfold takestimeltTriple_def untickuncall_def hoare_valid_def)
apply (clarify)
sorry

end
