(*  
   File:	ToyHLextras.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLextras.thy,v 1.1 2003/06/24 23:17:44 da Exp $

   Additional Hoare-style rules.  Not used in main development.
*)

theory ToyHLextras = ToyHLbasic:

declare HoareI [intro] HoareE [elim]

subsection {* HVoid *}

lemma HVoid': "\<Turnstile> P expr.Void {(z,s,v). \<exists> s'. (z,s') \<in> P \<and> s=tickn 1 s' \<and> v=val.Void}"
by (auto elim: evalVoid_cases)

lemma "\<Turnstile> {(z, s). True}
	  (expr.Void)
         {(z, s, result). result = val.Void}"
apply (rule HWC)
apply (rule HVoid')
apply (auto)
done


subsection {* HInt *}

lemma HInt': "\<Turnstile> P (expr.Int i) {(z, s, v). \<exists> s'.(z,s')\<in> P \<and> s=tickn 1 s' \<and> v=val.Int i}"
by (auto elim: evalInt_cases)



subsection {* HVar *}

lemma HVar': "\<Turnstile> P
		(expr.Var vn) 
	        {(z, s, v). \<exists> s'. (z,s') \<in> P \<and> s'<vn> = Some v \<and>  s=tickn 1 s'}"
by (fastsimp elim: evalVar_cases)


subsection {* HPrimop *}


(* this version better for PC, in that we don't need to show vn1, vn2 bound
 before using it. *)
lemma HPrimop': "\<Turnstile> P
                  (expr.Primop f vn1 vn2)
		   {(z, s, v). \<exists> s' i1 i2. (z,s') \<in> P \<and>
					    s'<vn1> = Some (val.Int i1) \<and>
			                    s'<vn2> = Some (val.Int i2) \<and>
					    s = tickn 3 s' \<and>
					    v = val.Int (f i1 i2)}"
by (fastsimp elim: evalPrimop_cases)

lemma "\<Turnstile> {((i,j), s). s<x1> = Some (val.Int i) \<and> s<x2> = Some (val.Int j)}
	   (Primop (op+) x1 x2)
         {((i,j), s, result). result = val.Int (i+j)}"
apply (rule HWC)
apply (rule HPrimop')
apply (auto)
done


subsection {* HLet *}

text {* Experimental versions:
\begin{itemize}
\item
   Let0 uses an implication and a second unknown meta variable.
\item
   Let1 uses object level existentials (which may be worse: explicit
    instantiation seems to be needed often).
\end{itemize}
 *}

lemma HLet0: "\<lbrakk> \<Turnstile> T (e') Q;
                \<Turnstile> P e R;
		\<forall> z s v. (z,s,v) \<in> R \<longrightarrow> (z, varupdate (tickn 1 s) x v) \<in> T
                \<rbrakk> 
       \<Longrightarrow> \<Turnstile> P (LET x=e IN e' END) Q"
by (simp add: hoare_valid_def, auto elim: evalLet_cases)

lemma HLet1: "\<lbrakk> \<Turnstile> P e R;  
	       \<Turnstile> {(z,s).\<exists> v s'. (z,s',v) \<in> R \<and> s=varupdate (tickn 1 s') x v}  e' Q \<rbrakk> 
       \<Longrightarrow> \<Turnstile> P (LET x=e IN e' END) Q"
by (simp add: hoare_valid_def, fastsimp elim: evalLet_cases)


subsection {* HNew *}

lemma HNew': "\<Turnstile> P
	        (New c)
		{(z, s, v). \<exists> a s'. (z, s') \<in> P \<and> 
				    a = freshloc (fmap_dom (heap s')) \<and>
				    s = tickn 1 (newobj s' a c) \<and> 
				    v = val.Ref a}"
by (fastsimp elim: evalNew_cases)



end
