(*  
   File:	ToyHLex
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLex.thy,v 1.1 2003/06/24 23:18:47 da Exp $

   Examples.
 
   TODO:
    - count up/down example: want to use adaptation rules and pre-post conditions
    - factorial example
    - port other examples
*)

header {* Hoare logic for Toy Grail: Examples *}

theory ToyHLex = ToyVCG:

section {* Some handy shorthand syntax *}

syntax
 "primplus"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl "OP+" 50)
translations
 "n OP+ m" == "Primop op+ n m"

syntax
 "primminus"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl "OP-" 50)
translations
 "n OP- m" == "Primop op- n m"

syntax
 "primtimes"  :: "iname \<Rightarrow> iname \<Rightarrow> expr"  (infixl "OP*" 50)
translations
 "n OP* m" == "Primop op* n m"


constdefs iszeroprimop::"int \<Rightarrow> int \<Rightarrow> int"
"iszeroprimop x y \<equiv> (if x = 0 then 1 else 0)"

declare iszeroprimop_def [simp]

syntax
 "primiszero"  :: "iname \<Rightarrow> expr"  ("ISZERO _" [50] 51)
translations
 "ISZERO n" => "Primop iszeroprimop n n"
 "ISZERO n" <= "Primop iszeroprimop n z"

syntax
 "num"  :: "'a \<Rightarrow> expr"  ("_\<^sub>z" [1000] 55)   (* did have \<int> here, but X-Sym bugs *)
translations
 "n\<^sub>z" == "expr.Int n"


section {* Even odd: mutually recursive functions *}

locale evenodd_example =
(* Simulating the typical example
      even(x) = let fun even x = if x=0 then true else odd(x-1)
                    fun odd x = if x=0 then false else even(x-1)
                in even(x)
 *)
  fixes    x :: iname
    and    b :: iname
    and	   one :: iname
    and	   evenfn    :: funame
    and    oddfn     :: funame
    and	   evenbdy :: expr
    and    oddbdy  :: expr
	   

  defines  "evenbdy == LET one = expr.Int 1;
			   b = ISZERO x;
			   x = x OP- one
			   IN 
			      IF b THEN expr.Int 1 ELSE CALL oddfn
  			   END"
  defines  "oddbdy == LET one = expr.Int 1;
			   b = ISZERO x;
			   x = x OP- one
			   IN 
			      IF b THEN expr.Int 0 ELSE CALL evenfn
  			   END"

  assumes  evenbdy[simp]:     "funtable evenfn = evenbdy"
      and  oddbdy[simp]:      "funtable oddfn = oddbdy"
      and  wfmeasure1 [simp]: "fun_wfmeasure_table evenfn = inv_image less_than (\<lambda> s. nat (get_ivar s x))"
      and  wfmeasure2 [simp]: "fun_wfmeasure_table oddfn = inv_image less_than (\<lambda> s. nat (get_ivar s x))"
      and  vardistinct:       "distinct [one,b,x]"


declare (in evenodd_example) evenbdy_def [simp]  (* unfold def *)
declare (in evenodd_example) oddbdy_def [simp]   (* unfold def *)

lemma (in evenodd_example)
  "\<Turnstile> {(z,s). s<x> = 0} (Call evenfn) {(z,s,v). v = IVal 1}"
apply (insert vardistinct)
apply hoare_simp
apply(auto)
done

ML {*
 val detrules = map thm ["evalNull", "evalInt", "evalIVar", "evalRVar",
			 "evalPrimop", "evalPutFi", "evalGetFi",
			 "evalPutFr", "evalGetFr", "evalNew",
			 "evalCall", "evalInvoke", "evalLeti", "evalLetr"];
 fun TG_eval_step tac i =
   (SELECT_GOAL ((resolve_tac detrules i) THEN (IF_UNSOLVED (REPEAT (CHANGED (tac i))))) i)
    ORELSE 
   ((resolve_tac [thm "evalIf_True"] i) THEN SELECT_GOAL (SOLVE (tac i)) i)
    ORELSE
   ((resolve_tac [thm "evalIf_False"] i) THEN SELECT_GOAL (SOLVE (tac i)) i)

*}

method_setup evalstep = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      TG_eval_step (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)) 1))  *}
  "Evaluation tactic"

lemma (in evenodd_example)
  "\<Turnstile> {(z,s). s<x> = 1} (Call evenfn) {(z,s,v). v = IVal 0}"
apply (insert vardistinct)
apply hoare_simp
apply (insert wfmeasure1, simp)
apply(auto)
oops(*
prefer 2
apply(simp add: tickn_def ivarupdate_def incrcallcount_def)
apply (insert wfmeasure1, simp)
apply (rule wf_inv_image, rule wf_less_than) 
apply (insert wfmeasure1, simp)
apply (rule wf_inv_image, rule wf_less_than) 
apply(simp_all add: tickn_def incrcallcount_def ivarupdate_def inv_image_def) should be replaced by some lemmas
apply(auto)
done
*)

lemma (in evenodd_example) 
   "s<x>=3 \<Longrightarrow> (\<exists> s1. (\<langle>s,CALL evenfn\<rangle> \<longrightarrow>e \<langle>IVal 0,s1\<rangle> \<and> (clock s1 - clock s) = 49))"
apply (rule, rule)
apply (insert vardistinct)
apply ((evalstep)+, auto)+
done

(* timings by experiment, instantiating ?k above: 
0 = 13
1 = 25
2 = 37
3 = 49
*)

(* Proof of a time bound by induction and symbolic evaluation *)

lemma (in evenodd_example) 
   "\<forall> s. (s<x>=(int)n) \<longrightarrow> (\<exists> s1. (\<langle>s,CALL evenfn\<rangle> \<longrightarrow>e \<langle>IVal (int((n+1) mod 2)),s1\<rangle> \<and> 
			  	   (clock s1 - clock s) = ((n+1) * 12 +1)))"
apply (induct n)
apply (insert vardistinct)
apply (rule, rule, rule, rule)
apply (evalstep+)
apply auto
apply (evalstep+)
apply simp
apply (rule, rule)
apply evalstep+
apply auto
apply evalstep
apply evalstep
apply (evalstep+, auto)+
apply(simp_all add: tickn_def ivarupdate_def rvarupdate_def incrcallcount_def)
oops

lemma (in evenodd_example) 
   "\<Turnstile> {(z,s). 0 < z \<and> (s<x>=2*z)}	
	(CALL evenfn) 
      {(z,s,v). v=IVal 1}"
apply hoare_simp_step
apply hoare_simp_step
apply hoare_simp_step
defer 1
apply hoare_simp_step
apply hoare_simp_step
apply hoare_simp_step
apply hoare_simp_step
apply hoare_simp_step
apply hoare_simp_step
apply(tactic {* instantiate_tac [("P2.20",
                                  "\<lambda> s1 s2 . ({(z, s). (0 < z) \<and> s<x> = (2 * z - 1) \<and> (s, s1) \<in> inv_image less_than (\<lambda>s. nat (s<x>))})")]*})
apply hoare_simp_step
apply hoare_simp_step
apply hoare_simp_step
defer 1
apply hoare_simp_step
apply hoare_simp_step
apply hoare_simp_step
apply hoare_simp_step
apply hoare_simp_step
apply hoare_simp_step
apply assumption
apply (insert wfmeasure2, simp)
apply (rule wf_inv_image, rule wf_less_than) (* WF measure *)
apply(simp_all)
oops
(*
apply(auto)
prefer 2
apply(rule)+
prefer 2
apply(rule)+
apply(clarsimp)
apply hoare_simp_step
apply (rule HConseqProc)  adaptation 
apply assumption
defer 1
apply simp
prefer 3
apply (insert wfmeasure1, simp)
apply (rule wf_inv_image, rule wf_less_than) WF measure
prefer 2
apply simp
oops
*)


section {* The old favourite: factorial *}
(*
locale faxexample =
 fixes FACrecurse::funame
  and  FACmname::mname
  and  FACcname::cname
  and  one:: iname
  and  r::iname
  and  p::iname
  and  k::iname
  and  FACrecursebody::expr
defines 
"FACrecursebody \<equiv> LET p = param OP- one;
                       r = Invoke self FACmname p;
                       r = Primop (\<lambda> x y. x * y) r param 
                   IN Var r END"

fixes  FACbody::expr
defines "FACbody \<equiv> 
	    LET one = 1\<^sub>z;
                 k = ISZERO param
              IN IF k THEN Var one ELSE CALL FACrecurse END"

assumes vardistinct: "distinct [one,r,p]"
    and funtable:    "funtable FACrecurse = FACrecursebody"
    and classtable:  
    "classtable FACname = 
           \<lparr>iflds = [], rflds=[],
	    meths = empty(FACmname \<mapsto> FACmethbody)\<rparr>"
fixes start :: state
assumes startstate: "heap start = empty(1 \<mapsto> (FACcname, empty)) &
                    start\<lfloor>self\<rfloor> = Some (Ref 1) & 
                    start<p> = N &
                    length (framestack start) <= maxstack start"
*)

constdefs TrivObj::"cname \<Rightarrow> obj"
"TrivObj cn == (cn, \<lambda>ifld . 0, \<lambda>rfld. Nullref)"

constdefs Oneheap::"cname \<Rightarrow> heap"
"Oneheap cn == (fmap_upd emptyfinmap 1 (TrivObj cn))"

consts facspec::"nat \<Rightarrow> nat"
primrec 
"facspec 0 = 1"
"facspec (Suc N) = (facspec N) * (Suc N)"

locale FAC =
 fixes FACrec::funame     and FACmain::funame
  and  M::mname           and C::cname
  and  ob :: rname
  and  one:: iname        and  res::iname
  and  p::iname
  and  k::iname
  and PP:: ifldname (*integer parameter currently passed through ifield*)
  and paramI:: iname
  and  RECbody::expr     and MAINbody::expr
defines 
"RECbody \<equiv> LET p = paramI OP- one;
               p = PutFi ob PP p;
               res = Invoke ob M param;
               res = Primop (\<lambda> x y. x * y) res paramI 
           IN IVar res END"

defines "MAINbody \<equiv> 
	    LET one = 1\<^sub>z;
                paramI = GetFi ob PP;
                k = ISZERO paramI
            IN IF k THEN IVar one ELSE CALL FACrec END"

assumes vardistinct: "distinct [one,res,p]"
    and funtable:    "funtable FACrec = RECbody \<and> funtable FACmain = MAINbody"
    and classtable1: "PP mem iflds(classTable C)"
    and classtable2: "rflds(classtable C) = []"
    and classtable3: "(meths(classtable C)) M = (({},{}),MAINbody)"

lemma (in FAC)
  "\<Turnstile> {(z,s). \<exists> iflds rflds n. s\<lfloor>ob\<rfloor> = Ref a \<and> fmap_lookup (heap s) a = Some (F, iflds, rflds) \<and> 
                               iflds PP = n \<and>
                               finite(fmap_dom (heap s)) \<and> card (fmap_dom (heap s)) = z}
     (Call FACmain) 
     {(z,s,v). finite(fmap_dom (heap s)) \<and> card (fmap_dom (heap s)) = z}"
apply (insert vardistinct funtable)
apply(simp)
apply(hoare_simp)
apply(simp add: funtable)
apply(rule HRec)
apply(hoare_simp)
apply(simp add: funtable MAINbody_def RECbody_def)
apply(hoare_simp)
apply(auto)
defer
apply(simp add: funtable)
defer
apply(simp)
apply(rule)
apply(auto)
apply (rule HCall)
apply (rule HSingleSingle)
apply (simp add: incfnbdy incbdy_def untickuncall_def)
apply (rule HBasicRules)+
apply (rule HSP, rule HInt)
apply (auto)
locale FAC =
 fixes FACrecurse::funame
  and ob :: rname
  and  M::mname
  and  C::cname
  and  one:: iname
  and  r::iname
  and  p::iname
  and  k::iname
  and PP:: ifldname (*integer parameter currently passed through ifield*)
  and paramI:: iname
  and  FACrecursebody::expr
defines 
"FACrecursebody \<equiv> LET p = paramI OP- one;
                       p = PutFi ob PP p;
                       r = Invoke ob M param;
                       r = Primop (\<lambda> x y. x * y) r paramI 
                   IN IVar r END"

fixes  FACbody::expr
defines "FACbody \<equiv> 
	    LET one = 1\<^sub>z;
                 paramI = GetFi ob PP;
                 k = ISZERO paramI
              IN IF k THEN IVar one ELSE CALL FACrecurse END"

assumes vardistinct: "distinct [one,r,p]"
    and funtable:    "funtable FACrecurse = FACrecursebody"
    and classtable1: "PP mem iflds(classTable FACcname)"
    and classtable2: "rflds(classtable FACcname) = []"
    and classtable3: "(meths(classtable FACcname)) FACmname = (({},{}),FACbody)"
(*fixes start :: state
assumes startstate: "heap start = Oneheap FACcname &
                    start\<lfloor>self\<rfloor> = (Ref 1) & 
                    start<p> = N &
                    length (framestack start) <= maxstack start"
*)
lemma (in faxexample)
  "\<Turnstile> {(z,s). \<exists> iflds rflds. (fmap_lookup (heap s) 1 = Some (FACcname, iflds, rflds) \<and> iflds PP = fst z \<and>
              finite(fmap_dom (heap s)) \<and> card (fmap_dom (heap s)) = snd z)}
     (Invoke self FACmname param) 
     {(z,s,v). finite(fmap_dom (heap s)) \<and> card (fmap_dom (heap s)) = snd z}"
apply (insert vardistinct)
apply(simp)
apply (rule HInvoke)
apply(simp add: classtable3)
apply(auto)
apply (rule HSingleSingle)
apply (simp add: incfnbdy incbdy_def untickuncall_def)
apply (rule HBasicRules)+
apply (rule HSP, rule HInt)
apply (auto)
apply hoare_simp
apply(auto)


section {* Hans-Wolfgang's Ex1  (increment function) *}

locale hwex1 =
  fixes    one :: iname
    and	   j :: iname
    and	   k :: iname
    and	   z :: iname
    and	   inc    :: funame
    and	   incbdy :: expr
  defines  "incbdy \<equiv> LET one = 1\<^sub>z;
			  j = j OP+ one
		       IN
                         Var j
		       END"
  assumes  incfnbdy:  "funtable inc = incbdy"
      and  vardistinct: "distinct [one,j,k,z]"

lemma (in hwex1) "takestime ?K (CALL inc)"
apply (simp add: takestime_def)
apply (rule HLiftCtxt, rule HCallSingleRec)
apply (rule HSingleSingle)
apply (simp add: incfnbdy incbdy_def untickuncall_def)
apply (rule HBasicRules)+
apply (rule HSP, rule HInt)
apply (auto)
done


section {* Hans-Wolfgang's Ex2 *}

section {* Hans-Wolfgang's Ex2 *}

section {* Hans-Wolfgang's ExDvD example *}

(*
  Example: dvd m n ... tests whether m divides n, using a running potential divisor
  Description: Mutually recursive, using function calls
*)

constdefs AND_op :: "iname \<Rightarrow> iname \<Rightarrow> expr"
 "AND_op m n == Primop (\<lambda> x y. x*y) m n"
constdefs OR_op :: "iname \<Rightarrow> iname \<Rightarrow> expr"
 "OR_op m n == Primop (\<lambda> x y. x*y) m n"
constdefs LT_op :: "iname \<Rightarrow> iname \<Rightarrow> expr"
 "LT_op m n == Primop (\<lambda> x y. if x<y then 1 else 0) m n"
constdefs GT_op :: "iname \<Rightarrow> iname \<Rightarrow> expr"
 "GT_op m n == Primop (\<lambda> x y. if x<y then 1 else 0) n m"
constdefs LE_op :: "iname \<Rightarrow> iname \<Rightarrow> expr"
 "LE_op m n == Primop (\<lambda> x y. if \<not (x<y) then 1 else 0) n m"
constdefs GE_op :: "iname \<Rightarrow> iname \<Rightarrow> expr"
 "GE_op m n == Primop (\<lambda> x y. if \<not> (x<y) then 1 else 0) m n"
constdefs ISZERO_op :: "iname \<Rightarrow> expr"
 "ISZERO_op n == Primop (\<lambda> x y. if x=0 then 1 else 0) n n"
constdefs NOTZERO_op :: "iname \<Rightarrow> expr"
 "NOTZERO_op n == Primop (\<lambda> x y. if \<not> (x=0) then 1 else 0) n n"
constdefs DEC_op :: "iname \<Rightarrow> expr"
 "DEC_op n == Primop (\<lambda> x y. x - 1) n n"
constdefs INC_op :: "iname \<Rightarrow> expr"
 "INC_op n == Primop (\<lambda> x y. x+1) n n" 
constdefs PLUS_op :: "iname \<Rightarrow> iname \<Rightarrow> expr"
 "PLUS_op m n == Primop (\<lambda> x y. x+y) m n"
constdefs MINUS_op :: "iname \<Rightarrow> iname \<Rightarrow> expr"
 "MINUS_op m n == Primop (\<lambda> x y. x - y) m n" 

locale exdvd =
  fixes    dvd1 :: funame
    and	   dvd2 :: funame
    and	   m :: iname and n :: iname and r :: iname 
    and    x :: iname and y :: iname and z :: iname
    and    rx :: iname and q1 :: iname and q2 :: iname and q3 ::iname 
    and    tt :: iname and ff :: iname
    and	   dummyarg :: iname and stat1 :: iname
    and	   l1     :: locn
    and	   even   :: mname
    and    FooClass :: cname
    and	   dvd2Body :: expr

  assumes vardistinct: "distinct [m,n,r,x,y,z,rx,q1,q2,q3,tt,ff,dummyarg,state]"

  defines  "dvd2Body \<equiv> 
             LET
               z  = INC r  ;
               r  = expr.Var z ;
               y  = Primop (\<lambda> x y. x*y) m r ; 
               q2 = Primop (\<lambda> x y. if (x=y) then (1::int) else (0::int)) y n ;
               tt = (expr.Int 1) 
             IN
               IF q2 
                 THEN Var tt
                 ELSE CALL dvd1
             END"

  assumes dvd2: "funtable dvd2 = dvd2Body"

(* ... etc *)



section {* Old example of Lennart's *}



(*First example:
  fun f(n,m) = let m = m+n
                   n = n -1
               in if n=0 then m else f(n,m)
  satisfies {\<lambda> [N,M] i s. s<n> = N & N > 0 & clock s = i}
            Result Call f
            {\<lambda> [N,M] i v s. clock s = i + factor N}
*) 
(*The program*)
consts fn::funame       
       m:: iname
       n:: iname
       k:: iname

(*in the second and third primops, m is only used as a dummy*)
constdefs fnbody::expr
"fnbody \<equiv> Let m (Primop (\<lambda> x y . x + y) m n)
           (Let n (Primop (\<lambda> x y . x - 1) n m)
           (Let k (Primop (\<lambda> x y. iszero x) n m)
           (If_ k (Var m) (Call fn))))"
constdefs factor::nat
"factor \<equiv> 14"

(*"Axiom", also refining the const body*)
constdefs AXIOM:: "bool"
"AXIOM \<equiv> n ~= m & m ~= n & m ~= k & k ~= m & n ~= k & k ~= n & funtable fn = fnbody"

(*Constructing the hoare triple - value N is a "global" input"*)
constdefs TRIPLE1::"nat \<Rightarrow> bool"
"TRIPLE1 N \<equiv>
   \<Turnstile> {(z,s). clock s=z  \<and>  s<n>=Some (val.Int (int N)) \<and> 0 < N}
           (Call fn)
     {(z,s,v). clock s = ((Suc z) + factor * N)}"


constdefs funIH :: "(nat \<times> nat) etriple"
  "funIH \<equiv>  ({((z,na), s). clock s = z \<and> s<n> = Some (val.Int (int na)) \<and> 0 < na}, 
	      CALL fn,
             {((z,na),s,v). clock s = Suc (z + factor * na)})"

(*Semantic validity of the triple -- independent from any input! Proof is by
  induction on the external parameter N"*)
lemma Triple1_Valid: "AXIOM \<Longrightarrow> TRIPLE1 N"
apply (induct_tac N)
apply (simp add: AXIOM_def TRIPLE1_def, rule HVacuous)
apply (simp add: AXIOM_def TRIPLE1_def)
sorry
(*
apply(erule evalexpr_evallet.elims,
      simp_all add: tickn_def get_var_def AXIOM_def fnbody_def varupdate_def iszero_def,
      auto)+
apply(case_tac "na = 0")
apply(auto)
apply(simp add: time_def factor_def)
apply(case_tac "na = 0")
apply(auto)
apply(erule evalexpr_evallet.elims,
      simp_all add: tickn_def get_var_def fnbody_def varupdate_def iszero_def,
      auto)+
apply(case_tac "int na - 1 = 0")
apply(auto)
apply(case_tac "na")
apply(auto)
apply(simp add: time_def factor_def)
apply(case_tac "int na - 1 = 0")
apply(auto)
apply(case_tac "na")
apply(auto)
*)

end

