(*  
   File:	ToyHLax.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLax.thy,v 1.1 2003/06/24 23:17:34 da Exp $
   Status:      [ IN DEVELOPMENT ]

   Axiomatic version of the development in ToyHLbasic, ToyHLproc.
*)

header {* Axiomatisation of the Hoare logic *}

theory ToyHLax = ToyHLproc:

text {* The axiomatisation simply introduces a inductive relation
  for the rules we have already proved sound semantically.
  This opens the way for a (relative) completeness proof.
  *}

consts
  hoare_deriv :: "'a preassn \<Rightarrow> expr \<Rightarrow> 'a postassn \<Rightarrow> bool"  ("|- (1_)/ (_)/ (1_)" 50)
  hoare_set_deriv :: "'a preassn \<Rightarrow> expr \<Rightarrow> 'a postassn \<Rightarrow> bool"  ("|- (1_)/ (_)/ (1_)" 50)

syntax (xsymbols)
  hoare_deriv_ :: "'a preassn \<Rightarrow> expr \<Rightarrow> 'a postassn \<Rightarrow> bool"   ("\<turnstile> (1_)/ (_)/ (1_)" 50)
  hoare_set_deriv_  :: "('a etriple) set \<Rightarrow> bool"		     ("\<parallel>- _" 50)
  hoare_cset_deriv_ :: "('a etriple) set \<Rightarrow> ('a etriple) set \<Rightarrow> bool" ("\<parallel>- _" 50)

end
