(* Time-stamp: <Tue May 20 2003 21:17:00 Stardate: [-29]0314.01 hwloidl> 
   File:	$RCSfile: ToyHLBasicMono.thy,v $
   Name:        $Name:  $
   Authors:	$Author: da $ \<in> David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLBasicMono.thy,v 1.1 2003/06/24 23:22:39 da Exp $

   Basic types, definitions and predicates for Hoare Logic.
   Aux = state
*)   

header {* Basic types, definitions and predicates for Hoare Logic. *}

theory ToyHLBasicMono = ToyGrailLemmas:

section {* Basic types, definitions and predicates for Hoare Logic. *}

subsection {* Assertions *}

text {* Assertions take two forms: pre-conditions are predicates
  on pre-states; post-conditions are predicates on post-states
  and also the resulting value.  Additionally we include 
  auxiliary variables related in the pre and post condition.
  Auxiliary variables can have any type. *}

(* This code is sponsored by the Association for the Elimination of Polymorphism *)
types
 a_preassn  = "(state \<times> state) set"
 a_postassn = "(state \<times> state \<times> val) set"

types
 a_cntxt = "(a_preassn \<times> expr \<times> a_postassn) set"

subsection {* Global tables of assertions and derived rules *}

(* moved up here to use in earlier rules -- HWL *)

(*
  Notes:
  1. We assume that funames are different in diff meths 
  2. Post assertion for functions may be same as post-assertion as whole
     method, but it may be convenient to have something different;
     in any case, adding post assertions to fun_assn_table may be
     convenient.
*)

(* changed types of {fun,meth}_assn_table to match those in ToyHlwp.thy -- HWL *)
(* I'm having problems feeding rewrite rules for fun_assn_table to the simplifier
   if it's type is polymorphic over the aux var; for now I have specialised it,
   but have to find a general solution (see ToyVCGtest0.thy) -- HWL *)

consts
 fun_preassn_table   ::  "funame \<Rightarrow> a_preassn" 
 fun_postassn_table  ::  "funame \<Rightarrow> a_postassn" 
 fun_assn_table      ::  "funame \<Rightarrow> (a_preassn \<times> a_postassn)" 
 fun_wfmeasure_table ::  "funame \<Rightarrow> (state \<times> state) set"

 meth_preassn_table   ::  "mname \<Rightarrow> a_preassn"
 meth_postassn_table  ::  "mname \<Rightarrow> a_postassn"
 meth_assn_table      ::  "mname \<Rightarrow> (a_preassn \<times> a_postassn)"
 meth_wfmeasure_table ::  "mname \<Rightarrow> (state \<times> state) set"

subsection {* Hoare Triples and other beasts *}

constdefs 
  hoare_valid :: "a_preassn \<Rightarrow> expr \<Rightarrow> a_postassn \<Rightarrow> bool"  ("|= (1_)/ (_)/ (1_)" 50)
   "|= P e Q \<equiv> \<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> 
				  (\<forall> z. (z, s) \<in>  P \<longrightarrow> (z, t, v) \<in> Q)"

syntax (xsymbols)
  hoare_valid :: "a_preassn \<Rightarrow> expr \<Rightarrow> a_postassn \<Rightarrow> bool"  ("\<Turnstile> (1_)/ (_)/ (1_)" 50)

(* extended to sets (for mutual recursion) *)
constdefs
 hoare_valids :: "a_cntxt \<Rightarrow> bool"               ("|\<Turnstile> _" 50)
 "|\<Turnstile> C \<equiv> \<forall>(P,e,Q) \<in> C. \<Turnstile> P e Q"

constdefs
 cntxt_hoare_valid :: "[a_cntxt, a_preassn, expr, a_postassn]  \<Rightarrow> bool" ("(_ /\<Turnstile> (1_)/ (_)/ (1_))" 50)
 "C \<Turnstile> P e Q \<equiv> |\<Turnstile> C \<longrightarrow> \<Turnstile> P e Q"

 cntxt_hoare_valids :: "[a_cntxt, a_cntxt] \<Rightarrow> bool" ("_ |\<Turnstile>/ _" 50)
 "C |\<Turnstile> D  \<equiv>  |\<Turnstile> C \<longrightarrow> |\<Turnstile> D"

subsection {* Resource predicates *}

text {* Here are some shorthands for constructing triples over an expression. *}

constdefs
  takestime  :: "nat \<Rightarrow> expr \<Rightarrow> bool"   (* uses an auxiliary variable! *)
  "takestime n e   \<equiv>  \<Turnstile> {(z,s). s = z} e {(z,s,v). clock s = (clock z)+(int n)}"

  takestimelt  :: "nat \<Rightarrow> expr \<Rightarrow> bool"
  "takestimelt n e   \<equiv>  \<Turnstile> {(z,s). s = z} e {(z,s,v). clock s < (clock z)+(int n)}"
(*
  takesspace :: "nat \<Rightarrow> expr \<Rightarrow> bool"
  "takesspace n e   
    \<equiv>  \<Turnstile> {(z,s). finite(fmap_dom (heap s)) \<and> card (fmap_dom (heap s)) = z} e 
	{(z,s,v). finite(fmap_dom (heap s)) \<and> card (fmap_dom (heap s)) = z+n}"
*)

constdefs relTakestime:: "state \<Rightarrow> nat \<Rightarrow> expr \<Rightarrow> bool"
"relTakestime S n e \<equiv>  \<Turnstile> {(z,s). s = z \<and> s = S} e {(z,s,v). clock s = (clock z)+(int n)}"

constdefs relTakestimelt:: "state \<Rightarrow> nat \<Rightarrow> expr \<Rightarrow> bool"
"relTakestimelt S n e \<equiv>  \<Turnstile> {(z,s). s = z \<and> s = S} e {(z,s,v). clock s < (clock z)+(int n)}"

(*
constdefs relTakesspace :: "state \<Rightarrow> nat \<Rightarrow> expr \<Rightarrow> bool"
"relTakesspace S n e   
    \<equiv>  \<Turnstile> {(z,s). finite(fmap_dom (heap s)) \<and> card (fmap_dom (heap s)) = z \<and> s = S} e 
	{(z,s,v). finite(fmap_dom (heap s)) \<and> card (fmap_dom (heap s)) = z+n}"
*)

end
