(*  
   File:	SpaceExperiments.thy
   Authors:	Olha
   Id:		$Id: SpaceExperiments.thy,v 1.1 2003/06/24 23:19:35 da Exp $

   Experiments with examples for "takesspace" predicates.
*)

header {* Examples using "takespace" and "relTakesspace" *}

theory SpaceExperiments = ToyHLbasic+ToyVCG:


lemma "\<lbrakk> b\<lfloor>rn\<rfloor>=Ref a ; b\<lless>a\<ggreater> = Some (cn, im, rm) \<rbrakk> 
       \<Longrightarrow> takesspace 0 (expr.GetFi rn f)"
apply (simp add: takesspace_def )
apply (hoare_simp)
apply (rule_tac x="a" in exI)
apply (rule conjI)

apply (rule HGetFi)
apply (auto)
apply (rule_tac x="a" in exI)
apply (rule conjI)
apply (simp)
sorry(*there is still a subgoal here ...*)

lemma "takesspace ?k (expr.PutFi vn f valv)"
apply (simp add: takesspace_def)
apply (rule HPutFi)
apply (auto)
sorry(*there is still a subgoal here ...*)

(* DA commented this out in ToyHLbasic.thy, 
because it clutters the context and causes much confusion
   later (e.g. global declaration of n).  
He asked to  use locale, or keep this test
   example in a child theory file which is not part of main development. *)

(* I also have to comment the lemma below.
It generates an error message, see after the code

lemma "(s\<lfloor>vn1\<rfloor> = Ref a1 \<and> 
        fmap_lookup (heap s) a1 = Some obj \<and> 
        relTakesspace (newframe (incrinvokecount s) mn dummyvar dummybdy a1 arg) 
                      k 
                      (snd (the (meths (classtable obj) mn))))
       \<longrightarrow> relTakesspace s k (Invoke vn1 mn vn2)"
apply (simp add: relTakesspace_def takesspace_def)
apply(auto)
apply (rule HInvoke)
apply(simp add: tickn_def incrcallcount_def hoare_valid_def)
done

The errror message:

*** Type unification failed: Clash of types "Datatype.option" and "IntDef.int".
*** Type error in application: Incompatible operand type.
*** 
*** Operator:  (op = (s<vn1>)) :: int => bool
*** Operand:   (Some (Ref a1)) :: ref option
*** 
*** At command "lemma".
*)


locale increment_example =
  fixes    one :: iname
    and	   j :: iname
    and	   inc    :: funame
    and	   incbdy :: expr
  defines  "incbdy == LET one = expr.Int 1;
			  j = Primop (% x y. x+y) j one
		       IN
                         IVar j
		       END"
  assumes  incfnbdy[simp]:     "funtable inc = incbdy"
      and  vardistinct[intro]: "distinct [one,j,k]"


lemma (in increment_example) "wf (fun_wfmeasure_table inc) \<Longrightarrow>
                  takesspace 0 (CALL inc)"
apply (insert vardistinct)
apply (simp add:  takesspace_def)
apply (simp add: tickn_def incrcallcount_def hoare_valid_def )
apply hoare_simp
apply (auto)
done

locale twice_example =
  fixes    i :: iname
    and	   j :: iname
    and	   k :: iname
    and	   twice    :: funame
    and	   countfn  :: funame
    and	   twicebdy :: expr
  defines  "twicebdy == LET k = IVar i;
                          j = Primop (% x y. x+y) i k
		      IN
                         IVar j
		      END"
  assumes  twicefnbdy:  "funtable twice = twicebdy"
      and  vardistinct[intro]: "distinct [i,j,k]"

declare (in twice_example) twicebdy_def [simp]
declare (in twice_example) twicefnbdy   [simp]

lemma (in twice_example) "wf (fun_wfmeasure_table twice) \<Longrightarrow>
                  takesspace 0 (CALL twice)"
apply (unfold takesspace_def)
apply hoare_simp
done

locale swap_example =
  fixes    m :: iname
    and	   n :: iname
    and	   q :: iname
    and	   z1 :: iname
    and	   z2 :: iname
    and	   lesser    :: ifldname
    and	   greater   :: ifldname
    and	   swap      :: funame
    and    SwapClass :: cname
    and	   swapBody  :: expr
    and    l1 :: locn
    and    M :: int    
    and    N :: int    
    and    M' :: int    
    and    N' :: int    
    and    curr_obj :: "int => int => obj"
  defines "swapBody \<equiv>  LET 
                m  = GetFi self lesser ;
                n  = GetFi self greater ;
                q  = Primop (\<lambda> x y . if y<x then (1::int) else (0::int)) m n 
              IN
                IF q 
                  THEN LET
                         z1 = PutFi self lesser n ; 
                         z2 = PutFi self greater m 
                       IN
                         expr.Int 1
                       END 
                  ELSE expr.Int 0
              END"
      and  "curr_obj x y == (SwapClass, (emptyi(lesser:=x))(greater:=y), emptyr)"
  assumes  swapfnbdy: "funtable swap = swapBody"
      and  swapClass: "classtable SwapClass = \<lparr> iflds = [lesser,greater], rflds = [], meths = \<lambda> mn. K mn \<rparr>"
      and  vardistinct: "distinct [m,n,q,z1,z2]"
      and  flddistinct: "distinct [lesser,greater]"

declare (in swap_example) swapBody_def [simp]
declare (in swap_example) swapfnbdy   [simp]

(* da: I changed this to use relTakesspace, because it isn't true
   for takesspace!! *)

lemma (in swap_example) "wf (fun_wfmeasure_table swap) \<Longrightarrow>
                  relTakesspace h 0 (CALL swap)"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def) (* unfold body *)
apply (simp add:  relTakesspace_def)
apply hoare_simp
prefer 2
apply assumption
(* da: again, remaining subgoal could be discharged by assuming that 
   the heap indeed contains an appropriate object *)
sorry

end
