(*  
   File:	ListReverseProgram.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ListReverseProgram.thy,v 1.1 2003/06/24 23:17:24 da Exp $

   List Examples for Toy Grail.
*)   

header {* List Examples for Toy Grail *}

theory ListReverseProgram = ToyVCG1 + ToyHLbasic1 + ToyPrelude + LIST:

section {* Example: In-place list reversal (functions no methods) *}

subsection {* Program *}

locale listrev_example = 
  fixes  
   (* program *)
         k  :: rname
    and  t  :: rname
    and  z  :: rname
    and  q  :: iname
    and  m  :: rname
    and  acc :: rname
    and  revAux :: funame
    and  loop :: funame
    and  main :: funame
    and  mainBody :: expr
    and  revAuxBody :: expr
    and  loopBody :: expr
    (* hand-crafted state *)
    and l1 :: locn and l2 :: locn
    and intCons :: "locn => int => locn => heap => heap"
    and myListOneObj  :: "obj"
    and oneObjHeap    :: "heap"
    and oneState      :: "state"
    and twoOneState   :: "state"
    and twoOneObjHeap :: "heap"
defines 
   (* program *)
        "mainBody \<equiv> LETR 
                  acc = NULL 
                IN
                  (CALL loop)
                END"
    and "revAuxBody \<equiv> LET
             q = ISNIL m
           IN
            IF q
              THEN (RVar acc)
              ELSE (CALL loop)
           END"
    and "loopBody \<equiv> LETR 
                        t = GetFr m tail ;
                        z = PutFr m tail acc ;
                        acc = RVar m ;
                        m = RVar t
                    IN 
                      (CALL revAux)
                    END"
    (* state *)
    and "intCons l n l0 h \<equiv> 
            h ( l \<mapsto>\<^sub>f (LIST, emptyi(head:=n), emptyr(tail:=(Ref l0)) ))"
    and "myListOneObj \<equiv> (LIST, emptyi(head:=1), emptyr(tail:=Nullref))"
    and "oneObjHeap \<equiv> emptyHeap (l1 \<mapsto>\<^sub>f  myListOneObj)"
    and "oneState \<equiv> emptyState (| heap := oneObjHeap |)"
    and "twoOneObjHeap \<equiv> intCons l2 2 l1 oneObjHeap"
    and "twoOneState \<equiv> emptyState (| heap := twoOneObjHeap |)"
 assumes revAux_fnbody: "funtable revAux = revAuxBody"
    and  loop_fnbody: "funtable loop = loopBody"
    and  vardistinct_iname: "distinct [q]"
    and  vardistinct_rname: "distinct [k,t,z,m,acc]"
    and  vardistinct_locn: "distinct [l1,l2]"

declare (in listrev_example) revAux_fnbody [simp]
declare (in listrev_example) loop_fnbody [simp]
declare (in listrev_example) revAuxBody_def [simp]
declare (in listrev_example) loopBody_def [simp]
declare (in listrev_example) mainBody_def [simp]

lemma fmap_dom_emptyHeap [simp]: "fmap_dom emptyHeap = {}"
apply (simp add: emptyfinmap_def fmap_dom_def)
done

lemma (in listrev_example) all_dom: "fmap_dom twoOneObjHeap = {l1,l2}"
apply (insert vardistinct_locn)
apply(simp add: fmap_dom_emptymap twoOneObjHeap_def oneObjHeap_def intCons_def)
apply(auto)
done

subsection {* Semantic functions (for testing) *}

(* Semantic reverse function: *)
consts reverse:: "int list => int list"
primrec
"reverse [] = []"
"reverse (h # t) = (reverse t) @ [h]"

subsection {* Semantic properties *}

lemma (in listrev_example) 
    "\<Turnstile> {(z,s). s\<lfloor>m\<rfloor>=Nullref}	
      mainBody
      {(z,s,v). s\<lfloor>m\<rfloor>=Nullref}"
apply (insert vardistinct_iname vardistinct_rname vardistinct_locn)
apply (simp)
apply (rule "HLetr")  (* LETR *)
defer 1
apply (rule "HCall")  (* body: CALL *)
defer 1
defer 1
apply (rule "HNull")  (* header: NULL *)
defer 1
defer 1
apply (simp)
apply (rule allI)
apply (rule "HLetr")  (* LETR *)
defer 1
apply (rule "HLetr")  (* LETR *)
defer 1
apply (rule "HLetr")  (* LETR *)
defer 1
apply (rule "HLetr")  (* LETR *)
defer 1
apply (rule "HCall")  (* body: CALL *)
defer 1
defer 1
defer 1


apply hoare_step
apply fastsimp
done

lemma (in listrev_example) 
   "[| \<Turnstile> (fun_preassn_table revAux) (CALL revAux) (fun_postassn_table revAux) ;
       \<Turnstile> (fun_preassn_table loop) (CALL loop) (fun_postassn_table loop) |] ==>
     \<Turnstile> {(z,s). s\<lfloor>l1\<rfloor>=Nullref}	
      mainBody
      {(z,s,v). s\<lfloor>l1\<rfloor>=Nullref}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
apply fastsimp
done


subsection {* Resource properties *}

(* nuked all foundational stuff
lemma "\<langle>twoOneState, (Call g)\<rangle> \<longrightarrow>e \<langle>val.Null, twoOneState (| clock := 1 |) \<rangle>"
apply (unfold twoOneState_def twoOneObjHeap_def mkState_def my_state_def my_heap_def main_def)
apply (simp)
apply (unfold intCons_def)
apply (auto)
apply (rule evalCall)
apply (rule)
apply (rule)
apply (rule)
apply (rule)
apply (rule)
apply (rule)
*)

end
