theory LenbVCGexamples = ToyVCG:

constdefs iszero::"int \<Rightarrow> int"
"iszero x == (if x = 0 then 1 else 0)"

locale count_example =
(*fun countdown(n) = let n = n -1
                     in if n < 1 then 0 else countdown(n) end
 *)
  fixes    m :: iname
    and	   n :: iname
    and	   b :: iname
    and	   countfn    :: funame
    and	   countfnbdy :: expr
  defines  "countfnbdy == LET m = expr.Int 1;
			      n = Primop (% x y. x-y) n m;
			      b = Primop (% x y. if x < 1 then 1 else 0) n n 
			   IN 

			      IF b THEN expr.Int 0 ELSE CALL countfn 
  			   END"
  assumes  countfnbdy[simp]:  "funtable countfn = countfnbdy"
      and  wfmeasure [simp]:  "fun_wfmeasure_table countfn = inv_image less_than (\<lambda> s. nat (get_ivar s n))"
      and  vardistinct:       "distinct [m,n,b]"

declare (in count_example) countfnbdy_def [simp]  (* unfold def *)

constdefs preCondTakesspace:: "(state \<Rightarrow> bool) \<Rightarrow> nat \<Rightarrow> expr \<Rightarrow> bool"
"preCondTakesspace P N e == 
  (\<Turnstile> {(z,s). card (fmap_dom (heap s)) = z \<and> P s} e
	{(z,s,v). card (fmap_dom (heap s)) = z+N})"
lemma (in count_example)
"preCondTakesspace (\<lambda> s. 0 < s<n>) 0 (CALL countfn)"
apply (insert vardistinct)
apply(simp add: preCondTakesspace_def)
apply hoare_simp
apply (erule_tac thin_rl)  (* remove used IH assumption *)
apply (simp add: inv_image_def)		     (* termination *)
apply (erule thin_rl, insert wfmeasure, simp)
apply(auto)
apply(arith)?
done

constdefs preCondTakestime:: "(state \<Rightarrow> bool) \<Rightarrow> nat \<Rightarrow> expr \<Rightarrow> bool"
"preCondTakestime P N e == 
    \<Turnstile> {(z,s). clock s = z \<and> P s} e {(z,s,v). clock s = z+N}"


lemma (in count_example) "\<Turnstile> {(z,s). clock s = 0 \<and> 1 = z \<and> z = s<n>} (CALL countfn)
                          {(z,s,v). clock s = 13}"
apply (insert vardistinct)
apply hoare_simp
apply (erule_tac thin_rl)  (* remove used IH assumption *)
apply(auto)
done



(* This concrete case is tricky because VCG tries to apply induction *)
lemma (in count_example) " \<Turnstile> {(z,s). 2 = s<n>} (CALL countfn)
                          {(z,s,v). v = IVal 0}"
apply (insert vardistinct)
apply(hoare_step)
apply(simp)
oops 

lemma (in count_example) " \<Turnstile> {(z,s). clock s = 0 \<and> 2 = s<n>} (CALL countfn)
                          {(z,s,v). \<exists> M . clock s = M}"
apply (insert vardistinct)
apply hoare_simp (*why do we get the side condition n = m here?*)
apply (erule_tac thin_rl)  (* remove used IH assumption *)
apply(auto)
oops


lemma (in count_example) "\<Turnstile> {(z,s). clock s = 0 \<and> 0 < z \<and> z = s<n>} (CALL countfn)
                          {(z,s,v). \<exists> K1 K2. clock s = K1 * (nat z) + K2}"
apply (insert vardistinct)
apply hoare_simp  (*why do we get the side condition s'<n> < 2 here?*)
apply (erule_tac thin_rl)  (* remove used IH assumption *)
apply(auto)
oops

(*the intention of this modified program is to prove that we create max (0, s<n>) objects*)
locale countNEW_example =
(*fun countdown(n) = let n = n -1
                         p = new LIST
                     in if n<1 then 0 else countdown(n) end
 *)
  fixes    m :: iname
    and	   n :: iname
    and	   b :: iname
    and    p :: rname
    and    C :: cname
    and	   countfn    :: funame
    and	   countfnbdy :: expr
  defines  "countfnbdy == LET m = expr.Int 1;
			      n = Primop (% x y. x-y) n m;
			      b = Primop (% x y. if x < 1 then 1 else 0) n n 
                          IN LETR p = NEW C
			     IN 
			      IF b THEN expr.Int 0 ELSE CALL countfn 
                             END
  			  END"
  assumes  countfnbdy[simp]:  "funtable countfn = countfnbdy"
      and  wfmeasure [simp]:  "fun_wfmeasure_table countfn = inv_image less_than (\<lambda> s. nat (get_ivar s n))"
      and  vardistinct:       "distinct [m,n,b]"
(*
      and  preinv: "fun_preassn_table countfn == {((z::int), s). s<n>=z \<and> }"
      and  const_postinv: "fun_postassn_table const == {((z::int), s, v). } "
*)

declare (in countNEW_example) countfnbdy_def [simp]  (* unfold def *)

lemma InsertDom[simp]:"card (insert l (fmap_dom H)) = Suc (card (fmap_dom H))"
sorry

types 'a AssnTable = "funame \<Rightarrow> ('a preassn \<times> 'a postassn)"

constdefs ok_local::"'a AssnTable \<Rightarrow> funame \<Rightarrow> bool"
"ok_local T f == (\<forall> P Q. (T f = (P,Q) \<longrightarrow> \<Turnstile> P (funtable f) Q))"

constdefs ok::"'a AssnTable \<Rightarrow> bool"
"ok T == (\<forall> f . ok_local T f)"

lemma "ok T \<and> T f = (P,Q) \<longrightarrow> \<Turnstile> P (funtable f) Q"
by(simp add: ok_def ok_local_def)


lemma (in countNEW_example)
"T countfn = ({(z,s) . clock s = z},{(z,s,v) . z < clock s}) \<longrightarrow> ok_local T countfn"
apply(simp add: ok_local_def)
apply(auto)
apply (insert vardistinct)
apply(hoare_simp)
apply(rule)
apply(rule)
oops

lemma (in countNEW_example)
"preCondTakesspace (\<lambda> s. 0 = s<n>) 1 (CALL countfn)"
apply (insert vardistinct)
apply(simp add: preCondTakesspace_def)
apply hoare_simp
apply(auto)
done

lemma (in countNEW_example)
"preCondTakesspace (\<lambda> s. 1 = s<n>) 1 (CALL countfn)"
apply (insert vardistinct)
apply(simp add: preCondTakesspace_def)
apply hoare_simp
apply(auto)
done

(* this one doesn't work: wrong induction hypothesis! *)
 lemma (in countNEW_example)
"preCondTakesspace (\<lambda> s. 2 = s<n>) 2 (CALL countfn)"
apply (insert vardistinct)
apply(simp add: preCondTakesspace_def)
apply hoare_simp
apply(auto)
oops

lemma (in countNEW_example) "(\<Turnstile> {((z1,nz),s).   card (fmap_dom (heap s)) = z1  \<and> s<n>=nz \<and> 0 < nz} (CALL countfn)
		     	        {((z1,nz),s,v). card (fmap_dom (heap s)) = z1+(nat nz)})"
apply (insert vardistinct)
apply hoare_simp
apply(auto)
(* apply(arith): Isabelle stupidity *)
defer 1
apply hoare_step apply(simp)
apply hoare_step
apply hoare_step
apply hoare_step
apply hoare_step
apply hoare_step
apply hoare_step
apply hoare_step
apply(auto)
done

lemma (in countNEW_example)
"(\<Turnstile> {(z,s). finite(fmap_dom (heap s)) \<and> card (fmap_dom (heap s)) = z \<and> s<n> = 2} 
    (CALL countfn)
    {(z,s,v). finite(fmap_dom (heap s)) \<and> card (fmap_dom (heap s)) = z+?N})"
apply (insert vardistinct)
apply hoare_simp
apply(auto)
done


lemma (in countNEW_example)
"preCondTakesspace (\<lambda> s. 0 < N \<and> N = nat (s<n>)) N (CALL countfn)"
apply (insert vardistinct)
apply(simp add: preCondTakesspace_def)
apply hoare_simp
apply (simp add: inv_image_def)		     (* termination *)
apply (erule thin_rl, insert wfmeasure, simp)
apply (erule_tac thin_rl)  (* remove used IH assumption *)
apply(auto)
apply(best)
prefer 2
apply (simp add: inv_image_def)		     (* termination *)
apply (erule thin_rl, insert wfmeasure, simp)
apply(auto)
apply(arith)
done
lemma card (insert l H) = Suc (card H)
