theory LISTTREEGen = ToyVCG:

datatype LIST_tp = NIL | CONS "TREE_tp" "LIST_tp" 
 and 	TREE_tp = LEAF "int" | NODE "TREE_tp" "int" "TREE_tp" 

consts 	TREE :: cname
 	LIST :: cname
 	
	hd:: rfldname
	left:: rfldname
	right:: rfldname
	tl:: rfldname
	content:: ifldname
	TAG :: ifldname

consts 	models_TREE:: "(locn \<times> state \<times> TREE_tp) set"
 	models_LIST:: "(locn \<times> state \<times> LIST_tp) set"
 	
inductive models_LIST models_TREE  intros
LEAF: "\<lbrakk> \<exists> ifields rfields . s \<lless>l\<ggreater> = Some(TREE,ifields,rfields) \<and> ifields content = a0 \<and>  ifields TAG = 1\<rbrakk> 
 \<Longrightarrow> (l, s, LEAF a0) \<in> models_TREE" 
NODE: "\<lbrakk> \<exists> ifields rfields . s \<lless>l\<ggreater> = Some(TREE,ifields,rfields) \<and> (\<exists> ll . rfields left = Ref ll \<and> (ll,s,a0) \<in> models_TREE) \<and> ifields content = a1 \<and> (\<exists> ll . rfields right = Ref ll \<and> (ll,s,a2) \<in> models_TREE) \<and>  ifields TAG = 2\<rbrakk> 
 \<Longrightarrow> (l, s, NODE a0 a1 a2) \<in> models_TREE" 
NIL: "\<lbrakk> \<exists> ifields rfields . s \<lless>l\<ggreater> = Some(LIST,ifields,rfields) \<and>  ifields TAG = 1\<rbrakk> 
 \<Longrightarrow> (l, s, NIL) \<in> models_LIST" 
CONS: "\<lbrakk> \<exists> ifields rfields . s \<lless>l\<ggreater> = Some(LIST,ifields,rfields) \<and> (\<exists> ll . rfields hd = Ref ll \<and> (ll,s,a0) \<in> models_TREE) \<and> (\<exists> ll . rfields tl = Ref ll \<and> (ll,s,a1) \<in> models_LIST) \<and>  ifields TAG = 2\<rbrakk> 
 \<Longrightarrow> (l, s, CONS a0 a1) \<in> models_LIST" 

lemma LEAF_intro: "\<exists> ifields rfields . s \<lless>l\<ggreater> = Some(TREE,ifields,rfields) \<and> ifields content = a0 \<and>  ifields TAG = 1
 \<Longrightarrow> (l, s, LEAF a0) \<in> models_TREE"
by (rule LEAF,simp)

lemma NODE_intro: "\<exists> ifields rfields . s \<lless>l\<ggreater> = Some(TREE,ifields,rfields) \<and> (\<exists> ll . rfields left = Ref ll \<and> (ll,s,a0) \<in> models_TREE) \<and> ifields content = a1 \<and> (\<exists> ll . rfields right = Ref ll \<and> (ll,s,a2) \<in> models_TREE) \<and>  ifields TAG = 2
 \<Longrightarrow> (l, s, NODE a0 a1 a2) \<in> models_TREE"
by (rule NODE,simp)

lemma NIL_intro: "\<exists> ifields rfields . s \<lless>l\<ggreater> = Some(LIST,ifields,rfields) \<and>  ifields TAG = 1
 \<Longrightarrow> (l, s, NIL) \<in> models_LIST"
by (rule NIL,simp)

lemma CONS_intro: "\<exists> ifields rfields . s \<lless>l\<ggreater> = Some(LIST,ifields,rfields) \<and> (\<exists> ll . rfields hd = Ref ll \<and> (ll,s,a0) \<in> models_TREE) \<and> (\<exists> ll . rfields tl = Ref ll \<and> (ll,s,a1) \<in> models_LIST) \<and>  ifields TAG = 2
 \<Longrightarrow> (l, s, CONS a0 a1) \<in> models_LIST"
by (rule CONS,simp)

lemma LEAF_elim: "(l, s, LEAF a0) \<in> models_TREE
 \<Longrightarrow> \<exists> ifields rfields . s \<lless>l\<ggreater> = Some(TREE,ifields,rfields) \<and> ifields content = a0 \<and>  ifields TAG = 1"
 by (erule models_LIST_models_TREE.elims, simp_all)

lemma NODE_elim: "(l, s, NODE a0 a1 a2) \<in> models_TREE
 \<Longrightarrow> \<exists> ifields rfields . s \<lless>l\<ggreater> = Some(TREE,ifields,rfields) \<and> (\<exists> ll . rfields left = Ref ll \<and> (ll,s,a0) \<in> models_TREE) \<and> ifields content = a1 \<and> (\<exists> ll . rfields right = Ref ll \<and> (ll,s,a2) \<in> models_TREE) \<and>  ifields TAG = 2"
 by (erule models_LIST_models_TREE.elims, simp_all)

lemma NIL_elim: "(l, s, NIL) \<in> models_LIST
 \<Longrightarrow> \<exists> ifields rfields . s \<lless>l\<ggreater> = Some(LIST,ifields,rfields) \<and>  ifields TAG = 1"
 by (erule models_LIST_models_TREE.elims, simp_all)

lemma CONS_elim: "(l, s, CONS a0 a1) \<in> models_LIST
 \<Longrightarrow> \<exists> ifields rfields . s \<lless>l\<ggreater> = Some(LIST,ifields,rfields) \<and> (\<exists> ll . rfields hd = Ref ll \<and> (ll,s,a0) \<in> models_TREE) \<and> (\<exists> ll . rfields tl = Ref ll \<and> (ll,s,a1) \<in> models_LIST) \<and>  ifields TAG = 2"
 by (erule models_LIST_models_TREE.elims, simp_all)

(*end of generated stuff*)

typedecl A
datatype List = n | c A List

consts 	models_List:: "(ref \<times> (ref list) \<times> state \<times> List) set"
consts models_A::"(ref \<times> state \<times> A) set"

inductive models_List  intros
N: "\<lbrakk> \<exists> ifields rfields . r = Ref l \<and> s \<lless>l\<ggreater> = Some(LIST,ifields,rfields) \<and>  ifields TAG = 1\<rbrakk> 
 \<Longrightarrow> (Ref l, [Nullref], s, n) \<in> models_List" 
C: "\<lbrakk> \<exists> ifields rfields . s \<lless>l\<ggreater> = Some(LIST,ifields,rfields) \<and> 
                          (\<exists> h . rfields hd = h \<and> (h,s,H) \<in> models_A) \<and> 
                          (\<exists> t . rfields tl = t \<and> (t,[r],s,T) \<in> models_List) \<and>  
                          ifields TAG = 2\<rbrakk> 
 \<Longrightarrow> (Ref l, [r], s, c H T) \<in> models_List" 

lemma "(s\<lless>1\<ggreater> = Some (LIST,I,R) \<and> I TAG = 2 \<and> R hd = Ref 3 \<and> R tl = Ref 2 \<and>
        s\<lless>2\<ggreater> = Some (LIST,I2,R2) \<and> I2 TAG = 1 \<and> (Ref 3, s, a0) \<in> models_A) \<longrightarrow>
       (Ref 1, [Nullref], s, c a0 n) \<in> models_List"
apply(clarsimp)
apply(subgoal_tac "\<exists> ifields rfields . s \<lless>1\<ggreater> = Some(LIST,ifields,rfields) \<and> 
                          (\<exists> h . rfields hd = h \<and> (h,s,a0) \<in> models_A) \<and> 
                          (\<exists> t . rfields tl = t \<and> (t,[Nullref],s,n) \<in> models_List) \<and>  
                          ifields TAG = 2")
apply(rule C, clarsimp)
apply(simp)
apply(rule N)
apply(auto)
done

consts append:: "List \<Rightarrow> List \<Rightarrow> List"
primrec
"append n l2 = l2"
"append (c a l) l2 = c a (append l l2)"

lemma "\<forall> r rr s l2 .
       ((r, [Ref rr], s, l1) \<in> models_List \<and> (Ref rr, [Nullref], s, l2) \<in> models_List \<longrightarrow> 
        (r, [Nullref], s, append l1 l2) \<in> models_List)"
apply(clarsimp)
apply(induct  "l1")
apply(simp)
apply(erule models_List.elims, simp)+
apply(clarsimp)
apply(simp)
apply(subgoal_tac "(r, [Nullref], s, append (c A List) l2) \<in> models_List")
apply(simp)
apply(erule models_List.elims, simp)+
apply(clarsimp)
apply(case_tac T)
apply(clarsimp)
apply(subgoal_tac "\<exists> ifields rfields . sb \<lless>l\<ggreater> = Some(LIST,ifields,rfields) \<and> 
                          (\<exists> h . rfields hd = h \<and> (h,sb,H) \<in> models_A) \<and> 
                          (\<exists> t . rfields tl = t \<and> (t,[Nullref],sb,n) \<in> models_List) \<and>  
                          ifields TAG = 2")
apply(rule C, simp)
apply(rule_tac x="ifields" in exI, rule_tac x="rfields" in exI, simp)


 end
