(*  
   File:        ToyVCGtest.ML
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: LIST.thy,v 1.1 2003/06/24 23:19:26 da Exp $

   Basic theory of list structures in the heap.
   Corresponds to ToyGrail language definition.
*)

theory LIST = ToyGrailDef + ToyPrelude:

(* name of the List class *)
consts LIST :: "cname"

(* predicates *)
consts is_LIST_object :: "obj \<Rightarrow>  bool"
primrec
 "is_LIST_object (cn, flds) = (cn = LIST)"

consts head :: "ifldname"
(* no field-descriptor constructs needed in ToyGrail *)
consts tail :: "rfldname"
(* no field-descriptor constructs needed in ToyGrail *)

(* build a list cell in the heap, and return the object representing the cell *)
constdefs cons ::"int \<Rightarrow> locn \<Rightarrow> obj"
 "cons h t == (LIST, emptyi (head:= h), emptyr (tail:=(Ref t)))"

(* build a list cell with integer n as its head, and return the object representing the cell *)
constdefs mkLIST:: "int => locn => obj"
 "mkLIST n l == (LIST, emptyi(head:= n), emptyr(tail:=(Ref l)))"

(* test whether first argument is empty list *)
(* 
consts isnil :: "val => int"
primrec
 "isnil (val.Void)   = (0::int)"
 "isnil (val.Null)   = (1::int)"
 "isnil (val.Int i)  = (0::int)"
 "isnil (val.Ref r)  = (0::int)"
*)

(* we assume that a val.Null is mapped to 0 and a val.Ref to a nat number > 0 *)
consts ref2int :: "ref => int"
primrec
 "ref2int Nullref = (0::int)"
 "ref2int (Ref l) = (int l)"

(*
constdefs myisnil :: "ref => int"
 "myisnil r == iszero (ref2int r)"
*)

consts 
  isnil :: "ref => int"
primrec
 "isnil Nullref = 1"
 "isnil (Ref l) = 0"

constdefs ISNIL_fct :: "ref \<Rightarrow> ref \<Rightarrow> int"
 "ISNIL_fct == \<lambda> r1 r2. isnil r1"

syntax
 "primisnil"  :: "rname \<Rightarrow> expr"  ("ISNIL _" [50] 51)
translations
 "ISNIL n" => "RPrimop ISNIL_fct n n"
 "ISNIL n" <= "RPrimop ISNIL_fct n z"

end
