(*  Some new, working, and uncluttered  induction examples!!! *)

theory InductionEgs = ToyVCG:
subsection {* Testing the VCGen: factorial *}

consts facspec :: "int \<Rightarrow> int"
recdef facspec "measure (\<lambda> n. (nat (abs n)))"
 "facspec n = (if n < 2 then 1 else n * (facspec (n - 1)))"

(* a trick to keep facspec out of the simpset (declare facspec_def [simp del] appears not to work\<dots>*)
constdefs FS::"int \<Rightarrow> int"
"FS i == (facspec i)"

locale fac_example =
 fixes n :: iname
  and  acc :: iname
  and  b :: iname
  and  fac ::funame
  and  facBody :: expr
defines 
"facBody \<equiv> LET acc = Primop (% x y. x * y) acc n;
                n = Primop (% x y. x - 1) n n;
                b = Primop (% x y. if x < 2 then 1 else 0) n n 
           IN IF b THEN IVar acc ELSE CALL fac
  	   END"

assumes vardistinct:   "distinct [n,acc,b] \<and> distinct [b,acc,n]"
    and fac_fnbody[simp]:    "funtable fac = facBody"
    and fac_wfmeasure[simp]: "fun_wfmeasure_table fac = inv_image less_than (\<lambda>s . nat (abs (s<n>)))"
    and fac_preinv[simp]:    "fun_preassn_table fac = {(N,s). 0 < N \<and> 0 < s<acc> \<and> 0 < s<n> \<and> 
                                                               (s<acc>) * (FS (s<n>)) = FS N}"
    and fac_postinv[simp]:   "fun_postassn_table fac = {(N,s,v). v = IVal (FS N)}"

declare (in fac_example) facBody_def   [simp]

lemma absL : "0 < A \<longrightarrow> abs A = A \<and> abs (A - (1::int)) = A - (1::int)"
by arith+

lemma facspecLemma: "(0::int) < a \<and> 0 < (s'<acc>) \<and> 0 < (s'<n>) \<and>  (s'<acc>) * facspec (s'<n>) = A \<and> \<not> s'<n> < 3 \<longrightarrow>
              (s'<acc>) * (s'<n>) * facspec (s'<n> - 1) = A"
apply(clarify)
apply(auto)
done

lemma MultPos: "(0::int) < A \<and> 0 < B \<longrightarrow> 0 < A * B"
apply (induct_tac "nat (abs A)")
apply arith
(* da: Interesting (odd) message from Isabelle:
Simple arithmetic decision procedure failed.
Now trying full Presburger arithmetic...

Counter example:
B = 1, A = 1, A * B = 0

Simple arithmetic decision procedure failed.
Now trying full Presburger arithmetic... *)


(*declare facspec_def [simp del]*)

lemma (in fac_example) fact_is_cool2:
   "\<Turnstile> {(N::int,s). 0 < N \<and> N = s<n> \<and> 1 = s<acc>}
	(CALL fac)
      {(N::int,s,v). v = IVal (FS N)}"
apply (insert vardistinct)
apply hoare_rec
defer 1
apply fastsimp
apply fastsimp
apply hoare_simp
apply (simp_all add: inv_image_def)		     (* termination *)
apply (erule thin_rl, insert fac_wfmeasure, simp)
apply auto
apply(simp_all only: FS_def)
apply (case_tac "s'<n> = 1")
apply(simp)
apply (case_tac "s'<n> = 2")
apply(simp)
apply(arith)
apply(simp add: MultPos)
apply(insert facspecLemma)
apply fast
apply(subgoal_tac "abs(s'<n>) = s'<n> \<and> abs(s'<n> - (1::int)) = s'<n> - (1::int)")
apply simp
apply(simp add: absL)
apply(auto)
oops (*only wf condition left*)

locale count_example =
(*fun countdown(n) = let n = n -1
                     in if n < 1 then 0 else countdown(n) end
 *)
  fixes    one :: iname
    and	   n :: iname
    and	   b :: iname
    and	   countfn    :: funame
    and	   countfnbdy :: expr
  defines  "countfnbdy == LET one = expr.Int 1;
			      n = Primop (% x y. x-y) n one;
			      b = Primop (% x y. if x < 1 then 1 else 0) n n 
			   IN 
			      IF b THEN expr.Int 42 ELSE CALL countfn
  			   END"
  assumes  countfnbdy[simp]:  "funtable countfn = countfnbdy"
      and  wfmeasure [simp]:  "fun_wfmeasure_table countfn = inv_image less_than (\<lambda> s. nat (get_ivar s n))"
      and  vardistinct:       "distinct [one,n,b] \<and> distinct [b,n,one]"
      and  preAss[simp]:    "fun_preassn_table countfn = {((C,N),s). 
                                                     clock s = C + 12 * (N - (s<n>)) \<and> 0 < s<n>}"
      and  postAss[simp]:   "fun_postassn_table countfn = {((C,N),s,v).
						     clock s = C + 12 * N + 1}"

declare (in count_example) countfnbdy_def [simp]

lemma (in count_example) 
   "\<Turnstile> {((C,N),s). C = clock s \<and> N = s<n> 
		  \<and> 0 < (s<n>)}	
	(CALL countfn) 
      {((C,N),s,v). clock s = C + 12 * N + 1}"
apply (insert vardistinct)
apply hoare_rec
defer 1
apply fastsimp
apply fastsimp
apply hoare_simp
apply (simp add: inv_image_def)		     (* termination *)
apply (erule thin_rl, insert wfmeasure, simp)
apply (rule wf_inv_image, rule wf_less_than) (* WF measure *)
done

constdefs HSize ::"state \<Rightarrow> int"
"HSize s == int (card (fmap_dom (heap s)))"
declare HSize_def [simp]

locale count2 =
(*fun countdown(n) = let n = n -1
                     in if n < 1 then 0 else countdown(n) end
 *)
  fixes    one :: iname
    and	   n :: iname
    and	   b :: iname
    and	   countfn    :: funame
    and	   countfnbdy :: expr
  defines  "countfnbdy == LET one = expr.Int 1;
			      n = Primop (% x y. x-y) n one;
			      b = Primop (% x y. if x < 1 then 1 else 0) n n 
			   IN 
			      IF b THEN expr.Int 42 ELSE CALL countfn
  			   END"
  assumes  countfnbdy[simp]:  "funtable countfn = countfnbdy"
      and  wfmeasure [simp]:  "fun_wfmeasure_table countfn = inv_image less_than (\<lambda> s. nat (get_ivar s n))"
      and  vardistinct:       "distinct [one,n,b] \<and> distinct [b,n,one]"
      and  preAss[simp]:    "fun_preassn_table countfn = {((C,N,H),s). 
                                                     clock s = C + 12 * (N - (s<n>)) \<and> 0 < s<n> \<and> HSize s = H}"
      and  postAss[simp]:   "fun_postassn_table countfn = {((C,N,H),s,v).
						     clock s = C + 12 * N + 1 \<and> HSize s = H \<and> v = IVal 42 \<and> s<n> = 0}"

declare (in count2) countfnbdy_def [simp]

lemma (in count2) 
   "\<Turnstile> {((C,N,H),s). C = clock s \<and> N = s<n> \<and> H = HSize s \<and> 0 < (s<n>)}	
	(CALL countfn) 
      {((C,N,H),s,v). clock s = C + 12 * N + 1 \<and> H = HSize s \<and> v = IVal 42 \<and> s<n> = 0}"
apply (insert vardistinct)
apply hoare_rec
defer 1
apply fastsimp
apply fastsimp
apply hoare_simp
apply (simp add: inv_image_def)		     (* termination *)
apply (erule thin_rl, insert wfmeasure, simp)
apply (rule wf_inv_image, rule wf_less_than) (* WF measure *)
done

locale count3 =
(*fun countdown(n) = let n = n -1
                         p = NEW C
                     in if n < 1 then 0 else countdown(n) end
 *)
  fixes    one :: iname
    and	   n :: iname
    and	   b :: iname
    and    p :: rname
    and    C :: cname
    and	   countfn    :: funame
    and	   countfnbdy :: expr
  defines  "countfnbdy == LET one = expr.Int 1;
			      n = Primop (% x y. x-y) n one;
			      b = Primop (% x y. if x < 1 then 1 else 0) n n 
			   IN LETR p = NEW C
			     IN 
			      IF b THEN expr.Int 42 ELSE CALL countfn 
                             END
  			  END"
  assumes  countfnbdy[simp]:  "funtable countfn = countfnbdy"
      and  wfmeasure [simp]:  "fun_wfmeasure_table countfn = inv_image less_than (\<lambda> s. nat (get_ivar s n))"
      and  vardistinct:       "distinct [one,n,b] \<and> distinct [b,n,one]"
      and  preAss[simp]:    "fun_preassn_table countfn = {((C,N,H),s). 
                                                     clock s = C + 14 * (N - (s<n>)) \<and> 0 < s<n> \<and> 
                                                     HSize s = H + (N - (s<n>))}"
      and  postAss[simp]:   "fun_postassn_table countfn = {((C,N,H),s,v).
						     clock s = C + 14 * N + 1 \<and> HSize s = H + N \<and> 
                                                     v = IVal 42 \<and> s<n> = 0}"

declare (in count3) countfnbdy_def [simp]

lemma SizeInsert[simp]: "int (card (insert (freshloc H) H)) = int (card H) + 1"
sorry


lemma (in count3) 
   "\<Turnstile> {((C,N,H),s). C = clock s \<and> N = s<n> \<and> H = HSize s \<and> 0 < (s<n>)}	
	(CALL countfn) 
      {((C,N,H),s,v). clock s = C + 14 * N + 1 \<and> HSize s = H + N \<and> v = IVal 42 \<and> s<n> = 0}"
apply (insert vardistinct)
apply hoare_rec
defer 1
apply fastsimp
apply fastsimp
apply hoare_simp
apply (simp add: inv_image_def)		     (* termination *)
apply (erule thin_rl, insert wfmeasure, simp)
apply (rule wf_inv_image, rule wf_less_than) (* WF measure *)
done

consts get_IFLDcontentAux2::"obj option \<Rightarrow> ifldname \<Rightarrow> int"
primrec
"get_IFLDcontentAux2 (Some obj) f = (fst (snd obj)) f"

consts get_IFLDcontentAux1::"state \<Rightarrow> ref \<Rightarrow> ifldname \<Rightarrow> int"
primrec
"get_IFLDcontentAux1 s (Ref l) f = get_IFLDcontentAux2 (s\<lless>l\<ggreater>) f"

constdefs get_IFLDcontent::"state \<Rightarrow> rname \<Rightarrow> ifldname \<Rightarrow> int"
"get_IFLDcontent s r f == get_IFLDcontentAux1 s (s\<lfloor>r\<rfloor>) f"

locale countInvoke =
(*methof C.countdown(n) = let n = n -1
                              p = NEW C
                          in if n < 1 then 0 else InvokeStatic C.countdown(n) end
 *)
  fixes    one :: iname
    and	   n :: iname
    and	   b :: iname
    and    p :: rname
    and    C :: cname
    and    content :: ifldname
    and	   count    :: mname
    and	   countbdy :: expr
  defines  "countbdy == LET one = expr.Int 1;
                              n = GetFi param content;
			      n = Primop (% x y. x-y) n one;
			      b = Primop (% x y. if x < 1 then 1 else 0) n n ;
                              n = PutFi param content n
		        IN 
			      IF b THEN expr.Int 42 ELSE expr.Int 55 END" 
 (* ([class C]\<bullet>count(param))END *)
  assumes  countlookup[simp]: "snd ((meths (classtable C)) count) = countbdy"
      and  wfmeasure [simp]:  "meth_wfmeasure_table count = inv_image less_than (\<lambda> s. nat (get_IFLDcontent s param content))"
      and  vardistinct:       "distinct [one,n,b] \<and> distinct [b,n,one]"
      and  preAss[simp]:    "fun_preassn_table countfn = 
                               {((Clk,N,H),s). clock s = Clk + 22 * (N - (get_IFLDcontent s param content)) \<and> 
                                               0 < (get_IFLDcontent s param content) \<and> 
                                               HSize s = H \<and>
                                               (\<exists> l ob . s\<lfloor>param\<rfloor> = Ref l \<and> s\<lless>l\<ggreater> = Some(ob))}"
      and  postAss[simp]:   "fun_postassn_table countfn = 
                               {((Clk,N,H),s,v). clock s = Clk + 22 * N + 1 \<and> HSize s = H \<and> v = IVal 42}"

declare (in countInvoke) countbdy_def [simp]
declare get_IFLDcontent_def [simp]

lemma (in countInvoke) 
   "\<Turnstile> {((Clk,N,H),s). Clk = clock s \<and> N = (get_IFLDcontent s param content) \<and> H = HSize s \<and> 0 < (get_IFLDcontent s param content) \<and> 
                      (\<exists> l ob . s\<lfloor>param\<rfloor> = Ref l \<and> s\<lless>l\<ggreater> = Some(ob))}	
	([class C]\<bullet>count(param))
      {((Clk,N,H),s,v). clock s = Clk + 22 * N + 1 \<and> HSize s = H + N \<and> v = IVal 42}"
apply (insert vardistinct)
apply(simp)
apply hoare_step apply(simp)
apply hoare_step apply(simp)
apply hoare_step apply(simp)
defer 1
apply hoare_step apply(simp)
apply hoare_step 
apply hoare_step apply(simp)
apply hoare_step 
apply hoare_step apply(simp)
apply hoare_step
apply hoare_step apply(simp)
apply hoare_step
apply hoare_step 
apply hoare_step 
apply hoare_step
apply (erule thin_rl, insert wfmeasure, simp)
apply (rule wf_inv_image, rule wf_less_than) (* WF measure *)
apply(auto) 
oops


(*------------------------------------------------------------------------------------*)

locale evenodd1 =
(* fun even n = {\<exists> k. s<n> = N - 2k}
                let m = n - 1 in
                if n = 0 then true 
                         else {\<exists> k. s<m> = N - 2k - 1}
                              let n = m - 1 in 
                              if m = 0 then false 
                                       else even n
   {{N,s,v) . (v = True \<longrightarrow> N even) \<and> v = False \<longrightarrow> N odd}
 *)
  fixes    n        :: iname    and    m       :: iname    and    b        :: iname
    and	   even     :: funame
    and	   evenBody :: expr
  defines  "evenBody == LET m = Primop (% x y. x - 1) n n;
			    b = Primop (% x y. if x < 1 then 1 else 0) n n
		        IN IF b THEN expr.Int 1 
                                ELSE LET n = Primop (% x y. x - 1) m m;
			                 b = Primop (% x y. if x < 1 then 1 else 0) m m
		                     IN IF b THEN expr.Int 0 ELSE CALL even
                                     END 
                        END"
  assumes  even_fnbdy[simp]:     "funtable even = evenBody"
      and  even_wfmeasure[simp]: "fun_wfmeasure_table even = inv_image less_than (\<lambda> s. nat (s<n>))"
      and  vardistinct: "distinct [n,m,b] \<and> distinct [b,m,n]"

      and  even_postinv: "fun_postassn_table even = {(N::int,s,v). ((v = (IVal 1) \<longrightarrow> (\<exists> k . N = 2 * k \<and> 0 <= k)) \<and> 
                                                                    (v = (IVal 0) \<longrightarrow> (\<exists> k . N = 2 * k + 1 \<and> 0 <= k)) \<and>
                                                                    (v = IVal 0 \<or> v = IVal 1))}"
      and  even_preinv: "fun_preassn_table even = {(N::int,s). 0 <= N \<and> 0 <= s<n> \<and> (\<exists> k . s<n> = N - 2 * k \<and> 0 <= k)}"
 
declare (in evenodd1) even_preinv    [simp]
declare (in evenodd1) even_postinv   [simp]
declare (in evenodd1) evenBody_def   [simp]

lemma (in evenodd1) 
    "\<Turnstile> {(N::int,s). 0 <= N \<and> s<n> = N}
      (CALL even)
      {(N::int,s,v). ((v = (IVal 1) \<longrightarrow> (\<exists> k . N = 2 * k \<and> 0 <= k)) \<and> 
                      (v = (IVal 0) \<longrightarrow> (\<exists> k . N = 2 * k + 1 \<and> 0 <= k)) \<and>
                      (v = IVal 0 \<or> v = IVal 1))}"
apply (insert vardistinct)
apply(clarsimp)
apply(hoare_rec)
apply(simp)
defer 1
apply fastsimp
apply fastsimp
apply hoare_simp
apply auto
apply(subgoal_tac "0 = a - 2 * k")
apply(rule_tac x="k" in exI, simp)
apply(auto)
apply(subgoal_tac "1 = a - 2 * k")
apply(rule_tac x="k" in exI, simp)
apply(auto)
apply(rule_tac x="k + 1" in exI)
apply(auto)
apply (simp add: inv_image_def)		     (* termination *)
done

(*HSize works\<dots>.*)
locale evenodd2 =
  fixes    n        :: iname    and    m       :: iname    and    b        :: iname
    and	   even     :: funame
    and	   evenBody :: expr
  defines  "evenBody == LET m = Primop (% x y. x - 1) n n;
			    b = Primop (% x y. if x < 1 then 1 else 0) n n
		        IN IF b THEN expr.Int 1 
                                ELSE LET n = Primop (% x y. x - 1) m m;
			                 b = Primop (% x y. if x < 1 then 1 else 0) m m
		                     IN IF b THEN expr.Int 0 ELSE CALL even
                                     END 
                        END"
  assumes  even_fnbdy[simp]:     "funtable even = evenBody"
      and  even_wfmeasure[simp]: "fun_wfmeasure_table even = inv_image less_than (\<lambda> s. nat (s<n>))"
      and  vardistinct: "distinct [n,m,b] \<and> distinct [b,m,n]"
      and  postAss[simp]: 
                "fun_postassn_table even = 
                  {((N::int,H),s,v). ((v = (IVal 1) \<longrightarrow> (\<exists> k . N = 2 * k \<and> 0 <= k)) \<and> 
                                      (v = (IVal 0) \<longrightarrow> (\<exists> k . N = 2 * k + 1 \<and> 0 <= k)) \<and>
                                      (v = IVal 0 \<or> v = IVal 1) \<and> 
                                      HSize s = H)}"
      and  preAss[simp]: 
                "fun_preassn_table even = 
                 {((N::int,H),s). 0 <= N \<and> 0 <= s<n> \<and> (\<exists> k . s<n> = N - 2 * k \<and> 0 <= k) \<and> HSize s = H}"
 
declare (in evenodd2) evenBody_def [simp]

lemma (in evenodd2) 
    "\<Turnstile> {((N::int,H),s). 0 <= N \<and> s<n> = N \<and> H = HSize s}
       (CALL even)
       {((N::int,H),s,v). ((v = (IVal 1) \<longrightarrow> (\<exists> k . N = 2 * k \<and> 0 <= k)) \<and> 
                           (v = (IVal 0) \<longrightarrow> (\<exists> k . N = 2 * k + 1 \<and> 0 <= k)) \<and>
                           (v = IVal 0 \<or> v = IVal 1) \<and>
                           HSize s = H)}"
apply (insert vardistinct)
apply clarsimp
apply hoare_rec
apply simp
defer 1
apply fastsimp
apply fastsimp
apply hoare_simp
apply auto
apply (subgoal_tac "0 = a - 2 * k")
apply (rule_tac x="k" in exI, simp)
apply auto
apply (subgoal_tac "1 = a - 2 * k")
apply (rule_tac x="k" in exI, simp)
apply auto
apply (rule_tac x="k + 1" in exI)
apply auto
apply (simp add: inv_image_def)		     (* termination *)
done

(*Clock & HSize work\<dots>.*)
locale evenodd3 =
  fixes    n        :: iname    and    m       :: iname    and    b        :: iname
    and	   even     :: funame
    and	   evenBody :: expr
  defines  "evenBody == LET m = Primop (% x y. x - 1) n n;
			    b = Primop (% x y. if x < 1 then 1 else 0) n n
		        IN IF b THEN expr.Int 1 
                                ELSE LET n = Primop (% x y. x - 1) m m;
			                 b = Primop (% x y. if x < 1 then 1 else 0) m m
		                     IN IF b THEN expr.Int 0 ELSE CALL even
                                     END 
                        END"
  assumes  even_fnbdy[simp]:     "funtable even = evenBody"
      and  even_wfmeasure[simp]: "fun_wfmeasure_table even = inv_image less_than (\<lambda> s. nat (s<n>))"
      and  vardistinct: "distinct [n,m,b] \<and> distinct [b,m,n]"
      and  postAss[simp]: 
                "fun_postassn_table even = 
                  {((N::int,Clk,H),s,v). ((v = (IVal 1) \<longrightarrow> ((\<exists> k . N = 2 * k \<and> 0 <= k \<and> clock s = Clk + 11 + 19 * k) \<and> s<n> = 0)) \<and> 
                                          (v = (IVal 0) \<longrightarrow> ((\<exists> k . N = 2 * k + 1 \<and> 0 <= k \<and> clock s = Clk + 20 + 19 * k) \<and> s<m> = 0))
                                          \<and>
                                          (v = IVal 0 \<or> v = IVal 1) \<and> 
                                          HSize s = H)}"
      and  preAss[simp]: 
                "fun_preassn_table even = 
                 {((N::int,Clk,H),s). (0 <= N \<and> 0 <= s<n> \<and> (\<exists> k . s<n> = N - 2 * k \<and> 0 <= k \<and> clock s = Clk + 19 * k) \<and> 
                                       HSize s = H)}"
 
declare (in evenodd3) evenBody_def [simp]

lemma (in evenodd3) 
    "\<Turnstile> {((N::int,Clk,H),s). 0 <= N \<and> s<n> = N \<and> clock s = Clk \<and> HSize s = H}
       (CALL even)
       {((N::int,Clk,H),s,v). ((v = (IVal 1) \<longrightarrow> ((\<exists> k . N = 2 * k \<and> 0 <= k \<and> clock s = Clk + 11 + 19 * k) \<and> s<n> = 0)) \<and> 
                               (v = (IVal 0) \<longrightarrow> ((\<exists> k . N = 2 * k + 1 \<and> 0 <= k \<and> clock s = Clk + 20 + 19 * k) \<and> s<m> = 0)) \<and>
                               (v = IVal 0 \<or> v = IVal 1) \<and> 
                               HSize s = H)}"
apply (insert vardistinct)
apply clarsimp
apply hoare_rec
apply simp
defer 1
apply fastsimp
apply fastsimp
apply hoare_simp
apply auto
apply (rule_tac x="k + 1" in exI, simp)
apply (simp add: inv_image_def)		     (* termination *)
done

(*A variant which creates a new object during in the "odd"-branch*)
locale evenoddNEW =
  fixes n    :: iname    and m   :: iname    and b :: iname
    and	even :: funame   and CN  :: cname    and p :: rname
    and	   evenBody :: expr
  defines  "evenBody == LET m = Primop (% x y. x - 1) n n;
			    b = Primop (% x y. if x < 1 then 1 else 0) n n
		        IN IF b THEN expr.Int 1 
                                ELSE LET n = Primop (% x y. x - 1) m m;
			                 b = Primop (% x y. if x < 1 then 1 else 0) m m
                                     IN LETR p = NEW CN
                                        IN IF b THEN expr.Int 0 ELSE CALL even
                                        END
                                     END 
                        END"
  assumes  even_fnbdy[simp]:     "funtable even = evenBody"
      and  even_wfmeasure[simp]: "fun_wfmeasure_table even = inv_image less_than (\<lambda> s. nat (s<n>))"
      and  vardistinct: "distinct [n,m,b] \<and> distinct [b,m,n]"
      and  postAss[simp]: 
                "fun_postassn_table even = 
                  {((N::int,Clk,H),s,v). ((v = (IVal 1) \<longrightarrow> ((\<exists> k . N = 2 * k \<and> 0 <= k \<and> 
                                                                    clock s = Clk + 11 + 21 * k \<and> HSize s = H + k) \<and> 
                                                             s<n> = 0)) \<and> 
                                          (v = (IVal 0) \<longrightarrow> ((\<exists> k . N = 2 * k + 1 \<and> 0 <= k \<and> 
                                                                    clock s = Clk + 22 + 21 * k \<and> HSize s = H + k + 1) \<and> 
                                                             s<m> = 0))
                                          \<and>
                                          (v = IVal 0 \<or> v = IVal 1))}"
      and  preAss[simp]: 
                "fun_preassn_table even = 
                 {((N::int,Clk,H),s). (0 <= N \<and> 0 <= s<n> \<and> 
                                       (\<exists> k . s<n> = N - 2 * k \<and> 0 <= k \<and> clock s = Clk + 21 * k \<and> HSize s = H + k))}"
 
declare (in evenoddNEW) evenBody_def [simp]

lemma (in evenoddNEW) 
    "\<Turnstile> {((N::int,Clk,H),s). 0 <= N \<and> s<n> = N \<and> clock s = Clk \<and> HSize s = H}
       (CALL even)
       {((N::int,Clk,H),s,v). ((v = (IVal 1) \<longrightarrow> ((\<exists> k . N = 2 * k \<and> 0 <= k \<and> clock s = Clk + 11 + 21 * k \<and> HSize s = H + k) \<and> 
                                                  s<n> = 0)) \<and> 
                               (v = (IVal 0) \<longrightarrow> ((\<exists> k . N = 2 * k + 1 \<and> 0 <= k \<and> clock s = Clk + 22 + 21 * k \<and> HSize s = H + k + 1) \<and>
                                                  s<m> = 0))
                               \<and>
                               (v = IVal 0 \<or> v = IVal 1))}"
apply (insert vardistinct)
apply clarsimp
apply hoare_rec
apply simp
defer 1
apply fastsimp
apply fastsimp
apply hoare_simp
apply auto
apply (simp add: inv_image_def)		     (* termination *)
done


(* Mutual recursion in even/odd*)

locale EO1 =
(* fun even n = {\<exists> k. s<n> = N - 2k}
                let m = n - 1 in
                if n = 0 then true 
                         else odd(m)
   fun odd m = {\<exists> k. s<m> = N - 2k - 1}
               let n = m - 1 in 
               if m = 0 then false 
               else even n
   {{N,s,v) . (v = True \<longrightarrow> N even) \<and> v = False \<longrightarrow> N odd}
 *)
  fixes    n        :: iname    and   m       :: iname    and    b        :: iname
    and	   even     :: funame   and   odd     :: funame
    and	   evenBody :: expr     and   oddBody :: expr
  defines  "evenBody == LET m = Primop (% x y. x - 1) n n;
			    b = Primop (% x y. if x < 1 then 1 else 0) n n
		        IN IF b THEN expr.Int 1 ELSE CALL odd
                        END"
      and  "oddBody ==  LET n = Primop (% x y. x - 1) m m;
                            b = Primop (% x y. if x < 1 then 1 else 0) m m
		        IN IF b THEN expr.Int 0 ELSE CALL even
                        END"

  assumes  even_fnbdy[simp]:     "funtable even = evenBody"
  assumes  odd_fnbdy[simp]:      "funtable odd = oddBody"
      and  even_wfmeasure[simp]: "fun_wfmeasure_table even = inv_image less_than (\<lambda> s. nat (s<n>))"
      and  odd_wfmeasure[simp] : "fun_wfmeasure_table odd  = inv_image less_than (\<lambda> s. nat (s<n>))"
      and  vardistinct: "distinct [n,m,b] \<and> distinct [b,m,n]"

      and  evenPost[simp]: "fun_postassn_table even = {(N::int,s,v). ((v = (IVal 1) \<longrightarrow> (
                                                                                         (\<exists> k . N = 2 * k \<and> 0 <= k))) \<and> 
                                                                      (v = (IVal 0) \<longrightarrow> (
                                                                                         (\<exists> k . N = 2 * k + 1 \<and> 0 <= k))) \<and>
                                                                      (v = IVal 0 \<or> v = IVal 1)
                                                                      )}"
 
      and  evenPre[simp]:  "fun_preassn_table even  = {(N::int,s). 0 <= N \<and> 0 <= s<n> \<and> (\<exists> k . s<n> = N - 2 * k \<and> 0 <= k)}"
(*
      and  oddPost[simp]:  "fun_postassn_table odd  = {(N::int,s,v). ((v = (IVal 1) \<longrightarrow> (
                                                                                         (\<exists> k . N = 2 * k \<and> 0 <= k))) \<and> 
                                                                      (v = (IVal 0) \<longrightarrow> (
                                                                                         (\<exists> k . N = 2 * k + 1 \<and> 0 <= k))) \<and>
                                                                      (v = IVal 0 \<or> v = IVal 1)
                                                                      )}"
      and  oddPre[simp]:   "fun_preassn_table odd   = {(N::int,s). 0 <= N \<and> 0 <= s<m> \<and> s<m> + 1 = s<n> \<and> (\<exists> k . s<m> = N - 2 * k - 1 \<and> 0 <= k)}"
*)
 
declare (in EO1) evenBody_def   [simp]
declare (in EO1) oddBody_def    [simp]

lemma (in EO1) 
    "\<Turnstile> {(N::int,s). 0 <= N \<and> s<n> = N \<and> s<m> = N}
      (CALL even)
      {(N::int,s,v). ((v = (IVal 1) \<longrightarrow> ( (\<exists> k . N = 2 * k \<and> 0 <= k))) \<and> 
                      (v = (IVal 0) \<longrightarrow> ( (\<exists> k . N = 2 * k + 1 \<and> 0 <= k))) \<and>
                      (v = IVal 0 \<or> v = IVal 1)
                     )}"
apply (insert vardistinct)
apply(clarsimp)
apply(hoare_rec)
apply(simp)
defer 1
apply fastsimp
apply fastsimp
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
defer 1
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(subgoal_tac "\<Turnstile> {(N::int,s). 0 <= N \<and> 0 <= s<m> \<and> (\<exists> k . s<m> = N - 2 * k - 1 \<and> 0 <= k)} (CALL odd)
                {(N, s, v).
                 (v = IVal 1 \<longrightarrow> (\<exists>k. N = 2 * k \<and> 0 \<le> k)) \<and>
                 (v = IVal 0 \<longrightarrow> (\<exists>k. N = 2 * k + 1 \<and> 0 \<le> k)) \<and> (v = IVal 0 \<or> v = IVal 1)}")
apply(fastsimp)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
defer 1
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply auto
apply(subgoal_tac "0 = a - 2 * k")
apply(rule_tac x="k" in exI, simp)
apply(auto)
apply(subgoal_tac "1 = a - 2 * k")
apply(rule_tac x="k" in exI, simp)
apply(auto)
apply(rule_tac x="k + 1" in exI)
apply(auto)
apply (simp add: inv_image_def)		     (* termination *)
apply(auto)
oops

(*---------------------------------------------------------------------------------------*)
consts   LST  :: cname
         HD   :: ifldname
         TL   :: rfldname
         TAG  ::ifldname
         modelsLoc:: "(locn \<times> int \<times> state) set"
         models:: "(rname \<times> iname \<times> state) set"
         mod:: "(rname \<times> int \<times> state) set"
(*models x y s true if s<x> models a list with s<y> CONS cells*)
inductive modelsLoc intros
MODL1: "\<lbrakk>s\<lless>l\<ggreater> = Some (LST, ifld,rfld) \<and> ifld TAG = 1 \<and> rfld TL = Ref ll \<and> 0 < i \<and> (ll, i - 1,s) \<in> modelsLoc \<rbrakk> 
        \<Longrightarrow> (l,i,s) \<in> modelsLoc"
MODL2: "\<lbrakk>s\<lless>l\<ggreater> = Some (LST, ifld,rfld) \<and> ifld TAG = 0\<rbrakk> 
        \<Longrightarrow> (l,0,s) \<in> modelsLoc"
inductive models intros
MOD:   "\<lbrakk>s\<lfloor>x\<rfloor> = Ref l \<and> (l,s<y>,s) \<in> modelsLoc\<rbrakk> \<Longrightarrow> (x,y,s) \<in> models"

locale ReynoldsRev = 
  (* Rev(i) = let j = New List Nil
                  t = i.tag
              in if t = NILTAG then j else h(i,j)
     h(i,j) = let k = i.tail; i.tail = j; j = i; i = k; t = i.tag
                  length --
              in if t = NILTAG then j else h(i,j) end
   where length is an artificial measure*)

  fixes    t        :: iname    and    l       :: iname    and    b   :: iname
    and    i        :: rname    and    j       :: rname    and    k   :: rname
    and	   h        :: funame
    and	   hBody    :: expr     and    RevBody :: expr
  defines  "hBody == LETR k = GetFr i TL;
                          j = PutFr i TL j;
                          j = RVar i;
                          i = RVar k IN
                     LET  t = GetFi i TAG;
                          l = Primop (% x y . x - 1) l l;
                          b = Primop (% x y. if x < 1 then 1 else 0) l l
		      IN IF b THEN RVar j ELSE CALL h
                      END
                     END"
                          
  defines  "RevBody == LETR j = NEW LST IN
                       LET  t = expr.Int 0;
                            t = PutFi j TAG t;
                            t = GetFi i TAG;
                            b = Primop (% x y. if x < 1 then 1 else 0) l l
		        IN IF b THEN RVar j ELSE CALL h
                        END
                       END"
(* exit condition should be  b = Primop (% x y. if x < 1 then 1 else 0) t t*)
  assumes  h_fnbdy[simp]:        "funtable h = hBody"
  assumes  wfmeasure[simp]:      "fun_wfmeasure_table h = inv_image less_than (\<lambda> s. nat (s<l>))"
  assumes  vardistinct[simp]:    "distinct [t,l,b] \<and> distinct [b,l,t]"

  assumes  h_preinv[simp]:      "fun_preassn_table h = {(N,s). 0 < s<l> \<and> (i,l,s) \<in> models}"

  assumes  h_postinv[simp]:     "fun_postassn_table h = {(N,s,v). s<l> < 1}"


lemma (in ReynoldsRev) "i \<noteq> j \<and> i \<noteq> k \<and> j \<noteq> k \<and> j \<noteq> i \<and> k \<noteq> i \<and> k \<noteq> j \<longrightarrow>
         \<Turnstile> {(N,s). 0 < s<l> \<and> (i,l,s) \<in> models} (CALL h) {(N,s,v). s<l> < 1}"
apply(insert vardistinct)
apply(clarify)
apply(hoare_rec)
apply(simp)
apply(hoare_simp)
apply(simp add: hBody_def)
apply(hoare_step, simp?)+
apply(erule models.elims, clarsimp)
apply(erule modelsLoc.elims, clarify, simp_all)
defer 1
apply(hoare_step, simp?)+
prefer 3
apply(auto)
apply(erule modelsLoc.elims, clarify, simp_all)
apply(case_tac "la = lb")
apply(auto)
apply(rule_tac x="LST" in exI, rule_tac x="iflda" in exI,simp)
apply(auto)
apply(rule_tac x="rflda" in exI)
prefer 3
apply(case_tac "la = ll")
apply(auto)
apply(rule_tac x="LST" in exI, rule_tac x="iflda" in exI,simp)
apply(auto)
apply(rule_tac x="rflda" in exI)
prefer 3
apply(fastsimp)
apply(simp add: hBody_def)

apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_simp)
defer 1
apply(simp add:hBody_def)
apply(hoare_step, simp?)
defer 1
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
apply(hoare_step, simp?)
defer 1
oops
apply(hoare_step, simp?)
apply(hoare_step, simp?)
done
locale NipkowCall =
(*method C.CALL(n) = let fun f() = let n = self.content
                                       n = n - 1
                                       self.content = n
                                       m =  
                              p = NEW C
                          in if n < 1 then 0 else InvokeStatic C.countdown(n) end
 *)
  fixes    one :: iname
    and	   n :: iname
    and	   b :: iname
    and    p :: rname
    and    C :: cname
    and    content :: ifldname
    and	   count    :: mname
    and	   countbdy :: expr
  defines  "countbdy == LET one = expr.Int 1;
                              n = GetFi param content;
			      n = Primop (% x y. x-y) n one;
			      b = Primop (% x y. if x < 1 then 1 else 0) n n ;
                              n = PutFi param content n
		        IN 
			      IF b THEN expr.Int 42 ELSE expr.Int 55 END" (*([class C]\<bullet>count(param))
  			END"*)
  assumes  countlookup[simp]: "snd ((meths (classtable C)) count) = countbdy"
      and  wfmeasure [simp]:  "meth_wfmeasure_table count = inv_image less_than (\<lambda> s. nat (get_IFLDcontent s param content))"
      and  vardistinct:       "distinct [one,n,b] \<and> distinct [b,n,one]"
      and  preAss[simp]:    "meth_preassn_table NipkowCall = 
                               {(N,s). (N = get_IFLDcontent s self content)}"
      and  postAss[simp]:   "meth_postassn_table countfn = {(N,s). (N = get_IFLDcontent s self content)}"

declare (in countInvoke) countbdy_def [simp]
declare get_IFLDcontent_def [simp]

apply(case_tac "s'\<lfloor>param\<rfloor>")
oops
apply(auto)
apply(simp add: get_rvar)
apply hoare_step
apply hoare_rec
defer 1
apply fastsimp
apply fastsimp
apply hoare_simp
apply (simp add: inv_image_def)		     (* termination *)
apply (erule thin_rl, insert wfmeasure, simp)
apply (rule wf_inv_image, rule wf_less_than) (* WF measure *)
done



end
