(* Based on ToyHL.thy *)

theory HLBase = ToyGrailDef:

types
'a preassn = "'a \<Rightarrow> state \<Rightarrow> bool"
'a postassn = "'a \<Rightarrow> val \<Rightarrow> state  \<Rightarrow> bool"

types
  'a etriple  = "'a preassn \<times> expr \<times> 'a postassn"

(*Hoare triples for expressions and letexpressions, and their
  semantic validity (partial correctness)
datatype 'a Etriple = etriple "'a preAssAV" "expr" "'a postAssAV"
*)

constdefs 
  hoare_valid :: "'a preassn \<Rightarrow> expr \<Rightarrow> 'a postassn \<Rightarrow> bool" ("\<Turnstile> {(1_)}/ (_)/ {(1_)}" 50)
  "\<Turnstile> {P}e{Q} \<equiv> (\<forall> s t v. (\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (\<forall> z. (P z s \<longrightarrow> Q z v t))))"

(* Predicates on time and other resources *)

(* exact time *)
constdefs time :: "nat \<Rightarrow> state \<Rightarrow> bool"
"time i s == clock s = i"

lemma clock_tickn[simp]: "\<forall> s . \<forall> n . clock (tickn n s) = n + (clock s)"
by (unfold tickn_def, simp)

(* Cool Lemmas from main branch *)
lemma tickn_tickn [simp] : "tickn i (tickn j s) = tickn (i+j) s"
apply(simp add: tickn_def)
done

lemma store_store_simp [simp]: "(s \<lparr> store := v \<rparr> \<lparr> store := w \<rparr>)  =  (s \<lparr> store:= w \<rparr>)"
apply (auto)
done

(* bounded time *)
constdefs btime :: "nat \<Rightarrow> state \<Rightarrow> bool"
"btime i s == clock s <= i"

lemma btime_tickn1: "\<forall> s m t. m<t \<and> btime (t-m) s --> btime t (tickn m s)"
apply (rule allI)+
apply (rule impI)
apply (unfold btime_def tickn_def)
apply (auto split: nat_diff_split_asm)
done

lemma btime_tickn2: "\<forall> s m t. m<t \<and> btime t (tickn m s) --> btime (t-m) s"
apply (rule allI)+
apply (rule impI)
apply (unfold btime_def tickn_def)
apply (auto split: nat_diff_split)
done

(* Here is today's structure of the state:
record state =
	heap       :: heap		 
	store      :: store	         -- {* store on top of stack *}
        framestack :: "frame list"       -- {* frame stack *}
        maxstack   :: nat		 -- {* maximum depth of stack *}  
	clock	   :: nat		 -- {* instruction counter *}
*)

(* Lemmas *)

lemma getvar_same [simp] : "get_var (varupdate s v val) v = Some val"
apply(simp add: get_var_def varupdate_def)
done

lemma heap_tick_invar: "\<forall> s . \<forall> n . heap (tickn n s) = heap s"
by (unfold tickn_def, simp)

lemma store_tick_invar: "\<forall> s . \<forall> n . store (tickn n s) = store s"
by (unfold tickn_def, simp)

lemma framestack_tick_invar: "\<forall> s . \<forall> n . framestack (tickn n s) = framestack s"
by (unfold tickn_def, simp)

lemma maxstack_tick_invar: "\<forall> s . \<forall> n . maxstack (tickn n s) = maxstack s"
by (unfold tickn_def, simp)

lemma updateStoreTwice[simp]: "s\<lparr>store := v\<rparr>\<lparr>store := w\<rparr> = s\<lparr>store := w\<rparr>"
apply(auto)
done

lemma updateClockTwice[simp]: "s\<lparr>clock := v\<rparr>\<lparr>clock := w\<rparr> = s\<lparr>clock := w\<rparr>"
apply(auto)
done

lemma updateMaxstackTwice[simp]: "s\<lparr>maxstack := v\<rparr>\<lparr>maxstack := w\<rparr> = s\<lparr>maxstack := w\<rparr>"
apply(auto)
done

lemma updateFramestackTwice[simp]: "s\<lparr>framestack := v\<rparr>\<lparr>framestack := w\<rparr> = s\<lparr>framestack := w\<rparr>"
apply(auto)
done

lemma updateHeapTwice[simp]: "s\<lparr>heap := v\<rparr>\<lparr>heap := w\<rparr> = s\<lparr>heap := w\<rparr>"
apply(auto)
done

(* currstack has disappeared again @%#%#%@%#
lemma currstack_tick_invar: "\<forall> s . \<forall> n . framestack (tickn n s) = framestack s"
by (unfold tickn_def, simp)
*)

lemma clock_tickn: "\<forall> s . \<forall> n . clock (tickn n s) = n + (clock s)"
by (unfold tickn_def, simp)

(* emptyState has disappeared again @%#%#%@%#
lemma emptyState_clock: "clock emptyState = 0"
by (unfold emptyState_def, simp)
*)

lemma clock1: "\<forall> (s::state). \<forall> (h::heap). \<forall> (st::store). \<forall> (fs::(frame list)). \<forall> (ms::nat). 
               clock s = clock (s \<lparr> heap := h, store := st, framestack := fs, maxstack := ms \<rparr>)"
apply (rule allI)+
apply (simp)
done
 

end