theory ExPing = HLBase: (* includes ToyGrailDef: *)

(* added RETURN case again 
translations
  "RETURN x"  == "ToyGrailDef_X.expr.Var x"
*)

(* --------------------------------------------------------------------------- *)
(* Code                                                                        *)
(* --------------------------------------------------------------------------- *)

(*
  class PingClass = field Pong pong  
               field int count
               method ping () { count := count -1; 
                                if count > 0  PingClass.ping() else return ()
*)

consts 
 z1 :: "vname"
 z2 :: "vname"
 q1 :: "vname"
 m :: "vname"
 n :: "vname"
 p :: "vname"
 zero :: "vname"
 x1 :: "vname"
 dummyarg :: "vname"
 stat1 :: "vname" (* reference to a statically allocated object *)

constdefs PETAQvname :: "bool"
"PETAQvname == dummyvar ~= param & dummyvar ~= self & dummyvar ~= stat1 & dummyvar ~= dummyarg & dummyvar ~= x1 & dummyvar ~= zero & dummyvar ~= p & dummyvar ~= n & dummyvar ~= m & dummyvar ~= q1 & dummyvar ~= z2 & dummyvar ~= z1 & param ~= dummyvar & param ~= self & param ~= stat1 & param ~= dummyarg & param ~= x1 & param ~= zero & param ~= p & param ~= n & param ~= m & param ~= q1 & param ~= z2 & param ~= z1 & self ~= dummyvar & self ~= param & self ~= stat1 & self ~= dummyarg & self ~= x1 & self ~= zero & self ~= p & self ~= n & self ~= m & self ~= q1 & self ~= z2 & self ~= z1 & stat1 ~= dummyvar & stat1 ~= param & stat1 ~= self & stat1 ~= dummyarg & stat1 ~= x1 & stat1 ~= zero & stat1 ~= p & stat1 ~= n & stat1 ~= m & stat1 ~= q1 & stat1 ~= z2 & stat1 ~= z1 & dummyarg ~= dummyvar & dummyarg ~= param & dummyarg ~= self & dummyarg ~= stat1 & dummyarg ~= x1 & dummyarg ~= zero & dummyarg ~= p & dummyarg ~= n & dummyarg ~= m & dummyarg ~= q1 & dummyarg ~= z2 & dummyarg ~= z1 & x1 ~= dummyvar & x1 ~= param & x1 ~= self & x1 ~= stat1 & x1 ~= dummyarg & x1 ~= zero & x1 ~= p & x1 ~= n & x1 ~= m & x1 ~= q1 & x1 ~= z2 & x1 ~= z1 & zero ~= dummyvar & zero ~= param & zero ~= self & zero ~= stat1 & zero ~= dummyarg & zero ~= x1 & zero ~= p & zero ~= n & zero ~= m & zero ~= q1 & zero ~= z2 & zero ~= z1 & p ~= dummyvar & p ~= param & p ~= self & p ~= stat1 & p ~= dummyarg & p ~= x1 & p ~= zero & p ~= n & p ~= m & p ~= q1 & p ~= z2 & p ~= z1 & n ~= dummyvar & n ~= param & n ~= self & n ~= stat1 & n ~= dummyarg & n ~= x1 & n ~= zero & n ~= p & n ~= m & n ~= q1 & n ~= z2 & n ~= z1 & m ~= dummyvar & m ~= param & m ~= self & m ~= stat1 & m ~= dummyarg & m ~= x1 & m ~= zero & m ~= p & m ~= n & m ~= q1 & m ~= z2 & m ~= z1 & q1 ~= dummyvar & q1 ~= param & q1 ~= self & q1 ~= stat1 & q1 ~= dummyarg & q1 ~= x1 & q1 ~= zero & q1 ~= p & q1 ~= n & q1 ~= m & q1 ~= z2 & q1 ~= z1 & z2 ~= dummyvar & z2 ~= param & z2 ~= self & z2 ~= stat1 & z2 ~= dummyarg & z2 ~= x1 & z2 ~= zero & z2 ~= p & z2 ~= n & z2 ~= m & z2 ~= q1 & z2 ~= z1 & z1 ~= dummyvar & z1 ~= param & z1 ~= self & z1 ~= stat1 & z1 ~= dummyarg & z1 ~= x1 & z1 ~= zero & z1 ~= p & z1 ~= n & z1 ~= m & z1 ~= q1 & z1 ~= z2"

consts
 count :: "fldname"
 pong :: "fldname"

constdefs PETAQfldname :: "bool"
"PETAQfldname == pong ~= count & count ~= pong"

constdefs PETAQ :: "bool"
"PETAQ == PETAQvname & PETAQfldname"

(*
translations
  "PETAQfld___" <=  "pong ~= count & count,\<dots>"
*)

consts
 ping :: "mname"

consts
 PingClass :: "cname"

consts 
  l1 :: "locn"



(* no mutual recursion for now *)
(*                p = GetF self pong ; *)
constdefs pingBody3 :: "expr"
"pingBody3 \<equiv> LET 
                z2 = Invoke self ping dummyarg
             IN
                Var z2
             END"

(* needs self to be initialised, pointing to an object of PingClass! *)
constdefs mainBody :: "expr"
"mainBody \<equiv> LET 
               x1 = Invoke self ping dummyarg 
             IN 
               Var x1 
             END"

(*in the second and third primops, m is only used as a dummy*)
constdefs pingBody :: expr
"pingBody \<equiv>  LET 
                m  = GetF self count ;
                n  = Primop (\<lambda> x y . x - 1) m m ;
                z1 = PutF self count n ; 
                zero = expr.Int 0 ;
                q1 = Primop (\<lambda> x y . if y<x then (1::int) else (0::int)) n zero
              IN
                IF q1 
                  THEN mainBody
                  ELSE Var z1
              END"

(* --------------------------------------------------------------------------- *)
(* State (hand crafted)                                                        *)
(* --------------------------------------------------------------------------- *)

constdefs pingMbody :: "methbody"
"pingMbody \<equiv> ({m,n,z1,z2,zero,q1,p}, pingBody)"

constdefs bonzo :: "mname \<leadsto> methbody"
"bonzo \<equiv> empty ( ping \<mapsto> pingMbody )"

(* 
constdefs my_fldmap :: "fldname \<leadsto> val"
"my_fldmap \<equiv> empty (count \<mapsto> (val.Int (int N))) (pong \<mapsto> (val.Ref 2))"

constdefs my_heap :: "heap"
"my_heap \<equiv> empty ( l1 \<mapsto> (PingClass,  my_fldmap) )"
*)

constdefs CONTEXT :: "bool"
"CONTEXT \<equiv> classtable PingClass = \<lparr> flds = [count, pong], meths = bonzo \<rparr>"

(* --------------------------------------------------------------------------- *)

constdefs factorPing :: "nat"
"factorPing \<equiv> 5"

constdefs constPing :: "nat"
"constPing \<equiv> 3"

(* Constructing the hoare triple - value N is a "global" input" 
constdefs TRIPLE_PING ::"nat \<Rightarrow> nat \<Rightarrow> (val list) ltriple"
"TRIPLE_PING N T \<equiv> (ping_preassn, mainBody, ping_postassn)"
*)


lemma stupid1: "\<forall> s. \<forall> x. \<forall> rtv . \<exists> s2. (varupdate s x rtv = s1) --> \<langle>s1, Var x\<rangle> \<longrightarrow>e \<langle>rtv, s2\<rangle>"
apply (rule allI)+
apply (rule exI)+
apply (rule impI)
apply (unfold varupdate_def)
apply (auto)
apply (rule evalVar)
apply (unfold get_var_def)
apply (simp)
done
(* OK *)

(*Semantic validity of the triple -- independent from any input! Proof is by
  induction on the external parameter N"*)
(* this fails because of too small constPing; skipped for now
lemma Triple_Ping_valid: "\<forall> i. CONTEXT \<longrightarrow> 
   hoare_lvalid  
       (\<lambda> z s. time T s \<and> (heap s l1) = Some o2 \<and> fst o2 = PingClass \<and> snd o2 count = Some (val.Int (int N)) \<and> snd o2 pong = Some (val.Void) \<and> store s = my_store)
       mainBody 
       (\<lambda> z v s. btime (T + constPing + factorPing * N) s)"
apply(unfold  mainBody_def hoare_lvalid_def)
(* induction on the "input" to the whole thing: the value in the count field *)
apply (induct_tac N)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (simp add: stupid1)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (unfold btime_def constPing_def)
apply (simp add: stupid1)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (simp add: stupid1 clock_tickn)
apply (unfold varupdate_def)
apply (auto)
apply (unfold newframe_def get_var_def varupdate_def)
apply (simp)
apply (erule evalexpr_evallet.elims)
apply (simp add: stupid1 clock_tickn store_tick_invar heap_tick_invar maxstack_tick_invar clock1)
apply (unfold time_def)
apply (auto)
(* False *)
(* fails because the cost of the base case isn't high enough *)
oops
*)

(* --------------------------------------------------------------------------- *)

constdefs factorPing1 :: "nat"
"factorPing1 \<equiv> 5"

constdefs constPing1 :: "nat"
"constPing1 \<equiv> 99"

consts 
  T :: "nat"
  petaQ :: "nat"
  o2 :: "obj"

constdefs my_store :: "store"
"my_store \<equiv> empty (stat1 \<mapsto> (val.Ref l1)) (dummyarg \<mapsto> val.Void) (self \<mapsto> val.Ref l1)"

(*
constdefs my_store :: "store"
"my_store \<equiv> empty (stat1 \<mapsto> (val.Ref l1)) (dummyarg \<mapsto> val.Void) (self \<mapsto> val.Ref l1) (param \<mapsto> val.Void) (m \<mapsto> val.Int (int (Suc petaQ))) (n \<mapsto> val.Int (int petaQ)) (z1 \<mapsto> val.Void) (zero \<mapsto> val.Int 0)"
*)

constdefs prea1 :: "nat \<Rightarrow> 'a preassn"
"prea1 \<equiv> \<lambda> petaQ z s. 
          time T s \<and> 0 < petaQ \<and> 
          heap s l1 = Some (PingClass, empty (count \<mapsto> val.Int (int petaQ)) (pong \<mapsto> val.Void)) \<and> 
          classtable PingClass = \<lparr> flds = [count, pong], meths = bonzo \<rparr> \<and> 
          store s = my_store"

constdefs posta1 :: "nat \<Rightarrow> 'a postassn"
"posta1 \<equiv> \<lambda> petaQ z v s. btime (T + constPing1 + factorPing1 * petaQ) s"

lemma Triple_Ping_valid: "\<forall> N::nat. CONTEXT \<and> PETAQ \<and> PETAQvname \<and> PETAQfldname \<longrightarrow>
   hoare_valid  
       (prea1 N)
       mainBody 
       (posta1 N)"
apply (unfold  prea1_def posta1_def mainBody_def hoare_valid_def)
apply (rule allI)+
apply (unfold my_store_def)
(* induction on the "input" to the whole thing: the value in the count field *)
apply (induct_tac N)
(* ++ base case *)
apply (auto)
(* LET x1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
(*   RETURN x1 *)
apply (unfold varupdate_def)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold newframe_def)
apply (simp_all add: state_functions)
apply (erule evalexpr.elims)
apply (auto)
(* .. simplify the time expression now *) 
apply (simp add: btime_def clock_tickn)
apply (simp only: varupdate_def get_var_def)
(* .. grab mbody out of state *)
apply (simp add: bonzo_def pingMbody_def pingBody_def)
apply (unfold PETAQvname_def)
apply (simp_all add: state_functions)
apply (fold PETAQvname_def)
(* LET m = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp only: varupdate_def get_var_def)
(* LET n = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp only: varupdate_def get_var_def)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold PETAQvname_def, simp_all add: varupdate_def get_var_def clock_tickn, fold PETAQvname_def)
(* LET z1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold PETAQfldname_def,simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp,fold PETAQfldname_def)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
(* LET zero = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold PETAQvname_def, simp add: state_functions, fold PETAQvname_def)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
(* LET q1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (erule evalexpr.elims)
apply (auto)
apply (simp add: varupdate_def get_var_def)
(* IF q1 ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp add: varupdate_def get_var_def)
apply (simp only: store_tick_invar)+
apply (unfold PETAQvname_def, simp add: stupid1 clock_tickn, fold PETAQvname_def)
(* apply (simp_all add:  varupdate_def get_var_def stupid1 clock_tickn clock_tickn tickn_tickn store_store_simp)+ *)
apply (erule evalexpr.elims)
apply (auto)
(*    THEN mainBody ;  recursive call *)
apply (fold mainBody_def)
apply (drule_tac x="tickn (Suc 0)
                    (tickn 4
                      (tickn (Suc (Suc 0))
                        (s(| invokecount := Suc (invokecount s),
                             framestack :=
                               (ping, dummyvar,
                                LET m = self^:count; n = Primop (%x y. x - 1) m m;
                                    z1 = self^.count := n; zero = expr.Int 0;
                                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                                IN IF q1 THEN mainBody  ELSE Var z1 END,
                                %u. if u = self then Some (Ref l1)
                                    else if u = dummyarg then Some val.Void
                                         else if u = stat1 then Some (Ref l1)
   else None) #
                               framestack s,
                             store := empty(self|->Ref l1)(param|->val.Void),
                             maxstack :=
                               max (Suc (length (framestack s))) (maxstack s),
                             clock := Suc (Suc (Suc (clock s))),
                             store := empty(self|->Ref l1)(param|->val.Void)(m
                               |->val.Int (1 + int na)),
                             clock := 7 + clock s,
                             store := empty(self|->Ref l1)(param|->val.Void)(m
                               |->val.Int (1 + int na))(n|->val.Int (int na)),
                             heap := heap s(l1
                               |->(PingClass,
                                   (%u. if u = pong then Some val.Void
                                        else if u = count
  then Some (val.Int (1 + int na)) else None)
                                   (count|->val.Int (int na)))),
                             clock := 11 + clock s,
                             store := empty(self|->Ref l1)(param|->val.Void)(m
                               |->val.Int (1 + int na))(n|->val.Int (int na))(z1
                               |->val.Void) |))
                       (| store := empty(self|->Ref l1)(param|->val.Void)(m
                            |->val.Int (1 + int na))(n|->val.Int (int na))(z1
                            |->val.Void)(zero|->val.Int 0) |))
                     (| store := empty(self|->Ref l1)(param|->val.Void)(m
                          |->val.Int (1 + int na))(n|->val.Int (int na))(z1
                          |->val.Void)(zero|->val.Int 0)(q1
                          |->val.Int
                              (if 0 < na then 1
                               else 0)) |))" in spec)
apply (drule_tac x="s1" in spec)
apply (auto)
apply (unfold time_def)
apply (simp_all add: state_functions)
defer 1 (* Goal: False !?  check it!!!! *)
defer 1 (* Goal: 0 < na !? why? *)
defer 1
defer 1
apply (unfold constPing1_def factorPing1_def)
apply (simp_all add: state_functions)
(* -- recursion has been resolved at this point, but
       . time expression can't be proven
       . there are unsatisfiable subgoals left
*)
defer 1
defer 1
(* Var z1 -- reaching the base case *)
apply (erule evalexpr.elims)
apply (auto)
(* -- that subgoal is history *)
oops

(* --------------------------------------------------------------------------- *)
(* note that from the state in the failed attempt above you can read off the
   factorPing we need: 18 *)

constdefs factorPing2 :: "nat"
"factorPing2 \<equiv> 18"

constdefs constPing2 :: "nat"
"constPing2 \<equiv> 99"

(* we have that already
consts 
  T :: "nat"
  petaQ :: "nat"
  o2 :: "obj"
*)

constdefs prea2 :: "nat \<Rightarrow> 'a preassn"
"prea2 \<equiv> \<lambda> petaQ z s. 
          time T s \<and> 0 < petaQ \<and> 
          heap s l1 = Some (PingClass, empty (count \<mapsto> val.Int (int petaQ)) (pong \<mapsto> val.Void)) \<and> 
          classtable PingClass = \<lparr> flds = [count, pong], meths = bonzo \<rparr> \<and> 
          store s = my_store"

constdefs posta2 :: "nat \<Rightarrow> 'a postassn"
"posta2 \<equiv> \<lambda> petaQ z v s. btime (T + constPing2 + factorPing2 * petaQ) s"

lemma Triple_Ping_valid: "\<forall> N::nat. CONTEXT \<and> PETAQ \<and> PETAQvname \<and> PETAQfldname \<longrightarrow>
   hoare_valid  
       (prea2 N)
       mainBody 
       (posta2 N)"
apply (unfold  prea2_def posta2_def mainBody_def hoare_valid_def)
apply (rule allI)+
apply (unfold my_store_def)
(* induction on the "input" to the whole thing: the value in the count field *)
apply (induct_tac N)
(* ++ base case *)
apply (auto)
(* LET x1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
(*   RETURN x1 *)
apply (unfold varupdate_def)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold newframe_def)
apply (simp_all add: state_functions)
apply (erule evalexpr.elims)
apply (auto)
(* .. simplify the time expression now *) 
apply (simp add: btime_def clock_tickn)
apply (simp only: varupdate_def get_var_def)
(* .. grab mbody out of state *)
apply (simp add: bonzo_def pingMbody_def pingBody_def)
apply (unfold PETAQvname_def)
apply (simp_all add: state_functions)
apply (fold PETAQvname_def)
(* LET m = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp only: varupdate_def get_var_def)
(* LET n = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp only: varupdate_def get_var_def)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold PETAQvname_def, simp_all add: varupdate_def get_var_def clock_tickn, fold PETAQvname_def)
(* LET z1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold PETAQfldname_def,simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp,fold PETAQfldname_def)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
(* LET zero = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold PETAQvname_def, simp add: state_functions, fold PETAQvname_def)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
(* LET q1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (erule evalexpr.elims)
apply (auto)
apply (simp add: varupdate_def get_var_def)
(* IF q1 ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp add: varupdate_def get_var_def)
apply (simp only: store_tick_invar)+
apply (unfold PETAQvname_def, simp add: stupid1 clock_tickn, fold PETAQvname_def)
(* apply (simp_all add:  varupdate_def get_var_def stupid1 clock_tickn clock_tickn tickn_tickn store_store_simp)+ *)
apply (erule evalexpr.elims)
apply (auto)
(* -- 2 subgoals, one for each branch of the conditional *)
(* Var z1 -- reaching the base case *)
defer 1 (* do the base case first *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp add: varupdate_def get_var_def)
apply (simp_all add: state_functions)
apply (unfold PETAQvname_def, simp add: stupid1 clock_tickn, fold PETAQvname_def)
apply (simp add: constPing2_def factorPing2_def btime_def time_def state_functions)
(* -- nuked that subgoal *)
(*    THEN mainBody ;  recursive call *)
apply (fold mainBody_def)
apply (rotate_tac 9)
(* now this is the first assertion: (if 0 < na then 1 else 0) = 1 *)
apply (case_tac "0 < na")
apply (simp_all add: state_functions)
(* bring ind hyp to front (not really necessary but convenient) *)
apply (rotate_tac 3)
apply (drule_tac x="tickn (Suc 0)
                    (tickn 4
                      (tickn (Suc (Suc 0))
                        (s(| invokecount := Suc (invokecount s),
                             framestack :=
                               (ping, dummyvar,
                                LET m = self^:count; n = Primop (%x y. x - 1) m m;
                                    z1 = self^.count := n; zero = expr.Int 0;
                                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                                IN IF q1 THEN mainBody  ELSE Var z1 END,
                                %u. if u = self then Some (Ref l1)
                                    else if u = dummyarg then Some val.Void
                                         else if u = stat1 then Some (Ref l1)
   else None) #
                               framestack s,
                             store := empty(self|->Ref l1)(param|->val.Void),
                             maxstack :=
                               max (Suc (length (framestack s))) (maxstack s),
                             clock := Suc (Suc (Suc (clock s))),
                             store := empty(self|->Ref l1)(param|->val.Void)(m
                               |->val.Int (1 + int na)),
                             clock := 7 + clock s,
                             store := empty(self|->Ref l1)(param|->val.Void)(m
                               |->val.Int (1 + int na))(n|->val.Int (int na)),
                             heap := heap s(l1
                               |->(PingClass,
                                   (%u. if u = pong then Some val.Void
                                        else if u = count
  then Some (val.Int (1 + int na)) else None)
                                   (count|->val.Int (int na)))),
                             clock := 11 + clock s,
                             store := empty(self|->Ref l1)(param|->val.Void)(m
                               |->val.Int (1 + int na))(n|->val.Int (int na))(z1
                               |->val.Void) |))
                       (| store := empty(self|->Ref l1)(param|->val.Void)(m
                            |->val.Int (1 + int na))(n|->val.Int (int na))(z1
                            |->val.Void)(zero|->val.Int 0) |))
                     (| store := empty(self|->Ref l1)(param|->val.Void)(m
                          |->val.Int (1 + int na))(n|->val.Int (int na))(z1
                          |->val.Void)(zero|->val.Int 0)(q1
                          |->val.Int
                              (if 0 < na then 1
                               else 0)) |))" in spec)
apply (rotate_tac -1)
apply (drule_tac x="s1" in spec)
apply (rotate_tac -1)
(* -- assume that the recursive call produces a value *)
apply (subgoal_tac "(EX v. \<langle>tickn (Suc 0)
                           (tickn 4
                             (tickn (Suc (Suc 0))
                               (s(| invokecount := Suc (invokecount s),
                                    framestack :=
                                      (ping, dummyvar,
                                       LET m = self^:count;
n = Primop (%x y. x - 1) m m; z1 = self^.count := n; zero = expr.Int 0;
q1 = Primop (%x y. if y < x then 1 else 0) n zero
                                       IN IF q1 THEN mainBody  ELSE Var z1 END,
                                       %u. if u = self then Some (Ref l1)
else if u = dummyarg then Some val.Void
     else if u = stat1 then Some (Ref l1) else None) #
                                      framestack s,
                                    store := empty(self|->Ref l1)(param|->val.Void),
                                    maxstack :=
                                      max (Suc (length (framestack s))) (maxstack s),
                                    clock := Suc (Suc (Suc (clock s))),
                                    store := empty(self|->Ref l1)(param|->val.Void)(m
                                      |->val.Int (1 + int na)),
                                    clock := 7 + clock s,
                                    store := empty(self|->Ref l1)(param|->val.Void)(m
                                      |->val.Int (1 + int na))(n|->val.Int (int na)),
                                    heap := heap s(l1
                                      |->(PingClass,
                                          (%u.
   if u = pong then Some val.Void
   else if u = count then Some (val.Int (1 + int na)) else None)
                                          (count|->val.Int (int na)))),
                                    clock := 11 + clock s,
                                    store := empty(self|->Ref l1)(param|->val.Void)(m
                                      |->val.Int (1 + int na))(n|->val.Int (int na))
                                      (z1|->val.Void) |))
                              (| store := empty(self|->Ref l1)(param|->val.Void)(m
                                   |->val.Int (1 + int na))(n|->val.Int (int na))(z1
                                   |->val.Void)(zero|->val.Int 0) |))
                            (| store := empty(self|->Ref l1)(param|->val.Void)(m
                                 |->val.Int (1 + int na))(n|->val.Int (int na))(z1
                                 |->val.Void)(zero|->val.Int 0)(q1
                                 |->val.Int
                                     (if 0 < na then 1
                                      else 0)) |)),mainBody\<rangle> \<longrightarrow>e \<langle>v,s1\<rangle>)")
apply (simp add: state_functions)
apply (erule impE)
prefer 2 (* this is the subgoal talking about time *)
apply (erule exE) (* pick the result value we assume exists *)
(* -- now simplifify the time expression, proven the time bound *)
apply (simp add: btime_def time_def constPing2_def factorPing2_def state_functions)
(* -- hurray, the time bound has been proven; BUT 2 subgoals remain to be shown *)
(* -- 1. subgoal makes statement about initial time T being same as time after
         one iteration; obviously wrong ---> fix pre-condition!!!! *)
apply (simp add: btime_def time_def constPing2_def factorPing2_def state_functions)
(* -- surprise, surprise, it reduces to False *)
defer 1 (* don't worry, be happy *)
(* -- 2. subgoal states that the recursive call produces a value
         should be ok to assume that, talking about partial correctness *)
(*
apply (erule impE)
apply (rotate_tac -2)
*)
(* -- pick the result value we know that exists *)
apply (rule_tac x="rtv" in exI)
apply (simp_all add: btime_def time_def state_functions)
(* hurray, we managed to prove this one, too *)

(* Summary about what happened here: *)
(* -- recursion has been resolved at this point, and time expression has been proven!
      BUT: we need a statement that the recurisve call produces a value
*)

(*
apply (erule impE)
(* -- with the bounds of constPing2 and factorPing2 this subgoal can be proven! *)
apply (simp_all add: constPing2_def factorPing2_def state_functions)
(* -- that subgoal is history *)
(* apply (simp add: time_def)  False *)



apply (rotate_tac -1)
apply (drule_tac x="rtv" in spec)
apply (simp_all add: btime_def time_def state_functions)
defer 1 (* what if mainBody doesn't evaluate at all  *)
defer 1 (* Goal: False !?  check it!!!! *)
defer 1
defer 1

(* -- 3 subgoals remaining; all of them have a NOT time_expr in assumptions 
      where do they pop up!? *)
*)

oops

(* --------------------------------------------------------------------------- *)
(* crap from here on \<dots>

apply (unfold mainBody_def)
apply (subgoal_tac "0 < na")
apply (simp_all add:  varupdate_def get_var_def stupid1 clock_tickn clock_tickn tickn_tickn store_store_simp)+
(* maybe this could be shortened using obscene_tac *)
(* specialise the pre- and post-states of the ind hyp to match the current states *)
apply (drule_tac x="tickn (Suc 0)
                    (tickn 4
                      (tickn (Suc (Suc 0))
                        (tickn 4
                          (tickn 4
                            (tickn (Suc (Suc (Suc 0)))
                              (s(| framestack :=
                                     (ping, dummyvar,
                                      LET m = GetF self count;
                                          n = Primop (%x y. x - 1) m m;
                                          z1 = PutF self count n; zero = expr.Int 0;
                                          q1 =
 Primop (%x y. if y < x then 1 else 0) n zero
                                      IN IF q1
                                          THEN LET x1 = Invoke self ping dummyarg
    IN RETURN x1 END 
                                          ELSE RETURN z1 END,
                                      my_store) #
                                     framestack s,
                                   store := empty(self|->Ref l1)(param|->arg),
                                   maxstack :=
                                     max (Suc (length (framestack s)))
                                      (maxstack s) |))
                             (| store :=
                                  store
                                   (tickn (Suc (Suc (Suc 0)))
                                     (s(| framestack :=
 (ping, dummyvar,
  LET m = GetF self count; n = Primop (%x y. x - 1) m m; z1 = PutF self count n;
      zero = expr.Int 0; q1 = Primop (%x y. if y < x then 1 else 0) n zero
  IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
      ELSE RETURN z1 END,
  my_store) #
 framestack s,
                                          store := empty(self|->Ref l1)(param|->arg),
                                          maxstack :=
 max (Suc (length (framestack s))) (maxstack s) |)))
                                  (m|->val.Int (1 + int na)) |))
                           (| store :=
                                store
                                 (tickn 4
                                   (tickn (Suc (Suc (Suc 0)))
                                     (s(| framestack :=
 (ping, dummyvar,
  LET m = GetF self count; n = Primop (%x y. x - 1) m m; z1 = PutF self count n;
      zero = expr.Int 0; q1 = Primop (%x y. if y < x then 1 else 0) n zero
  IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
      ELSE RETURN z1 END,
  my_store) #
 framestack s,
                                          store := empty(self|->Ref l1)(param|->arg),
                                          maxstack :=
 max (Suc (length (framestack s))) (maxstack s) |))
                                    (| store :=
                                         store
                                          (tickn (Suc (Suc (Suc 0)))
 (s(| framestack :=
        (ping, dummyvar,
         LET m = GetF self count; n = Primop (%x y. x - 1) m m;
             z1 = PutF self count n; zero = expr.Int 0;
             q1 = Primop (%x y. if y < x then 1 else 0) n zero
         IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
             ELSE RETURN z1 END,
         my_store) #
        framestack s,
      store := empty(self|->Ref l1)(param|->arg),
      maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
                                         (m|->val.Int (1 + int na)) |)))
                                (n|->val.Int (int na)),
                              heap :=
                                heap (tickn 4
                                       (tickn (Suc (Suc (Suc 0)))
                                         (s(| framestack :=
     (ping, dummyvar,
      LET m = GetF self count; n = Primop (%x y. x - 1) m m; z1 = PutF self count n;
          zero = expr.Int 0; q1 = Primop (%x y. if y < x then 1 else 0) n zero
      IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
          ELSE RETURN z1 END,
      my_store) #
     framestack s,
   store := empty(self|->Ref l1)(param|->arg),
   maxstack := max (Suc (length (framestack s))) (maxstack s) |))
                                        (| store :=
  store
   (tickn (Suc (Suc (Suc 0)))
     (s(| framestack :=
            (ping, dummyvar,
             LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                 z1 = PutF self count n; zero = expr.Int 0;
                 q1 = Primop (%x y. if y < x then 1 else 0) n zero
             IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                 ELSE RETURN z1 END,
             my_store) #
            framestack s,
          store := empty(self|->Ref l1)(param|->arg),
          maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
  (m|->val.Int (1 + int na)) |)))
                                (a|->(aa, b(count|->val.Int (int na)))) |))
                         (| store :=
                              store
                               (tickn 4
                                 (tickn 4
                                   (tickn (Suc (Suc (Suc 0)))
                                     (s(| framestack :=
 (ping, dummyvar,
  LET m = GetF self count; n = Primop (%x y. x - 1) m m; z1 = PutF self count n;
      zero = expr.Int 0; q1 = Primop (%x y. if y < x then 1 else 0) n zero
  IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
      ELSE RETURN z1 END,
  my_store) #
 framestack s,
                                          store := empty(self|->Ref l1)(param|->arg),
                                          maxstack :=
 max (Suc (length (framestack s))) (maxstack s) |))
                                    (| store :=
                                         store
                                          (tickn (Suc (Suc (Suc 0)))
 (s(| framestack :=
        (ping, dummyvar,
         LET m = GetF self count; n = Primop (%x y. x - 1) m m;
             z1 = PutF self count n; zero = expr.Int 0;
             q1 = Primop (%x y. if y < x then 1 else 0) n zero
         IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
             ELSE RETURN z1 END,
         my_store) #
        framestack s,
      store := empty(self|->Ref l1)(param|->arg),
      maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
                                         (m|->val.Int (1 + int na)) |))
                                  (| store :=
                                       store
                                        (tickn 4
                                          (tickn (Suc (Suc (Suc 0)))
 (s(| framestack :=
        (ping, dummyvar,
         LET m = GetF self count; n = Primop (%x y. x - 1) m m;
             z1 = PutF self count n; zero = expr.Int 0;
             q1 = Primop (%x y. if y < x then 1 else 0) n zero
         IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
             ELSE RETURN z1 END,
         my_store) #
        framestack s,
      store := empty(self|->Ref l1)(param|->arg),
      maxstack := max (Suc (length (framestack s))) (maxstack s) |))
(| store :=
     store
      (tickn (Suc (Suc (Suc 0)))
        (s(| framestack :=
               (ping, dummyvar,
                LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                    z1 = PutF self count n; zero = expr.Int 0;
                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                    ELSE RETURN z1 END,
                my_store) #
               framestack s,
             store := empty(self|->Ref l1)(param|->arg),
             maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
     (m|->val.Int (1 + int na)) |)))
                                       (n|->val.Int (int na)),
                                     heap :=
                                       heap (tickn 4
   (tickn (Suc (Suc (Suc 0)))
     (s(| framestack :=
            (ping, dummyvar,
             LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                 z1 = PutF self count n; zero = expr.Int 0;
                 q1 = Primop (%x y. if y < x then 1 else 0) n zero
             IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                 ELSE RETURN z1 END,
             my_store) #
            framestack s,
          store := empty(self|->Ref l1)(param|->arg),
          maxstack := max (Suc (length (framestack s))) (maxstack s) |))
    (| store :=
         store
          (tickn (Suc (Suc (Suc 0)))
            (s(| framestack :=
                   (ping, dummyvar,
                    LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                        z1 = PutF self count n; zero = expr.Int 0;
                        q1 = Primop (%x y. if y < x then 1 else 0) n zero
                    IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                        ELSE RETURN z1 END,
                    my_store) #
                   framestack s,
                 store := empty(self|->Ref l1)(param|->arg),
                 maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
         (m|->val.Int (1 + int na)) |)))
                                       (a|->(aa, b(count|->val.Int (int na)))) |)))
                              (z1|->val.Void) |))
                       (| store :=
                            store
                             (tickn (Suc (Suc 0))
                               (tickn 4
                                 (tickn 4
                                   (tickn (Suc (Suc (Suc 0)))
                                     (s(| framestack :=
 (ping, dummyvar,
  LET m = GetF self count; n = Primop (%x y. x - 1) m m; z1 = PutF self count n;
      zero = expr.Int 0; q1 = Primop (%x y. if y < x then 1 else 0) n zero
  IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
      ELSE RETURN z1 END,
  my_store) #
 framestack s,
                                          store := empty(self|->Ref l1)(param|->arg),
                                          maxstack :=
 max (Suc (length (framestack s))) (maxstack s) |))
                                    (| store :=
                                         store
                                          (tickn (Suc (Suc (Suc 0)))
 (s(| framestack :=
        (ping, dummyvar,
         LET m = GetF self count; n = Primop (%x y. x - 1) m m;
             z1 = PutF self count n; zero = expr.Int 0;
             q1 = Primop (%x y. if y < x then 1 else 0) n zero
         IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
             ELSE RETURN z1 END,
         my_store) #
        framestack s,
      store := empty(self|->Ref l1)(param|->arg),
      maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
                                         (m|->val.Int (1 + int na)) |))
                                  (| store :=
                                       store
                                        (tickn 4
                                          (tickn (Suc (Suc (Suc 0)))
 (s(| framestack :=
        (ping, dummyvar,
         LET m = GetF self count; n = Primop (%x y. x - 1) m m;
             z1 = PutF self count n; zero = expr.Int 0;
             q1 = Primop (%x y. if y < x then 1 else 0) n zero
         IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
             ELSE RETURN z1 END,
         my_store) #
        framestack s,
      store := empty(self|->Ref l1)(param|->arg),
      maxstack := max (Suc (length (framestack s))) (maxstack s) |))
(| store :=
     store
      (tickn (Suc (Suc (Suc 0)))
        (s(| framestack :=
               (ping, dummyvar,
                LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                    z1 = PutF self count n; zero = expr.Int 0;
                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                    ELSE RETURN z1 END,
                my_store) #
               framestack s,
             store := empty(self|->Ref l1)(param|->arg),
             maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
     (m|->val.Int (1 + int na)) |)))
                                       (n|->val.Int (int na)),
                                     heap :=
                                       heap (tickn 4
   (tickn (Suc (Suc (Suc 0)))
     (s(| framestack :=
            (ping, dummyvar,
             LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                 z1 = PutF self count n; zero = expr.Int 0;
                 q1 = Primop (%x y. if y < x then 1 else 0) n zero
             IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                 ELSE RETURN z1 END,
             my_store) #
            framestack s,
          store := empty(self|->Ref l1)(param|->arg),
          maxstack := max (Suc (length (framestack s))) (maxstack s) |))
    (| store :=
         store
          (tickn (Suc (Suc (Suc 0)))
            (s(| framestack :=
                   (ping, dummyvar,
                    LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                        z1 = PutF self count n; zero = expr.Int 0;
                        q1 = Primop (%x y. if y < x then 1 else 0) n zero
                    IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                        ELSE RETURN z1 END,
                    my_store) #
                   framestack s,
                 store := empty(self|->Ref l1)(param|->arg),
                 maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
         (m|->val.Int (1 + int na)) |)))
                                       (a|->(aa, b(count|->val.Int (int na)))) |))
                                (| store :=
                                     store
                                      (tickn 4
                                        (tickn 4
                                          (tickn (Suc (Suc (Suc 0)))
 (s(| framestack :=
        (ping, dummyvar,
         LET m = GetF self count; n = Primop (%x y. x - 1) m m;
             z1 = PutF self count n; zero = expr.Int 0;
             q1 = Primop (%x y. if y < x then 1 else 0) n zero
         IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
             ELSE RETURN z1 END,
         my_store) #
        framestack s,
      store := empty(self|->Ref l1)(param|->arg),
      maxstack := max (Suc (length (framestack s))) (maxstack s) |))
(| store :=
     store
      (tickn (Suc (Suc (Suc 0)))
        (s(| framestack :=
               (ping, dummyvar,
                LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                    z1 = PutF self count n; zero = expr.Int 0;
                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                    ELSE RETURN z1 END,
                my_store) #
               framestack s,
             store := empty(self|->Ref l1)(param|->arg),
             maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
     (m|->val.Int (1 + int na)) |))
                                         (| store :=
   store
    (tickn 4
      (tickn (Suc (Suc (Suc 0)))
        (s(| framestack :=
               (ping, dummyvar,
                LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                    z1 = PutF self count n; zero = expr.Int 0;
                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                    ELSE RETURN z1 END,
                my_store) #
               framestack s,
             store := empty(self|->Ref l1)(param|->arg),
             maxstack := max (Suc (length (framestack s))) (maxstack s) |))
       (| store :=
            store
             (tickn (Suc (Suc (Suc 0)))
               (s(| framestack :=
                      (ping, dummyvar,
                       LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                           z1 = PutF self count n; zero = expr.Int 0;
                           q1 = Primop (%x y. if y < x then 1 else 0) n zero
                       IN IF q1
                           THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                           ELSE RETURN z1 END,
                       my_store) #
                      framestack s,
                    store := empty(self|->Ref l1)(param|->arg),
                    maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
            (m|->val.Int (1 + int na)) |)))
   (n|->val.Int (int na)),
 heap :=
   heap (tickn 4
          (tickn (Suc (Suc (Suc 0)))
            (s(| framestack :=
                   (ping, dummyvar,
                    LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                        z1 = PutF self count n; zero = expr.Int 0;
                        q1 = Primop (%x y. if y < x then 1 else 0) n zero
                    IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                        ELSE RETURN z1 END,
                    my_store) #
                   framestack s,
                 store := empty(self|->Ref l1)(param|->arg),
                 maxstack := max (Suc (length (framestack s))) (maxstack s) |))
           (| store :=
                store
                 (tickn (Suc (Suc (Suc 0)))
                   (s(| framestack :=
                          (ping, dummyvar,
                           LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                               z1 = PutF self count n; zero = expr.Int 0;
                               q1 = Primop (%x y. if y < x then 1 else 0) n zero
                           IN IF q1
                               THEN LET x1 = Invoke self ping dummyarg
                                    IN RETURN x1 END 
                               ELSE RETURN z1 END,
                           my_store) #
                          framestack s,
                        store := empty(self|->Ref l1)(param|->arg),
                        maxstack :=
                          max (Suc (length (framestack s))) (maxstack s) |)))
                (m|->val.Int (1 + int na)) |)))
   (a|->(aa, b(count|->val.Int (int na)))) |)))
                                     (z1|->val.Void) |)))
                            (zero|->val.Int 0) |))
                     (| store :=
                          store
                           (tickn 4
                             (tickn (Suc (Suc 0))
                               (tickn 4
                                 (tickn 4
                                   (tickn (Suc (Suc (Suc 0)))
                                     (s(| framestack :=
 (ping, dummyvar,
  LET m = GetF self count; n = Primop (%x y. x - 1) m m; z1 = PutF self count n;
      zero = expr.Int 0; q1 = Primop (%x y. if y < x then 1 else 0) n zero
  IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
      ELSE RETURN z1 END,
  my_store) #
 framestack s,
                                          store := empty(self|->Ref l1)(param|->arg),
                                          maxstack :=
 max (Suc (length (framestack s))) (maxstack s) |))
                                    (| store :=
                                         store
                                          (tickn (Suc (Suc (Suc 0)))
 (s(| framestack :=
        (ping, dummyvar,
         LET m = GetF self count; n = Primop (%x y. x - 1) m m;
             z1 = PutF self count n; zero = expr.Int 0;
             q1 = Primop (%x y. if y < x then 1 else 0) n zero
         IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
             ELSE RETURN z1 END,
         my_store) #
        framestack s,
      store := empty(self|->Ref l1)(param|->arg),
      maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
                                         (m|->val.Int (1 + int na)) |))
                                  (| store :=
                                       store
                                        (tickn 4
                                          (tickn (Suc (Suc (Suc 0)))
 (s(| framestack :=
        (ping, dummyvar,
         LET m = GetF self count; n = Primop (%x y. x - 1) m m;
             z1 = PutF self count n; zero = expr.Int 0;
             q1 = Primop (%x y. if y < x then 1 else 0) n zero
         IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
             ELSE RETURN z1 END,
         my_store) #
        framestack s,
      store := empty(self|->Ref l1)(param|->arg),
      maxstack := max (Suc (length (framestack s))) (maxstack s) |))
(| store :=
     store
      (tickn (Suc (Suc (Suc 0)))
        (s(| framestack :=
               (ping, dummyvar,
                LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                    z1 = PutF self count n; zero = expr.Int 0;
                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                    ELSE RETURN z1 END,
                my_store) #
               framestack s,
             store := empty(self|->Ref l1)(param|->arg),
             maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
     (m|->val.Int (1 + int na)) |)))
                                       (n|->val.Int (int na)),
                                     heap :=
                                       heap (tickn 4
   (tickn (Suc (Suc (Suc 0)))
     (s(| framestack :=
            (ping, dummyvar,
             LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                 z1 = PutF self count n; zero = expr.Int 0;
                 q1 = Primop (%x y. if y < x then 1 else 0) n zero
             IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                 ELSE RETURN z1 END,
             my_store) #
            framestack s,
          store := empty(self|->Ref l1)(param|->arg),
          maxstack := max (Suc (length (framestack s))) (maxstack s) |))
    (| store :=
         store
          (tickn (Suc (Suc (Suc 0)))
            (s(| framestack :=
                   (ping, dummyvar,
                    LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                        z1 = PutF self count n; zero = expr.Int 0;
                        q1 = Primop (%x y. if y < x then 1 else 0) n zero
                    IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                        ELSE RETURN z1 END,
                    my_store) #
                   framestack s,
                 store := empty(self|->Ref l1)(param|->arg),
                 maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
         (m|->val.Int (1 + int na)) |)))
                                       (a|->(aa, b(count|->val.Int (int na)))) |))
                                (| store :=
                                     store
                                      (tickn 4
                                        (tickn 4
                                          (tickn (Suc (Suc (Suc 0)))
 (s(| framestack :=
        (ping, dummyvar,
         LET m = GetF self count; n = Primop (%x y. x - 1) m m;
             z1 = PutF self count n; zero = expr.Int 0;
             q1 = Primop (%x y. if y < x then 1 else 0) n zero
         IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
             ELSE RETURN z1 END,
         my_store) #
        framestack s,
      store := empty(self|->Ref l1)(param|->arg),
      maxstack := max (Suc (length (framestack s))) (maxstack s) |))
(| store :=
     store
      (tickn (Suc (Suc (Suc 0)))
        (s(| framestack :=
               (ping, dummyvar,
                LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                    z1 = PutF self count n; zero = expr.Int 0;
                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                    ELSE RETURN z1 END,
                my_store) #
               framestack s,
             store := empty(self|->Ref l1)(param|->arg),
             maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
     (m|->val.Int (1 + int na)) |))
                                         (| store :=
   store
    (tickn 4
      (tickn (Suc (Suc (Suc 0)))
        (s(| framestack :=
               (ping, dummyvar,
                LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                    z1 = PutF self count n; zero = expr.Int 0;
                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                    ELSE RETURN z1 END,
                my_store) #
               framestack s,
             store := empty(self|->Ref l1)(param|->arg),
             maxstack := max (Suc (length (framestack s))) (maxstack s) |))
       (| store :=
            store
             (tickn (Suc (Suc (Suc 0)))
               (s(| framestack :=
                      (ping, dummyvar,
                       LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                           z1 = PutF self count n; zero = expr.Int 0;
                           q1 = Primop (%x y. if y < x then 1 else 0) n zero
                       IN IF q1
                           THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                           ELSE RETURN z1 END,
                       my_store) #
                      framestack s,
                    store := empty(self|->Ref l1)(param|->arg),
                    maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
            (m|->val.Int (1 + int na)) |)))
   (n|->val.Int (int na)),
 heap :=
   heap (tickn 4
          (tickn (Suc (Suc (Suc 0)))
            (s(| framestack :=
                   (ping, dummyvar,
                    LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                        z1 = PutF self count n; zero = expr.Int 0;
                        q1 = Primop (%x y. if y < x then 1 else 0) n zero
                    IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                        ELSE RETURN z1 END,
                    my_store) #
                   framestack s,
                 store := empty(self|->Ref l1)(param|->arg),
                 maxstack := max (Suc (length (framestack s))) (maxstack s) |))
           (| store :=
                store
                 (tickn (Suc (Suc (Suc 0)))
                   (s(| framestack :=
                          (ping, dummyvar,
                           LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                               z1 = PutF self count n; zero = expr.Int 0;
                               q1 = Primop (%x y. if y < x then 1 else 0) n zero
                           IN IF q1
                               THEN LET x1 = Invoke self ping dummyarg
                                    IN RETURN x1 END 
                               ELSE RETURN z1 END,
                           my_store) #
                          framestack s,
                        store := empty(self|->Ref l1)(param|->arg),
                        maxstack :=
                          max (Suc (length (framestack s))) (maxstack s) |)))
                (m|->val.Int (1 + int na)) |)))
   (a|->(aa, b(count|->val.Int (int na)))) |)))
                                     (z1|->val.Void) |))
                              (| store :=
                                   store
                                    (tickn (Suc (Suc 0))
                                      (tickn 4
                                        (tickn 4
                                          (tickn (Suc (Suc (Suc 0)))
 (s(| framestack :=
        (ping, dummyvar,
         LET m = GetF self count; n = Primop (%x y. x - 1) m m;
             z1 = PutF self count n; zero = expr.Int 0;
             q1 = Primop (%x y. if y < x then 1 else 0) n zero
         IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
             ELSE RETURN z1 END,
         my_store) #
        framestack s,
      store := empty(self|->Ref l1)(param|->arg),
      maxstack := max (Suc (length (framestack s))) (maxstack s) |))
(| store :=
     store
      (tickn (Suc (Suc (Suc 0)))
        (s(| framestack :=
               (ping, dummyvar,
                LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                    z1 = PutF self count n; zero = expr.Int 0;
                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                    ELSE RETURN z1 END,
                my_store) #
               framestack s,
             store := empty(self|->Ref l1)(param|->arg),
             maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
     (m|->val.Int (1 + int na)) |))
                                         (| store :=
   store
    (tickn 4
      (tickn (Suc (Suc (Suc 0)))
        (s(| framestack :=
               (ping, dummyvar,
                LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                    z1 = PutF self count n; zero = expr.Int 0;
                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                    ELSE RETURN z1 END,
                my_store) #
               framestack s,
             store := empty(self|->Ref l1)(param|->arg),
             maxstack := max (Suc (length (framestack s))) (maxstack s) |))
       (| store :=
            store
             (tickn (Suc (Suc (Suc 0)))
               (s(| framestack :=
                      (ping, dummyvar,
                       LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                           z1 = PutF self count n; zero = expr.Int 0;
                           q1 = Primop (%x y. if y < x then 1 else 0) n zero
                       IN IF q1
                           THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                           ELSE RETURN z1 END,
                       my_store) #
                      framestack s,
                    store := empty(self|->Ref l1)(param|->arg),
                    maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
            (m|->val.Int (1 + int na)) |)))
   (n|->val.Int (int na)),
 heap :=
   heap (tickn 4
          (tickn (Suc (Suc (Suc 0)))
            (s(| framestack :=
                   (ping, dummyvar,
                    LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                        z1 = PutF self count n; zero = expr.Int 0;
                        q1 = Primop (%x y. if y < x then 1 else 0) n zero
                    IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                        ELSE RETURN z1 END,
                    my_store) #
                   framestack s,
                 store := empty(self|->Ref l1)(param|->arg),
                 maxstack := max (Suc (length (framestack s))) (maxstack s) |))
           (| store :=
                store
                 (tickn (Suc (Suc (Suc 0)))
                   (s(| framestack :=
                          (ping, dummyvar,
                           LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                               z1 = PutF self count n; zero = expr.Int 0;
                               q1 = Primop (%x y. if y < x then 1 else 0) n zero
                           IN IF q1
                               THEN LET x1 = Invoke self ping dummyarg
                                    IN RETURN x1 END 
                               ELSE RETURN z1 END,
                           my_store) #
                          framestack s,
                        store := empty(self|->Ref l1)(param|->arg),
                        maxstack :=
                          max (Suc (length (framestack s))) (maxstack s) |)))
                (m|->val.Int (1 + int na)) |)))
   (a|->(aa, b(count|->val.Int (int na)))) |))
                                       (| store :=
 store
  (tickn 4
    (tickn 4
      (tickn (Suc (Suc (Suc 0)))
        (s(| framestack :=
               (ping, dummyvar,
                LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                    z1 = PutF self count n; zero = expr.Int 0;
                    q1 = Primop (%x y. if y < x then 1 else 0) n zero
                IN IF q1 THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                    ELSE RETURN z1 END,
                my_store) #
               framestack s,
             store := empty(self|->Ref l1)(param|->arg),
             maxstack := max (Suc (length (framestack s))) (maxstack s) |))
       (| store :=
            store
             (tickn (Suc (Suc (Suc 0)))
               (s(| framestack :=
                      (ping, dummyvar,
                       LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                           z1 = PutF self count n; zero = expr.Int 0;
                           q1 = Primop (%x y. if y < x then 1 else 0) n zero
                       IN IF q1
                           THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                           ELSE RETURN z1 END,
                       my_store) #
                      framestack s,
                    store := empty(self|->Ref l1)(param|->arg),
                    maxstack := max (Suc (length (framestack s))) (maxstack s) |)))
            (m|->val.Int (1 + int na)) |))
     (| store :=
          store
           (tickn 4
             (tickn (Suc (Suc (Suc 0)))
               (s(| framestack :=
                      (ping, dummyvar,
                       LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                           z1 = PutF self count n; zero = expr.Int 0;
                           q1 = Primop (%x y. if y < x then 1 else 0) n zero
                       IN IF q1
                           THEN LET x1 = Invoke self ping dummyarg IN RETURN x1 END 
                           ELSE RETURN z1 END,
                       my_store) #
                      framestack s,
                    store := empty(self|->Ref l1)(param|->arg),
                    maxstack := max (Suc (length (framestack s))) (maxstack s) |))
              (| store :=
                   store
                    (tickn (Suc (Suc (Suc 0)))
                      (s(| framestack :=
                             (ping, dummyvar,
                              LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                                  z1 = PutF self count n; zero = expr.Int 0;
                                  q1 = Primop (%x y. if y < x then 1 else 0) n zero
                              IN IF q1
                                  THEN LET x1 = Invoke self ping dummyarg
                                       IN RETURN x1 END 
                                  ELSE RETURN z1 END,
                              my_store) #
                             framestack s,
                           store := empty(self|->Ref l1)(param|->arg),
                           maxstack :=
                             max (Suc (length (framestack s))) (maxstack s) |)))
                   (m|->val.Int (1 + int na)) |)))
          (n|->val.Int (int na)),
        heap :=
          heap (tickn 4
                 (tickn (Suc (Suc (Suc 0)))
                   (s(| framestack :=
                          (ping, dummyvar,
                           LET m = GetF self count; n = Primop (%x y. x - 1) m m;
                               z1 = PutF self count n; zero = expr.Int 0;
                               q1 = Primop (%x y. if y < x then 1 else 0) n zero
                           IN IF q1
                               THEN LET x1 = Invoke self ping dummyarg
                                    IN RETURN x1 END 
                               ELSE RETURN z1 END,
                           my_store) #
                          framestack s,
                        store := empty(self|->Ref l1)(param|->arg),
                        maxstack := max (Suc (length (framestack s))) (maxstack s) |))
                  (| store :=
                       store
                        (tickn (Suc (Suc (Suc 0)))
                          (s(| framestack :=
                                 (ping, dummyvar,
                                  LET m = GetF self count;
                                      n = Primop (%x y. x - 1) m m;
                                      z1 = PutF self count n; zero = expr.Int 0;
                                      q1 = Primop (%x y. if y < x then 1 else 0) n
 zero
                                  IN IF q1
                                      THEN LET x1 = Invoke self ping dummyarg
IN RETURN x1 END 
                                      ELSE RETURN z1 END,
                                  my_store) #
                                 framestack s,
                               store := empty(self|->Ref l1)(param|->arg),
                               maxstack :=
                                 max (Suc (length (framestack s))) (maxstack s) |)))
                       (m|->val.Int (1 + int na)) |)))
          (a|->(aa, b(count|->val.Int (int na)))) |)))
 (z1|->val.Void) |)))
                                   (zero|->val.Int 0) |)))
                          (q1|->val.Int
                                 1) |))" in spec)
apply (drule_tac x="s2a" in spec)
apply (blast) (* that's currently wishful thinking *)




apply (erule evalexpr.elims)
apply (auto)
apply (simp add: varupdate_def get_var_def)
(*       RETURN z2  *)
(* ** finally reached recursion case with: Invoke self ping dummyarg *)
apply (erule evalexpr.elims)
apply (auto)

apply (unfold btime_def constPing_def)
(* eval RETURN *)
apply (erule evalexpr.elims)
apply (simp add: stupid1 clock_tickn)
apply (unfold varupdate_def get_var_def)
apply (simp only: clock_tickn)
apply (auto)
(* now we have to get mbody out of the classtable ... *)
apply (unfold newframe_def time_def constPing1_def bonzo_def pingMbody_def)
apply (simp add: stupid1 clock_tickn store_tick_invar heap_tick_invar maxstack_tick_invar clock1)
apply (auto)
apply (unfold pingBody_def)
(* now the pingBody is unfolded and we can kick off an evaluation *)
(* LET m = ... *)
apply (erule evalexpr.elims)
apply (simp_all)
apply (simp add: clock_tickn clock1)
apply (auto)
(* LET n = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold varupdate_def get_var_def)
apply (simp add: clock_tickn clock1)
apply (subgoal_tac "self ~= param")
apply (simp add: clock_tickn clock1)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold varupdate_def get_var_def)
apply (simp add: clock_tickn clock1)
(* LET z1 = ... *)
apply (erule evalexpr.elims)
apply (unfold varupdate_def get_var_def)
apply (auto)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold varupdate_def get_var_def)
apply (simp add: clock_tickn clock1)
(* LET zero = ... *)
apply (erule evalexpr.elims)
apply (unfold varupdate_def get_var_def)
apply (auto)
apply (simp add: clock_tickn clock1)
apply (erule evalexpr.elims)
apply (auto)
apply (unfold varupdate_def get_var_def)
apply (simp add: clock_tickn clock1)
(* LET q1 = ... *)
apply (erule evalexpr.elims)
apply (unfold varupdate_def get_var_def)
apply (auto)
apply (erule evalexpr.elims)
apply (unfold varupdate_def get_var_def)
apply (auto)
(* IF q1 ... *)
apply (erule evalexpr.elims)
apply (unfold varupdate_def get_var_def)
apply (auto)
apply (simp add: clock_tickn clock1)
apply (case_tac "0 < i1")
apply (simp add: clock_tickn clock1)
apply (erule evalexpr.elims)
apply (auto)

apply (simp_all)

apply (unfold get_var_def)
(* eval LET n= ... *)
apply (erule evalexpr.elims)
apply (auto)
(* eval LET z1 = ... *)
apply (erule evalexpr.elims)
apply (auto)



apply (simp add: clock_tickn clock1)
apply (unfold bonzo_def pingMbody_def pingBody_def)
apply (simp add: stupid1 clock_tickn clock1)
apply (simp add: clock_tickn clock1)
(* batches of evals *)
apply (erule evalexpr.elims)
apply (simp_all)
apply (unfold varupdate_def)
apply (erule evalexpr.elims)
apply (simp_all)
apply (simp add: clock_tickn clock1)
(* --- *)
(* batches of evals *)
apply (erule evalexpr.elims)
apply (simp_all)
apply (unfold varupdate_def)
apply (erule evalexpr.elims)
apply (simp_all)
apply (simp add: clock_tickn clock1)
(* --- *)
(* batches of evals *)
apply (erule evalexpr.elims)
apply (simp_all)
apply (unfold varupdate_def)
apply (erule evalexpr.elims)
apply (simp_all)
apply (simp add: clock_tickn clock1)
(* --- *)
(* batches of evals *)
apply (erule evalexpr.elims)
apply (simp_all)
apply (unfold varupdate_def)
apply (erule evalexpr.elims)
apply (simp_all)
apply (simp add: clock_tickn clock1)
(* --- *)
(* batches of evals *)
apply (erule evalexpr.elims)
apply (simp_all)
apply (unfold varupdate_def)
apply (erule evalexpr.elims)
apply (simp_all)
apply (simp add: clock_tickn clock1)
(* --- *)
apply (erule evalexpr.elims)
apply (simp_all)
(* now we know that we are in the base case of the recursion; wow! *)
apply (simp add: clock_tickn clock1)
apply (simp_all)

apply (erule evalexpr.elims)
apply (simp_all)


apply (simp)



apply (erule evalexpr.elims)
apply (simp_all)
apply (simp add: clock_tickn clock1)
(* --- *)


apply (simp add: stupid1)
apply (simp)
apply (unfold pingMbody_def)
apply (simp)

apply (simp add: stupid1 clock_tickn store_tick_invar heap_tick_invar framestack_tick_invar maxstack_tick_invar currstack_tick_invar)

apply
apply (erule evalexpr.elims)
(* to be continued ... *)

*)