theory ExP = HLBase: (* includes ToyGrailDef *)

(* ping but using variables rather than fields *)
(* --------------------------------------------------------------------------- *)
(* Code                                                                        *)
(* --------------------------------------------------------------------------- *)

(* n is a global variable
  class PingClass = field Pong pong  
               method ping () { if (n>0) 
                                  then { n := n-1;
                                         PingClass.ping() }
                                  else n }
*)

consts 
 x1 :: "vname"
 q1 :: "vname"
 m :: "vname"
 n :: "vname"
 p :: "vname"
 zero :: "vname"
 dummyarg :: "vname"
 stat1 :: "vname" (* reference to a statically allocated object *)

constdefs PETAQvname :: "bool"
"PETAQvname == dummyvar ~= param & dummyvar ~= self & dummyvar ~= stat1 & dummyvar ~= dummyarg & dummyvar ~= zero & dummyvar ~= p & dummyvar ~= n & dummyvar ~= m & dummyvar ~= q1 & dummyvar ~= x1 & param ~= dummyvar & param ~= self & param ~= stat1 & param ~= dummyarg & param ~= zero & param ~= p & param ~= n & param ~= m & param ~= q1 & param ~= x1 & self ~= dummyvar & self ~= param & self ~= stat1 & self ~= dummyarg & self ~= zero & self ~= p & self ~= n & self ~= m & self ~= q1 & self ~= x1 & stat1 ~= dummyvar & stat1 ~= param & stat1 ~= self & stat1 ~= dummyarg & stat1 ~= zero & stat1 ~= p & stat1 ~= n & stat1 ~= m & stat1 ~= q1 & stat1 ~= x1 & dummyarg ~= dummyvar & dummyarg ~= param & dummyarg ~= self & dummyarg ~= stat1 & dummyarg ~= zero & dummyarg ~= p & dummyarg ~= n & dummyarg ~= m & dummyarg ~= q1 & dummyarg ~= x1 & zero ~= dummyvar & zero ~= param & zero ~= self & zero ~= stat1 & zero ~= dummyarg & zero ~= p & zero ~= n & zero ~= m & zero ~= q1 & zero ~= x1 & p ~= dummyvar & p ~= param & p ~= self & p ~= stat1 & p ~= dummyarg & p ~= zero & p ~= n & p ~= m & p ~= q1 & p ~= x1 & n ~= dummyvar & n ~= param & n ~= self & n ~= stat1 & n ~= dummyarg & n ~= zero & n ~= p & n ~= m & n ~= q1 & n ~= x1 & m ~= dummyvar & m ~= param & m ~= self & m ~= stat1 & m ~= dummyarg & m ~= zero & m ~= p & m ~= n & m ~= q1 & m ~= x1 & q1 ~= dummyvar & q1 ~= param & q1 ~= self & q1 ~= stat1 & q1 ~= dummyarg & q1 ~= zero & q1 ~= p & q1 ~= n & q1 ~= m & q1 ~= x1 & x1 ~= dummyvar & x1 ~= param & x1 ~= self & x1 ~= stat1 & x1 ~= dummyarg & x1 ~= zero & x1 ~= p & x1 ~= n & x1 ~= m & x1 ~= q1"

consts
 count :: "fldname"
 pong :: "fldname"

constdefs PETAQfldname :: "bool"
"PETAQfldname == pong ~= count & count ~= pong"

constdefs PETAQ :: "bool"
"PETAQ == PETAQvname & PETAQfldname"

(*
translations
  "PETAQfld___" <=  "pong ~= count & count,\<dots>"
*)

consts
 ping :: "mname"

consts
 PingClass :: "cname"

consts 
  l1 :: "locn"



(* needs self to be initialised, pointing to an object of PingClass! *)
constdefs pingBody2 :: expr
"pingBody2 \<equiv> LET 
               n  = Primop (\<lambda> x y . x - 1) n n ;
               x1 = Invoke self ping dummyarg 
             IN 
               Var x1 
             END"

(*in the second and third primops, m is only used as a dummy*)
constdefs pingBody :: expr
"pingBody \<equiv>  LET 
                q1 = Primop (\<lambda> x y . if y<x then (1::int) else (0::int)) n zero
              IN
                IF q1 
                  THEN pingBody2
                  ELSE Var n
              END"

(* --------------------------------------------------------------------------- *)
(* State (hand crafted)                                                        *)
(* --------------------------------------------------------------------------- *)

constdefs pingMbody :: "methbody"
"pingMbody \<equiv> ({m,n,q1,x1}, pingBody)"

constdefs bonzo :: "mname \<leadsto> methbody"
"bonzo \<equiv> empty ( ping \<mapsto> pingMbody )"

constdefs my_store :: "store"
"my_store \<equiv> empty (stat1 \<mapsto> (val.Ref l1)) (dummyarg \<mapsto> val.Void)"

constdefs CONTEXT :: "bool"
"CONTEXT \<equiv> classtable PingClass = \<lparr> flds = [count, pong], meths = bonzo \<rparr>"

(* --------------------------------------------------------------------------- *)

constdefs factorPing :: "nat"
"factorPing \<equiv> 5"

constdefs constPing :: "nat"
"constPing \<equiv> 3"

(* Constructing the hoare triple - value N is a "global" input" 
constdefs TRIPLE_PING ::"nat \<Rightarrow> nat \<Rightarrow> (val list) ltriple"
"TRIPLE_PING N T \<equiv> (ping_preassn, mainBody, ping_postassn)"
*)


lemma stupid1: "\<forall> s. \<forall> x. \<forall> rtv . \<exists> s2. (varupdate s x rtv = s1) --> \<langle>s1, Var x\<rangle> \<longrightarrow>e \<langle>rtv, s2\<rangle>"
apply (rule allI)+
apply (rule exI)+
apply (rule impI)
apply (unfold varupdate_def)
apply (auto)
apply (rule evalVar)
apply (unfold get_var_def)
apply (simp)
done
(* OK *)

(*Semantic validity of the triple -- independent from any input! Proof is by
  induction on the external parameter N"*)
(* this fails because of too small constPing; skipped for now
lemma Triple_Ping_valid: "\<forall> i. CONTEXT \<longrightarrow> 
   hoare_lvalid  
       (\<lambda> z s. time T s \<and> (heap s l1) = Some o2 \<and> fst o2 = PingClass \<and> snd o2 count = Some (val.Int (int N)) \<and> snd o2 pong = Some (val.Void) \<and> store s = my_store)
       mainBody 
       (\<lambda> z v s. btime (T + constPing + factorPing * N) s)"
apply(unfold  mainBody_def hoare_lvalid_def)
(* induction on the "input" to the whole thing: the value in the count field *)
apply (induct_tac N)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (simp add: stupid1)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (unfold btime_def constPing_def)
apply (simp add: stupid1)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (simp add: stupid1 clock_tickn)
apply (unfold varupdate_def)
apply (auto)
apply (unfold newframe_def get_var_def varupdate_def)
apply (simp)
apply (erule evalexpr_evallet.elims)
apply (simp add: stupid1 clock_tickn store_tick_invar heap_tick_invar maxstack_tick_invar clock1)
apply (unfold time_def)
apply (auto)
(* False *)
(* fails because the cost of the base case isn't high enough *)
oops
*)

(* --------------------------------------------------------------------------- *)

constdefs factorPing1 :: "nat"
"factorPing1 \<equiv> 5"

constdefs constPing1 :: "nat"
"constPing1 \<equiv> 99"

consts 
  T :: "nat"
  petaQ :: "nat"
  o2 :: "obj"

constdefs prea1 :: "nat \<Rightarrow> 'a preassn"
"prea1 \<equiv> \<lambda> petaQ z s. 
          time T s \<and> s<self> = Some (val.Ref l1) \<and> s<zero> = Some (val.Int 0) \<and>  s<n> = Some (val.Int (int petaQ)) \<and>  
          heap s l1 = Some (PingClass, empty (count \<mapsto> val.Int (int petaQ)) (pong \<mapsto> val.Void)) \<and> 
          classtable PingClass = \<lparr> flds = [count, pong], meths = bonzo \<rparr> \<and> 
          store s = my_store"

constdefs posta1 :: "nat \<Rightarrow> 'a postassn"
"posta1 \<equiv> \<lambda> petaQ z v s. btime (T + constPing1 + factorPing1 * petaQ) s"

lemma Triple_Ping_valid: "\<forall> N::nat. CONTEXT \<and> PETAQ \<and> PETAQvname \<and> PETAQfldname \<longrightarrow>
   hoare_valid  
       (prea1 N)
       pingBody 
       (posta1 N)"
apply (unfold  prea1_def posta1_def pingBody_def hoare_valid_def)
apply (rule allI)+
(* induction on the "input" to the whole thing: the value in the count field *)
apply (induct_tac N)
(* ++ base case *)
apply (auto)
(* LET q1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
(* IF q1 ... *)
apply (unfold varupdate_def)
apply (erule evalexpr.elims)
apply (auto)
(* -- q1 is in store *)
apply (erule evalexpr.elims)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
apply (auto)
(* RETURN n *)
apply (erule evalexpr.elims)
apply (auto)
(* .. simplify the time expression now *) 
apply (simp add: btime_def time_def constPing1_def clock_tickn varupdate_def get_var_def)
(* -- done with base case *)
(* ++ recursion case *)
(* LET q1 =  *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
(* IF q1 ... *)
(* -- first simplify q1 *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
(* -- now evaluate the IF *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
(* -- 1 subgoal (we know that we are in the recursion case) *)
apply (unfold pingBody2_def)
(* LET n = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
(* LET x1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
(* RETURN x1 *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
apply (unfold PETAQvname_def, simp_all add: varupdate_def get_var_def clock_tickn, fold PETAQvname_def)
apply (simp_all add: state_functions)
apply (unfold PETAQvname_def, simp_all add: state_functions, fold PETAQvname_def)
apply (erule evalexpr.elims)
apply (auto)
apply (simp only: bonzo_def pingMbody_def pingBody_def)
apply (simp_all add: state_functions)+
(* LET q1 = ... *)
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
apply (erule evalexpr.elims)
apply (auto)
apply (simp_all add: varupdate_def get_var_def tickn_tickn clock_tickn store_store_simp)+
apply (unfold PETAQvname_def)
apply (simp_all add: state_functions)
done
(* done already? I'm suspicious: too good to be true *)

