theory ExHLSwap = ToyHLproc:

(* exact time *)
constdefs time :: "nat \<Rightarrow> state \<Rightarrow> bool"
"time i s == clock s = i"

(* bounded time *)
constdefs btime :: "nat \<Rightarrow> state \<Rightarrow> bool"
"btime i s == clock s <= i"


(* --------------------------------------------------------------------------- *)
(* Code                                                                        *)
(* --------------------------------------------------------------------------- *)

(*
  class SwapClass = field int lesser
                    field int greater
                    method swap () { if lesser > greater then SwapClass.swap() else return ()}
*)
(* The follwoing sort-of-triple should hold 
   { ... } swapBody { self^.lesser <= self^.greater } 
*)

locale example_swap =
  fixes    m :: vname
    and	   n :: vname
    and	   q :: vname
    and	   z1 :: vname
    and	   lesser    :: fldname
    and	   greater   :: fldname
    and	   swap      :: mname  (* unused for now *)
    and    SwapClass :: cname  (* unused for now *)
    and	   swapBody  :: expr
  defines "swapBody \<equiv>  LET 
                m  = self^:lesser ;
                n  = self^:greater ;
                q  = Primop (\<lambda> x y . if y<x then (1::int) else (0::int)) m n 
              IN
                IF q 
                  THEN LET
                         z1 = (self^.lesser := n) ; 
                         z1 = (self^.greater := m) 
                       IN
                         expr.Void
                       END 
                  ELSE expr.Void
              END"
  assumes  SwapClass: "classtable SwapClass = \<lparr> flds = [lesser,greater], meths = empty ( swap \<mapsto> ({m,n,q}, swapBody) ) \<rparr>"
      and  vardistinct: "distinct [m,n,q,z1]"

(* --------------------------------------------------------------------------- *)
lemma (in example_swap) 
   "\<Turnstile> {(z,s). clock s = z \<and> N < M \<and> s<self> = Some (val.Ref l1) \<and>
          heap s l1 = Some (SwapClass, empty (lesser \<mapsto> val.Int (int M)) (greater \<mapsto> val.Int (int N)))}	
	swapBody
      {(z,s,v). btime (z + 99) s }"
apply (unfold swapBody_def)
apply (rule HLet)
apply (rule HLet)
apply (rule HLet)
apply (rule HIf)
apply (rule HLet)
apply (rule HLet)
apply (rule HVoid)
apply (rule HPutF)
apply (rule HSP)
apply (rule HPutF)
apply (simp_all)
apply (rule subsetI)
apply (clarify)
apply (rule_tac x="l1" in exI) (* real name of x is a *)
apply (rule conjI)
defer 1
apply (rule_tac x="SwapClass" in exI) (* real name of x is aa *)
apply (rule_tac x="empty(lesser\<mapsto>val.Int (int M))(greater\<mapsto>val.Int (int N))" in exI)  (* real name of x is b *)
apply (rule conjI)
defer 1
apply (simp_all)
apply (rule_tac x="val.Int (int N)" in exI)
apply (rule conjI)+
defer 1
apply (rule conjI)
(* -- hmm, "lesser mem flds (classtable SwapClass)" doesn't hold *)
defer 1
apply (rule_tac x="l1" in exI)
(* -- NB: auto would work here already; oh well ... *)
apply (simp add: state_functions)
apply (subgoal_tac "m ~= z1")
apply (simp)
apply (rule conjI)
apply (auto)
(* VOID *)
defer 1
apply (rule HPrimop)
apply (rule HGetF)
apply (rule HSP)
apply (rule HGetF)
apply (simp_all)
apply (rule subsetI)
apply (clarify)
(* subgoal: False *sigh* *)
defer 1
apply (rule HSP)
apply (rule HVoid)
apply (simp add: btime_def)
(* Unsatisfiable subgoal at this point:
 1. !!b. [| N < M; b<self> = Some (Ref l1);
            heap b l1 =
            Some (SwapClass, empty(lesser|->val.Int (int M))(greater
                  |->val.Int (int N))) |]
         ==> False
*)
apply (auto)
oops


lemma (in example_swap) 
   "[| N < M \<and> s<self> = Some (val.Ref l1) \<and>
          heap s l1 = Some (SwapClass, empty (lesser \<mapsto> val.Int (int M)) (greater \<mapsto> val.Int (int N))) |]	
    ==> takestime ?k swapBody"
apply (unfold swapBody_def takestime_def)
apply (rule HLet)
apply (rule HLet)
apply (rule HLet)
apply (rule HIf)
apply (rule HLet)
apply (rule HLet)
apply (rule HVoid)
apply (rule HPutF)
apply (rule HSP)
apply (rule HPutF)
apply (simp_all)
apply (rule subsetI)
apply (clarify)
apply (rule_tac x="l1" in exI) (* real name of x is a *)
apply (auto)
apply (rule HSP)
apply (rule HVoid)
apply (auto)
apply (rule HSP)
apply (rule HPrimop)
apply (auto)
apply (rule HSP)
apply (rule HGetF)
apply (auto)
apply (rule HSP)
apply (rule HGetF)
apply (auto)
(* again: False *)
oops


