theory ExHLPing = ToyHLproc + ToyGrailDef:

(*
  My start at proving ping's time bound via the shiny new Hoare Logic.
*)

(* exact time *)
constdefs time :: "nat \<Rightarrow> state \<Rightarrow> bool"
"time i s == clock s = i"

(* bounded time *)
constdefs btime :: "nat \<Rightarrow> state \<Rightarrow> bool"
"btime i s == clock s <= i"

section {* Simple recursion with functions *}

(* --------------------------------------------------------------------------- *)
(* Code                                                                        *)
(* --------------------------------------------------------------------------- *)

(*
  class PingClass = field Pong pong  
               field int count
               method ping () { count := count -1; 
                                if count > 0  PingClass.ping() else return ()
*)

locale example_ping =
  fixes    m :: vname
    and	   n :: vname
    and	   z1 :: vname
    and	   q1 :: vname
    and	   zero :: vname
    and	   dummyarg :: vname
    and	   count    :: fldname
    and	   ping     :: mname
    and	   countfn  :: funame
    and    PingClass :: cname 
    and	   pingBody :: expr
  defines "pingBody \<equiv>  LET 
                m  = GetF self count ;
                n  = Primop (\<lambda> x y . x - 1) m m ;
                z1 = PutF self count n ; 
                zero = expr.Int 0 ;
                q1 = Primop (\<lambda> x y . if y<x then (1::int) else (0::int)) n zero
              IN
                IF q1 
                  THEN Invoke self ping dummyarg
                  ELSE Var z1
              END"
  assumes  PingClass: "classtable PingClass = \<lparr> flds = [count], meths = empty ( ping \<mapsto> ({m,n,z1,q1,zero}, pingBody) ) \<rparr>"
      and  vardistinct: "distinct [m,n,z1,q1,zero]"

(* --------------------------------------------------------------------------- *)
(* note that from the state in the failed attempt above you can read off the
   factorPing we need: 18 *)

constdefs factorPing2 :: "nat"
"factorPing2 \<equiv> 18"

constdefs constPing2 :: "nat"
"constPing2 \<equiv> 99"

(* we have that already
consts 
  T :: "nat"
  petaQ :: "nat"
  o2 :: "obj"
*)

(* to be continued \<dots> *)

(* In a foundational proof it looks like this:

constdefs prea2 :: "nat \<Rightarrow> 'a preassn"
"prea2 \<equiv> \<lambda> petaQ z s. 
          time T s \<and> 0 < petaQ \<and> 
          heap s l1 = Some (PingClass, empty (count \<mapsto> val.Int (int petaQ)) (pong \<mapsto> val.Void)) \<and> 
          classtable PingClass = \<lparr> flds = [count, pong], meths = bonzo \<rparr> \<and> 
          store s = my_store"

constdefs posta2 :: "nat \<Rightarrow> 'a postassn"
"posta2 \<equiv> \<lambda> petaQ z v s. btime (T + constPing2 + factorPing2 * petaQ) s"

lemma Triple_Ping_valid: "\<forall> N::nat. CONTEXT \<and> PETAQ \<and> PETAQvname \<and> PETAQfldname \<longrightarrow>
   hoare_valid  
       (prea2 N)
       mainBody 
       (posta2 N)"
*)

consts 
  l1 :: "locn"  (* location of the PingClass object *)
  N :: "nat"    (* input *)
  T :: "nat"    (* time at beginning *)

lemma (in example_ping) 
   "\<Turnstile> {(z,s). clock s = z \<and> 0 < N \<and> 
          s<self> = Some (val.Ref l1) \<and> s<dummyarg> = Some (val.Void) \<and> 
          heap s l1 = Some (PingClass, empty (count \<mapsto> val.Int (int N)))}	
	pingBody
      {(z,s,v). btime (z + constPing2 + factorPing2 * N) s }"
apply (unfold pingBody_def)
apply (rule HLet)
apply (rule HLet)
apply (rule HLet)
apply (rule HLet)
apply (rule HLet)
apply (rule HIf)
apply (simp add: btime_def time_def constPing2_def factorPing2_def)
apply (rule HSP)
apply (rule HInvoke)

apply (rule HCallSingleRec)

