header {* Hoare logic for Toy Grail: Examples *}

theory ExHLDvd = ToyHL:

(*
  Example: dvd m n ... tests whether m divides n, using a running potential divisor
  Description: Mutually recursive, using function calls
*)

locale exdvd =
  fixes    dvd1 :: funame
    and	   dvd2 :: funame
    and	   m :: vname and n :: vname and r :: vname 
    and    x :: vname and y :: vname and z :: vname
    and    rx :: vname and q1 :: vname and q2 :: vname and q3 ::vname 
    and    tt :: vname and ff :: vname
    and	   dummyarg :: vname and stat1 :: vname
    and	   l1     :: locn
    and	   even   :: mname
    and    FooClass :: cname
    and	   dvd2Body :: expr

  assumes vardistinct: "distinct [m,n,r,x,y,z,rx,q1,q2,q3,tt,ff,dummyarg,state]"

  defines  "dvd2Body \<equiv> 
             LET
               z  = Primop (\<lambda> x y. x+1) r r  ;
               r  = expr.Var z ;
               y  = Primop (\<lambda> x y. x*y) m r ; 
               q2 = Primop (\<lambda> x y. if (x=y) then (1::int) else (0::int)) y n ;
               tt = (expr.Int 1) 
             IN
               IF q2 
                 THEN Var tt
                 ELSE CALL dvd1
             END"

  assumes dvd2: "funtable dvd2 = dvd2Body"

(* --------------------------------------------------------------------------- *)

lemma (in exdvd) 
   "\<Turnstile> {(z,s). clock s = z \<and> N < M \<and> s<self> = Some (val.Ref l1) \<and>
          heap s l1 = Some (SwapClass, empty (lesser \<mapsto> val.Int (int M)) (greater \<mapsto> val.Int (int N)))}	
	dvd2Body
      {(z,s,v). btime (z + 99) s }"
