theory ExEven = ToyGrailDef + HLBase + Divides:

(* Testing Invoke; shallow cheating over the arithmetic, using Isabelle's dvd *)

(* --------------------------------------------------------------------------- *)
(* Code                                                                        *)
(* --------------------------------------------------------------------------- *)

consts
 two :: vname
 m :: vname
 n :: vname
 i :: vname
 q1 :: vname
 q2 :: vname

consts 
 l1 :: locn
 dummyarg :: vname
 stat1 :: vname
 even :: mname
 FooClass :: cname

consts
 error :: expr


constdefs evenBody :: expr
"evenBody \<equiv>  LET 
                two = (expr.Int (2::int)) ;
                q1 = Primop (\<lambda> x y . if (x dvd y) then (1::int) else (0::int)) two  n
              IN
                Var q1
              END"

constdefs mainBody :: letexpr
"mainBody \<equiv>  LET 
                q2 = Invoke stat1 even dummyarg
              IN
                RETURN q2
              END"


(* --------------------------------------------------------------------------- *)
(* State (hand crafted)                                                        *)
(* --------------------------------------------------------------------------- *)

constdefs my_funtable :: "funame \<Rightarrow> letexpr"
 "my_funtable x \<equiv> error"

constdefs my_heap :: "heap"
 "my_heap \<equiv> empty"

constdefs evenMbody :: "methbody"
"evenMbody \<equiv> ({q1}, evenBody)"

constdefs evenMmap :: "mname \<leadsto> methbody"
"evenMmap \<equiv> empty ( even \<mapsto> evenMbody )"

(* 
constdefs my_fldmap :: "fldname \<leadsto> val"
"my_fldmap \<equiv> empty (count \<mapsto> (val.Int (int N))) (pong \<mapsto> (val.Ref 2))"

constdefs my_heap :: "heap"
"my_heap \<equiv> empty ( l1 \<mapsto> (PingClass,  my_fldmap) )"
*)

consts
  base :: "fldname"
  o2 :: "obj"

constdefs my_store :: "store"
"my_store \<equiv> empty (stat1 \<mapsto> (val.Ref l1)) (dummyarg \<mapsto> val.Void)"

constdefs my_state :: "state"
 "my_state \<equiv> \<lparr> heap = my_heap , store = my_store, framestack = [], 
               maxstack = 0, clock = 0 \<rparr>"


constdefs CONTEXT :: "nat \<Rightarrow> nat \<Rightarrow> 'a list \<Rightarrow> state \<Rightarrow> bool"
"CONTEXT T N \<equiv> (\<lambda> z s. classtable FooClass = \<lparr> flds = [base], meths = evenMmap \<rparr> \<and>
       time T s \<and> 
       s<stat1> = Some (val.Ref l1) \<and> (heap s l1) = Some o2 \<and> 
       fst o2 = FooClass \<and> snd o2 base = Some (val.Int (int N)) \<and>
       store s = my_store)"

(* --------------------------------------------------------------------------- *)
(* Costs                                                                       *)
(* --------------------------------------------------------------------------- *)

constdefs factorEven :: "nat"
"factorEven \<equiv> 0"

constdefs constEven :: "nat"
"constEven \<equiv> 13"

(* --------------------------------------------------------------------------- *)
(* Lemmas *)
(* --------------------------------------------------------------------------- *)

lemma heap_tick_invar: "\<forall> s . \<forall> n . heap (tickn n s) = heap s"
by (unfold tickn_def, simp)

lemma store_tick_invar: "\<forall> s . \<forall> n . store (tickn n s) = store s"
by (unfold tickn_def, simp)

lemma framestack_tick_invar: "\<forall> s . \<forall> n . framestack (tickn n s) = framestack s"
by (unfold tickn_def, simp)

lemma maxstack_tick_invar: "\<forall> s . \<forall> n . maxstack (tickn n s) = maxstack s"
by (unfold tickn_def, simp)

(* currstack has disappeared again @%#%#%@%#
lemma currstack_tick_invar: "\<forall> s . \<forall> n . framestack (tickn n s) = framestack s"
by (unfold tickn_def, simp)
*)

lemma clock_tickn: "\<forall> s . \<forall> n . clock (tickn n s) = n + (clock s)"
by (unfold tickn_def, simp)

(* emptyState has disappeared again @%#%#%@%#
lemma emptyState_clock: "clock emptyState = 0"
by (unfold emptyState_def, simp)
*)

lemma clock1: "\<forall> (s::state). \<forall> (h::heap). \<forall> (st::store). \<forall> (fs::(frame list)). \<forall> (ms::nat). 
               clock s = clock (s \<lparr> heap := h, store := st, framestack := fs, maxstack := ms \<rparr>)"
apply (rule allI)+
apply (simp)
done
 

lemma stupid1: "\<forall> s. \<forall> x. \<forall> rtv . \<exists> s2. (varupdate s x rtv = s1) --> \<langle>s1, Ret x\<rangle> \<longrightarrow>l \<langle>rtv, s2\<rangle>"
apply (rule allI)+
apply (rule exI)+
apply (rule impI)
apply (unfold varupdate_def)
apply (auto)
apply (rule evalRet)
apply (unfold get_var_def)
apply (simp)
done
(* OK *)

lemma stupid2: "\<exists> mbody. classtable FooClass = \<lparr> flds = [base], meths = evenMmap \<rparr> --> meths (classtable FooClass) even = Some mbody \<and> snd mbody = evenBody"
apply (rule exI)
apply (unfold evenMmap_def evenMbody_def)
apply (auto)
done
(* OK *)

(* --------------------------------------------------------------------------- *)
(* Resource properties                                                         *)
(* --------------------------------------------------------------------------- *)

(* seems that the pre-condition has to be inlined, i.e. can't use CONTEXT as
   defined above *)

lemma RP1: "\<forall> t n. 
   hoare_lvalid  
       (\<lambda> z s. time t s \<and> 
        classtable FooClass = \<lparr> flds = [base], meths = evenMmap \<rparr> \<and>
       s<stat1> = Some (val.Ref l1) \<and> (heap s l1) = Some o2 \<and> 
       fst o2 = FooClass \<and> snd o2 base = Some (val.Int (int N)) \<and>
       store s = my_store)
       mainBody 
       (\<lambda> z v s. btime (t + constEven + factorEven * n) s)"
apply (unfold  mainBody_def hoare_lvalid_def)
apply (rule allI)+
apply (rule impI)
(* no need for induction here *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold varupdate_def)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold newframe_def CONTEXT_def evenMmap_def evenMbody_def evenBody_def)
apply (simp add: stupid1 stupid2)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* time to simplify the btime bit *)
apply (unfold btime_def constEven_def factorEven_def)
apply (simp add: stupid1 stupid2 clock_tickn store_tick_invar heap_tick_invar maxstack_tick_invar clock1)
(* the body of the method is still not explicit! *)
apply (erule evalexpr_evallet.elims)
apply (simp add: stupid1 stupid2 clock_tickn store_tick_invar heap_tick_invar maxstack_tick_invar clock1)
apply (auto)
(* down to 1 subgoal again, as it should be *)
apply (unfold get_var_def time_def)
apply (simp add: stupid1 stupid2 clock_tickn)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* down to 1 subgoal again, as it should be *)
apply (unfold varupdate_def)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: varupdate_def stupid1 stupid2 clock_tickn)
(*    RETURN two *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (auto)
done 
(* OK *)


end