theory ExDvd = ToyGrailDef + HLBase + LIST:

(*
  Example: dvd m n ... tests whether m divides n, using a running potential divisor
  Description: Mutually recursive, using function calls
  Status: reaches recursive call; matching ind hyp is nightmare bacause of
          huge proof state at that point 

*)

(* --------------------------------------------------------------------------- *)
(* Code                                                                        *)
(* --------------------------------------------------------------------------- *)

consts (* functions *)
 dvd1 :: funame
 dvd2 :: funame

constdefs PETAQfuname :: "bool"
"PETAQfuname == dvd2 ~= dvd1 & dvd1 ~= dvd2  "

consts (* variables *)
 (* Arguments: m, n, r *)
 m :: vname
 n :: vname
 r :: vname
 (* aux int vars *)
 x :: vname
 y :: vname
 z :: vname
 rx :: vname
 (* qonditionals *)
 q1 :: vname
 q2 :: vname
 q3 :: vname
 (* bool consts (sort-of) *)
 tt :: vname
 ff :: vname
 dummyarg :: vname
 stat1 :: vname

constdefs PETAQvname :: "bool"
"PETAQvname == param ~= self & param ~= stat1 & param ~= dummyarg & param ~= ff & param ~= tt & param ~= q3 & param ~= q2 & param ~= q1 & param ~= rx & param ~= z & param ~= y & param ~= x & param ~= r & param ~= n & param ~= m & self ~= param & self ~= stat1 & self ~= dummyarg & self ~= ff & self ~= tt & self ~= q3 & self ~= q2 & self ~= q1 & self ~= rx & self ~= z & self ~= y & self ~= x & self ~= r & self ~= n & self ~= m & stat1 ~= param & stat1 ~= self & stat1 ~= dummyarg & stat1 ~= ff & stat1 ~= tt & stat1 ~= q3 & stat1 ~= q2 & stat1 ~= q1 & stat1 ~= rx & stat1 ~= z & stat1 ~= y & stat1 ~= x & stat1 ~= r & stat1 ~= n & stat1 ~= m & dummyarg ~= param & dummyarg ~= self & dummyarg ~= stat1 & dummyarg ~= ff & dummyarg ~= tt & dummyarg ~= q3 & dummyarg ~= q2 & dummyarg ~= q1 & dummyarg ~= rx & dummyarg ~= z & dummyarg ~= y & dummyarg ~= x & dummyarg ~= r & dummyarg ~= n & dummyarg ~= m & ff ~= param & ff ~= self & ff ~= stat1 & ff ~= dummyarg & ff ~= tt & ff ~= q3 & ff ~= q2 & ff ~= q1 & ff ~= rx & ff ~= z & ff ~= y & ff ~= x & ff ~= r & ff ~= n & ff ~= m & tt ~= param & tt ~= self & tt ~= stat1 & tt ~= dummyarg & tt ~= ff & tt ~= q3 & tt ~= q2 & tt ~= q1 & tt ~= rx & tt ~= z & tt ~= y & tt ~= x & tt ~= r & tt ~= n & tt ~= m & q3 ~= param & q3 ~= self & q3 ~= stat1 & q3 ~= dummyarg & q3 ~= ff & q3 ~= tt & q3 ~= q2 & q3 ~= q1 & q3 ~= rx & q3 ~= z & q3 ~= y & q3 ~= x & q3 ~= r & q3 ~= n & q3 ~= m & q2 ~= param & q2 ~= self & q2 ~= stat1 & q2 ~= dummyarg & q2 ~= ff & q2 ~= tt & q2 ~= q3 & q2 ~= q1 & q2 ~= rx & q2 ~= z & q2 ~= y & q2 ~= x & q2 ~= r & q2 ~= n & q2 ~= m & q1 ~= param & q1 ~= self & q1 ~= stat1 & q1 ~= dummyarg & q1 ~= ff & q1 ~= tt & q1 ~= q3 & q1 ~= q2 & q1 ~= rx & q1 ~= z & q1 ~= y & q1 ~= x & q1 ~= r & q1 ~= n & q1 ~= m & rx ~= param & rx ~= self & rx ~= stat1 & rx ~= dummyarg & rx ~= ff & rx ~= tt & rx ~= q3 & rx ~= q2 & rx ~= q1 & rx ~= z & rx ~= y & rx ~= x & rx ~= r & rx ~= n & rx ~= m & z ~= param & z ~= self & z ~= stat1 & z ~= dummyarg & z ~= ff & z ~= tt & z ~= q3 & z ~= q2 & z ~= q1 & z ~= rx & z ~= y & z ~= x & z ~= r & z ~= n & z ~= m & y ~= param & y ~= self & y ~= stat1 & y ~= dummyarg & y ~= ff & y ~= tt & y ~= q3 & y ~= q2 & y ~= q1 & y ~= rx & y ~= z & y ~= x & y ~= r & y ~= n & y ~= m & x ~= param & x ~= self & x ~= stat1 & x ~= dummyarg & x ~= ff & x ~= tt & x ~= q3 & x ~= q2 & x ~= q1 & x ~= rx & x ~= z & x ~= y & x ~= r & x ~= n & x ~= m & r ~= param & r ~= self & r ~= stat1 & r ~= dummyarg & r ~= ff & r ~= tt & r ~= q3 & r ~= q2 & r ~= q1 & r ~= rx & r ~= z & r ~= y & r ~= x & r ~= n & r ~= m & n ~= param & n ~= self & n ~= stat1 & n ~= dummyarg & n ~= ff & n ~= tt & n ~= q3 & n ~= q2 & n ~= q1 & n ~= rx & n ~= z & n ~= y & n ~= x & n ~= r & n ~= m & m ~= param & m ~= self & m ~= stat1 & m ~= dummyarg & m ~= ff & m ~= tt & m ~= q3 & m ~= q2 & m ~= q1 & m ~= rx & m ~= z & m ~= y & m ~= x & m ~= r & m ~= n"

consts 
 l1 :: locn
 even :: mname
 FooClass :: cname

(* 2 mutually recursive function:
    dvd checks whether the running divisor z has reached the 2nd arg n
    dvd2 does the test whether n=m*z
*)

constdefs dvd2Body :: letexpr
"dvd2Body \<equiv> 
             LET
               z  = Primop (\<lambda> x y. x+1) r r  ;
               r  = expr.Var z ;
               y  = Primop (\<lambda> x y. x*y) m r ; 
               q2 = Primop (\<lambda> x y. if (x=y) then (1::int) else (0::int)) y n ;
               tt = (expr.Int 1) 
             IN
               IF q2 
                 THEN (RETURN tt) 
                 ELSE (Call dvd1)
             END"

(*
               rx = (Invoke stat1 dvd1 dummyarg)
*)
(*
*)
(* tests whether m divides n, using z as running divisor *)
constdefs dvdBody :: letexpr
"dvdBody \<equiv> LET 
              q1 = (Primop (\<lambda> x y. if (x<y) then (1::int) else (0::int)) n r) ;
              ff = (expr.Int 0)
            IN
              IF q1 
                THEN (RETURN ff) 
                ELSE (CALL dvd2)
            END"

constdefs mainBody :: letexpr
"mainBody \<equiv> CALL dvd1 "

(* --------------------------------------------------------------------------- *)
(* State (hand crafted)                                                        *)
(* --------------------------------------------------------------------------- *)

(*
consts
  M :: int
  N :: int

constdefs my_store :: store
 "my_store == empty (m \<mapsto> (val.Int M)) (n \<mapsto> (val.Int N)) (r \<mapsto> (val.Int 0))"
*)

(* this is soooooooooooooooooooooooooooooo stupid *)
constdefs my_funtable :: "funame \<Rightarrow> letexpr"
 "my_funtable \<equiv> \<lambda> x. if x=dvd1 then dvdBody  else dvd2Body"

(*
constdefs myfuntable :: "funame \<Rightarrow> letexpr"
 "myfuntable dvd1 \<equiv> dvdBody 
  myfuntable dvd2 \<equiv> dvd2Body"
*)
(*  "my_funtable x == case x of dvd1 => dvdBody" *)

(*
 "my_funtable dvd1 == dvdBody 
  my_funtable dvd2 == dvd2Body"
*)
(* "my_funtable x == if x=dvd1 then dvdBody else if x=dvd2 then dvd2Body else error" *)

constdefs my_heap :: "heap"
 "my_heap == empty"

constdefs my_state :: "state"
 "my_state == \<lparr> heap = my_heap , store = empty, framestack = [], 
                maxstack = 0, clock = 0 \<rparr>"

(* --------------------------------------------------------------------------- *)
(* Costs                                                                       *)
(* --------------------------------------------------------------------------- *)

constdefs factorDvd :: "nat"
"factorDvd \<equiv> 99"

constdefs constDvd :: "nat"
"constDvd \<equiv> 13"

(* --------------------------------------------------------------------------- *)
(* Lemmas *)
(* --------------------------------------------------------------------------- *)

lemma heap_tick_invar: "\<forall> s . \<forall> n . heap (tickn n s) = heap s"
by (unfold tickn_def, simp)

lemma store_tick_invar: "\<forall> s . \<forall> n . store (tickn n s) = store s"
by (unfold tickn_def, simp)

lemma framestack_tick_invar: "\<forall> s . \<forall> n . framestack (tickn n s) = framestack s"
by (unfold tickn_def, simp)

lemma maxstack_tick_invar: "\<forall> s . \<forall> n . maxstack (tickn n s) = maxstack s"
by (unfold tickn_def, simp)

(* currstack has disappeared again @%#%#%@%#
lemma currstack_tick_invar: "\<forall> s . \<forall> n . framestack (tickn n s) = framestack s"
by (unfold tickn_def, simp)
*)

lemma clock_tickn: "\<forall> s . \<forall> n . clock (tickn n s) = n + (clock s)"
by (unfold tickn_def, simp)

(* emptyState has disappeared again @%#%#%@%#
lemma emptyState_clock: "clock emptyState = 0"
by (unfold emptyState_def, simp)
*)

lemma clock1: "\<forall> (s::state). \<forall> (h::heap). \<forall> (st::store). \<forall> (fs::(frame list)). \<forall> (ms::nat). 
               clock s = clock (s \<lparr> heap := h, store := st, framestack := fs, maxstack := ms \<rparr>)"
apply (rule allI)+
apply (simp)
done
 

lemma stupid1: "\<forall> s. \<forall> x. \<forall> rtv . \<exists> s2. (varupdate s x rtv = s1) --> \<langle>s1, Ret x\<rangle> \<longrightarrow>l \<langle>rtv, s2\<rangle>"
apply (rule allI)+
apply (rule exI)+
apply (rule impI)
apply (unfold varupdate_def)
apply (auto)
apply (rule evalRet)
apply (unfold get_var_def)
apply (simp)
done
(* OK *)

lemma stupid3: "dvd1 ~= dvd2 --> my_funtable dvd2 = dvd2Body"
apply (unfold my_funtable_def)
apply (simp)
done 

(* --------------------------------------------------------------------------- *)
(* Resource properties                                                         *)
(* --------------------------------------------------------------------------- *)

(* seems that the pre-condition has to be inlined, i.e. can't use CONTEXT as
   defined above *)
consts 
  M :: nat
  N :: nat
  R :: nat

constdefs CONTEXT :: "bool"
 "CONTEXT == m ~= n & n ~= r & r ~= x & x ~= y & y ~= z & z ~= ff & ff ~= tt & tt ~= q1 & q1 ~= q2 & q1 ~= ff & n ~= ff & q1 ~= r & q1 ~= m & q1 ~= n & n ~= r & dvd1 ~= dvd2 & r ~= ff & n ~= r & n ~= q1 & r ~= q1 & r ~= n & r ~= m & m ~= r & m ~= z & m ~= ff & m ~= q1 & n ~= y & n ~= z & q2 ~= tt"

(* Lemma for induction base case in main theorem: N=0 *)
theorem RP0: "\<forall> T M . CONTEXT & PETAQfuname & PETAQvname -->
   hoare_lvalid  
       (\<lambda> z s. time T s \<and> 
       funtable = my_funtable \<and> 
       store s = empty (m \<mapsto> (val.Int (int M))) (n \<mapsto> (val.Int (int 0))) (r \<mapsto> (val.Int 1)) )
       mainBody 
       (\<lambda> z v s. btime (T + constDvd + factorDvd * 0) s)"
apply (unfold mainBody_def hoare_lvalid_def)
apply (rule allI)+
apply (rule impI)
apply (rule allI)+
apply (rule impI)
apply (rule allI)+
(* CALL dvd1 *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* -- now, lets get the bloody function boody out of that silly my_funtable ... *)
apply (unfold my_funtable_def)
apply (simp)
apply (unfold dvdBody_def)
(* LET q1 = *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp only: varupdate_def)
(* -- q1 is in the store now *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: get_var_def clock_tickn)
apply (unfold PETAQvname_def, simp, fold PETAQvname_def)
(* LET ff = ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* -- ff is in the store now; hurrrayyy *)
(* -- before we evaluate the If construct we have to unfold context *)
apply (unfold PETAQvname_def, simp add: varupdate_def, fold PETAQvname_def)
(* -- now q1 has value 1 and it is cool to continue evaluating *)
(* IF q1 ...  *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (auto)
(*   THEN RETURN *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* -- evaluated then branch; now simplify the time expr *)
apply (unfold btime_def time_def constDvd_def factorDvd_def get_var_def)
apply (simp)
apply (simp add: clock_tickn)
(*   ELSE Call dvd2; *)
apply (unfold PETAQvname_def, simp add: store_tick_invar clock_tickn)
done
(* OK *)

lemma RPn: "\<forall> T M N R .  CONTEXT & PETAQfuname & PETAQvname -->
   hoare_lvalid  
       (\<lambda> z s. time T s \<and> 
       funtable = my_funtable \<and>
       store s = empty (m \<mapsto> (val.Int (int M))) (n \<mapsto> (val.Int (int N))) (r \<mapsto> (val.Int (int R))) \<and> (nat 0) < R )
       mainBody 
       (\<lambda> z v s. btime (T + constDvd + factorDvd * (N-R)) s)"
apply (unfold mainBody_def hoare_lvalid_def)
apply (rule allI)+
apply (rule impI)
(* do the induction thing *)
apply (induct_tac N)
(* ++ base case; inlined proof of RP0 *sigh* *)
apply (rule allI)+
apply (rule impI)
apply (rule allI)+
apply (rule impI)
(* CALL dvd1 *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* -- now, lets get the bloody function boody out of that silly my_funtable ... *)
apply (unfold my_funtable_def)
apply (simp)
apply (unfold dvdBody_def)
(* LET q1 = *)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def varupdate_def)
apply(clarsimp)
(*
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp only: varupdate_def)
*)
(* -- q1 is in the store now *)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def varupdate_def)
apply(clarsimp)
apply (simp only: get_var_def clock_tickn)
(*
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp only: get_var_def clock_tickn)
*)
apply (unfold PETAQvname_def, simp, fold PETAQvname_def)
(* LET ff = ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* -- ff is in the store now; hurrrayyy *)
(* -- before we evaluate the If construct we have to unfold context *)
apply (unfold PETAQvname_def, simp add: varupdate_def, fold PETAQvname_def)
(* -- now q1 has value 1 and it is cool to continue evaluating *)
(* IF q1 ...  *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (auto)
(*   THEN RETURN *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* -- evaluated then branch; now simplify the time expr *)
apply (unfold btime_def time_def constDvd_def factorDvd_def get_var_def)
apply (simp)
apply (simp add: clock_tickn)
(*   ELSE Call dvd2; *)
apply (unfold PETAQvname_def, simp add: store_tick_invar clock_tickn, fold PETAQvname_def)
(* -- finished with base caseOK *)
(* ++ recursion case (1 subgoal) *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* now, lets get the bloody function boody out of that silly my_funtable ... *)
apply (subgoal_tac "funtable dvd1 = dvdBody")
apply (simp)
apply (unfold dvdBody_def)
apply (induct_tac R)
(* LET q1 = \<dots> *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold varupdate_def)
(* -- q1 is in the store now *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold get_var_def)
(* LET ff = \<dots> *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold PETAQvname_def, simp add: varupdate_def, fold PETAQvname_def)
(* -- ff is in the store now; hurrrayyy *)
(* -- now q1 has value 1 and it is cool to continue evaluating *)
(* IF q1 ... *)
apply (case_tac "1 + int na < int R")
apply (simp)
(* -- now q1 \<mapsto> 1 *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (auto)
(*   THEN (RETURN ff) *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* -- evaluated; now simplify the time expr *)
apply (unfold btime_def time_def constDvd_def factorDvd_def get_var_def)
apply (simp add: clock_tickn)
apply (unfold PETAQvname_def, simp add: varupdate_def, fold PETAQvname_def)
(*   ELSE (CALL dvd2) *)
apply (simp only: store_tick_invar)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp only: store_tick_invar)

(*        (Call dvd2) *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* LET r = ... *)
apply (unfold varupdate_def)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold get_var_def)
apply (simp add: clock_tickn)
(* apply (subgoal_tac "r ~= ff") *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold PETAQvname_def)
apply (simp add: varupdate_def clock_tickn tickn_tickn store_store_simp store_tick_invar)
apply (fold PETAQvname_def)
(* LET y = ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold get_var_def)
apply (simp add: store_tick_invar clock_tickn)
defer 1
apply (simp add: store_tick_invar clock_tickn)
apply (simp add: store_tick_invar clock_tickn)
apply (simp add: store_tick_invar clock_tickn)
apply (simp add: store_tick_invar clock_tickn)
apply (simp add: store_tick_invar clock_tickn)
apply (simp add: store_tick_invar clock_tickn)
(* defer proof of funtable dvd2 = dvd2Body  (should be assumption anyway) *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* IF q1 ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(*   THEN RETURN ff *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold get_var_def)
apply (simp add: store_tick_invar clock_tickn)
apply (unfold PETAQvname_def)
apply (simp add: varupdate_def clock_tickn tickn_tickn store_store_simp store_tick_invar)
apply (fold PETAQvname_def)
(*   ELSE Call dvd2 *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* now, lets get the bloody function boody out of that silly my_funtable ... *)
apply (subgoal_tac "funtable dvd2 = dvd2Body")
apply (simp)
apply (unfold dvd2Body_def)
(* lets continue with our merry evaluation *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: varupdate_def store_tick_invar clock_tickn)
(* LET r = ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: get_var_def store_tick_invar clock_tickn)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: varupdate_def store_tick_invar clock_tickn)
(* LET y = ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: get_var_def store_tick_invar clock_tickn)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: varupdate_def store_tick_invar clock_tickn)
(* LET q2 = ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: get_var_def store_tick_invar clock_tickn)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: varupdate_def store_tick_invar clock_tickn)
(* LET tt = ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: get_var_def store_tick_invar clock_tickn)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: varupdate_def store_tick_invar clock_tickn)
(* IF q2 ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (auto)
(*    THEN RETURN ff *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold PETAQvname_def)
apply (simp add: varupdate_def clock_tickn tickn_tickn store_store_simp store_tick_invar)
apply (fold PETAQvname_def)
apply (simp add: get_var_def varupdate_def clock_tickn tickn_tickn store_store_simp store_tick_invar)
(*    ELSE CALL dvd1 *)
apply (drule_tac x = "tickn (Suc 0)
                    (tickn 3
                      (tickn 3
                        (tickn (Suc 0)
                          (tickn 3
                            (tickn (Suc 0)
                              (tickn 3 sa
                               (| store :=
                                    (%u. if u = r then Some (val.Int (int R))
                                         else if u = n
   then Some (val.Int (1 + int na))
   else if u = m then Some (val.Int (int M)) else None)
                                    (q1|->val.Int 0) |))
                             (| store :=
                                  (%u. if u = r then Some (val.Int (int R))
                                       else if u = n then Some (val.Int (1 + int na))
 else if u = m then Some (val.Int (int M)) else None)
                                  (q1|->val.Int 0)(ff|->val.Int 0) |))
                           (| store :=
                                (%u. if u = r then Some (val.Int (int R))
                                     else if u = n then Some (val.Int (1 + int na))
                                          else if u = m then Some (val.Int (int M))
    else None)
                                (q1|->val.Int 0)(ff|->val.Int 0)(z
                                |->val.Int (i2 + 1)) |))
                         (| store :=
                              (%u. if u = r then Some (val.Int (int R))
                                   else if u = n then Some (val.Int (1 + int na))
                                        else if u = m then Some (val.Int (int M))
  else None)
                              (q1|->val.Int 0)(ff|->val.Int 0)(z|->val.Int (i2 + 1))(r
                              |->val.Int (i2 + 1)) |))
                       (| store :=
                            (%u. if u = r then Some (val.Int (int R))
                                 else if u = n then Some (val.Int (1 + int na))
                                      else if u = m then Some (val.Int (int M))
else None)
                            (q1|->val.Int 0)(ff|->val.Int 0)(z|->val.Int (i2 + 1))(r
                            |->val.Int (i2 + 1))(y|->val.Int (i1 * (i2 + 1))) |))
                     (| store :=
                          (%u. if u = r then Some (val.Int (int R))
                               else if u = n then Some (val.Int (1 + int na))
                                    else if u = m then Some (val.Int (int M))
                                         else None)
                          (q1|->val.Int 0)(ff|->val.Int 0)(z|->val.Int (i2 + 1))(r
                          |->val.Int (i2 + 1))(y|->val.Int (i1 * (i2 + 1)))(q2
                          |->val.Int (if i1 * (i2 + 1) = i2a then 1 else 0)) |))
          (| store :=
               (%u. if u = r then Some (val.Int (int R))
                    else if u = n then Some (val.Int (1 + int na))
                         else if u = m then Some (val.Int (int M)) else None)
               (q1|->val.Int 0)(ff|->val.Int 0)(z|->val.Int (i2 + 1))(r
               |->val.Int (i2 + 1))(y|->val.Int (i1 * (i2 + 1)))(q2
               |->val.Int (if i1 * (i2 + 1) = i2a then 1 else 0))(tt
               |->val.Int
                   1) |)" in spec)
apply (drule_tac x = "s2a" in spec)
apply (simp)
(* got this far -------------------------------------------------- *)


apply(subgoal_tac "\<exists>v. \<langle>tickn (Suc 0)
            (tickn 3
              (tickn 3
                (tickn (Suc 0)
                  (tickn 3
                    (tickn (Suc 0)
                      (tickn 3 sa
                       \<lparr>store :=
                          (\<lambda>u. if u = r then Some (val.Int (int R))
                               else if u = n then Some (val.Int (1 + int na))
                                    else if u = m then Some (val.Int (int M))
                                         else None)
                          (q1\<mapsto>val.Int 0)\<rparr>)
                     \<lparr>store :=
                        (\<lambda>u. if u = r then Some (val.Int (int R))
                             else if u = n then Some (val.Int (1 + int na))
                                  else if u = m then Some (val.Int (int M)) else None)
                        (q1\<mapsto>val.Int 0)(ff\<mapsto>val.Int 0)\<rparr>)
                   \<lparr>store :=
                      (\<lambda>u. if u = r then Some (val.Int (int R))
                           else if u = n then Some (val.Int (1 + int na))
                                else if u = m then Some (val.Int (int M)) else None)
                      (q1\<mapsto>val.Int 0)(ff\<mapsto>val.Int 0)(z\<mapsto>val.Int (int R + 1))\<rparr>)
                 \<lparr>store :=
                    (\<lambda>u. if u = r then Some (val.Int (int R))
                         else if u = n then Some (val.Int (1 + int na))
                              else if u = m then Some (val.Int (int M)) else None)
                    (q1\<mapsto>val.Int 0)(ff\<mapsto>val.Int 0)(z\<mapsto>val.Int (int R + 1))(r\<mapsto>
                    val.Int (int R + 1))\<rparr>)
               \<lparr>store :=
                  (\<lambda>u. if u = r then Some (val.Int (int R))
                       else if u = n then Some (val.Int (1 + int na))
                            else if u = m then Some (val.Int (int M)) else None)
                  (q1\<mapsto>val.Int 0)(ff\<mapsto>val.Int 0)(z\<mapsto>val.Int (int R + 1))(r\<mapsto>
                  val.Int (int R + 1))(y\<mapsto>val.Int (int M * (int R + 1)))\<rparr>)
             \<lparr>store :=
                (\<lambda>u. if u = r then Some (val.Int (int R))
                     else if u = n then Some (val.Int (1 + int na))
                          else if u = m then Some (val.Int (int M)) else None)
                (q1\<mapsto>val.Int 0)(ff\<mapsto>val.Int 0)(z\<mapsto>val.Int (int R + 1))(r\<mapsto>
                val.Int (int R + 1))(y\<mapsto>val.Int (int M * (int R + 1)))(q2\<mapsto>val.Int 0)\<rparr>)
          \<lparr>store :=
             (\<lambda>u. if u = r then Some (val.Int (int R))
                  else if u = n then Some (val.Int (1 + int na))
                       else if u = m then Some (val.Int (int M)) else None)
             (q1\<mapsto>val.Int 0)(ff\<mapsto>val.Int 0)(z\<mapsto>val.Int (int R + 1))(r\<mapsto>
             val.Int (int R + 1))(y\<mapsto>val.Int (int M * (int R + 1)))(q2\<mapsto>val.Int 0)(tt\<mapsto>
             val.Int 1)\<rparr>,CALL dvd1\<rangle> \<longrightarrow>l \<langle>rtv,s2a\<rangle>")
apply (erule exE)
apply (simp add: store_tick_invar clock_tickn)



apply (erule allE)

apply (auto)
apply (simp add: store_tick_invar clock_tickn)
defer 1
apply (simp add: store_tick_invar clock_tickn)
defer 1
apply (erule exE)

(*
apply (subgoal_tac "\<forall> s. \<forall> t. (\<exists> v. \<langle>s,CALL dvd1\<rangle> \<longrightarrow>l \<langle>v,t\<rangle>) \<longrightarrow>
                clock s = clock sa \<and>
                store s =
                (\<lambda>u. if u = r then Some (val.Int (int R))
                     else if u = n then Some (val.Int (int na))
                          else if u = m then Some (val.Int (int M)) else None) \<longrightarrow>
                clock t \<le> clock sa + 13 + (8 * na - 8 * R)")
*)


apply (unfold get_var_def)
apply (simp add: store_tick_invar clock_tickn)
(* apply (subgoal_tac "n ~= r") *)
(* apply (subgoal_tac "n ~= q1") *)
(* apply (subgoal_tac "r ~= q1") *)
(* apply (subgoal_tac "r ~= n") *)
(* apply (subgoal_tac "r ~= m") *)
(* apply (subgoal_tac "m ~= r") *)
(* apply (subgoal_tac "m ~= z") *)
(* apply (subgoal_tac "m ~= ff") *)
(* apply (subgoal_tac "m ~= q1") *)
(* apply (simp) *)
(* LET q2 = ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: store_tick_invar clock_tickn)
(* LET tt = ... *)
apply (unfold varupdate_def)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold get_var_def)
apply (subgoal_tac "n ~= y")
apply (subgoal_tac "n ~= z")
(* LET tt = ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold varupdate_def)
(* IF q2 ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: store_tick_invar clock_tickn)
apply (erule evalexpr_evallet.elims)
apply (auto)
(*  THEN RETURN *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (subgoal_tac "q2 ~= tt")
apply (unfold get_var_def)
apply (simp add: clock_tickn)
(*   ELSE (CALL dvd2) *)
(* TODO: check this clause!! *)
prefer 4
(* recursive case; use ind hypo here !!!*)
apply (simp add: store_tick_invar clock_tickn)
apply (subgoal_tac "\<forall> s t. (\<exists> v. \<langle>s,CALL dvd1\<rangle> -->l \<langle>v,t\<rangle>) -->
                clock s = clock sa \<and>
                store s =
                (\<lambda> u. if u = r then Some (val.Int 1)
                     else if u = n then Some (val.Int (int na))
                          else if u = m then Some (val.Int (int M)) else None) -->
                clock t \<le> clock sa + 13 + 8 * na")

apply (erule evalexpr_evallet.elims)
apply (auto)
(* LET q1 = *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* LET ff = *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: store_tick_invar clock_tickn)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (unfold varupdate_def get_var_def)
apply (simp add: store_tick_invar clock_tickn)
(* IF q1 ... *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: store_tick_invar clock_tickn)
(* RETURN *)
apply (erule evalexpr_evallet.elims)
apply (auto)
(* mega-time-expr has been produced; nanofy it *)
apply (simp add: store_tick_invar clock_tickn)
(* hmmm... says "Suc 0 <= na" ; not sure why *)
defer 1
apply (simp add: store_tick_invar clock_tickn)
defer 1
apply (simp add: store_tick_invar clock_tickn)
defer 1
apply (simp add: store_tick_invar clock_tickn)
defer 1
apply (simp add: store_tick_invar clock_tickn)
(* CALL dvd2 *)
apply (erule evalexpr_evallet.elims)
apply (auto)





apply (unfold get_var_def)
apply (simp)













lemma
(* eval IF *)
apply (erule evalexpr_evallet.elims)
apply (auto)
apply (simp add: store_tick_invar clock_tickn)
apply (simp)




(* --------------------------------------------------------------------------- *)

(* Aux fct: mult (using Lennart's proof)
   fun f(n,m) = let m = m + n
                    n = n - 1
                in  if n=0 then m else f(n,m)
  satisfies {\<lambda> [N,M] i s. s<n> = N & N > 0 & clock s = i}
            Result Call f
            {\<lambda> [N,M] i v s. clock s = i + factor N}
*) 
(*The program*)

(*
consts mult::funame       
       m:: vname
       n:: vname
       k:: vname

constdefs iszero::"int \<Rightarrow> int"
"iszero x \<equiv> (if x = 0 then 1 else 0)"

(*in the second and third primops, m is only used as a dummy*)
constdefs multBody :: letexpr
"multBody \<equiv>  LET m = (Primop (\<lambda> x y . x + y) m n) ;
                  n = (Primop (\<lambda> x y . x - 1) n m) ;
                  k = (Primop (\<lambda> x y. iszero x) n m) 
              IN
                IF k THEN (RETURN m) ELSE (CALL mult)
              END"

constdefs factorMult :: nat
"factorMult \<equiv> 14"

(*"Axiom", also refining the const body*)
constdefs AXIOM:: "bool"
"AXIOM \<equiv> n ~= m & m ~= k & n ~= k & funtable mult = multBody"

(*Constructing the hoare triple - value N is a "global" input"*)
constdefs TRIPLE_MULT::"nat \<Rightarrow> nat \<Rightarrow> (val list) Ltriple"
"TRIPLE_MULT N i ==
   ltriple (\<lambda> z s. time i s \<and> s<n>=Some (val.Int (int N)) \<and> 0 < N)
           (Call mult)
           (\<lambda> z v s. time ((Suc i) + factorMult * N) s)"

(*Semantic validity of the triple -- independent from any input! Proof is by
  induction on the external parameter N"*)
lemma Triple_Mult_Valid: "\<forall> i. AXIOM \<longrightarrow> Lvalid (TRIPLE_MULT N i)"
apply(induct_tac N)
apply(auto)
apply(simp add: TRIPLE_MULT_def)
apply(simp add: TRIPLE_MULT_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def AXIOM_def multBody_def varupdate_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def varupdate_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def varupdate_def)
apply(auto)
apply(case_tac "m=n")
apply(auto)
apply(simp_all add: iszero_def)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def varupdate_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def varupdate_def)
apply(auto)
apply(case_tac "na = 0")
apply(auto)
apply(simp add: time_def factorMult_def)
apply(case_tac "na = 0")
apply(auto)
apply(subgoal_tac "time ((Suc 9) + (clock sa) + factorMult * na) s2a")
apply(simp add: time_def factorMult_def)
apply(simp add: time_def)
apply(auto)
apply(subgoal_tac 
  "clock s2a = Suc (clock ((sa\<lparr>clock := clock sa + 3, store := store sa(m\<mapsto>val.Int (i1 + (1 + int na))), clock := 6 + clock sa,
                store := store sa(m\<mapsto>val.Int (i1 + (1 + int na)))(n\<mapsto>val.Int (int na)), clock := 9 + clock sa,
                store := store sa(m\<mapsto>val.Int (i1 + (1 + int na)))(n\<mapsto>val.Int (int na))(k\<mapsto>val.Int 0)\<rparr>)) + factorMult * na)")
apply(simp)
apply(subgoal_tac 
  "store (sa\<lparr>clock := clock sa + 3, store := store sa(m\<mapsto>val.Int (i1 + (1 + int na))), clock := 6 + clock sa,
                           store := store sa(m\<mapsto>val.Int (i1 + (1 + int na)))(n\<mapsto>val.Int (int na)), clock := 9 + clock sa,
                           store := store sa(m\<mapsto>val.Int (i1 + (1 + int na)))(n\<mapsto>val.Int (int na))(k\<mapsto>val.Int 0)\<rparr>
         ) n = Some (val.Int (int na))")
prefer 2
apply(simp)
apply(blast)
done
(* OK *)

(* Example: divides (check whether x divides y, using z as aux var for divisor)
   fun f(x,y,z) = if z>y
                    then 0
                    else let 
                             yy = mult x z
                         in 
                           if yy=y
                             then 1
                             else let
                                    zz = z+1
                                    z = zz
                                  in
                                    f
                                  end                           
                         end         

  satisfies {\<lambda> [Y] i s. s<y> = Y & s<x> = X & Y>X & X>0 & clock s = i}
            Call f
            {\<lambda> [Y] i v s. clock s <=  Succ Y + factorDvd * X}
*) 

consts divides :: funame       
       divides2 :: funame       
       divides3 :: funame       
       x :: vname
       y :: vname
       z :: vname
       (* aux int vars *)
       xx :: vname
       yy :: vname
       zz :: vname
       (* aux bool vars *)
       q1 :: vname
       q2 :: vname
       (* bool consts (sort-of) *)
       tt :: vname
       ff :: vname

(* for some f*&@ing reason CALL doesn't seem to work any more *)
constdefs dividesBody3 :: letexpr
"dividesBody3 \<equiv> LET
                   zz = Primop (\<lambda> x y. x + 1) z z ; 
                   z = Var zz
                 IN
                   (Call divides)
                 END"

constdefs dividesBody2 :: letexpr
"dividesBody2 \<equiv> LET
                  n = Var x ;
                  m = Var z ;
                  yy = Call mult ;
                  q2 = Primop (\<lambda> x y. if x=y then 1 else 0) yy y ;
                  tt = expr.Int 1
                 IN
                  IF q2
                    THEN tt
                    ELSE dividesBody3
                 END"

constdefs dividesBody :: letexpr
"dividesBody \<equiv> LET 
                  q1 = (Primop (\<lambda> r s. if (r<s) then (0::int) else (1::int)) z y) ;
                  ff = (expr.Int 0)
                IN
                  IF q1 THEN (RETURN ff) ELSE (CALL dividesBody2)
                END"

*)