theory Ex2 = ToyGrailDef + LIST + IntDef:

(*
import IntDef(int)
*)

datatype bonzoval =
   BonzoVoid
 | BonzoNull
 | BonzoInt  int 
 | BonzoRef  locn

(*----------------------------PART I: assertions --------------------------*)
types preAss = "state \<Rightarrow> bool"
types postAss = "val \<Rightarrow> state \<Rightarrow> bool"

(*assertions with auxiliary variables/values*)
types
'a preAssAV = "'a \<Rightarrow> preAss"
'a postAssAV = "'a \<Rightarrow> postAss"

(*Hoare triples for expressions and letexpressions, and their
  semantic validity (partial correctness)*)
datatype 'a Etriple = etriple "'a preAssAV" "expr" "'a postAssAV"

consts Evalid::"'a Etriple \<Rightarrow> bool"
primrec
"Evalid (etriple P e Q) = (\<forall> s t v. (\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (\<forall> z. (P z s \<longrightarrow> Q z v t))))" 

datatype 'a Ltriple = ltriple "'a preAssAV" "letexpr" "'a postAssAV"
 
consts Lvalid:: "('a Ltriple) \<Rightarrow> bool"
primrec
"Lvalid (ltriple P l Q) = (\<forall> s t v. (\<langle>s,l\<rangle> \<longrightarrow>l \<langle>v,t\<rangle> \<longrightarrow> (\<forall> z. (P z s \<longrightarrow> Q z v t))))"

(* II. Example program: count occurences *)

(* Grail code should be something like this:
   fun f(xs,z,n) = 
             if isnil xs
               then n
               else 
                   let y  = getfield head xs
                       ys = getfield tail xs
                       xs = ys
                   in if y=z
                        then let m = n+1 
                                 n = m
                             in 
                               f(xs,z,n) 
                             end
                        else f(xs,z,n)
                   end

  satisfies {\<lambda> [N] i s. s<xs> = O1 & N > 0 & clock s = i}
            Call f
            {\<lambda> [N] i v s. clock s = i + factor N}
*) 

constdefs bool2int :: "bool \<Rightarrow> int"
 "bool2int x  \<equiv> case x of True  => (int 1) | False => (int 0)"

(*
constdefs valtoGalaxyClass :: "val \<Rightarrow> int"
 "valtoGalaxyClass \<equiv> \<lambda> x . case x of Void => (int 99) | Null => (int 1701)"
*)
(*
constdefs val2int :: "val \<Rightarrow> int"
 "val2int = \<lambda> x .  case x of BonzoVoid => (int 99) | BonzoNull => (int 1701) | qqq (BonzoInt n) => n | (BonzoRef l) => (int l)"

constdefs val2int :: "bonzoval \<Rightarrow> bool"
 "val2int BonzoVoid   = False
  val2int BonzoNull   = False
  val2int (BonzoInt n) = True
  val2int (BonzoRef l) = True"
*)

consts fn :: funame       
       m  :: vname
       n  :: vname
       xs :: vname
       y  :: vname
       ys :: vname
       z  :: vname
       baseCase :: vname
       found :: vname

constdefs fnbody2 ::letexpr
"fnbody2 == LET y  = (GetF xs LIST.head) ;
                ys = (GetF xs LIST.tail) ;
                xs = expr.Var ys ; 
                found = (Primop (\<lambda> x y. if x=y then 1 else 0) y z)
            IN
             IF found
               THEN LET
                      m = (Primop (\<lambda> x y . x + 1) n n) ;
                      n = expr.Var m
                    IN
                      CALL fn
                    END
               ELSE (CALL fn)
           END"

constdefs fnbody::letexpr
"fnbody == LET
             baseCase = (Primop (\<lambda> x y . isnil x) xs xs)
           IN 
             IF baseCase
               THEN RETURN n
               ELSE fnbody2
           END"


constdefs factor::nat
"factor == 14"

(*"Axiom", also refining the const body*)
constdefs AXIOM:: "bool"
"AXIOM == n ~= m & m ~= xs & xs ~= ys & ys ~= y & y ~= z & funtable fn = fnbody"

constdefs time::"nat \<Rightarrow> state \<Rightarrow> bool"
"time i s == clock s = i"

constdefs timeVoid::"nat \<Rightarrow> 'a Etriple"
"timeVoid i == etriple (\<lambda> z. time i) (expr.Void) (\<lambda> z v. time (Suc i))"

(*Constructing the hoare triple - value N is a "global" input"*)
constdefs TRIPLE1::"nat \<Rightarrow> nat \<Rightarrow> (val list) Ltriple"
"TRIPLE1 N i ==
   ltriple (\<lambda> z s. time i s \<and> s<n>=Some (val.Int (int N)) \<and> 0 < N)
           (Call fn)
           (\<lambda> z v s. time ((Suc i) + factor * N) s)"

(*Semantic validity of the triple -- independent from any input! Proof is by
  induction on the external parameter N"*)

lemma Triple1_Valid: "\<forall> i. AXIOM \<longrightarrow> Lvalid (TRIPLE1 N i)"
(* to be continued ... *)
