theory Ex2 = ToyGrailDef + LIST:

(*----------------------------PART I: assertions --------------------------*)
types preAss = "state \<Rightarrow> bool"
types postAss = "val \<Rightarrow> state \<Rightarrow> bool"

(*assertions with auxiliary variables/values*)
types
'a preAssAV = "'a \<Rightarrow> preAss"
'a postAssAV = "'a \<Rightarrow> postAss"

(*Hoare triples for expressions and letexpressions, and their
  semantic validity (partial correctness)*)
datatype 'a Etriple = etriple "'a preAssAV" "expr" "'a postAssAV"

consts Evalid::"'a Etriple \<Rightarrow> bool"
primrec
"Evalid (etriple P e Q) = (\<forall> s t v. (\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (\<forall> z. (P z s \<longrightarrow> Q z v t))))" 

datatype 'a Ltriple = ltriple "'a preAssAV" "letexpr" "'a postAssAV"
 
consts Lvalid:: "('a Ltriple) \<Rightarrow> bool"
primrec
"Lvalid (ltriple P l Q) = (\<forall> s t v. (\<langle>s,l\<rangle> \<longrightarrow>l \<langle>v,t\<rangle> \<longrightarrow> (\<forall> z. (P z s \<longrightarrow> Q z v t))))"

(*A simple predicate for time, auxiliary functions for producing simple
  Etriples for all expressions with the clock ticks as given in the op sem.
  Each constructed etriple is proven semantically valid.*)

constdefs time::"nat \<Rightarrow> state \<Rightarrow> bool"
"time i s == clock s = i"

constdefs timeVoid::"nat \<Rightarrow> 'a Etriple"
"timeVoid i == etriple (\<lambda> z. time i) (expr.Void) (\<lambda> z v. time (Suc i))"

(* II. Example program: ------------------------------------------------------------  *)

(* Aux fct: mult (using Lennart's proof)
   fun f(n,m) = let m = m + n
                    n = n - 1
                in  if n=0 then m else f(n,m)
  satisfies {\<lambda> [N,M] i s. s<n> = N & N > 0 & clock s = i}
            Result Call f
            {\<lambda> [N,M] i v s. clock s = i + factor N}
*) 
(*The program*)
consts mult::funame       
       m:: vname
       n:: vname
       k:: vname

constdefs iszero::"int \<Rightarrow> int"
"iszero x == (if x = 0 then 1 else 0)"

(*in the second and third primops, m is only used as a dummy*)
constdefs multBody :: letexpr
"multBody ==  LET m = (Primop (\<lambda> x y . x + y) m n) ;
                  n = (Primop (\<lambda> x y . x - 1) n m) ;
                  k = (Primop (\<lambda> x y. iszero x) n m) 
              IN
                IF k THEN (RETURN m) ELSE (CALL mult)
              END"

constdefs factorMult :: nat
"factorMult == 14"

(*"Axiom", also refining the const body*)
constdefs AXIOM:: "bool"
"AXIOM == n ~= m & m ~= k & n ~= k & funtable mult = multBody"

(*Constructing the hoare triple - value N is a "global" input"*)
constdefs TRIPLE_MULT::"nat \<Rightarrow> nat \<Rightarrow> (val list) Ltriple"
"TRIPLE_MULT N i ==
   ltriple (\<lambda> z s. time i s \<and> s<n>=Some (val.Int (int N)) \<and> 0 < N)
           (Call mult)
           (\<lambda> z v s. time ((Suc i) + factorMult * N) s)"

(*Semantic validity of the triple -- independent from any input! Proof is by
  induction on the external parameter N"*)
lemma Triple_Mult_Valid: "\<forall> i. AXIOM \<longrightarrow> Lvalid (TRIPLE_MULT N i)"
apply(induct_tac N)
apply(auto)
apply(simp add: TRIPLE_MULT_def)
apply(simp add: TRIPLE_MULT_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def AXIOM_def multBody_def varupdate_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def varupdate_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def varupdate_def)
apply(auto)
apply(case_tac "m=n")
apply(auto)
apply(simp_all add: iszero_def)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def varupdate_def)
apply(auto)
apply(erule evalexpr_evallet.elims)
apply(simp_all add: tickn_def get_var_def varupdate_def)
apply(auto)
apply(case_tac "na = 0")
apply(auto)
apply(simp add: time_def factorMult_def)
apply(case_tac "na = 0")
apply(auto)
apply(subgoal_tac "time ((Suc 9) + (clock sa) + factorMult * na) s2a")
apply(simp add: time_def factorMult_def)
apply(simp add: time_def)
apply(auto)
apply(subgoal_tac 
  "clock s2a = Suc (clock ((sa\<lparr>clock := clock sa + 3, store := store sa(m\<mapsto>val.Int (i1 + (1 + int na))), clock := 6 + clock sa,
                store := store sa(m\<mapsto>val.Int (i1 + (1 + int na)))(n\<mapsto>val.Int (int na)), clock := 9 + clock sa,
                store := store sa(m\<mapsto>val.Int (i1 + (1 + int na)))(n\<mapsto>val.Int (int na))(k\<mapsto>val.Int 0)\<rparr>)) + factorMult * na)")
apply(simp)
apply(subgoal_tac 
  "store (sa\<lparr>clock := clock sa + 3, store := store sa(m\<mapsto>val.Int (i1 + (1 + int na))), clock := 6 + clock sa,
                           store := store sa(m\<mapsto>val.Int (i1 + (1 + int na)))(n\<mapsto>val.Int (int na)), clock := 9 + clock sa,
                           store := store sa(m\<mapsto>val.Int (i1 + (1 + int na)))(n\<mapsto>val.Int (int na))(k\<mapsto>val.Int 0)\<rparr>
         ) n = Some (val.Int (int na))")
prefer 2
apply(simp)
apply(blast)
done
(* OK *)

(* Example: divides (check whether x divides y, using z as aux var for divisor)
   fun f(x,y,z) = if z>y
                    then 0
                    else let 
                             yy = mult x z
                         in 
                           if yy=y
                             then 1
                             else let
                                    zz = z+1
                                    z = zz
                                  in
                                    f
                                  end                           
                         end         

  satisfies {\<lambda> [Y] i s. s<y> = Y & s<x> = X & Y>X & X>0 & clock s = i}
            Call f
            {\<lambda> [Y] i v s. clock s <=  Succ Y + factorMult X}
*) 

consts divides :: funame       
       divides2 :: funame       
       divides3 :: funame       
       x :: vname
       y :: vname
       z :: vname
       (* aux int vars *)
       xx :: vname
       yy :: vname
       zz :: vname
       (* aux bool vars *)
       q1 :: vname
       q2 :: vname
       (* bool consts (sort-of) *)
       tt :: vname
       ff :: vname

(* for some f*&@ing reason CALL doesn't seem to work any more *)
constdefs dividesBody3 :: letexpr
"dividesBody3 == LET
                   zz = Primop (\<lambda> x y. x + 1) z z ; 
                   z = Var zz
                 IN
                   (Call divides)
                 END"

constdefs dividesBody2 :: letexpr
"dividesBody2 == LET
                  n = Var x ;
                  m = Var z ;
                  yy = Call mult ;
                  q2 = Primop (\<lambda> x y. if x=y then 1 else 0) yy y ;
                  tt = expr.Int 1
                 IN
                  IF q2
                    THEN tt
                    ELSE dividesBody3
                 END"

constdefs dividesBody :: letexpr
"dividesBody == LET 
                  q1 = (Primop (\<lambda> r s. if (r<s) then (0::int) else (1::int)) z y) ;
                  ff = (expr.Int 0)
                IN
                  IF q1 THEN (RETURN ff) ELSE (CALL dividesBody2)
                END"

