theory Ex1 = (* LIST + *) ToyGrailDef:

(* THIS SHOULD DEFINITELY BE SOMEWHERE ELSE DAMNIT*)
constdefs emptyState :: "state"
"emptyState == (| heap = empty, store = empty, framestack = [],
                 maxstack = 0, clock = 0 |)"
                 

consts i :: "vname"
consts j :: "vname"
consts k :: "vname"
consts z :: "vname"

consts inc:: "funame"

(* generic error thingie *)
consts error :: "letexpr"

(* requires input i to be set in the state *)
constdefs main :: "letexpr"
"main == (CALL inc)"
(* Let i (expr.Int 1)  *)

(* da: how does the below type check? *)
constdefs incBody :: "letexpr"
"incBody == LET j = (Primop (\<lambda> x y . x+1) i i) ; 
                i = (Var j)
            IN
            (RETURN i) END"

constdefs my_store :: store
 "my_store == empty (i \<mapsto> (val.Int 1))"

constdefs my_funtable :: "funame \<Rightarrow> letexpr"
 "my_funtable x == if x=inc then incBody else error"

constdefs my_heap :: "heap"
 "my_heap == empty"

constdefs my_state :: "state"
 "my_state == \<lparr> heap = my_heap , store = my_store, framestack = [], 
               maxstack = 0, clock = 0 \<rparr>"

lemma store_tick_invar: "\<forall> s . \<forall> n . store (tickn n s) = store s"
by (unfold tickn_def, simp)

lemma heap_tick_invar: "\<forall> s . \<forall> n . heap (tickn n s) = heap s"
by (unfold tickn_def, simp)

lemma maxstack_tick_invar: "\<forall> s . \<forall> n . maxstack (tickn n s) = maxstack s"
by (unfold tickn_def, simp)

lemma currstack_tick_invar: "\<forall> s . \<forall> n . framestack (tickn n s) = framestack s"
by (unfold tickn_def, simp)

lemma clock_tickn: "\<forall> s . \<forall> n . clock (tickn n s) = n + (clock s)"
by (unfold tickn_def, simp)

lemma emptyState_clock: "clock emptyState = 0"
by (unfold emptyState_def, simp)

constdefs 
  needsTime :: "letexpr \<Rightarrow> nat \<Rightarrow> bool"
 "needsTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>emptyState, c\<rangle> \<longrightarrow>l \<langle>v,s\<rangle>) & (clock s) = n))"

  boundedTime :: "letexpr \<Rightarrow> nat \<Rightarrow> bool"
 "boundedTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>emptyState, c\<rangle> \<longrightarrow>l \<langle>v,s\<rangle>) & (clock s) <= n))"

  needsTimeWithState :: "state \<Rightarrow> letexpr \<Rightarrow> nat \<Rightarrow> bool"
 "needsTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>s,c\<rangle> \<longrightarrow>l \<langle>v,s'\<rangle>) & (clock s') = n))"

  boundedTimeWithState :: "state \<Rightarrow> letexpr \<Rightarrow> nat \<Rightarrow> bool"
 "boundedTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>s,c\<rangle> \<longrightarrow>l \<langle>v,s'\<rangle>) & (clock s') <= n))"

  bTWSE :: "state \<Rightarrow> expr \<Rightarrow> nat \<Rightarrow> bool"
 "bTWSE \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>s,c\<rangle> \<longrightarrow>e \<langle>v,s'\<rangle>) & (clock s') <= n))"

lemma "[| ToyGrailDef.funtable = my_funtable |] ==> boundedTimeWithState my_state (CALL inc) 4"
apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (unfold my_state_def my_store_def my_heap_def main_def)
apply (rule evalCall)
apply (simp_all)
apply (unfold my_funtable_def)
apply (simp)
apply (unfold incBody_def)
apply (rule evalLet)
apply (rule evalPrimop)
apply (unfold get_var_def)
apply (auto)
apply (unfold varupdate_def)
apply (rule evalLet)
apply (rule evalVar)
apply (unfold get_var_def)
apply (auto)
apply (unfold varupdate_def)
apply (rule evalRet)
apply (unfold get_var_def)
apply (auto)
apply (simp add: clock_tickn)
(* False *)
oops

lemma "[| ToyGrailDef.funtable = my_funtable |] ==> boundedTimeWithState my_state (Call inc) 10"
apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (unfold my_state_def my_store_def my_heap_def main_def)
apply (rule evalCall)
apply (simp_all)
apply (unfold my_funtable_def)
apply (simp)
apply (unfold incBody_def)
apply (rule evalLet)
apply (rule evalPrimop)
apply (unfold get_var_def)
apply (auto)
apply (unfold varupdate_def)
apply (rule evalLet)
apply (rule evalVar)
apply (unfold get_var_def)
apply (auto)
apply (unfold varupdate_def)
apply (rule evalRet)
apply (unfold get_var_def)
apply (auto)
apply (simp add: clock_tickn)
done
(* OK *)

lemma "[| ToyGrailDef.funtable = my_funtable |] ==> \<forall> q::int . boundedTime (LET i = (expr.Int q) IN (CALL inc) END) 10"
apply (unfold boundedTime_def)
apply (rule allI)+
apply (rule exI)+
apply (rule conjI)
apply (rule evalLet)
apply (rule evalInt)
apply (unfold varupdate_def)
apply (rule evalCall)
apply (simp_all)
apply (unfold my_funtable_def)
apply (simp)
apply (unfold incBody_def)
apply (rule evalLet)
apply (rule evalPrimop)
apply (unfold get_var_def)
apply (auto)
apply (unfold varupdate_def)
apply (rule evalLet)
apply (rule evalVar)
apply (unfold get_var_def)
apply (simp)
apply (unfold varupdate_def)
apply (rule evalRet)
apply (unfold get_var_def)
(* see 1-liner below *)
apply (simp add: store_tick_invar clock_tickn)
apply (simp only: clock_tickn)
apply (simp)
apply (simp only: clock_tickn)
apply (simp)
apply (simp only: clock_tickn)
apply (simp)
apply (simp only: clock_tickn)
apply (simp)
apply (simp only: emptyState_clock)
done
(* OK *)

(* NB: using the following 1-liner should be cool in general:
apply (simp add: store_tick_invar emptyState_clock clock_tickn)+
*)

end
