(*  Examples from List.cmlt -> Grail*)

theory CmltList = ToyVCG:

(*Accumulator-style length function in Camelot 
  (the version without accumulator would not be tail resursive, so it would use invoke\<dots>) :
  let lngth i l = match l with Nil => i | Cons (h, t) => lngth (1 + i) t

  Our compiler currently emits the following Grail:
  method public static int lngth (int i, List$dia_0 l) =
   let
      fun f:lngth(List$dia_0 l, int ?t3, int h, List$dia_0 t, List$dia_0 l, int i) =
      let
         val tag = getfield l <int List$dia_0.$>
      in
         if tag = 0
         then f:0(l, ?t3, h, t, l, i)
         else f:1(l, ?t3, h, t, l, i)
      end

      fun f:1(List$dia_0 l, int ?t3, int h, List$dia_0 t, List$dia_0 l, int i) =
      let
         val h = getfield l <int List$dia_0.f1>
         val t = getfield l <List$dia_0 List$dia_0.f0>
         val ?t3 = add 1 i
      in
         invokestatic <int List.lngth (int, List$dia_0)> (?t3, t)
      end

      fun f:0(List$dia_0 l, int ?t3, int h, List$dia_0 t, List$dia_0 l, int i) =
         i
   in
      f:lngth(l, ?t3, h, t, l, i)
   end

  The essence of this is the following ToyGrail: 
  method lngth(int i, List l) =
            fun f(i,l) = let tag = l.$
                             b = ISZERO tag
                         in if b then i else let h = l.HD
                                                 l = l.TL
                                                 i = i + 1
                                             in f (i,l)
*)

consts LST     :: cname     (*these consts, and models, should be in the locale\<dots>*)
       TAG     :: ifldname
       HD      :: ifldname
       TL      :: rfldname

consts models::"(int list \<times> ref \<times> state) set"
inductive models intros
  NIL:  "\<lbrakk>\<exists> ifld rfld . (s\<lless>l\<ggreater> = Some (LST,ifld,rfld) \<and> ifld TAG = 0)\<rbrakk>\<Longrightarrow> ([],Ref l, s) \<in> models"
  CONS: "\<lbrakk>\<exists> ifld rfld tt . (s\<lless>l\<ggreater> = Some (LST,ifld,rfld) \<and> ifld TAG = 1 \<and> ifld HD = h \<and> rfld TL = tt \<and> (t,tt,s) \<in> models)\<rbrakk>
        \<Longrightarrow> ( h # t, Ref l,s) \<in> models"
lemma NIL_I : "s\<lless>l\<ggreater> = Some (LST,ifld,rfld) \<and> ifld TAG = 0 \<Longrightarrow> ([],Ref l, s) \<in> models" by(rule NIL, auto)
lemma CONS_I: "s\<lless>l\<ggreater> = Some (LST,ifld,rfld) \<and> ifld TAG = 1 \<and> ifld HD = h \<and> rfld TL = t \<and> (tt,t,s) \<in> models
        \<Longrightarrow> ( h # tt, Ref l,s) \<in> models" by(rule CONS, auto)
lemma NIL_E:  "([],Ref l, s) \<in> models \<Longrightarrow> (\<exists> ifld rfld . (s\<lless>l\<ggreater> = Some (LST,ifld,rfld) \<and> ifld TAG = 0))" 
               by(erule models.elims,auto)
lemma CONS_E: "(h # t, Ref l,s) \<in> models \<Longrightarrow> 
               (\<exists> ifld rfld tt . (s\<lless>l\<ggreater> = Some (LST,ifld,rfld) \<and> ifld TAG = 1 \<and> ifld HD = h \<and> rfld TL = tt \<and> (t,tt,s) \<in> models))"
               by(erule models.elims,auto)

(*The following are VERY useful lemmas, we should generate them automatically, together  with the models relation.*)
lemma modelsTick[simp]: "\<forall> r s n . ((L,r,s) \<in> models \<longrightarrow> (L,r, tickn n s) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)

lemma modelsIvarupdate[simp]: "\<forall> r s v val . ((L,r,s) \<in> models \<longrightarrow> (L,r, ivarupdate s v val) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)

lemma modelsRvarupdate[simp]: "\<forall> r s v val . ((L,r,s) \<in> models \<longrightarrow> (L,r, rvarupdate s v val) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)

lemma modelsIncrcallcount[simp]: "\<forall> r s . ((L,r,s) \<in> models \<longrightarrow> (L,r, incrcallcount s) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)

locale lngth1 = 
  fixes    tag     :: iname
    and	   h       :: iname
    and    i       :: iname
    and	   b       :: iname
    and    l       :: rname
    and	   f       :: funame
    and	   fBody   :: expr
 defines  "fBody == LET tag = GetFi l TAG;
                        b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                    IN IF b THEN IVar i ELSE LET  h = GetFi l HD;
                                                  i = Primop (% x y. x + 1) i i;
                                                  rf l = GetFr l TL 
					     IN 
						Call f
                                             END
                    END"
  assumes  fbdy[simp]:  "funtable f = fBody"
      and  wfmeasure [simp]:  
          "fun_wfmeasure_table f = inv_image less_than (\<lambda> s. THE M. (\<exists>  L . (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> length L = M))"

      and  vardistinct:       "distinct [tag,h,i,b,I] \<and> distinct [I,b,i,h,tag]"

      and  preAss[simp]:    "fun_preassn_table f = {(N,s). (\<exists> L . (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> int (length L) + (s<i>) = N) }"
      and  postAss[simp]:   "fun_postassn_table f = {(N,s,v) . v = IVal N}"

declare (in lngth1) fBody_def [simp]

lemma (in lngth1) 
   "\<Turnstile> {(N,s). (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> s<i> = 0 \<and> 0 <= N \<and> length L = nat N}
	(CALL f) 
      {(N,s,v) . v = IVal N}"
apply (insert vardistinct)
apply hoare_rec 
defer 1 
apply fastsimp
apply fastsimp
apply hoare_simp
apply(erule_tac models.elims, auto)
apply(rule_tac x="LST" in exI, rule_tac x="ifld" in exI, auto)
done

constdefs HSize ::"state \<Rightarrow> int"
"HSize s == int (card (fmap_dom (heap s)))"
declare HSize_def [simp]

lemma SizeInsert[simp]: "int (card (insert (freshloc H) H)) = int (card H) + 1"
sorry

(*With HSize and clock the proof gets even simpler!*)
locale lngth2 = 
  fixes    tag     :: iname
    and	   h       :: iname
    and    i       :: iname
    and	   b       :: iname
    and    l       :: rname
    and	   f       :: funame
    and	   fBody   :: expr
 defines  "fBody == LET tag = GetFi l TAG;
                        b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                    IN IF b THEN IVar i ELSE LET  h = GetFi l HD;
                                                  i = Primop (% x y. x + 1) i i; 
                                               rf l = GetFr l TL 
					     IN 
						Call f
                                             END
                    END"
  assumes  fbdy[simp]:  "funtable f = fBody"
      and  wfmeasure [simp]:  
          "fun_wfmeasure_table f = inv_image less_than (\<lambda> s. THE M. (\<exists>  L . (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> length L = M))"

      and  vardistinct:       "distinct [tag,h,i,b] \<and> distinct [b,i,h,tag]"

      and  preAss[simp]:    "fun_preassn_table f = 
                             {((N,C,H),s). (\<exists> L . (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> int (length L) + (s<i>) = N \<and> 
                                                  HSize s = H \<and> clock s = C + 19 * (s<i>)) }"
      and  postAss[simp]:   "fun_postassn_table f = {((N,C,H),s,v) . v = IVal N \<and> HSize s = H \<and> clock s = C + 19 * N + 9}"

declare (in lngth2) fBody_def [simp]

lemma (in lngth2) 
   "\<Turnstile> {((N,C,H),s). (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> s<i> = 0 \<and> 0 <= N \<and> length L = nat N \<and> HSize s = H \<and> clock s = C}
	(CALL f) 
      {((N,C,H),s,v) . v = IVal N \<and> HSize s = H \<and> clock s = C + 19 * N + 9}"
apply (insert vardistinct)
apply hoare_rec 
defer 1 
apply fastsimp
apply fastsimp
apply hoare_simp
apply(erule_tac models.elims, clarsimp)
sorry

(*---------------------Generate list of numbers b..a------------------------*)
(*
Camelot: generates list b..a, but is tail recursive
let genL a b acc = if a = b + 1 then acc else genL (a+1) b (Cons(a,acc))

Grail:
method public static List$dia_0 genL (int a, int b, List$dia_0 acc) =
let fun f:genL(List$dia_0 ?t5, int ?t4, int ?t3, List$dia_0 acc, int b, int a) =
      let val ?t3 = add b 1
      in if a = ?t3
         then f:0(?t5, ?t4, ?t3, acc, b, a)
         else f:1(?t5, ?t4, ?t3, acc, b, a)
      end
    fun f:0(List$dia_0 ?t5, int ?t4, int ?t3, List$dia_0 acc, int b, int a) = acc
    fun f:1(List$dia_0 ?t5, int ?t4, int ?t3, List$dia_0 acc, int b, int a) =
      let val ?t4 = add a 1
         val ?t5 = new <List$dia_0(int, int, List$dia_0)> (1, a, acc)
      in invokestatic <List$dia_0 List.genL (int, int, List$dia_0)> (?t4, b, ?t5)
      end
in f:genL(?t5, ?t4, ?t3, acc, b, a)
end

ToyGrail:
method public static List$dia_0 genL (int a, int b, List$dia_0 acc) =
let fun f:genL(int a, int b, List$dia_0 acc) =
      let val t3 = add b 1
      in if a = t3
         then acc
         else  let val t4 = add a 1
                   val t5 = new <List>$
                   val _ = PutFi t5 TAG 1
                   val _ = PutFi t5 HD a
                   val _ = PutFr t5 TL acc
                   val a = t4
                   val acc = t5
               in f (a, b, acc)
      end
   in f:genL(a, b, acc)
   end
*)

(*(a,A,L) \<in> genSpec if a >= A and L = [a, a-1, \<dots> A]*)
consts genSpec:: "(int \<times> int \<times> (int list)) set"
inductive genSpec intros
genSpec0: "\<lbrakk>a < A\<rbrakk> \<Longrightarrow> (a,A,[]) \<in> genSpec"
genSpec1: "(a,a,[a]) \<in> genSpec"
genSpec2: "\<lbrakk>A < a \<and> (a - 1, A, L) \<in> genSpec\<rbrakk> \<Longrightarrow> (a, A, a # L) \<in> genSpec"
lemma "(5,2,[5,4,3,2]) \<in> genSpec"
apply(rule genSpec2, simp)
apply(rule genSpec2, simp)
apply(rule genSpec2, simp)
by(rule genSpec1)

locale GenL = 
  fixes    a      :: iname
    and	   b       :: iname
    and	   bb      :: iname
    and	   t3      :: iname
    and	   t4      :: iname
    and	   one     :: iname
    and    t5      :: rname
    and    acc     :: rname
    and	   f       :: funame
    and	   fBody   :: expr
 defines  "fBody == LET bb = Primop (% x y. if x = y + 1 then 1 else 0) a b
                    IN IF bb THEN RVar acc ELSE LETR t5 = NEW LST IN
                                                LET  one = expr.Int 1;
                                                     one = PutFi t5 TAG one;
                                                     a   = PutFi t5 HD a IN
                                                LETR acc = PutFr t5 TL acc IN
                                                LET  a   = Primop (% x y. x + 1) a a IN
                                                LETR acc = RVar t5 IN CALL f
                                                END END END END END
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  wfmeasure [simp]:  
          "fun_wfmeasure_table f = inv_image less_than (\<lambda> s. nat (s<b> - (s<a>)))"

      and  vardistinct:  "distinct [a,b,bb,t3,t4,one] \<and> distinct [one,t4,t3,bb,b,a] \<and> 
                          distinct [t5,acc] \<and> distinct [acc,t5]"

      and  preAss[simp]: "fun_preassn_table f = 
                          {(A,s) . (\<exists> L . ((s<a> - 1, A, L) \<in> genSpec \<and> (L, s\<lfloor>acc\<rfloor>, s) \<in> models \<and> s<a> - 1 <= s<b>))}"
      and  postAss[simp]:"fun_postassn_table f = 
                          {(A,s,v) . (\<exists> L r . (v = RVal r \<and> (s<b>, A,L) \<in> genSpec \<and> (L,r,s) \<in> models))}"

declare (in GenL) fBody_def [simp]

lemma (in GenL) 
   "\<Turnstile> {(A,s). (s<a> <= s<b> \<and> s<a> = A \<and> (s<a> - 1, A,[]) \<in> genSpec \<and> ([],s\<lfloor>acc\<rfloor>,s) \<in> models)}
	(CALL f) 
      {(A,s,v) . (\<exists> L r . (v = RVal r \<and> (s<b>, A,L) \<in> genSpec \<and> (L,r,s) \<in> models))}"
apply (insert vardistinct)
apply hoare_rec 
defer 1 
apply fastsimp
apply fastsimp
apply hoare_simp
apply(auto)
apply(rule_tac x="LST" in exI, rule_tac x="emptyi" in exI, rule_tac x="emptyr" in exI)
apply(simp add: emptyobj_def)
apply auto
apply(rule_tac x="(s'<a> ) # L" in exI)
apply(rule, rule genSpec2)apply simp
oops
lemma genSpecProp[simp]: "\<forall> s a A . ((a - 1, A, []) \<in> genSpec \<longrightarrow> A < a)"
apply(clarsimp)
apply(erule genSpec.elims)
apply auto
oops

apply(case_tac "HD = TAG")
defer 1
apply(auto)
apply(case_tac L)
apply(simp, erule_tac models.elims)
apply(clarsimp, rule NIL)
apply(auto)
apply(rule_tac x="ifld" in exI)
apply(rule, rule_tac x="rfld" in exI)
apply(auto)
prefer 2
oops

locale GenL = 
  fixes    a      :: iname
    and	   b       :: iname
    and	   bb      :: iname
    and	   t3      :: iname
    and	   t4      :: iname
    and	   one     :: iname
    and    t5      :: rname
    and    acc     :: rname
    and	   f       :: funame
    and	   fBody   :: expr
 defines  "fBody == LET t3 = Primop (% x y. x + 1) b b;
                        bb = Primop (% x y. if x = y then 1 else 0) a t3
                    IN IF bb THEN RVar acc ELSE LET  t4 =  Primop (% x y. x + 1) a a IN
                                                LETR t5 = NEW LST IN
                                                LET  one = expr.Int 1;
                                                     one = PutFi t5 TAG one;
                                                     a   = PutFi t5 HD a IN
                                                LETR acc = PutFr t5 TL acc IN
                                                LET  a   = IVar t4 IN
                                                LETR acc = RVar t5 IN CALL f
                                                END END END END END END
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  wfmeasure [simp]:  
          "fun_wfmeasure_table f = inv_image less_than (\<lambda> s. nat (s<b> - (s<a>)))"

      and  vardistinct:  "distinct [a,b,bb,t3,t4,one] \<and> distinct [one,t4,t3,bb,b,a] \<and> 
                          distinct [t5,acc] \<and> distinct [acc,t5]"

      and  preAss[simp]: "fun_preassn_table f = 
                          {((A,N),s) . (HSize s = N + (s<a>) - A \<and> A <= s<a> \<and> s<a> <= s<b>)}"
      and  postAss[simp]:"fun_postassn_table f = 
                          {((A,N),s,v) . (HSize s = N + (s<a>) - A \<and> A <= s<a> \<and> s<a> = s<b>)}"
(*
      and  preAss[simp]: "fun_preassn_table f = 
                          {(A,s) . (\<exists> L . ((s<a>, A, L) \<in> genSpec \<and> (L, s\<lfloor>acc\<rfloor>, s) \<in> models \<and> s<a> <= s<b>))}"
      and  postAss[simp]:"fun_postassn_table f = 
                          {(A,s,v) . (\<exists> L r . (v = RVal r \<and> (s<b>, A,L) \<in> genSpec \<and> (L,r,s) \<in> models))}"
*)
declare (in GenL) fBody_def [simp]

lemma (in GenL) 
(*   "\<Turnstile> {(A,s). (s<a>,A,[]) \<in> genSpec \<and> s<a> <= s<b> \<and> ([],s\<lfloor>acc\<rfloor>,s) \<in> models}
	(CALL f) 
      {(A,s,v) . (\<exists> L r . (v = RVal r \<and> (s<b>, A,L) \<in> genSpec \<and> (L,r,s) \<in> models))}"
*)
   "\<Turnstile> {((A,N),s). s<a> <= s<b> \<and> A = s<a> \<and> HSize s = N}
	(CALL f) 
      {((A,N),s,v) . (HSize s = N + (s<a>) - A \<and> A <= s<a> \<and> s<a> = s<b>)}"
apply (insert vardistinct)
apply hoare_rec 
defer 1 
apply fastsimp
apply fastsimp
apply hoare_simp
apply(auto)
apply(rule_tac x="LST" in exI, rule_tac x="emptyi" in exI, rule_tac x="emptyr" in exI)
apply(simp add: emptyobj_def)
apply(auto)
apply(rule_tac x="(s'<a> ) # L" in exI)
apply(rule CONS,simp)
apply(case_tac "HD = TAG")
defer 1
apply(auto)
apply(case_tac L)
apply(simp, erule_tac models.elims)
apply(clarsimp, rule NIL)
apply(auto)
apply(rule_tac x="ifld" in exI)
apply(rule, rule_tac x="rfld" in exI)
apply(auto)
prefer 2

lemma modelsTick[simp]: "HD \<noteq> TAG \<longrightarrow> (\<forall> h t l ob s i . ((h # t,Ref l,s) \<in> models \<and> s\<lless>l\<ggreater> = Some ob \<longrightarrow> 
                                           (i # t,Ref l, obj_ifieldupdate s l ob HD i) \<in> models))"
apply(auto)
apply(erule models.elims, simp_all)
apply(clarsimp)
apply(rule CONS)
apply(auto)
apply(rule_tac x="aa(HD := i)" in exI)
apply(rule_tac x="b" in exI)
apply(auto)
apply(rule_tac x="aa(HD := i)" in exI)
lemma

(* append ---------------------------------------------------------------------*)
(* Camelot:
  let app l m lrev = match l with Nil@d => (match lrev with Nil@e => m
                                                          | Cons(h,t)@e => app (Nil@d) (Cons(h,m)@e) t)
                                | Cons(h,t)@d => app t m (Cons(h,lrev)@d)
Grail:
method public static List$dia_0 app (List$dia_0 l, List$dia_0 m, List$dia_0 lrev) =
   let
      fun f(l, lrev, e, ?t6, e#0, ?t5, d, int h, t, d, ?t7, d#0, int h#0, t#0, m) =
      let
         val tag = getfield l TAG
      in
         if tag = 0
         then f:0(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
         else f:1(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:1(\<dots>) =
      let
         val h#0 = getfield l <int List$dia_0.f1>
         val t#0 = getfield l <List$dia_0 List$dia_0.f0>
         val d#0 = l
         val () = putfield d#0 <int List$dia_0.$> 1
         val () = putfield d#0 <int List$dia_0.f1> h#0
         val () = putfield d#0 <List$dia_0 List$dia_0.f0> lrev
         val ?t7 = d#0
      in
         f:2(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:2(\<dots>) =
         invokestatic <List$dia_0 List.app (List$dia_0, List$dia_0, List$dia_0)> (t#0, m, ?t7)

      fun f:0(\<dots>) =
      let
         val d = l
         val tag = getfield lrev <int List$dia_0.$>
      in
         if tag = 0
         then f:3(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
         else f:4(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:4(\<dots>) =
      let
         val h = getfield lrev <int List$dia_0.f1>
         val t = getfield lrev <List$dia_0 List$dia_0.f0>
         val e#0 = lrev
         val () = putfield d <int List$dia_0.$> 0
         val ?t5 = d
      in
         f:5(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:5() =
      let
         val () = putfield e#0 <int List$dia_0.$> 1
         val () = putfield e#0 <int List$dia_0.f1> h
         val () = putfield e#0 <List$dia_0 List$dia_0.f0> m
         val ?t6 = e#0
      in
         f:6(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:6(\<dots>) =
         invokestatic <List$dia_0 List.app (List$dia_0, List$dia_0, List$dia_0)> (?t5, ?t6, t)

      fun f:3(\<dots>) =
      let
         val e = lrev
      in
         m
      end
   in
      f:app(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
   end

ToyGrail:
method public static List$dia_0 app (List$dia_0 l, List$dia_0 m, List$dia_0 lrev) =
   let
      fun f(l,m,lrev) =
      let
         val tag = getfield l TAG
      in
         if tag = 0
         then let val d = l
                  val tag = getfield lrev TAG
              in if tag = 0
                 then let val e = lrev
                      in m
                      end
                 else let val h = getfield lrev HD
                          val t = getfield lrev TL
                          val e#0 = lrev
                          val () = putfield d TAG 0
                          val ?t5 = d
                          val () = putfield e#0 TAG 1
                          val () = putfield e#0 HD h
                          val () = putfield e#0 TL m
                          val ?t6 = e#0
                      in invokestatic app (?t5, ?t6, t)
                      end
              end
         else let val h#0 = getfield l HD
                  val t#0 = getfield l TL
                  val d#0 = l
                  val () = putfield d#0 TAG 1
                  val () = putfield d#0 HD h#0
                  val () = putfield d#0 TL lrev
                  val ?t7 = d#0
              in invokestatic app (t#0, m, ?t7)
              end
   in
      f(l, m, lrev)
   end
*)
lemma

(*-----------------------------------------------------------------------------*)
(* List reversal:
Camelot:
let rev' l acc = match l with Nil => acc | Cons (h, t) => rev' t (Cons (h, acc)) 

Grail:   
  method public static List$dia_0 rev' (List$dia_0 l, List$dia_0 acc) =
  let

      fun f:rev'(List$dia_0 l, List$dia_0 ?t6, int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) =
      let
         val tag = getfield l <int List$dia_0.$>
      in
         if tag = 0
         then f:0(l, ?t6, h, t, acc, l)
         else f:1(l, ?t6, h, t, acc, l)
      end

      fun f:1(List$dia_0 l, List$dia_0 ?t6, int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) =
      let
         val h = getfield l <int List$dia_0.f1>
         val t = getfield l <List$dia_0 List$dia_0.f0>
         val ?t6 = new <List$dia_0(int, int, List$dia_0)> (1, h, acc)
      in
         invokestatic <List$dia_0 List.rev' (List$dia_0, List$dia_0)> (t, ?t6)
      end

      fun f:0(List$dia_0 l, List$dia_0 ?t6, int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) =
         acc
   in
      f:rev'(l, ?t6, h, t, acc, l)
   end

ToyGrail:
   method public static List rev' (l, acc) =
   let fun f (l, acc) =
       let val tag = getfield l TAG
       in if tag = 0
          then acc
          else let val h = getfield l HD
                   val t = getfield l TL
                   val L = new <List>
                       one   := 1
                       L.TAG := one
                       L.HD  := h 
                       L.TL  := acc
                       l      := t
                       acc    := L
               in f (l, L)
       end

   in
      f(l, acc)
   end
*)

locale RevPrime = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname   and L   :: rname
    and	   f       :: funame   and	   fBody   :: expr
 defines  "fBody == LET tag = GetFi l TAG;
                        b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                    IN IF b THEN RVar acc 
                            ELSE LET  h   = GetFi l HD;
                                      one = expr.Int 1 IN
                                 LETR t   = GetFr l TL IN 
                                 LETR L   = NEW LST IN 
                                 LET  tag = PutFi L TAG one; 
                                      h   = PutFi L HD h IN
                                 LETR acc = PutFr L TL acc IN 
                                 LETR l   = RVar t IN
                                 LETR acc = RVar L IN CALL f 
                                 END END END END END END END 
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  wfmeasure [simp]:  
          "fun_wfmeasure_table f = inv_image less_than (\<lambda> s. THE M. (\<exists>  L . (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> length L = M))"

      and  vardistinct:     "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and> distinct[l,acc,t,L] \<and> distinct [L,t,acc,l]"

      and  preAss[simp]:    "fun_preassn_table f = 
                             {(N,s). (\<exists> L A . (L,s\<lfloor>l\<rfloor>,s) \<in> models \<and> (A,s\<lfloor>acc\<rfloor>,s) \<in> models \<and> A @ (rev L) = rev N)}"
      and  postAss[simp]:   "fun_postassn_table f = 
                             {(N,s,v) . (\<exists> r . v = RVal r \<and> (rev N,r,s) \<in> models)}"

declare (in RevPrime) fBody_def [simp]

lemma (in RevPrime) 
   "\<Turnstile> {(N,s). (N,s\<lfloor>l\<rfloor>,s) \<in> models \<and> ([],s\<lfloor>acc\<rfloor>,s) \<in> models}
	(CALL f) 
      {(N,s,v) . (\<exists> r . v = RVal r \<and> (rev N,r,s) \<in> models)}"
apply (insert vardistinct)
apply hoare_rec 
defer 1 
apply fastsimp
apply fastsimp
apply hoare_simp
apply(erule_tac models.elims, auto)
apply(rule_tac x="LST" in exI, rule_tac x="ifld" in exI, auto)
apply(rule_tac x="LST" in exI, rule_tac x="ifld" in exI, auto)
apply(rule_tac x="LST" in exI, rule_tac x="emptyi" in exI, rule_tac x="emptyr" in exI, auto)
apply(simp add: emptyobj_def)
apply(rule_tac x="ta" in exI, auto)
oops
done

end
