(*  
   File:	$RCSfile: ToyVDMrecBD.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVDMrecBD.thy,v 1.1 2003/07/17 20:01:19 a1hloidl Exp $

   Auxiliary material to help prove soundness of recursive
   rules for partial correctness.
   VDM-style version.
*)   

(* theory ToyVDMrecBD = ToyVDMBD: (* ToyHLbasicBD: *)*)
theory ToyVDMrecBD = ToyVDMBD: 

subsection {* Evalution relation with height *}

(* 
 Code replication warning
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA

 This entire subsection on evaluation with height of derivations is the same
 as in ToyHLrecBD.thy. Eventually only one of VDM and HL should survive. But
 for consistency having just one shared file with evaln would be much much better *)

text {* Annoyingly we need another inductive definition which mentions the
   height of the derivation.  The clock isn't usable for this because of
   the logical rules which do not affect it, and the fact that it isn't
   incremented by exactly one tick for each rule. 
   [FIXME: check this!  Actually we only use it below in the case
    of a callcount increment\<dots>]
 *}

consts
  evalexprn  :: "(state \<times> 'a expr \<times> nat \<times> val \<times> state) set"

syntax
 evalexprn_  :: "[state, 'a expr, nat, val, state] \<Rightarrow> bool"      ("\<langle>_,_\<rangle> \<longrightarrow>_ \<langle>_,_\<rangle>")

translations
 "\<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle>" == "(s,e,n,v,s') : evalexprn"

inductive evalexprn intros
 evalnNull:    "\<langle>s, expr.Null\<rangle>   \<longrightarrow>1  \<langle>RVal Nullref, tick s\<rangle>"

 evalnInt:     "\<langle>s, expr.Int i\<rangle>  \<longrightarrow>1  \<langle>IVal i, tick s\<rangle>"

 evalnIVar:    "\<langle>s, IVar v\<rangle>      \<longrightarrow>1  \<langle>IVal (s<v>), tick s\<rangle>"

 evalnRVar:    "\<langle>s, RVar v\<rangle>      \<longrightarrow>1  \<langle>RVal (s\<lfloor>v\<rfloor>), tick s\<rangle>"

 evalnPrimop:  "\<langle>s, Primop f vn1 vn2\<rangle>  \<longrightarrow>1  \<langle>IVal (f (s<vn1>) (s<vn2>)), tickn 3 s\<rangle>"

 evalnRPrimop: "\<langle>s, RPrimop f vn1 vn2\<rangle> \<longrightarrow>1  \<langle>IVal (f (s\<lfloor>vn1\<rfloor>) (s\<lfloor>vn2\<rfloor>)), tickn 3 s\<rangle>"

 evalnGetFi:   "s\<lfloor>vn\<rfloor> = Ref a  \<Longrightarrow>  \<langle>s,  GetFi vn f\<rangle> \<longrightarrow>1 \<langle>IVal (s<a\<bullet>f>), tickn 2 s\<rangle>"

 evalnGetFr:   "s\<lfloor>vn\<rfloor> = Ref a  \<Longrightarrow>  \<langle>s,  GetFr vn f\<rangle> \<longrightarrow>1 \<langle>RVal (s\<lfloor>a\<diamondsuit>f\<rfloor>), tickn 2 s\<rangle>"

 evalnPutFi:   "s\<lfloor>vn1\<rfloor> = Ref a \<Longrightarrow> 
		\<langle>s, PutFi vn1 f vn2\<rangle> \<longrightarrow>1 \<langle> IVal (s<vn2>), tickn 3 (s<a\<bullet>f := (s<vn2>)>) \<rangle>"

 evalnPutFr:   "s\<lfloor>vn1\<rfloor> = Ref a \<Longrightarrow> 
                \<langle>s, PutFr vn1 f vn2\<rangle> \<longrightarrow>1 \<langle> RVal (s\<lfloor>vn2\<rfloor>), tickn 3 (s\<lfloor>a\<diamondsuit>f := (s\<lfloor>vn2\<rfloor>)\<rfloor>) \<rangle>"

 evalnNew:      "\<langle> s, New c ifldvals rfldvals\<rangle> \<longrightarrow>1 
		\<langle>RVal (Ref (freshlocst s)), tick (newobj s c ifldvals rfldvals)\<rangle>"

 evalnIf_True:  "\<lbrakk> s<v> = grailbool True; 
		  \<langle>tick s, l1\<rangle> \<longrightarrow>n \<langle>rtv, s1\<rangle> \<rbrakk> \<Longrightarrow> \<langle>s, Ifg v l1 l2\<rangle> \<longrightarrow>(n+1) \<langle>rtv, s1\<rangle>"

 evalnIf_False: "\<lbrakk> s<v> = grailbool False; 
		  \<langle>tick s, l2\<rangle> \<longrightarrow>n \<langle>rtv, s1\<rangle> \<rbrakk> \<Longrightarrow> \<langle>s, Ifg v l1 l2\<rangle> \<longrightarrow>(n+1) \<langle>rtv,s1\<rangle>"

 evalnLeti:     "\<lbrakk> \<langle>s, e\<rangle> \<longrightarrow>n \<langle>IVal i, s1\<rangle> ; \<langle>(tick s1)<vn:=i>, ls\<rangle> \<longrightarrow>m \<langle>rtv2, s2\<rangle> \<rbrakk>
	        \<Longrightarrow>
                \<langle>s, Leti vn e ls\<rangle> \<longrightarrow>(max (n+1) (m+1)) \<langle>rtv2, s2\<rangle>"

 evalnLetr:     "\<lbrakk> \<langle>s, e\<rangle> \<longrightarrow>n \<langle>RVal r, s1\<rangle> ; \<langle>(tick s1)\<lfloor>vn:=r\<rfloor>, ls\<rangle> \<longrightarrow>m \<langle>rtv2, s2\<rangle> \<rbrakk>
                \<Longrightarrow>
                \<langle>s, Letr vn e ls\<rangle> \<longrightarrow>(max (n+1) (m+1)) \<langle>rtv2, s2\<rangle>"

 evalnLetv:     "\<lbrakk> \<langle>s, e\<rangle> \<longrightarrow>n \<langle>rtv1, s1\<rangle> ; \<langle>s1, ls\<rangle> \<longrightarrow>m \<langle>rtv2, s2\<rangle> \<rbrakk>
                \<Longrightarrow>
                \<langle>s, Letv e ls\<rangle> \<longrightarrow>(max (n+1) (m+1)) \<langle>rtv2, s2\<rangle>"

 evalnCall:     "\<lbrakk> \<langle>tickcall s, funtable fn\<rangle> \<longrightarrow>n \<langle>rtv, s1\<rangle> \<rbrakk>
                \<Longrightarrow>
                \<langle>s, CALL fn\<rangle> \<longrightarrow>(n+1) \<langle>rtv, s1\<rangle>" 

 evalnInvoke: 
  "\<lbrakk> s\<lfloor>vn1\<rfloor> = Ref a; s\<guillemotleft>a\<guillemotright> = Some C;
     \<langle>newframe s mn (Ref a) (s\<lfloor>vn2\<rfloor>), methtable C mn\<rangle> \<longrightarrow>n \<langle>rtv, s'\<rangle> \<rbrakk>
 \<Longrightarrow>
    \<langle>s , Invoke vn1 mn vn2\<rangle> \<longrightarrow>(n+1) \<langle>rtv, tickn 5 (oldframe s' s) \<rangle>"

 evalnInvokeStatic: 
  "\<lbrakk> \<langle>newframe s mn Nullref (s\<lfloor>vn2\<rfloor>), methtable C mn\<rangle> \<longrightarrow>n \<langle>rtv, s'\<rangle> \<rbrakk>
 \<Longrightarrow>
   \<langle>s , InvokeStatic C mn vn2\<rangle> \<longrightarrow>(n+1) \<langle>rtv, tickn 4 (oldframe s' s) \<rangle>"

 evalnPre:     "\<lbrakk> (* (z,s) \<in> P; *) \<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle> \<rbrakk>    \<Longrightarrow> \<langle>s, Pre P e\<rangle> \<longrightarrow>(n+1) \<langle>v,s'\<rangle>"

 evalnPost:    "\<lbrakk> \<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle> (* (z,s',v) \<in> Q *) \<rbrakk> \<Longrightarrow> \<langle>s, Post Q e\<rangle> \<longrightarrow>(n+1) \<langle>v,s'\<rangle>"
 
 evalnMeasure: "\<lbrakk> \<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle>  (* (s,s') \<in> M *) \<rbrakk>   \<Longrightarrow> \<langle>s, Measure M e\<rangle> \<longrightarrow>(n+1) \<langle>v,s'\<rangle>"

(* FIXME: could we use size of term? *)

section {* Equivalence between operational semantics *}

lemma eval_evaln: "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,s'\<rangle> \<Longrightarrow> (\<exists> n. \<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle>)"
apply (erule evalexpr.induct)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros, assumption)
apply (rule, rule evalexprn.intros, assumption)
apply (rule, rule evalexprn.intros, assumption)
apply (rule, rule evalexprn.intros, assumption)
apply (rule, rule evalexprn.intros)
apply (erule exE, rule, rule evalexprn.intros, assumption, assumption)
apply (erule exE, rule, rule evalexprn.intros, assumption, assumption)
apply (erule exE, erule exE, rule, erule evalnLeti, assumption)
apply (erule exE, erule exE, rule, erule evalnLetr, assumption)
apply (erule exE, erule exE, rule, erule evalnLetv, assumption)
apply (erule exE, rule, rule evalexprn.intros, assumption)
(* apply (erule exE, rule, erule evalexprn.intros, assumption, assumption) *)
apply (erule exE)
apply (rule)
apply (erule evalexprn.intros)
apply (assumption)
apply (assumption)
(* -- *)
apply (erule exE)
apply (rule)
apply (erule evalexprn.intros)
(* -- *)
apply (erule exE)
apply (rule)
apply (erule evalexprn.intros)
(* -- *)
apply (erule exE)
apply (rule)
apply (erule evalexprn.intros)
(* -- *)
apply (erule exE)
apply (rule)
apply (erule evalexprn.intros)
(* -- *)
done

lemma evaln_eval: "\<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle> \<Longrightarrow> \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,s'\<rangle>"
apply (erule evalexprn.induct)
apply (auto intro: evalexpr.intros)+
done

lemma no_zero_height_derivs: "\<langle>s,e\<rangle> \<longrightarrow>0 \<langle>v,s'\<rangle> \<Longrightarrow> False"
apply (erule evalexprn.elims)
apply simp+
done


section {* Relativized validity *}

(* now this is specific to VDM-style
   AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA *)

constdefs
  vdm_validn :: "nat \<Rightarrow> state expr \<Rightarrow> vdmassn \<Rightarrow> bool"       ("\<Turnstile>v\<^sub>_ (1_)/ : (1_)" 50)
  "\<Turnstile>v\<^sub>n e : Q   \<equiv>  (\<forall> m. m<=n \<longrightarrow> (\<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>m \<langle>v,t\<rangle> \<longrightarrow> (s,t,v) \<in> Q))"

lemma VdmIn: 
  "(\<forall> m. m<=n \<longrightarrow> (\<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>m \<langle>v,t\<rangle> \<longrightarrow> (s,t,v) \<in> Q)) \<Longrightarrow> \<Turnstile>v\<^sub>n e : Q"
by (unfold vdm_validn_def, auto)

lemma lowerm: "\<lbrakk>   \<Turnstile>v\<^sub>n e : Q; m <= n \<rbrakk> \<Longrightarrow> \<Turnstile>v\<^sub>m  e : Q"
apply (simp (no_asm) add: vdm_validn_def)
apply (rule, rule)
apply (unfold vdm_validn_def)
apply (erule_tac x=ma in allE)
apply auto
done

lemma valid_validn: "\<Turnstile>\<^sub>v e : Q \<Longrightarrow> \<forall> n. \<Turnstile>v\<^sub>n e : Q"
apply (rule allI, rule VdmIn)
apply clarify
apply (erule VdmE)
apply (rule evaln_eval)
apply auto
done

lemma validn_valid: "\<forall> n. \<Turnstile>v\<^sub>n e : Q \<Longrightarrow> \<Turnstile>\<^sub>v e : Q"
apply (simp add: vdm_valid_def)
apply clarify
apply (drule eval_evaln)
apply (erule exE)
apply (erule_tac x=n in allE)
apply (simp add: vdm_validn_def)
apply auto
done

lemma validsucn_validn: "(\<Turnstile>v\<^sub>(n+1) e : Q) \<longrightarrow> \<Turnstile>v\<^sub>n  e : Q"
apply (subgoal_tac "n<n+1")
apply (rule impI)
apply (rotate_tac 1)
apply (rule lowerm)
apply auto
done

inductive_cases evalCalln_cases : "(s, Call fn, n, v, s') \<in> evalexprn"

(* (\<lambda> (s,s',v). (tickcall s,s',v)) ` Q)  *)
(* {(s,s',v). \<exists> t . s = tickcall t \<and> (t,s',v) \<in> Q} *)
(* (vdmimagepre tickcall Q) *)
lemma calllemma[rule_format(no_asm)]: 
  "(\<forall> m. m<n \<longrightarrow> (\<Turnstile>v\<^sub>m (CALL fn) : Q) \<longrightarrow> (\<Turnstile>v\<^sub>m (funtable fn) : (vdmimagepre tickcall Q))) 
		\<longrightarrow> (\<Turnstile>v\<^sub>n (CALL fn) : Q)"
apply (induct_tac n)
apply (simp add: vdm_validn_def)
apply (clarify, drule no_zero_height_derivs, auto)
apply (simp (no_asm) add: vdm_validn_def)
apply (rule, case_tac "m=Suc n") (* interesting case first *)
 apply rule
 apply clarsimp
 apply (erule evalCalln_cases)
 apply (erule_tac x=n in allE)
 apply simp
 apply (erule thin_rl)
 apply (simp add: vdm_validn_def)
 (*
 apply (erule_tac x=n in allE)
 apply (erule_tac x=n in allE)
 *)
 (* apply (simp add: image_def) *)
 apply clarsimp
 apply (erule_tac x=na in allE)
 apply clarsimp
 apply (erule_tac x="tick (incrcallcount s)" in allE)
 apply (erule_tac x=t in allE)
 apply (erule_tac x=v in allE)
 apply clarsimp
 apply (erule thin_rl)
 apply (simp add: tickn_def incrcallcount_def)
 (* apply (insert tickcall_inj) *)
 apply (subgoal_tac "s = a")
  apply clarsimp
  (* -- *)
  apply (rule_tac r=s in state.cases)
  apply (rule_tac r=a in state.cases)
  apply auto
 (* apply clarsimp *)
 apply (simp add: vdm_validn_def)
 apply (erule_tac x=m in allE)
 apply (erule_tac x=m in allE)
 apply clarsimp
done

inductive_cases evalInvokeStaticn_cases : "(s, InvokeStatic cn mn vn, n, v, s') \<in> evalexprn"

lemma invokestaticlemma[rule_format(no_asm)]: 
   "(\<forall> m. m<n \<longrightarrow> (\<Turnstile>v\<^sub>m (InvokeStatic cn mn vn) : Q) \<longrightarrow> 
                       (\<forall> s_init.
                         \<Turnstile>v\<^sub>m (methtable cn mn) : 
                            {(s,s',v). (s_init,tickn 4 (oldframe s' s_init),v) \<in> Q \<and> 
                                       s = newframe s_init mn Nullref (s_init\<lfloor>vn\<rfloor>)}) )
   \<longrightarrow> (\<Turnstile>v\<^sub>n (InvokeStatic cn mn vn) : Q)"
apply (induct_tac n)
apply (simp add: vdm_validn_def)
apply (clarify, drule no_zero_height_derivs, auto)
apply (simp (no_asm) add: vdm_validn_def)
apply (rule, case_tac "m=Suc n") (* interesting case first *)
 apply rule
 apply clarsimp
 apply (erule evalInvokeStaticn_cases)
 apply (erule_tac x=n in allE)
 apply simp
 (* apply (erule thin_rl) *)
 apply (simp add: vdm_validn_def)
 apply clarsimp
 apply (erule_tac x=na in allE)
 apply (erule_tac x="s" in allE)
 apply (erule_tac x=na in allE)
 apply simp
 apply (tactic {* all_tac *}) 
 (* -- *)
 apply (erule_tac x=m in allE)
 apply (rule impI)
 apply (rule allI)+
 apply (rule impI)
 apply (simp add: vdm_validn_def)
 apply (erule_tac x="m" in allE)
 apply (rotate_tac 1)
 apply (erule thin_rl)
 apply simp
done

inductive_cases evalInvoken_cases : "(s, Invoke vn1 mn vn2, n, v, s') \<in> evalexprn"

lemma invokelemma[rule_format(no_asm)]: 
   "(\<forall> m. m<n \<longrightarrow> (\<Turnstile>v\<^sub>m (Invoke vn1 mn vn2) : Q) \<longrightarrow> 
                    (\<forall> a s_init. 
                       \<Turnstile>v\<^sub>m (methtable (the (s_init\<guillemotleft>a\<guillemotright>)) mn) :
                            {(s,s',v). s_init\<lfloor>vn1\<rfloor> = (Ref a) \<and> 
                                       s = newframe s_init mn (Ref a) (s_init\<lfloor>vn2\<rfloor>) \<and>
                                       (s_init,tickn 5 (oldframe s' s_init),v) \<in> Q}))
   \<longrightarrow> (\<Turnstile>v\<^sub>n (Invoke vn1 mn vn2) : Q)"
apply (induct_tac n)
apply (simp add: vdm_validn_def)
apply (clarify, drule no_zero_height_derivs, auto)
apply (simp (no_asm) add: vdm_validn_def)
apply (rule, case_tac "m=Suc n") (* interesting case first *)
 apply rule
 apply clarsimp
 apply (erule_tac x="n" in allE)
 apply simp
 apply (erule thin_rl)
 apply (simp add: vdm_validn_def)
 apply (erule evalInvoken_cases)
 apply (erule_tac x="a" in allE)
 apply (erule_tac x="s" in allE)
 apply (erule_tac x="n" in allE)
 apply clarsimp
 (* m < Suc n *)
 apply (rule impI)
 apply (rule allI)+
 apply (rule impI)
 apply (simp add: vdm_validn_def)
 apply (erule_tac x=m in allE)
 apply (erule_tac x=m in allE)
 apply clarsimp
done

end
