(* 				 
   File:	$RCSfile: ToyVDMproofsBD.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVDMproofsBD.thy,v 1.1 2003/07/17 20:01:18 a1hloidl Exp $

   Proof system for Hoare Logic and soundness proof as suggested by Martin.
    
   FIXME: 1. doesn't include rules for invokestatic/invoke
          2. might be considerably simpler if use callcount directly 
             instead of second op.sems (see HLproofs2, HLproofs3)
          3. 

 
   DESIGN CHOICE:  
       1. use \<Turnstile>m P e Q : harmless meta-quantified formulae in all rules
       2. use G \<Turnstile> P e Q 
       3. use G \<turnstile> P e Q, deeper embedding of hoare rules
	  [ adv:    we know proof system exactly and stick to it;
	    disadv: may be incomplete ]

   Some rules for 1,2 are derived below as part of soundness proof.

   VDM-style version
*)

header {* Hoare logic for Toy Grail: Proof System *}

theory ToyVDMproofsBD = (* ToyVDMBD + *) ToyVDMrecBD:

subsection {* Hoare logic derivability *}

types
 'a tuple = "'a expr \<times> vdmassn"

consts
  vdmproof :: "('a tuple list \<times> 'a tuple)  set"

syntax
  vdm_deriv :: "'a tuple list 
		  \<Rightarrow> 'a expr \<Rightarrow> vdmassn \<Rightarrow> bool"  
		  ("_ |- (_) :/ (1_)" [900,200,100] 50)

(* NB: x-symbol loops when trying to combine \<turnstile>\<^sub>v and \<turnstile>\<^sup>n
       so I use plain ugly \<turnstile>v for VDM validity instead *)

syntax (xsymbols)
  vdm_deriv :: "'a tuple list \<Rightarrow>
		   'a expr \<Rightarrow> vdmassn \<Rightarrow> bool" 
		  ("_ \<turnstile>\<^sub>v (_):/ (1_)" [900,100,200] 50)

translations
 "G \<turnstile>\<^sub>v e : P" == "(G,e,P) \<in> vdmproof"

syntax
  vdm_emptyctx :: "'a expr \<Rightarrow> vdmassn \<Rightarrow> bool" ("\<turnstile>\<^sub>v (_) :/ (1_)" 40)
translations
  "\<turnstile>\<^sub>v e : Q" == "[] \<turnstile>\<^sub>v e : Q"


(* ----------------------------------------------------------------------------- *)
(*
inductive vdmproof intros
 vconseq: "\<lbrakk> G \<turnstile> e P; \<forall> s t v. (s,t,v)\<in> P \<longrightarrow> (s,t,v)\<in> Q) \<rbrakk> \<Longrightarrow> G \<turnstile> e : Q"

 vnull:  "\<turnstile> {(s, t, v). (z,tick s, RVal Nullref)\<in> Q} NULL Q"

 hint:   "\<turnstile> {(z, s). (z,tick s,IVal i) \<in> Q} (expr.Int i) Q"

 hivar:  "\<turnstile> {(z, s). (z, tick s, IVal (s<vn>)) \<in> Q} (expr.IVar vn) Q"

 hrvar : "\<turnstile> {(z, s). (z, tick s, RVal (s\<lfloor>vn\<rfloor>)) \<in> Q} (expr.RVar vn) Q"

 hprimop: 
  "\<turnstile> {(z, s). (z,tickn 3 s, IVal (f (s<vn1>) (s<vn2>))) \<in> P}
      (expr.Primop f vn1 vn2)
      P"

 hrprimop: 
  "\<turnstile> {(z, s). (z,tickn 3 s, IVal (f (s\<lfloor>vn1\<rfloor>) (s\<lfloor>vn2\<rfloor>))) \<in> P}
      (expr.RPrimop f vn1 vn2)
      P"

 hgetfi: "\<turnstile> {(z, s). ( z, tickn 2 s, IVal (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f>) ) \<in> Q}
	        (GetFi vn f)
		Q"
 hgetfr: "\<turnstile> {(z, s). ( z, tickn 2 s, RVal (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f\<rfloor>) ) \<in> Q}
	        (GetFr vn f)
		Q"
 hputfi: 
  "\<turnstile> {(z, s). (z, tickn 3 (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f := (s<valv>)>), IVal (s<valv>)) \<in> Q}
	      (PutFi vn f valv)
	      Q"
 hputfr: 
  "\<turnstile> {(z, s). (z, tickn 3 (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f := (s\<lfloor>valv\<rfloor>)\<rfloor>), RVal (s\<lfloor>valv\<rfloor>)) \<in> Q}
	      (PutFr vn f valv)
	       Q"
 hnew: "\<turnstile> {(z, s). (z, tick (newobj s c ifldvals rfldvals), RVal (Ref (freshlocst s))) \<in> P}
	        (New c ifldvals rfldvals)
	   P"

 hif : "\<lbrakk> G \<turnstile> P1 e1 Q;  G \<turnstile> P2 e2 Q; 
               P \<subseteq> {(z,s). (s<x>=1 \<longrightarrow> (z,tick s) \<in> P1)  \<and> 
			    (s<x>=0 \<longrightarrow> (z,tick s) \<in> P2)}
               \<rbrakk>
          \<Longrightarrow> G \<turnstile> P (IF x THEN e1 ELSE e2) Q"

 hlet: "\<lbrakk> G \<turnstile> P e {(z,s,v). (z,ivarupdate (tick s) x (theival v)) \<in> R};
	  G \<turnstile> R e' Q \<rbrakk> 
       \<Longrightarrow> G \<turnstile> P (LET x=e IN e' END) Q"

 hletr: "\<lbrakk> G \<turnstile> P e {(z,s,v). (z,rvarupdate (tick s) x (therval v)) \<in> R};
	   G \<turnstile> R e' Q \<rbrakk> 
       \<Longrightarrow> G \<turnstile> P (LET rf x=e IN e' END) Q"

 hletv: "\<lbrakk> G \<turnstile> P e {(z,s,v). (z,s)\<in> R}; G \<turnstile> R e' Q \<rbrakk> 
       \<Longrightarrow> G \<turnstile> P (LET _=e IN e' END) Q"

(* it turns out that the following rule is slightly more useful
   and not derivable if we have nats in state.
*)
 hcall:  
    "((P,CALL fn,Q)#G) \<turnstile> (imagepre tickcall P) (funtable fn) Q 
      \<Longrightarrow> G \<turnstile> P (CALL fn) Q"
(*
 hcall: 
    "((invimagepre tickcall P,CALL fn,Q)#G) \<turnstile> P (funtable fn) Q 
      \<Longrightarrow> G \<turnstile> (invimagepre tickcall P) (CALL fn) Q"
*)

 hinvokestatic:
  "(\<forall> s_init. 
    (((P,InvokeStatic C mn vn2,Q)#G) \<turnstile>
      {(z, s). s = newframe s_init mn Nullref (s_init\<lfloor>vn2\<rfloor>) \<and> (z, s_init) \<in> P}
       (methtable C mn)
      {(z,s,v). \<exists> s'. s'=tickn 4 (oldframe s s_init) \<and> (z,s',v) \<in> Q})) \<Longrightarrow>
     (G \<turnstile> P (InvokeStatic C mn vn2) Q)"

 hinvoke:
  "(\<forall> s_init. 
  (((P,Invoke vn1 mn vn2,Q)#G) \<turnstile> 
      {(z, s). s_init\<lfloor>vn1\<rfloor> = (Ref a) \<and> 
                s = newframe s_init mn (Ref a) (s_init\<lfloor>vn2\<rfloor>) \<and>
                (z, s_init) \<in> P}
      (methtable (the (s_init\<guillemotleft>a\<guillemotright>)) mn)
      {(z,s,v). \<exists> s'. s'=tickn 5 (oldframe s s_init) \<and> (z,s',v) \<in> Q})) \<Longrightarrow>
  (G \<turnstile> P (Invoke vn1 mn vn2) Q)"

 hpre:  "\<lbrakk> G \<turnstile> P1 e Q; P \<subseteq> P1  \<rbrakk> \<Longrightarrow> G \<turnstile> P (PRE P1: e) Q"

 hpost: "\<lbrakk> G \<turnstile> P e Q1; Q1 \<subseteq> Q \<rbrakk> \<Longrightarrow> G \<turnstile> P (POST Q1: e) Q"

 hmeasure:  "\<lbrakk> G \<turnstile> P e Q \<rbrakk> \<Longrightarrow> 
               G \<turnstile> {(z,s). (z,s)\<in> P \<and> (\<exists> s'. (\<exists> v. (z,s',v)\<in> Q) \<and> (s,s')\<in> M)} (Measure M e) Q"

 hax:       "(P,e,Q) mem G \<Longrightarrow> G \<turnstile> P e Q"

 hthin:     "\<lbrakk> G \<turnstile> P e Q; set G \<subseteq> set H \<rbrakk> \<Longrightarrow> H \<turnstile> P e Q"

*)


section {* Soundness of VDM Logic *}

subsection {* Context validity *}

constdefs
  vdm_ctxt_valid :: "state tuple list \<Rightarrow> bool"      ("|\<Turnstile>\<^sub>v _" 60)
 "|\<Turnstile>\<^sub>v G  \<equiv>  (list_all (\<lambda> (e, Q). \<Turnstile>\<^sub>v e : Q) G)"

(* FIXME: syntax: why is space needed before |\<Turnstile> ? *)

lemma ctx_proj[rule_format]:  "(( |\<Turnstile>\<^sub>v G) \<and> ((e,Q) mem G) ) \<longrightarrow> (\<Turnstile>\<^sub>v e : Q)"
apply (induct_tac G)
apply simp
apply (simp add: vdm_ctxt_valid_def)
done

lemma ctxt_drop: "( |\<Turnstile>\<^sub>v ((e,Q)#G)) ==> |\<Turnstile>\<^sub>v G"
by  (simp add: vdm_ctxt_valid_def) 

lemma ctxt_ext[simp]: "( |\<Turnstile>\<^sub>v ((e,Q)#G)) = ((\<Turnstile>\<^sub>v e : Q) \<and> ( |\<Turnstile>\<^sub>v G))"
by (simp add: vdm_ctxt_valid_def)

lemma ctx_sub[rule_format]:  "(( |\<Turnstile>\<^sub>v G) \<and> (set H \<subseteq> set G) ) \<longrightarrow> ( |\<Turnstile>\<^sub>v H)"
apply (simp add: vdm_ctxt_valid_def list_all_conv)
apply auto
done

lemma emptyctx [simp]: "|\<Turnstile>\<^sub>v []"
by (simp add: vdm_ctxt_valid_def)


text {* Context validity to depth n *}

constdefs
  vdm_ctxt_validn :: "nat \<Rightarrow> state tuple list \<Rightarrow> bool"      ("|\<Turnstile>v\<^sub>_ _" 60)
  "|\<Turnstile>v\<^sub>n G  \<equiv>  (list_all (\<lambda> (e, Q). \<Turnstile>v\<^sub>n e : Q) G)"

lemma ctxt_valid_validn: "( |\<Turnstile>\<^sub>v G) \<Longrightarrow> (\<forall> n.( |\<Turnstile>v\<^sub>n G))"
apply (simp add: vdm_ctxt_validn_def vdm_ctxt_valid_def)
apply (simp add: list_all_conv)
apply rule
apply rule
apply (drule_tac x=x in bspec, simp)
apply (auto elim: valid_validn [THEN spec])
done

lemma emptyctxn [simp]: "|\<Turnstile>v\<^sub>n []"
by (simp add: vdm_ctxt_validn_def)

lemma ctx_projn[rule_format]:  "(( |\<Turnstile>v\<^sub>n G) \<and> ((e,Q) mem G) ) \<longrightarrow> (\<Turnstile>v\<^sub>n e : Q)"
apply (induct_tac G)
apply simp
apply (simp add: vdm_ctxt_validn_def)
done


lemma ctx_subn[rule_format]:  "(( |\<Turnstile>v\<^sub>n G) \<and> (set H \<subseteq> set G) ) \<longrightarrow> ( |\<Turnstile>v\<^sub>n H)"
apply (simp add: vdm_ctxt_validn_def list_all_conv)
apply auto
done

lemma ctxt_cons: "\<lbrakk> |\<Turnstile>\<^sub>v G; \<Turnstile>\<^sub>v e : Q \<rbrakk> \<Longrightarrow> ( |\<Turnstile>\<^sub>v ((e,Q) # G))"
by (simp add: vdm_ctxt_valid_def)

lemma ctxt_validn_valid[rule_format]: "(\<forall> n.( |\<Turnstile>v\<^sub>n G)) \<longrightarrow> ( |\<Turnstile>\<^sub>v G)"
apply (induct_tac G)
apply simp
apply clarify
apply (rule ctxt_cons)
apply (simp add:  vdm_ctxt_validn_def)
apply (rule validn_valid)
apply (simp add:  vdm_ctxt_validn_def)
done

lemma ctxt_lower: "\<lbrakk> |\<Turnstile>v\<^sub>n G; m<n \<rbrakk> \<Longrightarrow> |\<Turnstile>v\<^sub>m G"
apply (simp add: vdm_ctxt_validn_def)
apply (simp add: list_all_conv)
apply rule
apply rule
apply (drule_tac x=x in bspec, simp)
apply clarsimp
apply (rule_tac n="n" in lowerm)
apply auto
done

lemma lowerm: "\<lbrakk>  m < n; \<Turnstile>v\<^sub>n e : Q  \<rbrakk> \<Longrightarrow> \<Turnstile>v\<^sub>m e : Q"
apply (simp (no_asm) add: vdm_validn_def)
apply (rule, rule)
apply (unfold vdm_validn_def)
apply (erule_tac x=ma in allE)
apply auto
done

lemma ctxt_consn: "\<lbrakk> |\<Turnstile>v\<^sub>n G; \<Turnstile>v\<^sub>n e : Q \<rbrakk> \<Longrightarrow> ( |\<Turnstile>v\<^sub>n ((e,Q) # G))"
by (simp add: vdm_ctxt_validn_def)


subsection {* Relativized validity in a context *}

constdefs
  vdm_valid_in_ctxt :: "state tuple list \<Rightarrow> state expr \<Rightarrow> vdmassn \<Rightarrow> bool"      ("_ \<Turnstile>v _ : _" 75)
  "G \<Turnstile>v e : Q  \<equiv>  \<forall> n. ( |\<Turnstile>v\<^sub>n G ) \<longrightarrow> \<Turnstile>v\<^sub>n e : Q"

syntax
  vdm_valid_in_emptyctx :: "'a expr \<Rightarrow> vdmassn \<Rightarrow> bool" ("\<Turnstile>v (_) :/ (1_)" 40)
translations
  "\<Turnstile>v e : Q" == "[] \<Turnstile>v e : Q"

(*
 1. \<And>G P P1 P2 Q e1 e2 x.
       \<lbrakk>G \<turnstile> P1 e1 Q; G |\<Turnstile> P1 e1 Q; G \<turnstile> P2 e2 Q; G |\<Turnstile> P2 e2 Q;
          P \<subseteq> {(z, s). (s<x> = 1 \<longrightarrow> (z, tick s) \<in> P1) \<and> (s<x> = 0 \<longrightarrow> (z, tick s) \<in> P2)}\<rbrakk>
       \<Longrightarrow> G |\<Turnstile> P IF x THEN e1 ELSE e2 Q
*)

(*lemma "\<lbrakk> G |\<Turnstile> P e Q;  \<Longrightarrow> \<Turnstile> G \<longrightarrow> *)

subsection {* structural rules *}

text {* standard introduction and elimination rules *}

lemma CVdmI [intro]:
"\<lbrakk> |\<Turnstile>\<^sub>v G ; (\<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (s,t,v) \<in> P) \<rbrakk> \<Longrightarrow> G \<Turnstile>v e : P"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (simp add: evaln_eval)
done


lemma CVdmE [elim]: "\<lbrakk> G \<Turnstile>v e : P; |\<Turnstile>\<^sub>v G ; \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<rbrakk> \<Longrightarrow> (s,t,v) \<in> P"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply (drule eval_evaln, erule exE)
apply (erule_tac x="n" in allE)
apply (drule ctxt_valid_validn)
apply (simp add: vdm_ctxt_valid_def)
apply (erule_tac x="n" in allE)
apply (erule_tac x="n" in allE)
apply clarsimp
done

text {* Single structural rule of weakening *}

lemma VWn:"\<lbrakk> \<Turnstile>v\<^sub>n e :  P; P \<subseteq> Q \<rbrakk> \<Longrightarrow>
           \<Turnstile>v\<^sub>n e :  Q" 
apply (unfold vdm_validn_def)
apply fastsimp
done

lemma CVW:"\<lbrakk> G \<Turnstile>v e : P; P \<subseteq> Q \<rbrakk> \<Longrightarrow>
           G \<Turnstile>v e :  Q" 
apply (simp add: vdm_valid_in_ctxt_def)
apply clarsimp
apply (rule VWn)
apply fastsimp
apply assumption
done

subsection {* Recursion rules in context *}

lemma CVCall: "\<lbrakk> ((CALL fn, Q) # G) \<Turnstile>v (funtable fn) : (vdmimagepre tickcall Q) \<rbrakk> \<Longrightarrow>  
	       G \<Turnstile>v (CALL fn) : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply rule 
apply rule
apply (rule calllemma)
apply (rule, rule, rule)
apply (drule_tac x="m" in spec)
apply (erule impE)
apply (rule ctxt_consn)
apply (erule ctxt_lower)
apply auto
done

lemma CVInvokeStatic:
 "\<lbrakk> \<forall> s_init . ((InvokeStatic cn mn vn, Q) # G) \<Turnstile>v
      (methtable cn mn) :
      {(s,s',v). (s_init,tickn 4 (oldframe s' s_init),v) \<in> Q \<and> 
                 s = newframe s_init mn Nullref (s_init\<lfloor>vn\<rfloor>)} \<rbrakk>
  \<Longrightarrow>
  G \<Turnstile>v (InvokeStatic cn mn vn) : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule)
apply (rule invokestaticlemma)
apply (rule, rule, rule)
apply (rule allI)
apply (erule_tac x="s_init" in allE)
apply (erule_tac x="m" in allE)
apply (erule impE)
apply (rule ctxt_consn)
apply (drule ctxt_lower)
apply auto
done

lemma CVInvoke:
  "\<forall> a s_init. 
     (((Invoke vn1 mn vn2), Q) # G) \<Turnstile>v 
         (methtable (the (s_init\<guillemotleft>a\<guillemotright>)) mn) :
         {(s,s',v). s_init\<lfloor>vn1\<rfloor> = (Ref a) \<and> 
                    s = newframe s_init mn (Ref a) (s_init\<lfloor>vn2\<rfloor>) \<and>
                    (s_init,tickn 5 (oldframe s' s_init),v) \<in> Q}
  \<Longrightarrow>
  G \<Turnstile>v (Invoke vn1 mn vn2) : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule allI)
apply (rule impI)
apply (rule invokelemma)
apply (rule allI)
apply (rule impI)
apply (rule impI)
apply (rule allI)+
apply (erule_tac x="a" in allE)
apply (erule_tac x="s_init" in allE)
apply (erule_tac x="m" in allE)
apply (erule impE)
apply (rule ctxt_consn)
apply (drule ctxt_lower)
apply auto
done


(* ToDo: fix InvokeStatic and Invoke for VDM 
lemma CHInvokeStatic:
 "\<lbrakk> (\<forall> s_init . ((P, InvokeStatic cn mn vn, Q) # G) \<Turnstile>
                  {(z, s). s = newframe s_init mn Nullref (s_init\<lfloor>vn\<rfloor>) \<and> (z, s_init) \<in> P}
                  (methtable cn mn)
                  {(z,s,v). (z,tickn 4 (oldframe s s_init),v) \<in> Q}) \<rbrakk>
  \<Longrightarrow>
  G \<Turnstile> P (InvokeStatic cn mn vn) Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule)
apply (rule invokestaticlemma)
apply (rule, rule, rule)
apply (rule allI)
apply (erule_tac x="s_init" in allE)
apply (erule_tac x="m" in allE)
apply (erule impE)
apply (rule ctxt_consn)
apply (drule ctxt_lower)
apply auto
done

lemma CHInvoke:
  "\<forall> a s_init. 
     ((P, (Invoke vn1 mn vn2), Q) # G) \<Turnstile> 
      {(z, s). s_init\<lfloor>vn1\<rfloor> = (Ref a) \<and> 
               s = newframe s_init mn (Ref a) (s_init\<lfloor>vn2\<rfloor>) \<and>
               (z, s_init) \<in> P}
      (methtable (the (s_init\<guillemotleft>a\<guillemotright>)) mn)
      {(z,s,v). (z,tickn 5 (oldframe s s_init),v) \<in> Q} \<Longrightarrow>
  G \<Turnstile> P (Invoke vn1 mn vn2) Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule allI)
apply (rule impI)
apply (rule invokelemma)
apply (rule allI)
apply (rule impI)
apply (rule impI)
apply (rule allI)+
apply (erule_tac x="a" in allE)
apply (erule_tac x="s_init" in allE)
apply (erule_tac x="m" in allE)
apply (erule impE)
apply (rule ctxt_consn)
apply (drule ctxt_lower)
apply auto
done
*)

subsection {* Other rules with non-empty contexts *}

text {* Relativized rules which mention the context have
  to be derived afresh from first principles, because
  G \<Turnstile> P e Q  can be true more often than  \<Turnstile> G \<longrightarrow> \<Turnstile> P e Q.
  Former defined as      \<forall> n. \<Turnstile>n G \<longrightarrow> \<Turnstile>n P e Q
  Latter equivalent to   (\<forall> n. \<Turnstile>n G) \<longrightarrow> (\<forall> n. \<Turnstile>n P e Q)
  
 *}

inductive_cases evalIfn_cases : "(s, IF x THEN e1 ELSE e2, n, v, s') \<in> evalexprn"

(* based on Bonzo version
lemma VIfn: "\<lbrakk> \<Turnstile>v\<^sub>n e1 : Q1; \<Turnstile>v\<^sub>n e2 : Q2;
		{(s,s',v).  (s<x>=grailbool True \<longrightarrow> (tick s,s',v)\<in> Q1)
		 	  \<and> (s<x>=grailbool False \<longrightarrow> (tick s,s',v)\<in> Q2)} \<subseteq> Q \<rbrakk>
          \<Longrightarrow> \<Turnstile>v\<^sub>n (IF x THEN e1 ELSE e2) : Q"
apply (unfold vdm_validn_def)
apply (rule, rule, rule, rule, rule, rule)
apply (erule_tac x="m" in allE)
apply (erule_tac x="m" in allE)
apply (clarsimp elim: evalIfn_cases)
apply (erule_tac x="tick s" in allE)
apply (rotate_tac -1)
apply (erule_tac x="t" in allE)
apply (rotate_tac -1)
apply (erule_tac x="v" in allE)
apply (erule_tac x="tick s" in allE)
apply (erule_tac x="t" in allE)
apply (erule_tac x="v" in allE)
oops
*)

lemma VIfn : "\<lbrakk> \<Turnstile>v\<^sub>n e1 : Q1; \<Turnstile>v\<^sub>n e2 : Q2 \<rbrakk>
          \<Longrightarrow> \<Turnstile>v\<^sub>n (IF x THEN e1 ELSE e2) : 
		{(s,s',v).  (s<x>=grailbool True \<longrightarrow> (tick s,s',v)\<in> Q1)
		 	  \<and> (s<x>=grailbool False \<longrightarrow> (tick s,s',v)\<in> Q2)}"
apply (unfold vdm_validn_def)
apply (simp add: evalIfn_cases)
apply (rule, rule, rule, rule, rule, rule)
apply (rule, rule)
(* THEN branch *)
apply (erule evalIfn_cases)
apply (erule_tac x="na" in allE)
apply (erule_tac x="na" in allE)
apply simp
apply clarsimp
(* ELSE branch *)
apply rule
apply (erule evalIfn_cases)
apply (erule_tac x="na" in allE)
apply (erule_tac x="na" in allE)
apply simp
apply clarsimp
apply (erule_tac x="na" in allE)
apply (erule_tac x="na" in allE)
apply simp
done

lemma CVIf : "\<lbrakk> G \<Turnstile>v e1 : Q1; G \<Turnstile>v e2 : Q2 ;
                {(s,s',v).  (s<x>=grailbool True \<longrightarrow> (tick s,s',v)\<in> Q1)
		 	  \<and> (s<x>=grailbool False \<longrightarrow> (tick s,s',v)\<in> Q2)} \<subseteq> Q \<rbrakk>
          \<Longrightarrow> G \<Turnstile>v (IF x THEN e1 ELSE e2) : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (unfold vdm_validn_def)
apply (rule, rule)
apply (rule allI)+
apply (rule)
apply (erule evalIfn_cases)
apply clarsimp
apply (erule_tac x=na in allE)
apply (erule_tac x=na in allE)
apply simp
apply (erule_tac x="tick s" in allE, rotate_tac -1)
apply (erule_tac x="t" in allE, rotate_tac -1)
apply (erule_tac x="v" in allE, rotate_tac -1)
apply clarsimp
apply (subgoal_tac "(s, t, v) \<in> {(s, s', v). (s<x> = 1 \<longrightarrow> (tick s, s', v) \<in> Q1) \<and> (s<x> = 0 \<longrightarrow> (tick s, s', v) \<in> Q2)}")
 apply clarsimp
 apply (frule subsetI)
 apply auto
 (* -- *)
apply (erule_tac x=na in allE)
apply (erule_tac x=na in allE)
apply simp
apply (rotate_tac -1)
apply (erule_tac x="tick s" in allE, rotate_tac -1)
apply (erule_tac x="t" in allE, rotate_tac -1)
apply (erule_tac x="v" in allE, rotate_tac -1)
apply auto
done

(*
lemma CVIf: "\<lbrakk>G \<Turnstile>v e1 : Q; G \<Turnstile>v e2 : Q;
             {(z, s). (s<x> = 1 \<longrightarrow> (z, tick s) \<in> P1) \<and> (s<x> = 0 \<longrightarrow> (z, tick s) \<in> P2)} \<subseteq> Q\<rbrakk>
       \<Longrightarrow> G \<Turnstile>v IF x THEN e1 ELSE e2 : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HIfn, assumption, assumption, simp)
done
*)
(*
lemma HIfn : "\<lbrakk>  \<Turnstile>\<^sup>n P1 e1 Q;   \<Turnstile>\<^sup>n P2 e2 Q; 
               P \<subseteq> {(z,s). (s<x>=1 \<longrightarrow> (z,tick s) \<in> P1)  \<and> 
			    (s<x>=0 \<longrightarrow> (z,tick s) \<in> P2)}
               \<rbrakk>
          \<Longrightarrow>  \<Turnstile>\<^sup>n P (IF x THEN e1 ELSE e2) Q"
apply (simp add: vdm_validn_def)
apply clarify 
apply (erule evalIfn_cases)
apply (erule_tac x="na" in allE)
apply (erule_tac x="na" in allE)
apply (case_tac "na<m")
apply fastsimp
apply fastsimp
apply (erule_tac x="na" in allE)
apply (erule_tac x="na" in allE)
apply (case_tac "na<m")
apply fastsimp
apply fastsimp
done

lemma CHIf: "\<lbrakk>G \<Turnstile> P1 e1 Q; G \<Turnstile> P2 e2 Q;
             P \<subseteq> {(z, s). (s<x> = 1 \<longrightarrow> (z, tick s) \<in> P1) \<and> (s<x> = 0 \<longrightarrow> (z, tick s) \<in> P2)}\<rbrakk>
       \<Longrightarrow> G \<Turnstile> P IF x THEN e1 ELSE e2 Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HIfn, assumption, assumption, simp)
done
*)

inductive_cases evalLetn_cases : "(s, LET x = e IN e' END, n, v, s') \<in> evalexprn"

(*
lemma VLetn1: "\<lbrakk> \<Turnstile>v\<^sub>n e : Q1 ; \<Turnstile>v\<^sub>n  e' : {(s,s',v). \<exists> t t'. (t,t',v) \<in> Q1 \<and> s = (tick t')<x:=theival v> \<and> (t,s',v) \<in> Q } \<rbrakk>
              \<Longrightarrow>  \<Turnstile>v\<^sub>n LET x = e IN e' END : Q"
apply (simp add: vdm_validn_def)
apply clarify 
apply (erule evalLetn_cases)
apply (erule_tac x="na" in allE)
apply (erule_tac x="ma" in allE)
apply (case_tac "(max na ma)<m")
apply (subgoal_tac "na < m \<and> ma < m")
apply fastsimp
apply arith
apply fastsimp
done


lemma VLetn2: "\<lbrakk> \<Turnstile>v\<^sub>n e : {(s,s',v). \<exists> t' v'. ((tick s')<x:=theival v>,t',v) \<in> R \<and> (s,t',v') \<in> Q } ; \<Turnstile>v\<^sub>n  e' : R \<rbrakk>
              \<Longrightarrow>  \<Turnstile>v\<^sub>n LET x = e IN e' END : Q"
oops


lemma CHLet: "\<lbrakk> G \<Turnstile> P e {(z, s, v). (z, (tick s)<x:=theival v>) \<in> R}; G \<Turnstile> R e' Q\<rbrakk>
       \<Longrightarrow> G \<Turnstile> P LET x = e IN e' END Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HLetn)
apply fastsimp
apply assumption
done
*)

inductive_cases evalLetin_cases : "(s, LET x = e IN e' END, n, v, s') \<in> evalexprn"

(* based on Bonzo version *)
lemma VLetUselessn: "\<lbrakk> \<Turnstile>v\<^sub>n e : Q1 ; \<Turnstile>v\<^sub>n  e' : Q2 ;
                {(s,s',v). \<exists> t' v'. (s,t',v') \<in> Q1 \<and> ((tick t')<x:=theival v'>,s',v) \<in> Q2} \<subseteq> Q \<rbrakk>
              \<Longrightarrow>  \<Turnstile>v\<^sub>n LET x = e IN e' END : Q"
apply (unfold vdm_validn_def)
apply (rule, rule, rule, rule, rule, rule)
apply (erule evalLetin_cases)
apply clarsimp
(* pick s t v for let header first *)
apply (erule_tac x="na" in allE)
apply (erule_tac x="ma" in allE)
apply (subgoal_tac "na <= n \<and> ma <= n")
apply clarsimp
apply (erule_tac x="s" in allE, rotate_tac -1)
apply (erule_tac x="s1" in allE, rotate_tac -1)
apply (erule_tac x="IVal i" in allE)
apply (erule_tac x="tick s1<x:=i>" in allE)
apply (erule_tac x="t" in allE)
apply (erule_tac x="v" in allE)
apply fastsimp
apply arith
done

lemma CVLetUseless: "\<lbrakk> G \<Turnstile>v e : Q1 ; G \<Turnstile>v e' : Q2 ; 
                {(s,s',v). \<exists> t' v'. (s,t',v') \<in> Q1 \<and> ((tick t')<x:=theival v'>,s',v) \<in> Q2} \<subseteq> Q \<rbrakk>
              \<Longrightarrow> G \<Turnstile>v LET x = e IN e' END : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule VLetUselessn)
apply fastsimp
apply assumption
apply clarsimp
done

lemma VLetBonzon: "\<lbrakk> \<Turnstile>v\<^sub>n e : Q1 ; \<Turnstile>v\<^sub>n e' : Q2 ;
                    {(s,s',v). (s,t',v') \<in> Q1 \<longrightarrow> (\<langle>tick t'<x:=theival v'>,e'\<rangle> \<longrightarrow>e \<langle>v,s'\<rangle>) \<longrightarrow> ((tick t')<x:=theival v'>,s',v) \<in> Q2} \<subseteq> Q \<rbrakk>
              \<Longrightarrow>  \<Turnstile>v\<^sub>n LET x = e IN e' END : Q"
apply (simp add: vdm_validn_def)
apply clarsimp
apply (erule_tac x="m" in allE)
apply (erule_tac x="m" in allE)
apply clarsimp
apply (erule_tac x="s" in allE, rotate_tac -1)
apply (erule_tac x="t'" in allE, rotate_tac -1)
apply (erule_tac x="v'" in allE)
apply (erule_tac x="tick t'<x:=theival v'>" in allE)
apply (erule_tac x="t" in allE)
apply (erule_tac x="v" in allE)
apply auto
sorry (* , NOT! *)

lemma CVLetBonzo: "\<lbrakk> G \<Turnstile>v e : Q1 ; G \<Turnstile>v e' : Q2 ;
                    {(s,s',v). (s,t',v') \<in> Q1 \<longrightarrow> (\<langle>tick t'<x:=theival v'>,e'\<rangle> \<longrightarrow>e \<langle>v,s'\<rangle>) \<longrightarrow> ((tick t')<x:=theival v'>,s',v) \<in> Q2} \<subseteq> Q \<rbrakk>
              \<Longrightarrow> G \<Turnstile>v LET x = e IN e' END : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule VLetBonzon)
apply fastsimp
apply assumption
apply auto
done

lemma VLetPatheticn: "\<lbrakk> \<Turnstile>v\<^sub>n e :  P1; \<Turnstile>v\<^sub>n e' : P2 \<rbrakk> \<Longrightarrow>
	     \<Turnstile>v\<^sub>n (LET x=e IN e' END) : 
	       {(s,s',v). \<exists> t' v'. (s,t',v')\<in> P1
				  \<and> ((tick t')<x:=theival v'>,s',v) \<in> P2}"
apply (unfold vdm_validn_def)
apply (rule, rule, rule, rule, rule, rule)
apply (erule evalLetin_cases)
apply clarsimp
(* pick s t v for let header first *)
apply (erule_tac x="na" in allE)
apply (erule_tac x="ma" in allE)
apply (subgoal_tac "na <= n \<and> ma <= n")
apply clarsimp
apply (erule_tac x="s" in allE, rotate_tac -1)
apply (erule_tac x="s1" in allE, rotate_tac -1)
apply (erule_tac x="IVal i" in allE)
apply (erule_tac x="tick s1<x:=i>" in allE)
apply (erule_tac x="t" in allE)
apply (erule_tac x="v" in allE)
apply fastsimp
apply arith
done

lemma CVLetPathetic: "\<lbrakk> G \<Turnstile>v e :  P1; G \<Turnstile>v e' : P2 \<rbrakk> \<Longrightarrow>
	     G \<Turnstile>v (LET x=e IN e' END) : 
	       {(s,s',v). \<exists> t' v'. (s,t',v')\<in> P1
				  \<and> ((tick t')<x:=theival v'>,s',v) \<in> P2}"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule VWn)
apply (rule VLetPatheticn)
apply fastsimp
apply assumption
apply auto
done

inductive_cases evalLetrn_cases : "(s, LET rf x = e IN e' END, n, v, s') \<in> evalexprn"

(* based on Bonzo version *)
lemma VLetrn: "\<lbrakk> \<Turnstile>v\<^sub>n e : Q1 ; \<Turnstile>v\<^sub>n  e' : Q2 ;
                            {(s,s',v). \<exists> t' v'. (s,t',v') \<in> Q1 \<and> ((tick t')\<lfloor>x:=therval v'\<rfloor>,s',v) \<in> Q2} \<subseteq> Q \<rbrakk>
              \<Longrightarrow>  \<Turnstile>v\<^sub>n LET rf x = e IN e' END : Q"
apply (unfold vdm_validn_def)
apply (rule, rule, rule, rule, rule, rule)
apply (erule evalLetrn_cases)
apply clarsimp
(* pick s t v for let header first *)
apply (erule_tac x="na" in allE)
apply (erule_tac x="ma" in allE)
apply (subgoal_tac "na <= n \<and> ma <= n")
apply clarsimp
apply (erule_tac x="s" in allE, rotate_tac -1)
apply (erule_tac x="s1" in allE, rotate_tac -1)
apply (erule_tac x="RVal r" in allE)
apply (erule_tac x="tick s1\<lfloor>x:=r\<rfloor>" in allE)
apply (erule_tac x="t" in allE)
apply (erule_tac x="v" in allE)
apply fastsimp
apply arith
done

lemma CVLetr: "\<lbrakk> G \<Turnstile>v e : Q1 ; G \<Turnstile>v e' : Q2 ;
                            {(s,s',v). \<exists> t' v'. (s,t',v') \<in> Q1 \<and> ((tick t')\<lfloor>x:=therval v'\<rfloor>,s',v) \<in> Q2} \<subseteq> Q \<rbrakk>
              \<Longrightarrow> G \<Turnstile>v LET rf x = e IN e' END : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule VLetrn)
apply fastsimp
apply assumption
apply clarsimp
done

inductive_cases evalLetvn_cases : "(s, LET _ = e IN e' END, n, v, s') \<in> evalexprn"

(* based on Bonzo version *)
lemma VLetvn: "\<lbrakk> \<Turnstile>v\<^sub>n e : Q1 ; \<Turnstile>v\<^sub>n  e' : Q2 ;
                            {(s,s',v). \<exists> t' v'. (s,t',v') \<in> Q1 \<and> (t',s',v) \<in> Q2} \<subseteq> Q \<rbrakk>
              \<Longrightarrow>  \<Turnstile>v\<^sub>n LET _ = e IN e' END : Q"
apply (unfold vdm_validn_def)
apply (rule, rule, rule, rule, rule, rule)
apply (erule evalLetvn_cases)
apply clarsimp
(* pick s t v for let header first *)
apply (erule_tac x="na" in allE)
apply (erule_tac x="ma" in allE)
apply (subgoal_tac "na <= n \<and> ma <= n")
apply clarsimp
apply (erule_tac x="s" in allE, rotate_tac -1)
apply (erule_tac x="s1" in allE, rotate_tac -1)
apply (erule_tac x="rtv1" in allE)
apply (erule_tac x="s1" in allE)
apply (erule_tac x="t" in allE)
apply (erule_tac x="v" in allE)
apply fastsimp
apply arith
done

lemma CVLetv: "\<lbrakk> G \<Turnstile>v e : Q1 ; G \<Turnstile>v e' : Q2 ;
                            {(s,s',v). \<exists> t' v'. (s,t',v') \<in> Q1 \<and> (t',s',v) \<in> Q2} \<subseteq> Q \<rbrakk>
              \<Longrightarrow> G \<Turnstile>v LET _ = e IN e' END : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule VLetvn)
apply fastsimp
apply assumption
apply clarsimp
done

(*
lemma VLetrn: "\<lbrakk> \<Turnstile>v\<^sub>n e : {(s, s', v). \<exists> t' v'. ((tick s')\<lfloor>x:=therval v\<rfloor>,t',v') \<in> R \<and> (s,t',v') \<in> Q}; \<Turnstile>v\<^sub>n e' : R\<rbrakk>
       \<Longrightarrow>  \<Turnstile>v\<^sub>n LET rf x = e IN e' END : Q"
apply (simp add: vdm_validn_def)
apply clarify 
apply (erule evalLetrn_cases)
apply (erule_tac x="na" in allE)
apply (erule_tac x="ma" in allE)
apply (case_tac "(max na ma)<m")
apply (subgoal_tac "na < m \<and> ma < m")
apply fastsimp
apply arith
apply fastsimp
done

lemma CHLetr: "\<lbrakk> G \<Turnstile> P e {(z, s, v). (z, (tick s)\<lfloor>x:=therval v\<rfloor>) \<in> R}; G \<Turnstile> R e' Q\<rbrakk>
       \<Longrightarrow> G \<Turnstile> P LET rf x = e IN e' END Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HLetrn)
apply fastsimp+
done

lemma HLetvn: "\<lbrakk> \<Turnstile>\<^sup>n P e {(z, s, v). (z, s) \<in> R}; \<Turnstile>\<^sup>n R e' Q\<rbrakk>
       \<Longrightarrow>  \<Turnstile>\<^sup>n P LET _ = e IN e' END Q"
sorry
(*
apply (simp add: vdm_validn_def)
apply clarify 
apply (erule evalLetvn_cases)
apply (erule_tac x="na" in allE)
apply (erule_tac x="ma" in allE)
apply (case_tac "(max na ma)<m")
apply (subgoal_tac "na < m \<and> ma < m")
apply fastsimp
apply arith
apply fastsimp
done
*)

lemma CHLetv: "\<lbrakk> G \<Turnstile> P e {(z, s, v). (z, s) \<in> R}; G \<Turnstile> R e' Q\<rbrakk>
       \<Longrightarrow> G \<Turnstile> P LET _ = e IN e' END Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply rule
apply rule
apply (erule_tac x=n in allE)
apply (erule_tac x=n in allE)
apply (simp)
apply (rule HLetvn)
apply fastsimp+
done
*)

inductive_cases evalPren_cases  : " (s, PRE P: e, n, v, s') \<in> evalexprn"
inductive_cases evalPostn_cases : "(s, POST P: e, n, v, s') \<in> evalexprn"

lemma VPren: "\<lbrakk> \<Turnstile>v\<^sub>n e : Q; P \<subseteq> P1\<rbrakk> \<Longrightarrow> \<Turnstile>v\<^sub>n (PRE P1: e) : Q"
apply (simp add: vdm_validn_def)
apply clarify 
apply (erule evalPren_cases)
apply (erule_tac x="na" in allE)
apply (case_tac "na<m")
apply fastsimp+
done

lemma CVPre: " \<lbrakk>G \<Turnstile>v e : Q; P \<subseteq> P1\<rbrakk> \<Longrightarrow> G \<Turnstile>v (PRE P1: e) : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE, simp)
apply (rule VPren)
apply fastsimp+
done

lemma VPostn: "\<lbrakk> \<Turnstile>v\<^sub>n e : Q1; Q1 \<subseteq> Q\<rbrakk> \<Longrightarrow> \<Turnstile>v\<^sub>n (POST Q1: e) : Q"
apply (simp add: vdm_validn_def)
apply clarify 
apply (erule evalPostn_cases)
apply (erule_tac x="na" in allE)
apply (case_tac "na<m")
apply fastsimp+
done

lemma CVPost: " \<lbrakk>G \<Turnstile>v e : Q1; Q1 \<subseteq> Q\<rbrakk> \<Longrightarrow> G \<Turnstile>v (POST Q1: e) : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE, simp)
apply (rule VPostn)
apply fastsimp+
done

inductive_cases evalMeasuren_cases : "(s, MEASURE M: e, n, v, s') \<in> evalexprn"

lemma VMeasuren:  "\<lbrakk> \<Turnstile>v\<^sub>n e : Q;  {(s,s',v). (s, s') \<in> M} \<subseteq> Q \<rbrakk> 
       \<Longrightarrow> \<Turnstile>v\<^sub>n (MEASURE M: e) : Q"
apply (simp add: vdm_validn_def)
apply clarify 
apply (erule evalMeasuren_cases)
apply (erule_tac x="na" in allE)
apply (case_tac "na<m")
apply fastsimp+
done

lemma CVMeasure:  "\<lbrakk> G \<Turnstile>v e : Q;  {(s,s',v). (s, s') \<in> M} \<subseteq> Q \<rbrakk> 
       \<Longrightarrow> G \<Turnstile>v (MEASURE M: e) : Q"
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule)
apply (erule_tac x=n in allE, simp)
apply (rule VMeasuren)
apply fastsimp+
done

subsection {* leaf rules *}

inductive_cases evalNulln_cases 	 : "(s, expr.Null, n, v, s') \<in> evalexprn"
inductive_cases evalInt_vases 	 : "(s, expr.Int i, n, v, s') \<in> evalexprn"
inductive_cases evalIVarn_cases   : "(s, expr.IVar vn, n, v, s') \<in> evalexprn"
inductive_cases evalRVarn_cases   : "(s, expr.RVar vn, n, v, s') \<in> evalexprn"
inductive_cases evalIntn_cases  	 : "(s, expr.Int i, n, v, s') \<in> evalexprn"
inductive_cases evalPrimopn_cases : "(s, expr.Primop f vn1 vn2, n, v, s') \<in> evalexprn"
inductive_cases evalRPrimopn_cases: "(s, expr.RPrimop f vn1 vn2, n, v, s') \<in> evalexprn"
inductive_cases evalGetFin_cases	 : "(s, expr.GetFi vn f, n, v, s') \<in> evalexprn"
inductive_cases evalGetFrn_cases	 : "(s, expr.GetFr vn f, n, v, s') \<in> evalexprn"
inductive_cases evalPutFin_cases	 : "(s, expr.PutFi vn1 f vn2, n, v, s') \<in> evalexprn"
inductive_cases evalPutFrn_cases	 : "(s, expr.PutFr vn1 f vn2, n, v, s') \<in> evalexprn"
inductive_cases evalNewn_cases  	 : "(s, New c ifs rfs, n, v, s') \<in> evalexprn"

lemma VNulln:  "\<Turnstile>v\<^sub>n NULL : {(s, s', v). (s' = tick s) \<and> (v = RVal Nullref)}"
apply (simp add: vdm_validn_def)
apply auto
apply (erule evalNulln_cases)
apply simp
apply (erule evalNulln_cases)
apply simp
done

(* apply (simp add: no_zero_height_derivs) *)
(* apply (auto elim: evalNulln_cases) *)

lemma CVNull:  "G \<Turnstile>v NULL : {(s, s', v). (s' = tick s) \<and> (v = RVal Nullref)}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalNulln_cases, simp)
done

lemma VIntn:   "\<Turnstile>v\<^sub>n (expr.Int i) : {(s,s',v). (s' = tick s) \<and> (v = IVal i)}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalIntn_cases, simp)
done

lemma CVInt:  "G \<Turnstile>v (expr.Int i) : {(s,s',v). (s' = tick s) \<and> (v = IVal i)}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalIntn_cases, simp)
done

lemma VIVarn: "\<Turnstile>v\<^sub>n (expr.IVar vn) : {(s, s', v). (s' = tick s) \<and> v = IVal s<vn>}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalIVarn_cases, simp)
done

lemma CVIVar: "G \<Turnstile>v (expr.IVar vn) : {(s, s', v). (s' = tick s) \<and> v = IVal s<vn>}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalIVarn_cases, simp)
done

lemma VRVarn: "\<Turnstile>v\<^sub>n (expr.RVar vn) : {(s, s', v). (s' = tick s) \<and> v = RVal s\<lfloor>vn\<rfloor>}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalRVarn_cases, simp)
done

lemma CVRVar: "G \<Turnstile>v (expr.RVar vn) : {(s, s', v). (s' = tick s) \<and> v = RVal s\<lfloor>vn\<rfloor>}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalRVarn_cases, simp)
done

subsection {* VPrimop, VRPrimop *}

lemma VPrimopn: 
  "\<Turnstile>v\<^sub>n (expr.Primop f vn1 vn2) : {(s,s',v). s' = tickn 3 s \<and> v = IVal (f (s<vn1>) (s<vn2>))}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalPrimopn_cases, simp)
done

lemma CVPrimop: 
  "G \<Turnstile>v (expr.Primop f vn1 vn2) : {(s,s',v). s' = tickn 3 s \<and> v = IVal (f (s<vn1>) (s<vn2>))}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalPrimopn_cases, simp)
done

lemma VRPrimopn: 
  "\<Turnstile>v\<^sub>n (expr.RPrimop f vn1 vn2) : {(s,s',v). s'=tickn 3 s \<and> v = IVal (f (s\<lfloor>vn1\<rfloor>) (s\<lfloor>vn2\<rfloor>))}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalRPrimopn_cases, simp)
done

lemma CVRPrimop: 
  "G \<Turnstile>v (expr.RPrimop f vn1 vn2) : {(s,s',v). s'=tickn 3 s \<and> v = IVal (f (s\<lfloor>vn1\<rfloor>) (s\<lfloor>vn2\<rfloor>))}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalRPrimopn_cases, simp)
done

lemma VGetFin: "\<Turnstile>v\<^sub>n (GetFi vn f) : {(s,s',v). s'=tickn 2 s \<and> v = IVal (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f>)}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalGetFin_cases, simp)
done

lemma CVGetFi: "G \<Turnstile>v (GetFi vn f) : {(s,s',v). s'=tickn 2 s \<and> v = IVal (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f>)}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalGetFin_cases, simp)
done

lemma VGetFrn: "\<Turnstile>v\<^sub>n (GetFr vn f) : {(s,s',v). s'=tickn 2 s \<and> v = RVal (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f\<rfloor>)}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalGetFrn_cases, simp)
done

lemma CVGetFr: "G \<Turnstile>v (GetFr vn f) : {(s,s',v). s'=tickn 2 s \<and> v = RVal (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f\<rfloor>)}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalGetFrn_cases, simp)
done

lemma VPutFin: 
  "\<Turnstile>v\<^sub>n (PutFi vn f valv) : {(s,s',v). s' = tickn 3 (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f := (s<valv>)>)
				     \<and> v = IVal (s<valv>)}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalPutFin_cases, simp)
done

lemma CVPutFi: 
  "G \<Turnstile>v (PutFi vn f valv) : {(s,s',v). s' = tickn 3 (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f := (s<valv>)>)
				     \<and> v = IVal (s<valv>)}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalPutFin_cases, simp)
done

lemma VPutFrn: 
  "\<Turnstile>v\<^sub>n (PutFr vn f valv) : {(s,s',v). s'= tickn 3 (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f := (s\<lfloor>valv\<rfloor>)\<rfloor>) 
				     \<and> v = RVal (s\<lfloor>valv\<rfloor>)}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalPutFrn_cases, simp)
done

lemma CVPutFr: 
  "G \<Turnstile>v (PutFr vn f valv) : {(s,s',v). s'= tickn 3 (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f := (s\<lfloor>valv\<rfloor>)\<rfloor>) 
				     \<and> v = RVal (s\<lfloor>valv\<rfloor>)}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalPutFrn_cases, simp)
done

lemma VNewn: "\<Turnstile>v\<^sub>n (New c ifldvals rfldvals) : 
	  {(s,s',v). s'=tick (s \<lparr> oheap := (oheap s)((freshlocst s) \<mapsto>\<^sub>f c),
				  iheap := iheapflds ifldvals (freshlocst s) (iheap s) s,
			          rheap := rheapflds rfldvals (freshlocst s) (rheap s) s\<rparr>)
			           \<and> v = RVal (Ref (freshlocst s))}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalNewn_cases, simp)
done

lemma CVNew: "G \<Turnstile>v (New c ifldvals rfldvals) : 
	  {(s,s',v). s'=tick (s \<lparr> oheap := (oheap s)((freshlocst s) \<mapsto>\<^sub>f c),
				  iheap := iheapflds ifldvals (freshlocst s) (iheap s) s,
			          rheap := rheapflds rfldvals (freshlocst s) (rheap s) s\<rparr>)
			           \<and> v = RVal (Ref (freshlocst s))}"
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def)
apply clarsimp
apply (erule evalNewn_cases, simp)
done

subsection {* Contexts *}

lemma Cctx_projn[rule_format]:  "\<lbrakk> |\<Turnstile>\<^sub>v  G ; (e,Q) mem G \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>v e : Q"
apply (induct_tac G)
apply (rule ctx_proj [of G e Q] )
apply simp
apply (simp add: vdm_ctxt_valid_def)
done


subsection {* Main theorem *}

lemma valid_validn: "\<Turnstile>\<^sub>v e : Q \<Longrightarrow> \<Turnstile>v\<^sub>n e : Q"
apply (rule VdmIn)
apply clarify
apply (erule VdmE)
apply (rule evaln_eval)
apply auto
done

lemma [simp]: "( \<Turnstile>\<^sub>v e : Q) =  (\<forall> n. \<Turnstile>v\<^sub>n e : Q)"
apply (simp add: vdm_valid_def vdm_validn_def eval_evaln)
apply auto
apply (erule_tac x="s" in allE)
apply (erule_tac x="t" in allE)
apply (erule_tac x="v" in allE)
apply (erule impE)
apply (erule evaln_eval)
apply assumption
apply (rotate_tac -1)
apply (drule eval_evaln) (* [of s e v t]) *)
apply (rotate_tac -1)
apply (erule_tac exE)
apply (erule_tac x="n" in allE)
apply (erule_tac x="n" in allE)
apply simp
done

(*
theorem hsound: "(G \<turnstile> P e Q) \<Longrightarrow> (G \<Turnstile> P e Q)"
apply (erule hoareproof.induct) 
apply (simp add: vdm_valid_in_ctxt_def  vdm_validn_def)
apply (fastsimp)
(* rules with empty contexts are easy: 
   transfered from corresponding validity rule *)
apply (simp, rule, rule valid_validn, rule HNull)
apply (simp, rule, rule valid_validn, rule HInt)
apply (simp, rule, rule valid_validn, rule HVar)
apply (simp, rule, rule valid_validn, rule HVarr)
apply (simp, rule, rule valid_validn, rule HPrimop)
apply (simp, rule, rule valid_validn, rule HRPrimop)
apply (simp, rule, rule valid_validn, rule HGetFi)
apply (simp, rule, rule valid_validn, rule HGetFr)
apply (simp, rule, rule valid_validn, rule HPutFi)
apply (simp, rule, rule valid_validn, rule HPutFr)
apply (simp, rule, rule valid_validn, rule HNew)
apply (rule CHIf CHLet CHLetr CHLetv CHCall CHPre CHPost CHMeasure, simp+)+
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule, fastsimp intro: ctx_projn)
apply (simp add: vdm_valid_in_ctxt_def)
apply (rule, rule, fastsimp intro: ctx_subn)
done

text {* Finally, soundness in an empty context: *}

corollary "(\<turnstile> P e Q)  \<longrightarrow> (\<Turnstile> P e Q)"
apply (rule, frule hsound, auto intro: validn_valid)
done
*)

subsection {* Soundness and completeness of relativised contextual validity w.r.t. naive validity *}

lemma mini_sound: "\<lbrakk> |\<Turnstile>\<^sub>v G ; G \<Turnstile>v e : P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>v e : P"
apply(simp add: vdm_valid_def vdm_valid_in_ctxt_def)
apply clarsimp
apply (induct_tac n)
apply (erule_tac x=n in allE)
(* base case *)
apply(simp add: vdm_validn_def)
apply (rule allI)+
(* apply (insert no_zero_height_derivs) *)
apply (subgoal_tac "\<forall> s e t v . \<langle>s,e\<rangle> \<longrightarrow>0 \<langle>v,t\<rangle> \<longrightarrow> False")
 apply (erule_tac x="s" in allE)
 apply (erule_tac x="e" in allE)
 apply (erule_tac x="t" in allE)
 apply (erule_tac x="v" in allE)
 apply (simp)
 (* -- *)
 apply (rule allI)+
 apply (rule impI)
 apply (erule evalexprn.elims)
 apply simp+
(* ind case *)
apply(simp add: vdm_validn_def)
apply clarsimp
apply (erule_tac x="m" in allE)
apply (erule_tac x="m" in allE)
apply (frule ctxt_valid_validn)
apply (rotate_tac -1)
apply (erule_tac x="m" in allE)
apply simp
apply (case_tac "m = Suc na")
 apply simp
 apply (erule_tac x="m" in allE)
 apply simp
 (* -- *)
 apply simp
done

corollary "\<Turnstile>v e : P  \<Longrightarrow> \<Turnstile>\<^sub>v e : P"
apply (rule mini_sound [of "[]"])
apply simp
apply assumption
done

lemma mini_complete: "\<Turnstile>\<^sub>v e : P \<Longrightarrow> G \<Turnstile>v e : P"
by (simp add: vdm_valid_def vdm_valid_in_ctxt_def)
 

subsection {* Collecting the rules together *}

text {* The set @{text vdmbasics} are rules used for non-looping code;
  @{text vdmprocs} are the procedure rules.  These rule sets are
  for interactive use, the VCG uses a custom set. *}

lemmas vdmbasicsC = CVNull CVInt CVIVar CVRVar CVPrimop CVRPrimop CVGetFi CVGetFr CVPutFi CVPutFr CVNew CVIf 
(* Let rules still experimental! *)
(* CVLeti CVLetr CVLetv *)

lemmas vdmprocsC  = CVCall CVInvokeStatic CVInvoke

end
