(*  
   File:	$RCSfile: ToyVDMderivedBD.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVDMderivedBD.thy,v 1.1 2003/07/17 20:01:18 a1hloidl Exp $

   Derived VDM rules
*)

theory ToyVDMderivedBD = ToyVDMBD + ToyHLderivedBD:

subsection {* Derived syntax *}

types vdmexpr = "state expr"

syntax Satisfies :: "state postassn \<Rightarrow> vdmexpr \<Rightarrow> vdmexpr"  ("(SATISFIES _:/ _)" [0,60] 66)
translations
 "SATISFIES P : e" => "(POST P : e) :: vdmexpr"   (* fix type *)
 "SATISFIES P : e" <= "POST P : e"

(* do an oldframe on a stack s, which already has a new frame on top; ignore iheap!! *)
constdefs 
 myoldframe :: "state \<Rightarrow> state \<Rightarrow> state"
"myoldframe s' s == s'\<lparr> istore := fst (snd (hd (framestack s))),  rstore := snd (snd (hd (framestack s))), 
	                framestack := (tl (framestack s)) \<rparr>"

lemma my_oldframe: "\<And>s s' mn r vn. myoldframe s' (newframe s mn r (s\<lfloor>vn\<rfloor>)) = oldframe s' s"
by (simp add: myoldframe_def oldframe_def)


(* apply (tactic {* record_split_tac 1 *}) *)

subsection {* Interactive versions of rule (differing from VCG versions) *}

lemma VLetI: "\<lbrakk>  \<Turnstile>\<^sub>v e' : P2; \<Turnstile>\<^sub>v e :  P1 \<rbrakk> \<Longrightarrow>
	  \<Turnstile>\<^sub>v (LET x=e IN e' END) : 
	       {(s,s',v). \<exists> s'' v'. (s,s'',v')\<in> P1
				  \<and> (ivarupdate (tick s'') x (theival v'),s',v) \<in> P2}"
by (simp add: vdm_valid_def, fastsimp elim: evalLeti_cases)

(* Bonzo version for Backward reasoning *)
lemma VIfBonzo: "\<lbrakk> \<Turnstile>\<^sub>v e1 : Q1; \<Turnstile>\<^sub>v e2 : Q2;
		{(s,s',v).  (s<x>=grailbool True \<longrightarrow> (tick s,s',v)\<in> Q1)
		 	  \<and> (s<x>=grailbool False \<longrightarrow> (tick s,s',v)\<in> Q2)} \<subseteq> Q \<rbrakk>
          \<Longrightarrow> \<Turnstile>\<^sub>v (IF x THEN e1 ELSE e2) : Q"
apply (unfold vdm_valid_def)
apply (rule, rule, rule, rule)
apply (fastsimp elim!: evalIf_cases)
done

lemma VLetiBonzo: "\<lbrakk> \<Turnstile>\<^sub>v e : Q1 ; \<Turnstile>\<^sub>v  e' : Q2 ;
                            {(s,s',v). \<exists> t' v'. (s,t',v') \<in> Q1 \<and> ((tick t')<x:=theival v'>,s',v) \<in> Q2} \<subseteq> Q \<rbrakk>
              \<Longrightarrow>  \<Turnstile>\<^sub>v LET x = e IN e' END : Q"
apply (unfold vdm_valid_def)
apply (rule, rule, rule, rule)
(* apply (fastsimp elim!: evalLeti_cases) *)
apply (erule evalLeti_cases)
apply clarsimp
(* pick s t v for let header first *)
apply (erule_tac x="s" in allE)
apply (rotate_tac -1)
apply (erule_tac x="s1" in allE)
apply (rotate_tac -1)
apply (erule_tac x="IVal i" in allE)
apply (erule_tac x="tick s1<x:=i>" in allE)
apply (rotate_tac -1)
apply (erule_tac x="t" in allE)
apply (rotate_tac -1)
apply (erule_tac x="v" in allE)
apply fastsimp
done

lemma VLetrBonzo: "\<lbrakk> \<Turnstile>\<^sub>v e : Q1 ; \<Turnstile>\<^sub>v  e' : Q2 ;
                            {(s,s',v). \<exists> t' v'. (s,t',v') \<in> Q1 \<and> ((tick t')\<lfloor>x:=therval v'\<rfloor>,s',v) \<in> Q2} \<subseteq> Q \<rbrakk>
              \<Longrightarrow>  \<Turnstile>\<^sub>v LET rf x = e IN e' END : Q"
apply (unfold vdm_valid_def)
apply (rule, rule, rule, rule)
(* apply (fastsimp elim!: evalLeti_cases) *)
apply (erule evalLetr_cases)
apply clarsimp
(* pick s t v for let header first *)
apply (erule_tac x="s" in allE)
apply (rotate_tac -1)
apply (erule_tac x="s1" in allE)
apply (rotate_tac -1)
apply (erule_tac x="RVal r" in allE)
apply (erule_tac x="tick s1\<lfloor>x:=r\<rfloor>" in allE)
apply (rotate_tac -1)
apply (erule_tac x="t" in allE)
apply (rotate_tac -1)
apply (erule_tac x="v" in allE)
apply fastsimp
done

lemma VLetvBonzo: "\<lbrakk> \<Turnstile>\<^sub>v e : Q1 ; \<Turnstile>\<^sub>v  e' : Q2 ;
                            {(s,s',v). \<exists> t' v'. (s,t',v') \<in> Q1 \<and> (t',s',v) \<in> Q2} \<subseteq> Q \<rbrakk>
              \<Longrightarrow>  \<Turnstile>\<^sub>v LET _ = e IN e' END : Q"
apply (unfold vdm_valid_def)
apply (rule, rule, rule, rule)
(* apply (fastsimp elim!: evalLeti_cases) *)
apply (erule evalLetv_cases)
apply clarsimp
(* pick s t v for let header first *)
apply (erule_tac x="s" in allE)
apply (rotate_tac -1)
apply (erule_tac x="s1" in allE)
apply (rotate_tac -1)
apply (erule_tac x="rtv1" in allE)
apply (erule_tac x="s1" in allE)
apply (rotate_tac -1)
apply (erule_tac x="t" in allE)
apply (rotate_tac -1)
apply (erule_tac x="v" in allE)
apply fastsimp
done

subsection {* Rules for recursion *}

(* long-winded proof to derive from Hoare version *)
(* NB: HCallRec is still unproven *)
lemma VCallRec: "\<lbrakk> \<Turnstile>\<^sub>v (CALL fn) : P \<Longrightarrow> \<Turnstile>\<^sub>v (funtable fn) :
					      {(s,s',v). \<exists> s''. s=tickcall s''
							 \<and> (s'',s',v) \<in> P} \<rbrakk>  \<Longrightarrow>  
	      \<Turnstile>\<^sub>v (CALL fn) : P"
apply (rule HtoV)
apply (rule HCallRec)
apply (drule HtoV)
apply (subgoal_tac "\<Turnstile>\<^sub>v funtable fn : {(s, s', v). \<exists>s''. s = tickcall s'' \<and> (s'', s', v) \<in> P}")
apply (rule HConseq, rule VtoH)
apply assumption
prefer 2
apply simp
apply auto
apply (erule thin_rl)
apply (subgoal_tac "s''=b")
apply auto
apply (rotate_tac -1)
apply (simp add: tickn_def incrcallcount_def)
apply (rule_tac r=s'' in state.cases)
apply (rule_tac r=b in state.cases)
apply auto
done

(* This version uses inverse image: avoids need for untick uncall junk *)
lemma VCallRec1: "\<lbrakk> \<Turnstile>\<^sub>v (CALL fn) : {(s,s',v). (tickcall s,s',v)\<in> P}
                    \<Longrightarrow> \<Turnstile>\<^sub>v (funtable fn) : P \<rbrakk>
		  \<Longrightarrow> \<Turnstile>\<^sub>v (CALL fn) : {(s,s',v). (tickcall s,s',v)\<in> P}"
apply (rule VCallRec)
apply clarsimp
apply (rule VW)
apply assumption
apply clarsimp
apply (simp add: tickn_def incrcallcount_def)
apply (rule_tac x="a \<lparr> callcount := callcount a - 1, clock := clock a - 1\<rparr>" in exI)
apply auto
apply (rule_tac r=a in state.cases)
apply auto
done

text {*  A customized rule for using post condition in code. *}

lemma VCallRecSat: "\<lbrakk> funtable fn = SATISFIES P : body;
		      \<Turnstile>\<^sub>v (CALL fn) : {(s,s',v). (tickcall s,s',v)\<in> P}
                        \<Longrightarrow> \<Turnstile>\<^sub>v body : P;
		      {(s,s',v). (tickcall s,s',v)\<in> P} \<subseteq> Q \<rbrakk>
		  \<Longrightarrow> \<Turnstile>\<^sub>v (CALL fn) : Q"
apply (rule VW)
apply (rule VCallRec1)
apply auto
apply (rule VPost, auto)
done



subsection {* tweaked rules to make existentials disappear *}

constdefs 
  apfstofthree :: "['a \<Rightarrow> 'd, 'a \<times> 'b \<times> 'c ] \<Rightarrow> 'd \<times> 'b \<times> 'c"
  "apfstofthree \<equiv> \<lambda> f (a,b,c). (f a, b, c)"

declare apfstofthree_def [simp add]

(* alternative version of VCallRec using image operator to hide existential 
lemma VCallRec2: "\<lbrakk> \<Turnstile>\<^sub>v (CALL fn) : P \<Longrightarrow> 
                   \<Turnstile>\<^sub>v (funtable fn) :
                       apfstofthree tickcall ` P \<rbrakk>  \<Longrightarrow>  
	      \<Turnstile>\<^sub>v (CALL fn) : P"
apply (rule VCallRec)
apply (simp add: image_def)
oops
*)

subsection {* Same for static invocation *}

lemma bonzo_1963: "\<forall> m n n'. max m n = max m n' \<and> m <= n \<and> m <= n' --> n=n'"
by (simp add: max_def)

lemma newframe_inj: "\<forall> r v mn . inj (\<lambda> s. newframe s mn r s\<lfloor>v\<rfloor>)"
apply (rule allI)+
apply (rule inj_onI)
apply (rename_tac s s')
apply (simp add: newframe_def)
apply (rule_tac r=s in state.cases)
apply (rule_tac r=s' in state.cases)
apply clarsimp
done

lemma BOBO13: "\<lbrakk> \<Turnstile>\<^sub>v e : P \<rbrakk> \<Longrightarrow> \<forall> s s' v. (s,s',v) \<in> P \<longrightarrow> \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,s'\<rangle> \<longrightarrow> framestack s = framestack s'"
apply (rule allI)+
apply clarify
apply (simp add: framestack_const)
done

(*
lemma BOBO14: "\<lbrakk> \<Turnstile>\<^sub>v InvokeStatic cn mn vn : {(s,s',v). has_frame_of s (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>)v) \<and> (s,s',v) \<in> P} \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>v InvokeStatic cn mn vn : P"
*)

(* P = body + post-tickling *)
(* the "has_frame_of mn s' s" should link the pre- and post-states in the precedent, so
   that we can simplify any reference to the top frame in the post-state to a reference
   to the pre-state, which we know *)
(*
lemma VInvokeStatic000: "
    \<lbrakk> \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . (s, tickn 4 (popframe s'), v) \<in> P \<and> has_frame_of mn s' s} \<rbrakk> \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}"
apply (rule VW)
apply (rule VInvokeStatic)
apply (simp add: framestack_const has_frame_of_def)
apply clarsimp
done

lemma VInvokeStatic000Rec: "
    ( \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P } \<Longrightarrow> \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . (s, tickn 4 (popframe s'), v) \<in> P \<and> has_frame_of mn s' s} ) \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}"
sorry
*)

(* this Lemma is needed to link pre-and post-state *)
lemma BOBO15: "\<And> s mn vn v. snd (snd (hd (framestack (newframe s mn Nullref (s\<lfloor>vn\<rfloor>))))) = rstore s"
(* apply (rule allI)+ *)
apply (simp add: framestack_const )
done

(*++ Version ngoqQIp_cha' ++*)
lemma VngoqQIp_cha': "
    \<lbrakk> methtable C mn = SATISFIES P : body ;
      \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P 
              \<and> rstore s = rstore s' (* FSC3 *) } 
      \<rbrakk>  \<Longrightarrow>   \<Turnstile>\<^sub>v body : {(s,s',v) . (s, tickn 4 (oldframe s' s), v) \<in> P } ;
      {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P \<and> rstore s = rstore s' } \<subseteq> Q \<rbrakk>
      \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : Q"
sorry

(* popframe version *)
(* NB: (t,t') are pre- and post-states of just the body, as specified in P;
       no pre- or post-tickling recorded in these states *)
(*
lemma VInvokeStatic000RecSat: "
    \<lbrakk> methtable C mn = SATISFIES P : body ;
      \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P 
              \<and> rstore s = rstore s' (* FSC3 *) } 
       (* ; (\<forall> t t' v . (newframe t mn Nullref (t\<lfloor>vn2\<rfloor>), tickn 4 (popframe t'), v) \<in> P  \<longrightarrow> topframe_rst t' = rstore t)   FSC2 *)
      \<rbrakk>  \<Longrightarrow>   \<Turnstile>\<^sub>v body : {(s,s',v) . (s, tickn 4 (popframe s'), v) \<in> P } ;
      {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P \<and> rstore s = rstore s' } \<subseteq> Q \<rbrakk>
      \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : Q"
sorry
*)

(*
      (* (\<forall> t t' v . (t,tickn 4 (popframe t'),v) \<in> Q \<and> (newframe t mn Nullref (t\<lfloor>vn2\<rfloor>),t',v) \<in> P \<longrightarrow> topframe_rst t' = rstore t) ;  *)
      (* (\<forall> t t' v . (t,tickn 4 (popframe t'),v) \<in> Q \<longrightarrow>  has_frame_of mn t' t) ; *)
      (* (\<forall> t t' v . (t,tickn 4 (popframe t'),v) \<in> Q \<and> (newframe t mn Nullref (t\<lfloor>vn2\<rfloor>),t',v) \<in> P \<longrightarrow> topframe_rst t' = rstore t) \<longrightarrow>  *)
*)
(*  \<and> (\<exists> t. topframe_rst s' = rstore t \<and> s = newframe t mn Nullref (t\<lfloor>vn2\<rfloor>)) *)

subsubsection {* Invoke *}

(* UNTESTED *)
(* NB: P = body (untickled!) *)
lemma VInvoke:
 "\<And> s_init a C . 
  \<lbrakk>
  \<Turnstile>\<^sub>v (Invoke vn1 mn vn2) : {(s,s',v) . \<exists> t' . s' = tickn 5 (oldframe t' s) \<and> (newframe s mn (Ref a) (s\<lfloor>vn2\<rfloor>), t', v) \<in> P} \<Longrightarrow>
  
   methtable C mn = SATISFIES P : body ;
   \<Turnstile>\<^sub>v body : {(s,s',v) . (\<exists> t t' . t=s_init \<and> t\<lfloor>vn1\<rfloor> = Ref a \<and> t\<guillemotleft>a\<guillemotright> = Some C \<and> 
                          (t,t',v) \<in> P \<and> s=newframe t mn (Ref a) (t\<lfloor>vn2\<rfloor>) \<and> 
		          t' = tickn 5 (oldframe s' t))} ;
   \<Turnstile>\<^sub>v (Invoke vn1 mn vn2) : {(s,s',v) . \<exists> t' . s' = tickn 5 (oldframe t' s) \<and> (newframe s mn (Ref a) (s\<lfloor>vn2\<rfloor>), t', v) \<in> P} \<subseteq> Q \<rbrakk>
   \<Longrightarrow>
   \<Turnstile>\<^sub>v (Invoke vn1 mn vn2) : Q"
sorry

(* EXPERIMENTAL from here on -------------------------------------------------- *)

(* P = pre-tickling + body + post-tickling 
lemma VInvokeStaticNaive: "
    \<lbrakk> (* \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : P \<Longrightarrow> *)
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . (s, tickn 4 (popframe s'), v) \<in> P} \<rbrakk> \<Longrightarrow>      
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}"
apply (rule VW)
apply (rule VInvokeStatic)
apply assumption
apply clarsimp
apply (insert newframe_inj)
apply (rotate_tac -1)
apply (erule_tac x="Nullref" in allE)
apply (erule_tac x="vn2" in allE)
apply (erule_tac x="mn" in allE)
apply (subgoal_tac "a=s''a")
 defer 1
 apply (rule injD)
 apply simp
apply assumption
apply clarsimp
done
*)

(* basic recursion rule *)
(* popframe version *)
(* NB: in contrast to Call, we need access to the pre-tickled state because oldframe
       retrieves orig iheap from this state!! Therefore ex-quantified t *)
(* P = body + post-tickling *)
(*
lemma VInvokeStaticRecUNPROVEN: "
    \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P} \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . (s, tickn 4 (popframe s'), v) \<in> P} \<rbrakk> \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}"
(* fill in proof based on \<turnstile> here !!!! *)
sorry

(* same as above but without ind hypo *)
lemma "
    \<lbrakk> (* \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P} \<Longrightarrow> *)
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . (s, tickn 4 (popframe s'), v) \<in> P} \<rbrakk> \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}"
apply (rule VW)
apply (rule VInvokeStatic)
apply auto
done
*)
(*
apply (insert popframe1)
apply (erule_tac x="a" in allE)
apply (erule_tac x="t'" in allE)
apply (erule_tac x="mn" in allE)
apply (subgoal_tac "(popframe t') = (oldframe t' a)")
apply clarsimp
oops
*)
(*
apply (rule VW)
apply (rule VInvokeStatic)
apply auto
apply (insert newframe_inj)
apply (rotate_tac -1)
apply (erule_tac x="Nullref" in allE)
apply (erule_tac x="vn2" in allE)
apply (erule_tac x="mn" in allE)
apply (subgoal_tac "a=t")
 defer 1
 apply (rule injD)
 apply simp
apply assumption
apply clarsimp
done
*)

(* test test test test test test test test test test test test test test test test *)
(*
lemma VInvokeStaticRecUNPROVEN0: "\<And> t. 
    \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). s=t \<and> (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P} \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . s = newframe t mn Nullref (t\<lfloor>vn2\<rfloor>) \<and>
                                     (s, tickn 4 (oldframe s' t), v) \<in> P} \<rbrakk> \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). s=t \<and> (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}"
sorry
*)

(* trying to pull negative ex out and use a meta-level univ quant *)
(* P = body + post-tickling *)
(* oldframe version
lemma "\<And> t. 
    \<lbrakk> 
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . s = newframe t mn Nullref (t\<lfloor>vn2\<rfloor>) \<and>
                                     (s, tickn 4 (oldframe s' t), v) \<in> P} \<rbrakk> \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). s=t \<and> (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}"
oops
apply (rule VW)
apply (rule VInvokeStatic)
apply auto
apply (insert newframe_inj)
apply (rotate_tac -1)
apply (erule_tac x="Nullref" in allE)
apply (erule_tac x="vn2" in allE)
apply (erule_tac x="mn" in allE)
apply (subgoal_tac "a=t")
 defer 1
 apply (rule injD)
 apply simp
apply assumption
(* -- *)
apply (rotate_tac -1)
apply (erule_tac x="Nullref" in allE)
apply (erule_tac x="vn2" in allE)
apply (erule_tac x="mn" in allE)
apply (subgoal_tac "a=t")
apply simp
 (* subgoal next *)
 apply (rule injD)
 apply simp
apply assumption
apply assumption
done
*)

(* rec version of previous rule
lemma VInvokeStaticRec1: "
    \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P} \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . (s, tickn 4 (oldframe s' s), v) \<in> P} \<rbrakk> \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}"
sorry
*)

(* P specifies method body 
lemma VInvokeStaticNaive0: "
    \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). \<exists> t'. s'=tickn 4 (oldframe t' s) \<and> (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),t',v) \<in> P} \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn :  P \<rbrakk> \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). \<exists> t'. s'=tickn 4 (oldframe t' s) \<and> (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),t',v) \<in> P}"
apply (rule VW)
apply (rule VInvokeStatic)
apply auto
oops
*)
(* rec version of previous rule 
lemma VInvokeStaticRec0: "
    \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). \<exists> t'. s'=tickn 4 (oldframe t' s) \<and> (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),t',v) \<in> P} \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn :  P \<rbrakk> \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). \<exists> t'. s'=tickn 4 (oldframe t' s) \<and> (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),t',v) \<in> P}"
apply (rule VW)
apply (rule VInvokeStaticRecUNPROVEN)
sorry
*)
(*
apply (rule VW)
apply (rule VInvokeStaticRecUNPROVEN)
apply auto
apply (subgoal_tac "\<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}")
apply simp
apply (rule VdmI)
apply (rule allI)+
apply (rule impI)
apply auto
apply (rule VInvokeStaticRec1)
apply (subgoal_tac "\<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}")
apply simp
apply (rotate_tac -1)
apply (frule VdmE)
apply simp
apply simp
apply (rule VInvokeStaticRec1)
oops
*)
(* using ` *)
(*
lemma VInvokeStaticRecSatQQQ: "\<lbrakk> methtable C mn = SATISFIES P : body ;
   \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : (apfstofthree (\<lambda> s. newframe s mn Nullref (s\<lfloor>vn2\<rfloor>)) ` P) \<Longrightarrow>
   \<Turnstile>\<^sub>v body : {(s,s',v) . (s, tickn 4 (oldframe s' s), v) \<in> P};
   (apfstofthree (\<lambda> s. newframe s mn Nullref (s\<lfloor>vn2\<rfloor>)) ` P) \<subseteq> Q \<rbrakk> \<Longrightarrow>      
   \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : Q"
sorry
*)
(* P = body + post-tickling *)
(* oldframe version
lemma VInvokeStaticRecSat: "\<lbrakk> methtable C mn = SATISFIES P : body ;
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P} \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . \<exists> t. s = newframe t mn Nullref (t\<lfloor>vn2\<rfloor>) \<and>
                                           (s, tickn 4 (oldframe s' t), v) \<in> P} ;
     {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P} \<subseteq> Q \<rbrakk> 
     \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : Q"
apply (rule VW)
apply (rule VInvokeStaticRecUNPROVEN)
apply auto
done
*)

(*
lemma VInvokeStaticRecSat: "\<lbrakk> methtable C mn = SATISFIES P : body ;
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P} \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . (s, tickn 4 (popframe s'), v) \<in> P} ;
     {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P} \<subseteq> Q \<rbrakk> 
     \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : Q"
apply (rule VW)
apply (rule VInvokeStaticRecUNPROVEN)
apply auto
done
*)

(* test test test test test test test test test test test test test test test test *)
(*
lemma VInvokeStaticRecSat0: "\<And> t. 
    \<lbrakk> methtable C mn = SATISFIES P : body ;
      \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). s=t \<and> (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P} \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . s = newframe t mn Nullref (t\<lfloor>vn2\<rfloor>) \<and>
                                     (s, tickn 4 (oldframe s' t), v) \<in> P} ;
     {(s,s',v). s=t \<and> (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P} \<subseteq> Q \<rbrakk> 
    \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : Q"
apply (rule VW)
apply (rule VInvokeStaticRecUNPROVEN0)
apply auto
done
*)
(* coolest InvokeStatic rule so far *)
(*
lemma VInvokeStaticRecSatCool: "\<lbrakk> methtable C mn = SATISFIES P : body ;
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : (\<lambda> (s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),tickn 4 (oldframe s' s),v)) ` P \<Longrightarrow>
     \<Turnstile>\<^sub>v body : P ; 
     (\<lambda> (s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),tickn 4 (oldframe s' s),v)) ` P \<subseteq> Q \<rbrakk> \<Longrightarrow>      
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : Q"
apply (rule VW)
apply (rule VInvokeStaticRecUNPROVEN)
defer 1
apply auto
apply (rule VW)
apply (rule VPost)
apply auto
sorry
*)

subsection {* Invoke *}

lemma VInvoke001: "
    \<lbrakk> methtable C mn = SATISFIES P : body ;
      \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P 
              \<and> rstore s = rstore s' (* FSC3 *) } 
      \<rbrakk>  \<Longrightarrow>   \<Turnstile>\<^sub>v body : {(s,s',v) . (s, tickn 4 (oldframe s' s), v) \<in> P } ;
      {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P \<and> rstore s = rstore s' } \<subseteq> Q \<rbrakk>
      \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : Q"
sorry

(* --------------------------------------------------------------------------- *)
(*
lemma "\<lbrakk> \<Turnstile>\<^sub>v InvokeStatic cn mn vn2 : P \<rbrakk> \<Longrightarrow>
       \<forall> s s' v. (s,s',v) \<in> P \<longrightarrow> snd (snd (hd (framestack s'))) = rstore s"
apply (rule allI)+
apply (rule impI)
apply (rule_tac VInvokeStatic)
apply (fastsimp elim: evalInvokeStatic_cases)
oops
*)
(********************************************************************************)

subsection {* Collecting the rules together *}

text {* The set @{text vdmbasics} are rules used for non-looping code;
  @{text vdmprocs} are the procedure rules.  These rule sets are
  for interactive use, the VCG uses a custom set. *}

lemmas vdmbasicsI = VNull VInt VIVar VVarr VPrimop VRPrimop VGetFi VGetFr VPutFi VPutFr VNew VIf VLetI VLetR 

lemmas vdmprocs  = VCall VInvokeStatic 
(* VInvoke  *) (* you wish! *)

(* TEST *)
(*
lemma Vframestack_const: "\<forall> s s' v.  \<Turnstile>\<^sub>v e : P \<and> (s,s',v) \<in> P  \<longrightarrow> framestack s' = framestack s"
apply (rule allI)+
apply (rule impI)
apply (erule conjE)
apply (frule VdmE)
(* apply (rule evalexpr.induct) *)
apply (simp_all add: framestack_const)
done
*)
end
