val before_set2pred_simp_tac =
  (simp_tac (HOL_basic_ss addsimps [Collect_conj_eq RS sym,thm "Compl_Collect"]));

val split_simp_tac = (simp_tac (HOL_basic_ss addsimps [split_conv]));

(*****************************************************************************)
(** set2pred transforms sets inclusion into predicates implication,         **)
(** maintaining the original variable names.                                **)
(** Ex. "{x. x=0} <= {x. x <= 1}" -set2pred-> "x=0 --> x <= 1"              **)
(** Subgoals containing intersections (A Int B) or complement sets (-A)     **)
(** are first simplified by "before_set2pred_simp_tac", that returns only   **)
(** subgoals of the form "{x. P x} <= {x. Q x}", which are easily           **)
(** transformed.                                                            **)
(** This transformation may solve very easy subgoals due to a ligth         **)
(** simplification done by (split_all_tac)                                  **)
(*****************************************************************************)

fun set2pred i thm = let fun mk_string [] = ""
                           | mk_string (x::xs) = x^" "^mk_string xs;
                       (*  
                         val vars=get_vars(thm);
                         val var_string = mk_string (map (fst o dest_Free) vars);
                        *)
      in ((before_set2pred_simp_tac i) THEN_MAYBE
          (EVERY [rtac subsetI i, 
                  (* do we really need Collect[ID] since we work with sets, not
                     functions as assertions anyway -- HWL
                  rtac CollectI i,
                  dtac CollectD i, *)
                  (TRY(split_all_tac i)) THEN_MAYBE
                  ((* (rename_tac var_string i) THEN *)
                   (full_simp_tac (HOL_basic_ss addsimps [split_conv]) i)) ])) thm
      end;

(*****************************************************************************)
(** BasicSimpTac is called to simplify all verification conditions. It does **)
(** a light simplification by applying "mem_Collect_eq", then it calls      **)
(** MaxSimpTac, which solves subgoals of the form "A <= A",                 **)
(** and transforms any other into predicates, applying then                 **)
(** the tactic chosen by the user, which may solve the subgoal completely.  **)
(*****************************************************************************)

val simpletac =   
  clarsimp_tac 
    (HOL_cs ,
    (HOL_basic_ss addsimps [mem_Collect_eq,split_conv] addsimprocs [record_simproc]));

fun MaxSimpTac tac = FIRST'[rtac subset_refl, 
			    set2pred THEN_MAYBE' (simpletac THEN_MAYBE' tac),
                            K all_tac]


fun BasicSimpTac tac = simpletac THEN_MAYBE' MaxSimpTac tac;

val Hleaf_rules = map thm ["VNull" "VInt" "VIVar" "VVarr" "VPrimop" "VRPrimop" "VGetFi" "VGetFr" "VPutFi" "VPutFr" "VNew"] ;

val Hlet_rules = map thm ["VLet" "VLetR"] ; 

(* precond: if a pre-condition is to be solved; 
   rep:     if tactic should loop and fail if not solved 
		(otherwise will execute a single step, and always return a result)
 *)

 fun tacif flag tac = if flag then tac else all_tac

 (* --------------------------------------------------------------------------- *)
 (* std *)

 fun HoareMaybeApplyIndHypThenAgainMaybeNot i = 
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyVDMBD.vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDefBD.expr.Call",_) $ Free(fnname,_) =>
		   (tracing ("__ Using RecWF for function " ^ fnname);
  	           EVERY [rtac (thm "VWC") i, assumption i])
              | Const("ToyGrailDefBD.expr.Call",_) $ Const(fnname,_) =>
		(tracing ("__ Using RecWF for function " ^ fnname);
  	         EVERY [rtac (thm "VWC") i, assumption i])
	     | _ => no_tac)
         | _ => no_tac
      end) i

 (* Apply HRecWF' to a "CALL foo" instance *)
 fun HoareRecWFCall i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyVDMBD.vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDefBD.expr.Call",_) $ Free(fnname,_) =>
		   (tracing ("__ Using HRecWF for function " ^ fnname);
  	           res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "VRecWF'") i)
              | Const("ToyGrailDefBD.expr.Call",_) $ Const(fnname,_) =>
		(tracing ("__ Using HRecWF for function " ^ fnname);
		 res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "VRecWF'") i)
	     | _ => no_tac)
         | _ => no_tac
      end) i

 fun HoareRecWFInvoke i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyVDMBD.vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDefBD.expr.Invoke",_) $ Free(rn,_) $ Free(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvoke for obj " ^ rn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDefBD.expr.Invoke",_) $ Free(rn,_) $ Const(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvoke for obj " ^ rn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDefBD.expr.Invoke",_) $ Const(rn,_) $ Free(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvoke for obj " ^ rn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDefBD.expr.Invoke",_) $ Const(rn,_) $ Const(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvoke for obj " ^ rn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
	     | _ => no_tac)
         | _ => no_tac
      end) i

 fun HoareRecWFInvokestatic i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyVDMBD.vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDefBD.expr.InvokeStatic",_) $ Free(cn,_) $ Free(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvokeStatic for class " ^ cn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDefBD.expr.InvokeStatic",_) $ Free(cn,_) $ Const(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvokeStatic for class " ^ cn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDefBD.expr.InvokeStatic",_) $ Const(cn,_) $ Free(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvokeStatic for class " ^ cn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
              | Const("ToyGrailDefBD.expr.InvokeStatic",_) $ Const(cn,_) $ Const(mn,_)  $ pn =>
		   (tracing ("__ HoareRecWFInvokeStatic for class " ^ cn ^ " and method " ^ mn);
  	           res_inst_tac [("r","meth_wfmeasure_table " ^ mn)] (thm "HRecWF'") i)
	     | _ => no_tac)
         | _ => no_tac
      end) i

 fun HoareCheckInvoke tac i st = st |>
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyVDMBD.vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDefBD.expr.Invoke",_) $  Free(rn,_) $ Free(mn,_) $ pn =>
		   (tracing ("__ HoareRecWFInvoke for class " ^ rn ^ " and method " ^ mn);
  	            all_tac)
              | Const("ToyGrailDefBD.expr.Invoke",_) $ Free(rn,_) $ Const(mn,_) $ pn =>
		   (tracing ("__ HoareRecWFInvoke for class " ^ rn ^ " and method " ^ mn);
  	            all_tac)
              | Const("ToyGrailDefBD.expr.Invoke",_) $ Const(rn,_) $ Free(mn,_) $ pn =>
		   (tracing ("__ HoareRecWFInvoke for class " ^ rn ^ " and method " ^ mn);
  	            all_tac)
              | Const("ToyGrailDefBD.expr.Invoke",_) $ Const(rn,_) $ Const(mn,_) $ pn =>
		   (tracing ("__ HoareRecWFInvoke for class " ^ rn ^ " and method " ^ mn);
  	            all_tac)
	     | _ => no_tac)
         | _ => no_tac
      end) i

 (* --------------------------------------------------------------------------- *)
 (* WAS hoare1: using merged Adaptation and CALL; adaptation is Nipkow-style *)

 (* Apply HRecWF' to a "CALL foo" instance 
 fun HoareRecWFCall1 i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyVDMBD.vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDefBD.expr.Call",_) $ Free(fnname,_) =>
		   (tracing (".. Using HRecWF for function " ^ fnname);
  	           res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "HRecWF'") i)
              | Const("ToyGrailDefBD.expr.Call",_) $ Const(fnname,_) =>
		(tracing (".. Using HRecWF for function " ^ fnname);
		 res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "HRecWF'") i)
	     | _ => no_tac)
         | _ => no_tac
      end) i
 *)
 fun VDMLetRule1Tac tac precond rep i = 
     (tracing "-- Trying Let" ; 
      EVERY[resolve_tac Vlet_rules i,
            fn x => (tracing ".. Got lucky with a Let"; all_tac x),
            tacif rep (VDMRule1Tac tac true(*!!was:false!!*) rep (i+1))]  (* let body *)
     )
 and VDMRule1Tac tac precond rep i st = st |>  
    (  (VDMLetRule1Tac tac precond rep i  THEN 
         tacif rep (VDMRule1Tac tac precond rep i))            (* let header *)
       ORELSE
     ( 
     (tracing ".. Once more unto the breach" ; 
      FIRST[trace_goalno_tac (resolve_tac Vleaf_rules) i,
	    (tracing ".. No leaf, Trying If" ; 
	     EVERY[trace_goalno_tac (rtac (thm "VIf")) i,
                   tacif rep (VDMRule1Tac tac true(*!!was:false!!*) rep (i+2)), (* else branch *)
                   tacif rep (VDMRule1Tac tac true(*!!was:false!!*) rep (i+1))]), (* then branch *)
	    (tracing ".. No If, Trying Call" ; 
             (assume_tac i)      (* CALL: induction hyp by assumption *)
				  (* FIXME: would be nice to thin remaining goals here *)
              ORELSE		  (* or, try unravelling body. *)
	      (EVERY[trace_goalno_tac (rtac (thm "VCall")) i,
		     (* rtac allI i, *)
		     tac i,	  (* unfolding of fntable should be done by tac! *)
                     tacif rep (VDMRule1Tac tac true rep i)])),    
				(* FIXME: why extra subgoal here? *)
	    (tracing ".. No Call, Trying Invoke" ; 
             (assume_tac i)    (* CALL: induction hyp by assumption *)
				(* FIXME: would be nice to thin remaining goals here *)
              ORELSE		(* or, try unravelling body. *)
	      (EVERY[trace_goalno_tac (rtac (thm "HInvokeStatic")) i,
		     rtac allI i,  
		     tac i,
                     tacif rep (VDMRule1Tac tac false rep i)])),       (* method body *)

	    (tracing ".. Nothing at all, let's sulk in a corner" ; 
             if rep then (K all_tac i) else no_tac )    (* if stepping, must succeed on some rule. *)
             ]
       THEN 
             (if precond 
               then (if rep then (fn x=>x) else TRY) (tracing ".. BasicSimpTac" ; trace_goalno_tac (BasicSimpTac tac) i)
               else (if rep then (fn x=>x) else TRY) (tracing ".. subset_refl" ; (trace_goalno_tac (rtac (thm "subset_refl")) i))
            )
         )) )

fun vcg_tac tac i thm = SUBGOAL (fn _ =>
   (VDMRule1Tac tac true true i)) i thm

fun vcg_step_tac tac i thm = SUBGOAL (fn _ =>
   (VDMRule1Tac tac true false i)) i thm

 (* --------------------------------------------------------------------------- *)
 (* WAS hoare3: using merged Adaptation and CALL; adaptation is Kleyman-style *)

 (* Apply HRecWF' to a "CALL foo" instance 
 fun HoareRecWFCall3 i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyVDMBD.vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDefBD.expr.Call",_) $ Free(fnname,_) =>
		   (tracing ("__ Using HRecWF for function " ^ fnname);
                    res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "HRecWF'") i)
              | Const("ToyGrailDefBD.expr.Call",_) $ Const(fnname,_) =>
		  (tracing ("__ Using HRecWF for function " ^ fnname);
		   res_inst_tac [("r","fun_wfmeasure_table " ^ fnname)] (thm "HRecWF'") i)
	     | _ => no_tac)
         | _ => no_tac
      end) i
 *)

 fun VDMLetRuleTac tac precond rep i = 
     (tracing "-- Trying Let" ; 
      EVERY[resolve_tac Vlet_rules i,
            fn x => (tracing ".. Got lucky with a Let"; all_tac x),
            tacif rep (VDMRuleTac tac true(*!!was:false!!*) rep (i+1))]  (* let body *)
     )
 and VDMRuleTac tac precond rep i st = st |>  
    (  (VDMLetRuleTac tac precond rep i  THEN 
         tacif rep (VDMRuleTac tac precond rep i))            (* let header *)
       ORELSE
     ( 
     (tracing "__ Once more unto the breach" ; 
      FIRST[trace_goalno_tac (resolve_tac Vleaf_rules) i,
	    (tracing "__ No leaf, Trying If" ; 
	     EVERY[trace_goalno_tac (rtac (thm "HIf'")) i,
                   tacif rep (VDMRuleTac tac true(*!!was:false!!*) rep (i+2)),   (* else branch *)
                   tacif rep (VDMRuleTac tac true(*!!was:false!!*) rep (i+1))]), (* then branch *)
	    (tracing "__ No If, Trying Call" ; 
             (HoareMaybeApplyIndHypThenAgainMaybeNot i)       (* apply ind hyp if possb *)
				  (* FIXME: would be nice to thin remaining goals here *)
              ORELSE		  (* or, try unravelling body. *)
	      (EVERY[rtac (thm "VWC") i,
                     trace_goalno_tac (rtac (thm "VCallpost")) i,
		     (* rtac allI i, *)
		     tac i,	  (* unfolding of fntable should be done by tac! *)
                     tacif rep (VDMRuleTac tac true rep i)])),    
				(* FIXME: why extra subgoal here? *)
	    (tracing "__ No Call, Trying Invoke" ; 
             (assumption i)       (* apply ind hyp if possb *)
				(* FIXME: would be nice to thin remaining goals here *)
              ORELSE		(* or, try unravelling body. *)
	      (EVERY[trace_goalno_tac (rtac (thm "VInvoke")) i,
		     rtac allI i,  
		     tac i,
                     tacif rep (VDMRuleTac tac false rep i)])),       (* method body *)

	    (tracing "__ No Invoke, trying InvokeStatic" ; 
             (assumption i)       (* apply ind hyp if possb *)
				(* FIXME: would be nice to thin remaining goals here *)
              ORELSE		(* or, try unravelling body. *)
	      (EVERY[trace_goalno_tac (rtac (thm "HInvokeStatic")) i,
		     rtac allI i,  
		     tac i,
                     tacif rep (VDMRuleTac tac false rep i)])),       (* method body *)

	    (tracing "__ Nothing at all, let's sulk in a corner" ; 
             if rep then (K all_tac i) else no_tac )    (* if stepping, must succeed on some rule. *)
             ]
       THEN 
             (if precond 
               then (if rep then (fn x=>x) else TRY) (tracing "__ BasicSimpTac" ; trace_goalno_tac (BasicSimpTac tac) i)
               else (if rep then (fn x=>x) else TRY) (tracing "__ subset_refl" ; (trace_goalno_tac (rtac (thm "subset_refl")) i))
            )
         )) )

fun vcg1_tac tac i thm = SUBGOAL (fn _ =>
   (VDMRuleTac tac true true i)) i thm

fun vcg1_step_tac tac i thm = SUBGOAL (fn _ =>
   (VDMRuleTac tac true false i)) i thm

(* --------------------------------------------------------------------------- *)
(* rec: using invariants in function calls *)

 (* Similar to HoareRecWFCall, but inserting pre- and post-conditions here *)

 fun VDMInst thmname p tab i =
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl (* fixme: dest *) of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyVDMBD.vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		Const("ToyGrailDefBD.expr.Call",_) $ Free(fnname,_) =>
		   (tracing ("__ VDMInst for function " ^ fnname);
		 res_inst_tac [(p,tab ^ " " ^ fnname)] (thm thmname) i)
              | Const("ToyGrailDefBD.expr.Call",_) $ Const(fnname,_) =>
		(tracing ("__ VDMInst for function " ^ fnname);
		 res_inst_tac [(p,tab ^ " " ^ fnname)] (thm thmname) i)
	     | _ => no_tac)
         | _ => no_tac
      end) i

 fun VDMLetRuleTacRec tac precond rep i = 
     (tracing "-- Trying Let" ; 
      EVERY[resolve_tac Hlet_rules i,
            fn x => (tracing ".. Got lucky with a Let"; all_tac x),
            tacif rep (VDMRuleTacRec tac true(*!!was:false!!*) rep (i+1))]  (* let body *)
     )
 and VDMRuleTacRec tac precond rep i st = st |>  
    (  (VDMLetRuleTacRec tac precond rep i  THEN 
        tacif rep (VDMRuleTacRec tac precond rep i))            (* let header *)
       ORELSE
     ( 
     (tracing "Trying Leaf" ; 
      FIRST[resolve_tac Vleaf_rules i,
	    (tracing "Trying If" ; 
	     EVERY[rtac (thm "VIf") i,
                   tacif rep (VDMRuleTacRec tac true(*!!was:false!!*) rep (i+2)),     (* else branch *)
                   tacif rep (VDMRuleTacRec tac true(*!!was:false!!*) rep (i+1))]),	(* then branch *)
             ((EVERY[VDMInst "VCall" "Q'" "fun_postassn_table" i, (* ??? *)
                     (* or use some form of adaptation rule with hard-wired table lookup
                     rtac (thm "HWC") i,
                     rtac (thm "HCallAdapt3") i,
		     *)
		     tac (i+1),
                     HoareInst "HSP" "P'" "fun_preassn_table" i, (* ??? *)
                     tac i])),
             ((EVERY[rtac (thm "HSP") i,
                     rtac (thm "HInvoke") i,
		     rtac allI i,  
		     tac i,
                     tacif rep (VDMRuleTacRec tac false rep i)])),    (* method body *)

             if rep then (K all_tac i) else no_tac  (* if stepping, must succeed on some rule. *)
             ]
       THEN (tracing "Done" ; 
             (if precond 
               then (if rep then (fn x=>x) else TRY) (BasicSimpTac tac i)
               else (if rep then (fn x=>x) else TRY) (rtac (thm "subset_refl") i))
            )
         )) )

 (* --------------------------------------------------------------------------- *)
 (* check whether top level thing in conclusion is a hoare_valid of an expr *)

 fun VDMCheckExpr tac i  st = st |>  
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl of 
	  (Const ("Trueprop", _) $
	   (Const ("ToyVDMBD.vdm_valid",_) $ P $ expr $ Q)) =>
	      (case expr of 
		  Const("ToyGrailDefBD.expr.Call",_) $ Free(fnname,_) =>
		   (tracing ("^^ it is a CALL " ^ fnname); all_tac)
		| Const("ToyGrailDefBD.expr.Invoke",_) $ rname1 $ mname $ rname2 =>
		   (tracing "^^ it is a Invoke "; all_tac)
		| Const("ToyGrailDefBD.expr.Null",_) =>
		   (tracing "^^ it is a Null "; all_tac)
		| Const("ToyGrailDefBD.expr.Int",_) $ i =>
		   (tracing "^^ it is a Int "; all_tac)
		| Const("ToyGrailDefBD.expr.IVar",_) $ iname  =>
		   (tracing "^^ it is a IVar "; all_tac)
		| Const("ToyGrailDefBD.expr.RVar",_) $ rname  =>
		   (tracing "^^ it is a RVar "; all_tac)
		| Const("ToyGrailDefBD.expr.Primop",_) $ f $ iname1 $ iname2  =>
		   (tracing "^^ it is a Primop "; all_tac)
		| Const("ToyGrailDefBD.expr.RPrimop",_) $ f $ rname1 $ rname2  =>
		   (tracing "^^ it is a RPrimop "; all_tac)
		| Const("ToyGrailDefBD.expr.New",_) $ cname  =>
		   (tracing "^^ it is a New "; all_tac)
		| Const("ToyGrailDefBD.expr.If_",_) $ iname $ expr1 $ expr2 =>
		   (tracing "^^ it is a If "; all_tac)
		| Const("ToyGrailDefBD.expr.Leti",_) $ iname $ expr1 $ expr2 =>
		   (tracing "^^ it is a Leti "; all_tac)
		| Const("ToyGrailDefBD.expr.Letr",_) $ rname $ expr1 $ expr2 =>
		   (tracing "^^ it is a Letr "; all_tac)
		| Const("ToyGrailDefBD.expr.GetFi",_) $ ifldname $ iname2 =>
		   (tracing "^^ it is a GetFi "; all_tac)
		| Const("ToyGrailDefBD.expr.GetFr",_) $ ifldname $ iname =>
		   (tracing "^^ it is a GetFr "; all_tac)
		| Const("ToyGrailDefBD.expr.PutFi",_) $ iname1 $ ifldname $ iname2 =>
		   (tracing "^^ it is a PutFi "; all_tac)
		| Const("ToyGrailDefBD.expr.PutFr",_) $ rname $ ifldname $ iname =>
		   (tracing "^^ it is a PutFr "; all_tac)
	        | _ => (tracing "^^ no match in inner case over expr" ; all_tac))
         | _ => (tracing "^^ VDMInst: no match in outer case over concl" ; no_tac)
      end) i

 (* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)

fun vcg_check_expr_tac tac i thm = SUBGOAL (fn _ =>
   (VDMCheckExpr tac i)) i thm

fun vcg_check_invoke_tac tac i thm = SUBGOAL (fn _ =>
   (VDMCheckInvoke tac i)) i thm

fun vcg_rec_tac tac i thm = SUBGOAL (fn _ =>
   (VDMRuleTacRec tac true true i)) i thm

fun vcg_rec_step_tac tac i thm = SUBGOAL (fn _ =>
   (VDMRuleTacRec tac true false i)) i thm

