(*  
   File:	ToyHLrec.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLrecBD.thy,v 1.1 2003/07/17 20:01:17 a1hloidl Exp $

   Auxiliary material to help prove soundness of recursive
   rules for partial correctness.
*)   

theory ToyHLrecBD = ToyHLbasicBD:

subsection {* Evalution relation with height *}

text {* Annoyingly we need another inductive definition which mentions the
   height of the derivation.  The clock isn't usable for this because of
   the logical rules which do not affect it, and the fact that it isn't
   incremented by exactly one tick for each rule. 
   [FIXME: check this!  Actually we only use it below in the case
    of a callcount increment\<dots>]
 *}

consts
  evalexprn  :: "(state \<times> 'a expr \<times> nat \<times> val \<times> state) set"

syntax
 evalexprn_  :: "[state, 'a expr, nat, val, state] \<Rightarrow> bool"      ("\<langle>_,_\<rangle> \<longrightarrow>_ \<langle>_,_\<rangle>")

translations
 "\<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle>" == "(s,e,n,v,s') : evalexprn"

inductive evalexprn intros
 evalnNull:    "\<langle>s, expr.Null\<rangle>   \<longrightarrow>1  \<langle>RVal Nullref, tick s\<rangle>"

 evalnInt:     "\<langle>s, expr.Int i\<rangle>  \<longrightarrow>1  \<langle>IVal i, tick s\<rangle>"

 evalnIVar:    "\<langle>s, IVar v\<rangle>      \<longrightarrow>1  \<langle>IVal (s<v>), tick s\<rangle>"

 evalnRVar:    "\<langle>s, RVar v\<rangle>      \<longrightarrow>1  \<langle>RVal (s\<lfloor>v\<rfloor>), tick s\<rangle>"

 evalnPrimop:  "\<langle>s, Primop f vn1 vn2\<rangle>  \<longrightarrow>1  \<langle>IVal (f (s<vn1>) (s<vn2>)), tickn 3 s\<rangle>"

 evalnRPrimop: "\<langle>s, RPrimop f vn1 vn2\<rangle> \<longrightarrow>1  \<langle>IVal (f (s\<lfloor>vn1\<rfloor>) (s\<lfloor>vn2\<rfloor>)), tickn 3 s\<rangle>"

 evalnGetFi:   "s\<lfloor>vn\<rfloor> = Ref a  \<Longrightarrow>  \<langle>s,  GetFi vn f\<rangle> \<longrightarrow>1 \<langle>IVal (s<a\<bullet>f>), tickn 2 s\<rangle>"

 evalnGetFr:   "s\<lfloor>vn\<rfloor> = Ref a  \<Longrightarrow>  \<langle>s,  GetFr vn f\<rangle> \<longrightarrow>1 \<langle>RVal (s\<lfloor>a\<diamondsuit>f\<rfloor>), tickn 2 s\<rangle>"

 evalnPutFi:   "s\<lfloor>vn1\<rfloor> = Ref a \<Longrightarrow> 
		\<langle>s, PutFi vn1 f vn2\<rangle> \<longrightarrow>1 \<langle> IVal (s<vn2>), tickn 3 (s<a\<bullet>f := (s<vn2>)>) \<rangle>"

 evalnPutFr:   "s\<lfloor>vn1\<rfloor> = Ref a \<Longrightarrow> 
                \<langle>s, PutFr vn1 f vn2\<rangle> \<longrightarrow>1 \<langle> RVal (s\<lfloor>vn2\<rfloor>), tickn 3 (s\<lfloor>a\<diamondsuit>f := (s\<lfloor>vn2\<rfloor>)\<rfloor>) \<rangle>"

 evalnNew:      "\<langle> s, New c ifldvals rfldvals\<rangle> \<longrightarrow>1 
		\<langle>RVal (Ref (freshlocst s)), tick (newobj s c ifldvals rfldvals)\<rangle>"

 evalnIf_True:  "\<lbrakk> s<v> = grailbool True; 
		  \<langle>tick s, l1\<rangle> \<longrightarrow>n \<langle>rtv, s1\<rangle> \<rbrakk> \<Longrightarrow> \<langle>s, Ifg v l1 l2\<rangle> \<longrightarrow>(n+1) \<langle>rtv, s1\<rangle>"

 evalnIf_False: "\<lbrakk> s<v> = grailbool False; 
		  \<langle>tick s, l2\<rangle> \<longrightarrow>n \<langle>rtv, s1\<rangle> \<rbrakk> \<Longrightarrow> \<langle>s, Ifg v l1 l2\<rangle> \<longrightarrow>(n+1) \<langle>rtv,s1\<rangle>"

 evalnLeti:     "\<lbrakk> \<langle>s, e\<rangle> \<longrightarrow>n \<langle>IVal i, s1\<rangle> ; \<langle>(tick s1)<vn:=i>, ls\<rangle> \<longrightarrow>m \<langle>rtv2, s2\<rangle> \<rbrakk>
	        \<Longrightarrow>
                \<langle>s, Leti vn e ls\<rangle> \<longrightarrow>(max (n+1) (m+1)) \<langle>rtv2, s2\<rangle>"

 evalnLetr:     "\<lbrakk> \<langle>s, e\<rangle> \<longrightarrow>n \<langle>RVal r, s1\<rangle> ; \<langle>(tick s1)\<lfloor>vn:=r\<rfloor>, ls\<rangle> \<longrightarrow>m \<langle>rtv2, s2\<rangle> \<rbrakk>
                \<Longrightarrow>
                \<langle>s, Letr vn e ls\<rangle> \<longrightarrow>(max (n+1) (m+1)) \<langle>rtv2, s2\<rangle>"

 evalnLetv:     "\<lbrakk> \<langle>s, e\<rangle> \<longrightarrow>n \<langle>rtv1, s1\<rangle> ; \<langle>s1, ls\<rangle> \<longrightarrow>m \<langle>rtv2, s2\<rangle> \<rbrakk>
                \<Longrightarrow>
                \<langle>s, Letv e ls\<rangle> \<longrightarrow>(max (n+1) (m+1)) \<langle>rtv2, s2\<rangle>"

 evalnCall:     "\<lbrakk> \<langle>tickcall s, funtable fn\<rangle> \<longrightarrow>n \<langle>rtv, s1\<rangle> \<rbrakk>
                \<Longrightarrow>
                \<langle>s, CALL fn\<rangle> \<longrightarrow>(n+1) \<langle>rtv, s1\<rangle>" 

 evalnInvoke: 
  "\<lbrakk> s\<lfloor>vn1\<rfloor> = Ref a; s\<guillemotleft>a\<guillemotright> = Some C;
     \<langle>newframe s mn (Ref a) (s\<lfloor>vn2\<rfloor>), methtable C mn\<rangle> \<longrightarrow>n \<langle>rtv, s'\<rangle> \<rbrakk>
 \<Longrightarrow>
    \<langle>s , Invoke vn1 mn vn2\<rangle> \<longrightarrow>(n+1) \<langle>rtv, tickn 5 (oldframe s' s) \<rangle>"

 evalnInvokeStatic: 
  "\<lbrakk> \<langle>newframe s mn Nullref (s\<lfloor>vn2\<rfloor>), methtable C mn\<rangle> \<longrightarrow>n \<langle>rtv, s'\<rangle> \<rbrakk>
 \<Longrightarrow>
   \<langle>s , InvokeStatic C mn vn2\<rangle> \<longrightarrow>(n+1) \<langle>rtv, tickn 4 (oldframe s' s) \<rangle>"

 evalnPre:     "\<lbrakk> (* (z,s) \<in> P; *) \<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle> \<rbrakk>    \<Longrightarrow> \<langle>s, Pre P e\<rangle> \<longrightarrow>(n+1) \<langle>v,s'\<rangle>"

 evalnPost:    "\<lbrakk> \<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle> (* (z,s',v) \<in> Q *) \<rbrakk> \<Longrightarrow> \<langle>s, Post Q e\<rangle> \<longrightarrow>(n+1) \<langle>v,s'\<rangle>"
 
 evalnMeasure: "\<lbrakk> \<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle>  (* (s,s') \<in> M *) \<rbrakk>   \<Longrightarrow> \<langle>s, Measure M e\<rangle> \<longrightarrow>(n+1) \<langle>v,s'\<rangle>"

(* FIXME: could we use size of term? *)

section {* Equivalence between operational semantics *}

lemma eval_evaln: "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,s'\<rangle> \<Longrightarrow> (\<exists> n. \<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle>)"
apply (erule evalexpr.induct)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros)
apply (rule, rule evalexprn.intros, assumption)
apply (rule, rule evalexprn.intros, assumption)
apply (rule, rule evalexprn.intros, assumption)
apply (rule, rule evalexprn.intros, assumption)
apply (rule, rule evalexprn.intros)
apply (erule exE, rule, rule evalexprn.intros, assumption, assumption)
apply (erule exE, rule, rule evalexprn.intros, assumption, assumption)
apply (erule exE, erule exE, rule, erule evalnLeti, assumption)
apply (erule exE, erule exE, rule, erule evalnLetr, assumption)
apply (erule exE, erule exE, rule, erule evalnLetv, assumption)
apply (erule exE, rule, rule evalexprn.intros, assumption)
(* apply (erule exE, rule, erule evalexprn.intros, assumption, assumption) *)
apply (erule exE)
apply (rule)
apply (erule evalexprn.intros)
apply (assumption)
apply (assumption)
(* -- *)
apply (erule exE)
apply (rule)
apply (erule evalexprn.intros)
(* -- *)
apply (erule exE)
apply (rule)
apply (erule evalexprn.intros)
(* -- *)
apply (erule exE)
apply (rule)
apply (erule evalexprn.intros)
(* -- *)
apply (erule exE)
apply (rule)
apply (erule evalexprn.intros)
(* -- *)
done

lemma evaln_eval: "\<langle>s,e\<rangle> \<longrightarrow>n \<langle>v,s'\<rangle> \<Longrightarrow> \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,s'\<rangle>"
apply (erule evalexprn.induct)
apply (auto intro: evalexpr.intros)+
done

lemma no_zero_height_derivs: "\<langle>s,e\<rangle> \<longrightarrow>0 \<langle>v,s'\<rangle> \<Longrightarrow> False"
apply (erule evalexprn.elims)
apply simp+
done


section {* Relativized validity *}


constdefs 
  hoare_validn :: "nat \<Rightarrow> 'a preassn \<Rightarrow> 'a expr \<Rightarrow> 'a postassn \<Rightarrow> bool"  ("\<Turnstile>\<^sub>_ (1_)/ (_)/ (1_)" 50)

  "\<Turnstile>\<^sub>n P e Q \<equiv> (\<forall> m. m<=n \<longrightarrow> (\<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>m \<langle>v,t\<rangle> \<longrightarrow> (\<forall> z. (z, s) \<in>  P \<longrightarrow> (z, t, v) \<in> Q)))" 

lemma HoareIn: 
  "(\<forall> m. m<=n \<longrightarrow> (\<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>m \<langle>v,t\<rangle> \<longrightarrow> (\<forall> z. ((z,s)\<in> P \<longrightarrow> (z,t,v)\<in> Q)))) \<Longrightarrow> \<Turnstile>\<^sub>n P e Q"
by (unfold hoare_validn_def, auto)

lemma lowerm: "\<lbrakk>   \<Turnstile>\<^sub>n P e Q; m <= n \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>m P e Q"
apply (simp (no_asm) add: hoare_validn_def)
apply (rule, rule)
apply (unfold hoare_validn_def)
apply (erule_tac x=ma in allE)
apply auto
done

lemma valid_validn: "\<Turnstile> P e Q \<Longrightarrow> \<forall> n. \<Turnstile>\<^sub>n P e Q"
apply (rule allI, rule HoareIn)
apply clarify
apply (erule HoareE)
apply (rule evaln_eval)
apply auto
done

lemma validn_valid: "\<forall> n. \<Turnstile>\<^sub>n P e Q \<Longrightarrow> \<Turnstile> P e Q"
apply (simp add: hoare_valid_def)
apply clarify
apply (drule eval_evaln)
apply (erule exE)
apply (erule_tac x=n in allE)
apply (simp add: hoare_validn_def)
apply auto
done


lemma validsucn_validn: "(\<Turnstile>\<^sub>(n+1) P e Q) \<longrightarrow> \<Turnstile>\<^sub>n P e Q"
apply (unfold hoare_validn_def)
apply clarsimp
apply (erule_tac x="m" in allE)
apply auto
done

inductive_cases evalCalln_cases : "(s, Call fn, n, v, s') \<in> evalexprn"

lemma calllemma[rule_format(no_asm)]: 
     "(\<forall> m. m<n \<longrightarrow> (\<Turnstile>\<^sub>m P (CALL fn) Q) \<longrightarrow> (\<Turnstile>\<^sub>m (imagepre tickcall P) (funtable fn) Q))
		   \<longrightarrow> (\<Turnstile>\<^sub>n P (CALL fn) Q)"
apply (induct_tac n)
apply (simp add: hoare_validn_def)
apply (clarify, drule no_zero_height_derivs, auto)
apply (simp (no_asm) add: hoare_validn_def)
apply (rule, case_tac "m=Suc n") (* interesting case first *)
apply rule
apply clarsimp
apply (erule evalCalln_cases)
apply (erule_tac x=n in allE)
apply simp
apply (erule thin_rl)
apply (simp add: hoare_validn_def)
apply fastsimp
(* now case by IH immediately *)
apply rule
apply (erule thin_rl)
apply (simp add: hoare_validn_def)
apply (erule_tac x=m in allE)
apply fastsimp
done

inductive_cases evalInvokeStaticn_cases : "(s, InvokeStatic cn mn vn, n, v, s') \<in> evalexprn"

lemma invokestaticlemma[rule_format(no_asm)]: 
   "(\<forall> m. m<n \<longrightarrow> (\<Turnstile>\<^sub>m P (InvokeStatic cn mn vn) Q) \<longrightarrow> 
                    (\<forall> s_init. 
                       \<Turnstile>\<^sub>m {(z, s). s = newframe s_init mn Nullref (s_init\<lfloor>vn\<rfloor>) \<and> (z, s_init) \<in> P}
                       methtable cn mn
                       {(z,s,v). (z,tickn 4 (oldframe s s_init),v) \<in> Q}) )
   \<longrightarrow> (\<Turnstile>\<^sub>n P (InvokeStatic cn mn vn) Q)"
apply (induct_tac n)
apply (simp add: hoare_validn_def)
apply (clarify, drule no_zero_height_derivs, auto)
apply (simp (no_asm) add: hoare_validn_def)
apply (rule, case_tac "m=Suc n") (* interesting case first *)
 apply rule
 apply clarsimp
 apply (erule_tac x="n" in allE)
 apply simp
 apply (erule thin_rl)
 apply (simp add: hoare_validn_def)
 apply (erule_tac x="s" in allE)
 apply (erule_tac x="n" in allE)
 apply clarsimp
 apply (erule evalInvokeStaticn_cases)
 apply clarsimp
 (* m < Suc n *)
 apply (rule impI)
 apply (rule allI)+
 apply (rule impI)
 apply (rule allI)
 apply (rule impI)
 apply (simp add: hoare_validn_def)
 apply (erule_tac x=m in allE)
 apply (erule_tac x=m in allE)
 apply clarsimp
done

inductive_cases evalInvoken_cases : "(s, Invoke vn1 mn vn2, n, v, s') \<in> evalexprn"

lemma invokelemma[rule_format(no_asm)]: 
   "(\<forall> m. m<n \<longrightarrow> (\<Turnstile>\<^sub>m P (Invoke vn1 mn vn2) Q) \<longrightarrow> 
                    (\<forall> a s_init. 
                        
                       \<Turnstile>\<^sub>m {(z, s). s_init\<lfloor>vn1\<rfloor> = (Ref a) \<and> 
                                    s = newframe s_init mn (Ref a) (s_init\<lfloor>vn2\<rfloor>) \<and>
                                    (z, s_init) \<in> P}
                           (methtable (the (s_init\<guillemotleft>a\<guillemotright>)) mn)
                           {(z,s,v). (z,tickn 5 (oldframe s s_init),v) \<in> Q}))
   \<longrightarrow> (\<Turnstile>\<^sub>n P (Invoke vn1 mn vn2) Q)"
apply (induct_tac n)
apply (simp add: hoare_validn_def)
apply (clarify, drule no_zero_height_derivs, auto)
apply (simp (no_asm) add: hoare_validn_def)
apply (rule, case_tac "m=Suc n") (* interesting case first *)
 apply rule
 apply clarsimp
 apply (erule_tac x="n" in allE)
 apply simp
 apply (erule thin_rl)
 apply (simp add: hoare_validn_def)
 apply (erule evalInvoken_cases)
 apply (erule_tac x="a" in allE)
 apply (erule_tac x="s" in allE)
 apply (erule_tac x="n" in allE)
 apply clarsimp
 (* m < Suc n *)
 apply (rule impI)
 apply (rule allI)+
 apply (rule impI)
 apply (rule allI)
 apply (rule impI)
 apply (simp add: hoare_validn_def)
 apply (erule_tac x=m in allE)
 apply (erule_tac x=m in allE)
 apply clarsimp
done

end
