(*  
   File:        $RCSfile: ExamplePingVDMBD.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExamplePingVDMBD.thy,v 1.1 2003/07/17 20:01:15 a1hloidl Exp $

   Example: ping (simplified for direct recursion; using Invoke) VDM style
*)

theory ExamplePingVDMBD = ToyPreludeBD + ToyVDMderivedBD:

section {* Testing the VCGen *}

subsection {* ping example: direct recursion *}

(* --------------------------------------------------------------------------- *)
(* Code                                                                        *)
(* --------------------------------------------------------------------------- *)

(*
  class PingClass = field Pong pong  
               field int count
               method ping () { count := count -1; 
                                if count > 0  PingClass.ping() else return ()
*)

(* "param never changes" (needed in popframe- but not in oldframe version): *)
(*  s\<lceil>param\<rceil> = s'\<lceil>param\<rceil> *)

locale pingI_example =
 fixes  m      	  :: iname
 fixes  n      	  :: iname
 fixes  q      	  :: iname
 fixes  h      	  :: iname
 fixes  x      	  :: iname
 fixes  z      	  :: iname
 fixes  count  	  :: ifldname
 fixes  pong   	  :: ifldname
 fixes  ping   	  :: mname
 fixes  PingClass :: cname
 fixes  l1        :: locn
 assumes ping_methtable[simp]: "methtable PingClass ping =
           (SATISFIES {(s::state,s'::state,v).  0 < s<s\<lceil>param\<rceil>\<bullet>count> \<longrightarrow>
                        v = (IVal 0) \<and> s'<s'\<lceil>param\<rceil>\<bullet>count> = 0} :
            (LET 
                m  = param\<bullet>count ;
                n  = m :-- ;
                z  = (param\<bullet>count := n) ; 
                q  = n :0?
             IN
                IF q 
                  THEN n\<^sup>I
                  ELSE PingClass\<bullet>ping(param)
             END) :: state expr)"
 assumes  vardistinct: "distinct  [m,n,h,q,x,z] \<and> distinct [z,x,q,h,n,m]"

(*
lemma (in pingI_example) bonzo_1915:
 "\<And> s s' mn . \<lbrakk> s = newframe s' mn Nullref (s'\<lfloor>param\<rfloor>) \<rbrakk> \<Longrightarrow> s'\<lfloor>param\<rfloor>=s\<lfloor>param\<rfloor>"
by clarsimp

lemma (in pingI_example) bonzo_1916:
 "\<And> s s' x mn . \<lbrakk> s = newframe s' mn Nullref x \<rbrakk> \<Longrightarrow> s\<lfloor>param\<rfloor>=x"
by clarsimp
*)

lemma (in pingI_example)
    "\<Turnstile>\<^sub>v (PingClass\<bullet>ping(param) :: state expr) :
       {(s::state,s'::state,v). 0 < s<s\<lceil>param\<rceil>\<bullet>count> \<longrightarrow>
          v = (IVal 0) \<and> s'<s'\<lceil>param\<rceil>\<bullet>count> = 0}"
apply (insert vardistinct)
apply clarsimp
(* .. doing VCG *)
(* apply (rule "VInvokeStatic000RecSat") *) (* popframe version *)
apply (rule "VngoqQIp_cha'")                (* oldframe version *)
apply (simp add: ping_methtable)
apply rule
apply (simp add: framestack_const)
apply simp
apply (rule VW)
apply (rule vdmbasicsI)+
apply assumption
apply (rule vdmbasicsI)+
apply clarsimp (* simp might be enough *)
apply (tactic {* all_tac *})
(* .. a bunch of bloody VCs (no ex-quant; no schematic vars) *)
(* --- Version:  FSC3 *)
defer 1
apply (clarsimp)
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply (simp add: framestack_const)
 apply (tactic {* all_tac *})
 apply (simp add: framestack_const)
done

(* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)
(* older versions of VC simplification; all based on popframe; none goes through *)
(* --- Version: NO FSC 
defer 1
apply (clarsimp)
apply (subgoal_tac "theloc (topframe_rst aa param) = a\<lceil>param\<rceil>")
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply simp
 apply (tactic {* all_tac *})
 apply simp
 apply (tactic {* all_tac *})
*)
(* 1 subgoal left: "theloc (topframe_rst aa param) = a\<lceil>param\<rceil>"
   the one introduced by subgoal_tac above:
*)
(* --- Version: FSC1 
defer 1
apply clarsimp
apply (subgoal_tac "theloc (topframe_rst aa param) = a\<lceil>param\<rceil>")
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply (simp add: frame_lemmas)
 apply (tactic {* all_tac *})
 apply (simp add: frame_lemmas)
 apply (tactic {* all_tac *})
*)
(* only 1 subgoal: "theloc (topframe_rst aa param) = a\<lceil>param\<rceil>"; 
   now, try to proof it with our funny-side-condition  *)
(*
apply (erule_tac x="a" in allE)
apply (erule_tac x="aa" in allE)
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply (simp add: frame_lemmas)
 apply (tactic {* all_tac *})
 apply (simp add: frame_lemmas)
*)
(* different subgoal now: "theloc (snd (snd (hd (framestack aa))) param) = aa\<lceil>param\<rceil>" 
   this shouldn't be needed at all *)
(* --- Version: FSC2
defer 1
apply clarsimp
apply (subgoal_tac "theloc (topframe_rst aa param) = a\<lceil>param\<rceil>")
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply (simp add: frame_lemmas)
 apply (tactic {* all_tac *})
 apply (simp add: frame_lemmas)
 apply (tactic {* all_tac *})
(* only 1 subgoal: "theloc (topframe_rst aa param) = a\<lceil>param\<rceil>"; 
   now, try to proof it with our funny-side-condition  *)
apply (erule_tac x="a" in allE)       (* instantiate with pre-state *)
apply (erule_tac x="aa" in allE)      (* instantiate with post-state *)
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply (simp add: frame_lemmas)
 defer 1
 apply (simp add: frame_lemmas VngoqQIp_cha')
(* 2 subgoals, similar structure: 
   "theloc (snd (snd (hd (framestack aa))) param) = aa\<lceil>param\<rceil>" 
   this shouldn't be needed at all *)
oops
*)

(*
 apply (subgoal_tac "theloc (topframe_rst aa param) = a\<lceil>param\<rceil>") 
  apply simp
 apply (tactic {* all_tac *})
(* subgoal left: "theloc (topframe_rst aa param) = a\<lceil>param\<rceil>" *)
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply (simp add: topframe_rst_def)
 defer 1 
 apply (simp add: topframe_rst_def)
 apply (erule conjE)+
 

oops
*)

(* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)

(* ALTERNATIVE: split up conj *)
(*
apply rule
(* 1/3 *)
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply (simp add: frame_lemmas)
 apply (tactic {* all_tac *})
 apply (simp add: frame_lemmas)
 apply (tactic {* all_tac *})
 (* done wiht 1/3 *)
apply rule
(* 2/3 *)
apply (subgoal_tac "theloc (topframe_rst aa param) = a\<lceil>param\<rceil>")
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply (simp add: frame_lemmas)
 apply (tactic {* all_tac *})
 apply (simp add: frame_lemmas)
 apply (tactic {* all_tac *})
 (* done with 2/3 *)
apply (subgoal_tac "theloc (topframe_rst aa param) = a\<lceil>param\<rceil>")
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply (simp add: frame_lemmas)
 apply (tactic {* all_tac *})
 apply (simp add: frame_lemmas)
 apply (tactic {* all_tac *})
 (* done with 3/3 *)
(* 3 subgoals: those from the subgoal_tacs above *)
apply (erule_tac x="a" in allE)       (* instantiate with pre-state *)
apply (erule_tac x="aa" in allE)      (* instantiate with post-state *)
(* apply (subgoal_tac "0 < a<a\<lceil>param\<rceil>\<bullet>count>") *)
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0")
   apply (simp add: frame_lemmas)
   apply (tactic {* all_tac *})
   apply (simp only: topframe_rst_def)
   apply simp
   (* done with 1/3 *)
defer 1
apply (erule_tac x="a" in allE)       (* instantiate with pre-state *)
apply (erule_tac x="aa" in allE)      (* instantiate with post-state *)
(* apply (subgoal_tac "0 < a<a\<lceil>param\<rceil>\<bullet>count>") *)
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0")
   apply (simp add: frame_lemmas)
   apply (tactic {* all_tac *})
   apply (simp only: topframe_rst_def)
   apply simp
   (* done with 2/3 *)
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0")
   apply (simp add: frame_lemmas)
   apply (tactic {* all_tac *})
   apply (simp only: topframe_rst_def)
   apply simp
   (* done with 2/3 *)

   apply (erule_tac x="a" in allE)       (* instantiate with pre-state *)
   apply (erule_tac x="aa" in allE)      (* instantiate with post-state *)
(* apply (subgoal_tac "0 < a<a\<lceil>param\<rceil>\<bullet>count>") *)
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0")
   apply (simp add: frame_lemmas)
   defer 1
   apply (simp only: topframe_rst_def)
   apply (tactic {* all_tac *})
   (* done with subgoal 1/3 *)
oops
*)

(* only 1 subgoal: "topframe_rst aa = rstore a"; 
   should be ok, but can't be proven *)
(* ok, so we can prove that bloody subgoal from the funny-side-condition *)
(*
apply clarsimp
apply (rule_tac x="unnewframe a" in exI)
apply rule
apply rule
apply (rule_tac x="unnewframe a" in exI)
apply (simp add: topframe_rst_def)
apply (rule_tac x="unnewframe a" in exI)

 apply rule+
 apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0")
  apply (simp add: topframe_rst_def)
  apply (simp add: topframe_rst_def)
 defer 1 (* needs unnewframe lemma *)
 apply rule+
 apply (simp add: unnewframe_inv)
 prefer 12
 apply rule
 apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0")
  apply (simp add: topframe_rst_def)
  defer 1
  apply (simp add: topframe_rst_def)
  defer 1
 apply (simp add: topframe_rst_def)
 
 apply (simp add: unnewframe_inv)

 apply (rule impE)

 apply (simp add: topframe_rst_def)
 defer 1
 apply (simp add: topframe_rst_def)
 apply (rule conjI)
 apply (rule impI)
 apply (rule conjI)
 apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0")
  apply (simp add: topframe_rst_def)
  apply (simp add: topframe_rst_def)
 defer 1
 apply (rule conjI)
 defer 1
 apply (rule conjI)
 apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0")
  apply (simp add: topframe_rst_def)
  defer 1
  apply (simp add: topframe_rst_def)
  defer 1
 apply (simp add: topframe_rst_def)




 apply (simp add: topframe_rst_def)

 apply rule
 defer 1
 apply rule
 apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0")
  apply (simp add: topframe_rst_def)
  defer 1
  apply (simp add: topframe_rst_def)
  defer 1
 apply (simp add: topframe_rst_def)
 
oops
*)

(*
(* defer 1 *)
apply auto
  (* 
  prefer 4
  apply (simp add: topframe_rst_def framestack_const)
  apply auto
  prefer 4
  apply (simp add: topframe_rst_def framestack_const)
  apply auto
  *)
apply (tactic {* all_tac *})
apply (subgoal_tac "topframe_rst aa = rstore a")
apply (simp add: topframe_rst_def)
defer 1
apply (subgoal_tac "topframe_rst aa = rstore a")
apply (simp add: topframe_rst_def)
(* only 2 subgoals both: "topframe_rst aa = rstore a"; 
   should be ok, but can't be proven *)
oops
*)
(* "unnewframe" version
apply (rule_tac x="unnewframe a" in exI)
apply (simp add: newframe_def unnewframe_def topframe_ist_def topframe_rst_def)
defer 1
apply (subgoal_tac "topframe_rst aa = rstore a")
apply (simp add: topframe_rst_def)
defer 1
apply (subgoal_tac "topframe_rst aa = rstore a")
apply (simp add: topframe_rst_def)
defer 1
apply (rule_tac x="unnewframe a" in exI)
apply (simp add: newframe_def unnewframe_def topframe_ist_def topframe_rst_def)
defer 1
(* unnew doesn't work properly; need different untickling functions if 
   I want to use \<exists> in InvokeStatic rule;
   better not to use \<exists> alltogether *)
oops
*)
(*
apply (subgoal_tac "topframe_rst aa = rstore a")
apply (simp add: topframe_rst_def)
apply (subgoal_tac "snd (snd (hd (framestack aa))) = rstore a")
apply clarsimp
defer 1
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply simp
 apply simp
 (* apply (erule conjE) *)
(* apply (simp add: framestack_const) *)
apply auto
apply auto

apply (subgoal_tac "snd (snd (hd (framestack aa))) = rstore a")
apply clarsimp
defer 1
apply (subgoal_tac "snd (snd (hd (framestack aa))) = rstore a")
apply clarsimp
(* 2 subgoals from above tacs; should be ok but needs to be in ass set *)
oops


(* apply (subgoal_tac "has_frame_of aa a") *)
(* apply (subgoal_tac "topframe_rst aa = rstore a") *)
apply (simp add: topframe_rst_def)
(*
apply (insert popframe1)
apply clarsimp
*)
apply (simp add: has_frame_of_def)
oops
*)

(* proof gets up to topframe/rstore subgoal *)
lemma (in pingI_example)
   "\<Turnstile>\<^sub>v (PingClass\<bullet>ping(param) :: state expr) :
       {(s::state,s'::state,v). 0 < s<s\<lceil>param\<rceil>\<bullet>count> \<longrightarrow>
          v = (IVal 0) \<and> s'<s'\<lceil>param\<rceil>\<bullet>count> = 0 \<and> s\<lceil>param\<rceil> = s'\<lceil>param\<rceil>}"
apply (insert vardistinct)
apply clarsimp
      apply (rule "VInvokeStaticRecSatCool")
apply (rule "VInvokeStatic000RecSat") (* was "VInvokeStaticRecSat" *) (* was VInvokeStaticRecSat2 *) 
apply (simp add: ping_methtable)
apply rule
defer 1
defer 1
apply (simp add: ping_methtable)
apply (rule VW) 
apply (rule VPost)
apply (rule VW)
apply (rule vdmbasicsI)+
apply assumption
apply (rule vdmbasicsI)+
apply clarsimp
(* a bunch of bloody VCs *)
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply simp
 apply simp
apply auto
apply (tactic {* all_tac *})
apply (subgoal_tac "topframe_rst aa = rstore a")
apply (simp add: topframe_rst_def)
defer 1
apply (subgoal_tac "topframe_rst aa = rstore a")
apply (simp add: topframe_rst_def)
(* only 2 subgoals both: "topframe_rst aa = rstore a"; 
   should be ok, but can't be proven *)
oops


(* note the "param never changes" subclause in the specification; needed for this proof *)
(* oldframe version
lemma (in pingI_example)
   "\<Turnstile>\<^sub>v (PingClass\<bullet>ping(param) :: state expr) :
       {(s::state,s'::state,v). 0 < s<s\<lceil>param\<rceil>\<bullet>count> \<longrightarrow>
          v = (IVal 0) \<and> s'<s'\<lceil>param\<rceil>\<bullet>count> = 0 \<and> s\<lceil>param\<rceil> = s'\<lceil>param\<rceil>}"
apply (insert vardistinct)
apply clarsimp
(* apply (rule VW) *)
apply (rule "VInvokeStaticRecSat") (* was VInvokeStaticRecSat2 *)
apply (simp add: ping_methtable)
apply rule
defer 1
apply auto
apply (rule VW)
apply (rule VPost)
apply (rule VW)
apply (rule vdmbasicsI)+
apply assumption
(* apply (rule VW) *)
apply (rule vdmbasicsI)+
apply clarsimp
apply rule
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply simp
 apply simp
apply rule
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply simp
 apply simp
apply (case_tac "a<a\<lceil>param\<rceil>\<bullet>count> - 1 = 0 ")
 apply simp
 apply simp
apply clarsimp
(* NB: with oldframe version, there remained a bloody existential <spit> right here *)
apply rule
apply clarsimp
done


(* old version based on HL; probably doesn't work any more *)
locale ping_example =
 fixes  m      	  :: iname
 fixes  n      	  :: iname
 fixes  q      	  :: iname
 fixes  h      	  :: iname
 fixes  x      	  :: iname
 fixes  y      	  :: iname
 fixes  count  	  :: ifldname
 fixes  pong   	  :: ifldname
 fixes  ping   	  :: mname
 fixes  PingClass :: cname
 fixes  l1        :: locn
 assumes ping_methtable[simp]: "methtable PingClass ping =
           ((PRE  {(z::state,s::state). (z<h>) = s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> \<and> 0 < (z<h>)} :
            (POST {(z::state,s::state,v). v = (IVal 0) \<and> s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> = 0 \<and> z<h> = s<h> \<and> z\<lfloor>param\<rfloor> = s\<lfloor>param\<rfloor>} : 
            (LET 
                m  = param\<bullet>count ;
                n  = m :-- ;
                z  = (param\<bullet>count := n) ; 
                q  = n :0?
             IN
                IF q 
                  THEN n\<^sup>I
                  ELSE PingClass\<bullet>ping(param)
             END))) :: state expr)"
 assumes  vardistinct:    "distinct [m,n,q,x,z] \<and> distinct [z,x,q,n,m]" 
 assumes  constdistinct': "distinct [param,self]"

lemma (in ping_example)
   "\<Turnstile> {(z::state,s::state). 0 < s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> \<and> s<h>=s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> \<and> s<h>=s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> \<and> z=s}
       (PingClass\<bullet>ping(param) :: state expr)
       {(z::state,s::state,v). v = (IVal 0) \<and> s<(theloc (s\<lfloor>param\<rfloor>))\<bullet>count> = 0 \<and> z<h> = s<h> \<and> 
                               z\<lfloor>param\<rfloor> = s\<lfloor>param\<rfloor>}"
apply (insert vardistinct)
apply (insert constdistinct') 
apply clarsimp
apply (rule "HInvokeStaticRec")
apply (rule allI)
apply (rule impI)
apply (simp add: ping_methtable)
apply (tactic {* all_tac *})
apply (rule "HSP")
apply (rule "HPre")
apply (rule "HSP")
apply (rule "HWC")
apply (rule "HPost")
apply (rule "HLetI")
apply (rule "HLetI")
apply (rule "HLetI")
apply (rule "HLetI")
apply (rule "HIf")
apply (rule hoarebasics)
(* rec call *)
apply assumption
apply (rule subset_refl)
apply (rule hoarebasics)
apply (rule hoarebasics)
apply (rule hoarebasics)
apply (rule hoarebasics)
apply (rule subset_refl)
apply clarsimp
defer 1
apply clarsimp
defer 1
apply (rule subset_refl)
apply clarsimp
defer 1
apply rule
apply rule
apply rule
defer 1
apply clarsimp
apply auto
done


subsection {* ping2 example: mutual recursion *}

(* --------------------------------------------------------------------------- *)
(* Code                                                                        *)
(* --------------------------------------------------------------------------- *)

(*
  class PingClass = 
               field int count
               field int kount
               method ping () { count := count - 1; 
                                if count > 0  PingClass.pong() else return () }
               method pong () { kount := kount + 1; 
                                PingClass.ping() }
*)

locale ping2_example =
 fixes  m      	  :: iname
 fixes  n      	  :: iname
 fixes  q      	  :: iname
 fixes  g      	  :: iname
 fixes  h      	  :: iname
 fixes  x      	  :: iname
 fixes  z      	  :: iname
 fixes  count  	  :: ifldname
 fixes  kount  	  :: ifldname
 fixes  pong   	  :: mname
 fixes  ping   	  :: mname
 fixes  PingClass :: cname
 fixes  l1        :: locn
 assumes ping_methtable[simp]: "methtable PingClass ping =
           ((PRE  {(z::state,s::state). (z<g>) = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>count> \<and> 0 < (z<g>) \<and>
                                        (z<h>) = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>kount> \<and> 0 < (z<h>)} :
            (POST {(z::state,s::state,v). v = (IVal 0) \<and> s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>count> = 0 \<and> s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>kount> = z<g>} : 
            (LET 
                m  = self\<bullet>count ;
                n  = m :-- ;
                z  = (self\<bullet>count := n) ; 
                q  = n :0?
             IN
                IF q 
                  THEN n\<^sup>I
                  ELSE PingClass\<bullet>ping(self)
             END))) :: state expr)"
 assumes pong_methtable[simp]: "methtable PingClass pong =
           ((PRE  {(z::state,s::state). (z<g>) = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>count> \<and> 0 < (z<g>) \<and>
                                        (z<h>) = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>kount> \<and> 0 < (z<h>)} :
            (POST {(z::state,s::state,v). (z<g>) = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>count> \<and>
                                          (z<h>)+1 = s<(theloc (s\<lfloor>self\<rfloor>))\<bullet>kount> } : 
            (LET 
                m  = self\<bullet>kount ;
                m  = m :++ ;
                z = (self\<bullet>kount := m) 
             IN
                PingClass\<bullet>ping(self)
             END))) :: state expr)"
 assumes  vardistinct: "distinct  [m,n,q,x,z] \<and> distinct [z,x,q,n,m]"
*)

end
