(*  
   File:        $RCSfile: ExampleKonstproofs.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleKonstproofs.thy,v 1.1 2003/07/22 14:28:26 a1hloidl Exp $

   A test of the Hoare Logic demonstrating manual use of adaptation.

   [NB: correctness only so no question over with clock/callcount position]
*)

theory ExampleKonstproofs = ToyHLproofsDeriv + ToyPrelude:

locale konst_flat_example =
  fixes    n         :: iname
    and	   q         :: iname
    and	   z         :: iname
    and    konst     :: funame
 assumes [simp]:
  "funtable konst = (LET
                         q =  Primop (\<lambda> x y. if x<0 then 1 else 0) n n
                       IN 
                         IF q
                           THEN n\<^sup>I
                           ELSE LET
                                  n = n :--  ;
                                  z = CALL konst ;
                                  n = n:++
                                IN 
                                  n\<^sup>I
                                END
                       END :: int expr)"
  assumes  vardistinct: "distinct [n,q,z]"


lemma (in konst_flat_example)
      constadapt:  "[({(N,s). s<n> =  N},(CALL konst),{(N,s,v). s<n> =  N})]
                    \<turnstile> {(N,s). s<n> + 1 =  N} (CALL konst) {(N,s,v). s<n> + 1 =  N}"
apply (rule hconseq)
apply (rule hax, simp, rule, rule refl, rule refl)  (* projection *)
apply auto
done

lemma (in konst_flat_example) 
   "\<turnstile> {(N,s). s<n> =  N}
	(CALL konst)
      {(N,s,v). s<n> =  N}"
apply (insert vardistinct)
apply (rule hcall, simp)
apply (rule hoareproof_ibasics)+
apply (rule hwc, rule constadapt)
apply simp
apply (rule hoareproof_ibasics)
apply (rule subset_refl)
apply (rule hsp, rule hoareproof_ibasics)
apply auto
done

end
