(*  
   File:        $RCSfile: ExampleFactIBD.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleFactIBD.thy,v 1.1 2003/07/17 20:01:15 a1hloidl Exp $

   Example: factorial (using Invoke) VDM style
*)

theory ExampleFactIBD = ToyVDMderivedBD + ToyPrelude:

section {* Testing Invoke rules *}

subsection {* factorial *}

consts facspec :: "nat \<Rightarrow> nat"
primrec (* recdef   facspec "measure (\<lambda> n. n)" *)
 "facspec 0 = (1::nat)"
 "facspec (Suc n) = (facspec n) * (Suc n)"

(* ToDo: int version of facspec would be much easier to use *)
(*
consts facspec_int :: "int \<Rightarrow> int"
recdef facspec_int "measure (\<lambda> n. n)"
 "facspec_int = \<lambda> n . if (0 < n) then (n * (facspec_int (n - 1))) else (1::int)"
*)

locale facI_example =
 fixes  arg :: ifldname
 fixes  sum :: ifldname
 fixes  n   :: iname
 fixes  m   :: iname
 fixes  q   :: iname
 fixes  z   :: iname
 fixes  fac :: mname
 fixes  facClass :: cname
 assumes fac_methtable[simp]: "methtable FacClass fac =
         ((LET 
              q = n :0?
            IN 
              IF q
                THEN 1\<^sup>z
                ELSE q\<^sup>I
            END) :: state expr)"
(*  assumes vardistinct:   "distinct [n,m,q,z]" *)

(*
lemma (in facI_example) 
 bonzo13: "wf (inv_image less_than (\<lambda>s. nat (s<n>)))"
by (rule wf_inv_image, rule wf_less_than)
*)

subsubsection {* abstracted over input *}

(* 
 stupid lemmas needed for nat-int conversion
 unproven so far
*)

lemma (in facI_example) bonzo_1066:

 "[| 0 < N ; 0 < M |] ==>
  M * N * int (facspec (nat (N - 1))) = M * int (facspec (nat N))"
sorry

lemma (in facI_example) bonzo_1067:
 "[| 0 < (N::int) ; 0 < M |] ==> 0 < M * N"
sorry

lemma (in facI_example) bonzo_1068:
 "[| 0 < (N::int) ; N - 1 \<noteq> 0 |] ==> 0 < N - 1"

apply arith
done

lemma (in facI_example) fact_is_cool_99:
   "\<Turnstile>\<^sub>v (FacClass\<bullet>fac(param) :: state expr) :
        {(s::state,s'::state,v).  0 < s<s\<lceil>param\<rceil>\<bullet>sum> \<and> 0 < s<s\<lceil>param\<rceil>\<bullet>arg> \<longrightarrow> v = IVal ((s<s\<lceil>param\<rceil>\<bullet>sum>) * (int (facspec (nat (s<s\<lceil>param\<rceil>\<bullet>arg>)))))}"
apply (insert vardistinct)
(* apply (insert topframe_rstore0) *)
(* apply (insert popframe_ist popframe_rst) *)
apply clarsimp
(* apply (rule VW) *)
apply (rule "VInvokeStatic000RecSat") (* was "VInvokeStaticRecSat" *) (* was VInvokeStaticRecSat2 *)
  (*
  prefer 3
  apply clarsimp
  defer 1
  *)
apply (simp add: ping_methtable)
apply rule
defer 1
defer 1
(*
apply (rule VW) 
apply (rule VPost)
*)
apply (simp add: ping_methtable)
apply (rule VW) 
apply (rule VPost)
apply (rule VW)
apply (rule vdmbasicsI)+
apply assumption
(* apply (rule VW) *)
apply (rule vdmbasicsI)+
apply clarsimp
(* a bunch of bloody VCs *)


(* UNTESTED *)

subsubsection {* resource properties *}

lemma (in facI_example) 
(*    "[| \<Turnstile> (fun_preassn_table fac) (CALL fac) (fun_postassn_table fac) |] ==> *)
    "relTakestimelt (emptyState (|istore := (fun_upd (fun_upd (istore emptyState) n 5) m 1)|))	99 (CALL fac)"
apply (insert vardistinct)
apply (simp add: relTakestimelt_def)
apply vcg_simp
apply clarsimp
apply (tactic {* all_tac *})
(* needs instantiation of z similar to above proof *)
oops


end
