(*  
   File:        $RCSfile: ExampleEvenOddproofs.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleEvenOddproofs.thy,v 1.1 2003/07/22 14:28:26 a1hloidl Exp $

   Another test of the Hoare Logic demonstrating use of adaptation
   with mutually-recursive functions.

   [NB: correctness only so no question over with clock/callcount position]
*)

theory ExampleEvenOddproofs = ToyPrelude + ToyHLproofsDeriv:

constdefs
 Even :: "int \<Rightarrow> bool"
 "Even i \<equiv> \<exists> k. i=2*k"
 Odd :: "int \<Rightarrow> bool"
 "Odd i \<equiv> \<exists> k. i=2*k+1"

lemma [simp]: "Even (x + 1) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]:  "Odd(x + 1) = Even(x)"
by (simp add: Even_def Odd_def)
(* arith failed, presburger succeeded! *)

(* the next two lemmas aren't really needed, just simplify a bit more *)
lemma [simp]: "(\<not> Odd(x)) = Even(x)"
by (simp add: Even_def Odd_def, arith)   

lemma [simp]: "(\<not> Even(x)) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]: "Odd 0 = False"
by (simp add: Odd_def, arith)

lemma [simp]: "Even 0 = True"
by (simp add: Even_def)

   

locale evenodd_example =
(* Simulating the typical example
      even(x) = let fun even x = if x=0 then true else odd(x-1)
                    fun odd x = if x=0 then false else even(x-1)
                in even(x)
 *)
  fixes    x :: iname
    and    b :: iname
    and	   even    :: funame
    and    odd     :: funame

  assumes funtable_even:
 "funtable even = PRE  {(N,s).   N = s<x> \<and> 0 <= s<x>}:
		  POST {(N,s,v). v=IVal (grailbool (Even N))}:
		     LET   b = x :0?;
			   x = x :--
			   IN 
			      IF b THEN tt ELSE CALL odd
  			   END"

  and funtable_odd:
 "funtable odd = PRE  {(N,s). N = s<x> \<and> 0 <= s<x>}:
 	         POST {(N,s,v). v=IVal (grailbool (Odd N))}:
		     LET   b = x :0?;
			   x = x :--
		      IN 
			   IF b THEN ff ELSE CALL even
  		     END"

  and  vardistinct:   "distinct[b,x] \<and> distinct[x,b]"

text {* It's easier to express the adaption rules using
 Isabelle's implication than in the proof system context. *}
  

lemma (in evenodd_example)
  evenadapt:   "(G \<turnstile> {(N,s). N = s<x> \<and> 0 <= s<x>} (CALL even) {(N,s,v). v=IVal (grailbool (Even N))})
		\<Longrightarrow> G \<turnstile> {(N,s). N = (s<x> + 1) \<and> 0 <= s<x>} (CALL even)
		          {(N,s,v). v=IVal (grailbool (Odd N))}"
apply (rule hconseq)
apply assumption
apply auto
done


lemma (in evenodd_example)
  oddadapt:   "(G \<turnstile> {(N,s). N = s<x> \<and> 0 <= s<x>} (CALL odd) {(N,s,v). v=IVal (grailbool (Odd N))})
	      \<Longrightarrow> (G \<turnstile> {(N,s). N = (s<x> + 1) \<and> 0 <= s<x>} (CALL odd)
		          {(N,s,v). v=IVal (grailbool (Even N))})"
apply (rule hconseq)
apply assumption      
apply auto
done

lemma (in evenodd_example) "\<turnstile> {(N,s). N = s<x> \<and> 0 <= s<x>} 
				(CALL even) 
			      {(N,s,v). v=IVal (grailbool (Even N))}"
apply (insert vardistinct)
apply (rule hcall)
apply (simp only: funtable_even)
apply (rule hsp)       (* playout the VCG *)
apply (rule hoareproof_ibasics hpre hpost)+
(* now unravel odd: first using adaptation to make pre-post match up *)
apply (rule oddadapt)
(* now let's examine call to odd *)
apply (rule hcall)
apply (simp only: funtable_odd)
apply (rule hoareproof_ibasics hpre hpost)+
(* now apply induction hypothesis and adaptation for even *)
apply (rule evenadapt)
apply (rule hax, simp)
apply (rule subset_refl)
apply (rule hoareproof_ibasics)
apply (rule hsp, rule hoareproof_ibasics)
apply clarsimp
apply (rule subset_refl)
apply clarsimp
apply (rule subset_refl)
apply (rule hoareproof_ibasics | rule hsp)+
prefer 3
apply (rule subset_refl)
apply auto
done

end
