(*  
   File:        $RCSfile: ExampleEOIVDMBD.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleEOIVDMBD.thy,v 1.1 2003/07/17 20:01:15 a1hloidl Exp $

   Example: even/odd with invoke (VDM style)
*)

theory ExampleEOIVDMBD = ToyPreludeBD + ToyVDMderivedBD: 

section {* Example: even/odd with invoke (VDM style) *}

subsection {* Semantic functions *}

constdefs
 Even :: "int \<Rightarrow> bool"
 "Even i \<equiv> \<exists> k. i=2*k"
 Odd :: "int \<Rightarrow> bool"
 "Odd i \<equiv> \<exists> k. i=2*k+1"

lemma [simp]: "Even (x + 1) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]:  "Odd(x + 1) = Even(x)"
by (simp add: Even_def Odd_def)
(* arith failed, presburger succeeded! *)

(* the next two lemmas aren't really needed, just simplify a bit more 
lemma [simp]: "( Odd(x)) = Even(x)"
by (simp add: Even_def Odd_def, arith)   

lemma [simp]: "( Even(x)) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]: "Odd 0 = False"
by (simp add: Odd_def, arith)

lemma [simp]: "Even 0 = True"
by (simp add: Even_def)


lemma bonzo_999: "Even x -->  Odd x"
by (simp add: Even_def Odd_def, arith)

lemma bonzo_998: "Odd x -->  Even x"
by (simp add: Even_def Odd_def, arith)

(* ngoqvam moHbogh vImuSqu' !!!! *)
lemma bonzo_997: "0 < x --> Even (x) = Odd(x - 1)"
by (simp add: Even_def Odd_def, arith)

(* ngoqvam moHbogh vImuSqu' !!!! *)
lemma bonzo_996: "0 < x --> Odd (x) = Even (x - 1)"
by (simp add: Even_def Odd_def, arith)

lemma bonzo_995: "0 <= x ==> Odd x --> 0 < x"
by (simp add: Even_def Odd_def, arith)
*)

subsection {* even/odd example: direct recursion with invoke *}

constdefs OHSize ::"state \<Rightarrow> int"
"OHSize s == int (card (fmap_dom (oheap s)))"
(* IHsize and RHsize need sum over all i/rflds
constdefs OHSize ::"state \<Rightarrow> int"
"OHSize s == int (card (fmap_dom (oheap s))) + int (card (dom (iheap s))) + int (card (dom (rheap s)))"
*)

declare OHSize_def [simp]

locale evenoddInv =
  fixes    n         :: iname    
  fixes    m         :: iname    
  fixes    b         :: iname 
  fixes    one       :: iname
  fixes    z         :: iname 
  fixes    h         :: iname
  fixes    r1701        :: rname
  fixes    l1701        :: locn
  fixes    count     :: ifldname
  fixes	   even_odd  :: mname
  fixes    EvenOddClass :: cname
  assumes even_odd_methtable[simp]: "
          methtable EvenOddClass even =
                     (SATISFIES {(s,s',v). (0 <= s<s\<lceil>param\<rceil>\<bullet>count>) \<longrightarrow> 
                                           (Even(s<s\<lceil>param\<rceil>\<bullet>count>) \<longrightarrow> (v = IVal 1) \<and> 
                                            Odd(s<s\<lceil>param\<rceil>\<bullet>count>)  \<longrightarrow> (v = IVal 0))} :
                      (LET 
                        n = param\<bullet>count ;
		        b = n :0?
		       IN IF b 
                           THEN tt
                           ELSE LET 
                                  n = n:-- ;
		                  b = n :0?
		                IN 
                                  IF b 
                                    THEN ff
                                    ELSE LET
                                           n = n:-- ;
                                           z = param\<bullet>count := n ;
                                           b = InvokeStatic EvenOddClass even param
                                         IN
                                           b\<^sup>I
                                         END
                                END 
                        END) :: state expr)"
 assumes vardistinct:  "distinct [n,m,b,one] \<and> distinct [one,b,m,n]"
 assumes petaq1701: "s\<lceil>r1701\<rceil> = l1701 \<and> s\<lless>l1701\<ggreater> = Some EvenOddClass \<and> 0 <= s<(theloc (s\<lfloor>l1\<rfloor>))\<bullet>count>"


lemma (in evenoddInv) 
   "\<Turnstile>\<^sub>v  EvenOddClass\<bullet>even_odd(param) :
       {(s,s',v). (0 <= s<s\<lceil>param\<rceil>\<bullet>count>) \<longrightarrow> 
                   v = IVal (grailbool (Even(s<s\<lceil>param\<rceil>\<bullet>count>)))}"
apply (insert vardistinct)
apply clarsimp
(* apply (rule "VW") *)
apply (rule "VngoqQIp_cha'")                (* oldframe version *)
apply (simp add: even_odd_methtable)
apply rule
apply (simp add: framestack_const)
apply simp
apply (rule VW)
apply (rule vdmbasicsI)+
apply assumption
apply (rule vdmbasicsI)+
apply simp (* simp might be enough *)
apply (tactic {* all_tac *})
(* VCs *)
apply (rule subsetI)
apply simp
oops
(* Fails *)

(* Hoare style *)
lemma (in evenoddInv) 
   "[|  \<Turnstile> (fun_preassn_table even) (CALL even) (fun_postassn_table even) |] ==>
    \<Turnstile> {(z,s). 0 <= z<n> \<and> s<n> = z<n> \<and> z<h> = HSize s} 
       (CALL even)
       {(z,s,v). ((v = (IVal 1) \<longrightarrow> (\<exists> k . z<n> = 2 * k \<and> 0 <= k)) \<and> 
                  (v = (IVal 0) \<longrightarrow> (\<exists> k . z<n> = 2 * k + 1 \<and> 0 <= k)) \<and>
                  (v = IVal 0 \<or> v = IVal 1) \<and>
                  HSize s = z<h>)}"
apply (insert vardistinct)
apply clarsimp
apply vcg_rec_simp
(* VCs look ok !! *)
apply auto
apply (rule_tac x="0" in exI)
apply clarsimp
apply (rule_tac x="0" in exI)
apply clarsimp
done

subsection {* even/odd example: mutual recursion *}

(* doesn't work yet *)

locale evenodd_example =
(* Simulating the typical example
      even(x) = let fun even x = if x=0 then true else odd(x-1)
                    fun odd x = if x=0 then false else even(x-1)
                in even(x)
 *)
  fixes    x :: iname
    and    y :: iname
    and    z :: iname
    and    q :: iname
    and    Z :: int
    and	   evenfn  :: funame
    and    oddfn   :: funame
    and	   evenBody :: expr
    and    oddBody  :: expr
  defines  "evenBody == LET 
                          q = x :0?
                       IN 
                         IF q 
                           THEN tt
                           ELSE LET 
                                  x = x :-- ;
                                  y = CALL oddfn ;
                                  z = : y
                                IN 
                                  z\<^sup>I
  			        END
                       END"
  defines  "oddBody == LET  
                        q = x :0?
                      IN
                         IF q 
                           THEN ff
                           ELSE LET 
                                  x = x :-- ;
                                  y = CALL evenfn ;
                                  z = : y
                                IN 
                                  z\<^sup>I
  			        END
                       END"
  assumes  even_fnbdy:     "funtable evenfn = evenBody"
      and  odd_fnbdy:      "funtable oddfn = oddBody"
      and  even_wfmeasure: "fun_wfmeasure_table evenfn = inv_image less_than (\<lambda> s. nat (get_ivar s x))"
      and  odd_wfmeasure:  "fun_wfmeasure_table oddfn = inv_image less_than (\<lambda> s. nat (get_ivar s x))"
      and  vardistinct: "distinct [x,y,z,q]"
      (* invariants *)
      and  even_preinv: "fun_preassn_table evenfn == {(z,s). 0 < z<x> \<and> z<x> = s<x>}"
      and  even_postinv: "fun_postassn_table evenfn == {(z,s,v). ( v=(IVal 1) --> 2 dvd z<x> ) \<and> ( v=IVal 0 -->  (2 dvd z<x>) )}"

      and  odd_preinv: "fun_preassn_table oddfn == {(z,s). 0 < z<x> \<and> z<x> = s<x>}"
      and  odd_postinv: "fun_postassn_table oddfn == {(z,s,v). ( v=(IVal 0) --> 2 dvd z<x> ) \<and> ( v=IVal 1 -->  (2 dvd z<x>) )}"

declare (in evenodd_example) evenBody_def   [simp]
declare (in evenodd_example) oddBody_def    [simp]
declare (in evenodd_example) even_fnbdy     [simp]
declare (in evenodd_example) odd_fnbdy      [simp]
declare (in evenodd_example) even_wfmeasure [simp]
declare (in evenodd_example) odd_wfmeasure  [simp]
declare (in evenodd_example) even_preinv    [simp]
declare (in evenodd_example) even_postinv   [simp]
declare (in evenodd_example) odd_preinv     [simp]
declare (in evenodd_example) odd_postinv    [simp]

lemma (in evenodd_example) 
   "\<Turnstile> {(z,s). \<exists> k . 0 < z<x> \<and> (s<x>=2*k) \<and> s<x>=z<x>}	
	evenBody
      {(z,s,v). v=IVal 1}"
apply (insert vardistinct)
apply (simp)
apply vcg1_simp
apply (simp add:  cntxt_hoare_valid_def)
apply (rule HCallMutRec)
apply (tactic {* res_inst_tac [("P","fun_preassn_table")] (thm "HCallMutRec") 1 *})
defer 1
defer 1
defer 1
oops

lemma (in evenodd_example) 
   "\<Turnstile> {(z,s). 0 < z \<and> (s<x>=2*z)}	
	evenBody
      {(z,s,v). v=IVal 1}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
(* *)
prefer 3
apply simp
apply clarsimp
prefer 3
apply hoare_rec_step
defer 1
apply simp
apply simp
prefer 4
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply simp
apply hoare_rec_step
defer 1
apply simp
apply simp
apply simp
oops

end
