(*  
   File:	$RCSfile: ExSwapVDMBD.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExSwapVDMBD.thy,v 1.1 2003/07/17 20:01:14 a1hloidl Exp $

   Non-recursive function (VDM style)
   This version uses a definition of validity with proven soundeness of recursion rules.
*)

theory ExSwapVDMBD = ToyPreludeBD + ToyVDMproofsBD: (* ToyVDMderivedBD: *)

section {* swap two variables *}
(*
 PRE { ((a,X,Y),s).   s<x>=X \<and> s<y>=Y}:
 POST {((a,X,Y),s,v). s<x> = min X Y \<and> s<y> = max X Y \<and> 
			         v = IVal (if (X<=Y) then 0 else 1) }:
*)
locale swap_example =
  fixes   tmp :: iname
  fixes	  x :: iname
  fixes	  y :: iname
  fixes	  q :: iname
  fixes	  swap      :: funame
  assumes swapfun[simp]:

"funtable swap =  
(POST  {(s,s',v). s'<x> = min s<x> s<y>}:
 (LET 
  q  = x :> y
 IN
  IF q 
    THEN LET
     tmp = IVar x;
     x = IVar y;
     y = IVar tmp
  IN
     1\<^sup>z
  END 
     ELSE 0\<^sup>z
 END) :: state expr)"

 assumes  vardistinct: "distinct [tmp,x,y,q] \<and> distinct [q,y,x,tmp]"

(* feed in several preconditions to simplify proof *)
lemma (in swap_example) 
   "\<Turnstile>v CALL swap :
      {(s,s',v). 0 < s<x> \<and> 0 < s<y> \<and> s<x> < s<y> \<longrightarrow> s'<x> = s<x>}"
apply (insert vardistinct)
(* apply (rule CVW) *)
apply (rule vdmprocsC)
apply simp
apply (rule CVPost)
(* apply (rule CVW) *)
apply (rule CVLetUseless)
defer 1
apply (rule vdmbasicsC)
apply (rule CVLetUseless)
defer 1
apply (rule CVLetUseless)
defer 1
apply (rule CVLetUseless)
defer 1
apply (rule vdmbasicsC)
apply clarsimp
defer 1
defer 1
defer 1
apply (rule vdmbasicsC)
apply clarsimp
defer 1
defer 1
defer 1
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply fastsimp
apply auto
(* FUCK *)
apply (case_tac "a<y> < a<x>")
apply (simp add: min_def)
apply (simp add: min_def)
apply (simp add: min_def)
apply (rule subsetI)
apply clarsimp
done

(* proof specification of swap *)
lemma (in swap_example) 
   "\<Turnstile>v CALL swap :
      {(s,s',v). s'<x> = min s<x> s<y>}"
apply (insert vardistinct)
apply (rule VW)
apply (rule vdmprocs)
apply simp
apply (rule VPost)
apply (rule VW)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply (rule vdmbasicsC)
apply clarsimp
apply (case_tac "a<y> < a<x>")
apply (simp add: min_def)
apply (simp add: min_def)
apply (simp add: min_def)
apply (rule subsetI)
apply clarsimp
done
(* exactly proof script as above; lucky us! *)


end

