(*  
   File:        ToyVCGtest6.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGtest6.thy,v 1.1 2003/05/29 11:46:08 a1hloidl Exp $

   More tests of the VCG (even/odd).
*)

theory ToyVCGtest6 = ToyVCG + ToyPrelude + ToyHLbasic:

section {* Testing the VCGen *}

subsection {* even/odd example: direct recursion *}

constdefs HSize ::"state \<Rightarrow> int"
"HSize s == int (card (fmap_dom (heap s)))"
declare HSize_def [simp]

locale evenodd2 =
  fixes    n        :: iname    and    m       :: iname    and    b        :: iname and h :: iname
    and	   even     :: funame
    and	   evenBody :: expr
  defines  "evenBody == LET m = Primop (% x y. x - 1) n n;
			    b = Primop (% x y. if x < 1 then 1 else 0) n n
		        IN IF b THEN expr.Int 1 
                                ELSE LET n = Primop (% x y. x - 1) m m;
			                 b = Primop (% x y. if x < 1 then 1 else 0) m m
		                     IN IF b THEN expr.Int 0 ELSE CALL even
                                     END 
                        END"
  assumes  even_fnbdy[simp]:     "funtable even = evenBody"
      and  even_wfmeasure[simp]: "fun_wfmeasure_table even = inv_image less_than (\<lambda> s. nat (s<n>))"
      and  vardistinct: "distinct [n,m,b] \<and> distinct [b,m,n]"
      and  postAss[simp]: 
                "fun_postassn_table even = 
                  {(z,s,v). ((v = (IVal 1) \<longrightarrow> (\<exists> k . z<n> = 2 * k \<and> 0 <= k)) \<and> 
                             (v = (IVal 0) \<longrightarrow> (\<exists> k . z<n> = 2 * k + 1 \<and> 0 <= k)) \<and>
                             (v = IVal 0 \<or> v = IVal 1) \<and> 
                             HSize s = z<h>)}"
      and  preAss[simp]: 
                "fun_preassn_table even = 
                 {(z,s). 0 <= z<n> \<and> 0 <= s<n> \<and> (\<exists> k . s<n> = z<n> - 2 * k \<and> 0 <= k) \<and> HSize s = z<h>}"
 
declare (in evenodd2) evenBody_def [simp]

lemma (in evenodd2) 
    "[|  \<Turnstile> (fun_preassn_table even) (CALL even) (fun_postassn_table even) |] ==>
    \<Turnstile> {(z,s). 0 <= z<n> \<and> s<n> = z<n> \<and> z<h> = HSize s} 
       evenBody
       {(z,s,v). ((v = (IVal 1) \<longrightarrow> (\<exists> k . z<n> = 2 * k \<and> 0 <= k)) \<and> 
                  (v = (IVal 0) \<longrightarrow> (\<exists> k . z<n> = 2 * k + 1 \<and> 0 <= k)) \<and>
                  (v = IVal 0 \<or> v = IVal 1) \<and>
                  HSize s = z<h>)}"
apply (insert vardistinct)
apply clarsimp
apply vcg1_simp
(* VCs look ok *)
apply clarsimp
apply auto
apply (rule_tac x="0" in exI)
apply clarsimp
apply (rule_tac x="0" in exI)
apply clarsimp
done

lemma (in evenodd2) 
    "[|  \<Turnstile> (fun_preassn_table even) (CALL even) (fun_postassn_table even) |] ==>
    \<Turnstile> {(z,s). 0 <= z<n> \<and> s<n> = z<n> \<and> z<h> = HSize s} 
       evenBody
       {(z,s,v). ((v = (IVal 1) \<longrightarrow> (\<exists> k . z<n> = 2 * k \<and> 0 <= k)) \<and> 
                  (v = (IVal 0) \<longrightarrow> (\<exists> k . z<n> = 2 * k + 1 \<and> 0 <= k)) \<and>
                  (v = IVal 0 \<or> v = IVal 1) \<and>
                  HSize s = z<h>)}"
apply (insert vardistinct)
apply clarsimp
apply vcg_rec_simp
(* VCs look ok !! *)
apply auto
apply (rule_tac x="0" in exI)
apply clarsimp
apply (rule_tac x="0" in exI)
apply clarsimp
done

subsection {* even/odd example: mutual recursion *}

(* doesn't work yet *)

locale evenodd_example =
(* Simulating the typical example
      even(x) = let fun even x = if x=0 then true else odd(x-1)
                    fun odd x = if x=0 then false else even(x-1)
                in even(x)
 *)
  fixes    x :: iname
    and    y :: iname
    and    z :: iname
    and    q :: iname
    and    Z :: int
    and	   evenfn  :: funame
    and    oddfn   :: funame
    and	   evenBody :: expr
    and    oddBody  :: expr
  defines  "evenBody == LET 
                          q = x :0?
                       IN 
                         IF q 
                           THEN tt
                           ELSE LET 
                                  x = x :-- ;
                                  y = CALL oddfn ;
                                  z = :\<not> y
                                IN 
                                  z\<^sup>I
  			        END
                       END"
  defines  "oddBody == LET  
                        q = x :0?
                      IN
                         IF q 
                           THEN ff
                           ELSE LET 
                                  x = x :-- ;
                                  y = CALL evenfn ;
                                  z = :\<not> y
                                IN 
                                  z\<^sup>I
  			        END
                       END"
  assumes  even_fnbdy:     "funtable evenfn = evenBody"
      and  odd_fnbdy:      "funtable oddfn = oddBody"
      and  even_wfmeasure: "fun_wfmeasure_table evenfn = inv_image less_than (\<lambda> s. nat (get_ivar s x))"
      and  odd_wfmeasure:  "fun_wfmeasure_table oddfn = inv_image less_than (\<lambda> s. nat (get_ivar s x))"
      and  vardistinct: "distinct [x,y,z,q]"
      (* invariants *)
      and  even_preinv: "fun_preassn_table evenfn == {(z,s). 0 < z<x> \<and> z<x> = s<x>}"
      and  even_postinv: "fun_postassn_table evenfn == {(z,s,v). ( v=(IVal 1) --> 2 dvd z<x> ) \<and> ( v=IVal 0 --> \<not> (2 dvd z<x>) )}"

      and  odd_preinv: "fun_preassn_table oddfn == {(z,s). 0 < z<x> \<and> z<x> = s<x>}"
      and  odd_postinv: "fun_postassn_table oddfn == {(z,s,v). ( v=(IVal 0) --> 2 dvd z<x> ) \<and> ( v=IVal 1 --> \<not> (2 dvd z<x>) )}"

declare (in evenodd_example) evenBody_def   [simp]
declare (in evenodd_example) oddBody_def    [simp]
declare (in evenodd_example) even_fnbdy     [simp]
declare (in evenodd_example) odd_fnbdy      [simp]
declare (in evenodd_example) even_wfmeasure [simp]
declare (in evenodd_example) odd_wfmeasure  [simp]
declare (in evenodd_example) even_preinv    [simp]
declare (in evenodd_example) even_postinv   [simp]
declare (in evenodd_example) odd_preinv     [simp]
declare (in evenodd_example) odd_postinv    [simp]

lemma (in evenodd_example) 
   "\<Turnstile> {(z,s). \<exists> k . 0 < z<x> \<and> (s<x>=2*k) \<and> s<x>=z<x>}	
	evenBody
      {(z,s,v). v=IVal 1}"
apply (insert vardistinct)
apply (simp)
apply vcg1_simp
apply (simp add:  cntxt_hoare_valid_def)
apply (rule HCallMutRec)
apply (tactic {* res_inst_tac [("P","fun_preassn_table")] (thm "HCallMutRec") 1 *})
defer 1
defer 1
defer 1
oops

lemma (in evenodd_example) 
   "\<Turnstile> {(z,s). 0 < z \<and> (s<x>=2*z)}	
	evenBody
      {(z,s,v). v=IVal 1}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
(* *)
prefer 3
apply simp
apply clarsimp
prefer 3
apply hoare_rec_step
defer 1
apply simp
apply simp
prefer 4
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply simp
apply hoare_rec_step
defer 1
apply simp
apply simp
apply simp
oops

end
