(*  
   File:        ToyVCGtest5.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGtest5.thy,v 1.2 2003/05/23 12:49:51 a1hloidl Exp $

   More tests of the VCG (Nipkow-constant).

   Bottom line:
   using vcg1 and doing single stepping, the ind hyp is discharged, i.e. adaptation
   rule succeeds here
   result still has schematic variables (ToDo: compare with vcg_simp where rules differ)
   vcg1_simp doesn't use the same route (ToDo: compare order of single stepping with full tactic)
*)

(* theory ToyVCGtest5 = ToyHLVCG + ToyPrelude + ToyHLRules: *)
theory ToyVCGtest5 = ToyVCG + ToyPrelude + ToyHLbasic:

section {* Testing the VCGen *}

subsection {* Nip_const *}

locale nipconst_flat_example =
  fixes    n         :: iname
    and	   q         :: iname
    and	   z         :: iname
    and    nipconst     :: funame
    and	   nipconstBody :: expr
 defines   "nipconstBody \<equiv> LET
                         q =  n :0?
                       IN 
                         IF q
                           THEN n\<^sup>I
                           ELSE LET
                                  n = n :--  ;
                                  z = CALL nipconst ;
                                  n = n:++
                                IN 
                                  n\<^sup>I
                                END
                       END"
  assumes  vardistinct: "distinct [n,q,z]"
      (* function tables *)
      and  nipconst_fnbdy:  "funtable nipconst  = nipconstBody "
      (* measures *)
      and  nipconst_wfmeasure:  "fun_wfmeasure_table nipconst = inv_image less_than (\<lambda>s . nat (s<n>))"
      (* invariants *)
(*
      and  nipconst_preinv:  "fun_preassn_table  nipconst == {(z,s). s<n> = z<n>}"
      and  nipconst_postinv: "fun_postassn_table nipconst == {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
      and  nipconst_inv_holds: "\<Turnstile> (fun_preassn_table nipconst) (CALL nipconst) (fun_postassn_table nipconst)"
*)

declare (in nipconst_flat_example) nipconstBody_def[simp]
declare (in nipconst_flat_example) nipconst_fnbdy[simp]
declare (in nipconst_flat_example) nipconst_wfmeasure[simp]
(*
declare (in nipconst_flat_example) nipconst_preinv[simp]
declare (in nipconst_flat_example) nipconst_postinv[simp]
*)

lemma (in nipconst_flat_example) 
   "\<Turnstile> {(z,s). 0 < z<n> \<and> s<n> = z<n>}
	(CALL nipconst)
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
apply (insert vardistinct)
apply (simp)
apply vcg1_simp
apply (tactic {* all_tac *})
oops

(* vcg1_simp seems to be best bet so far  *)
lemma (in nipconst_flat_example) 
   "\<Turnstile> {(z,s). 0 < z<n> \<and> s<n> = z<n>}
	(CALL nipconst)
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
apply (insert vardistinct)
apply (simp)
(* apply vcg1_simp *)
apply (tactic {* all_tac *})
(* single stepping  *)
apply vcg1_step
apply simp
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
defer 1
defer 1
apply vcg1_step
apply auto
(* VCs *)
oops

(* CALL
apply (tactic {* HoareRecWFCall3 1 *})
apply (tactic {* res_inst_tac [("r","fun_wfmeasure_table " ^ "nipconst")] (thm "HRecWF'") 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HSP") 1 *})
apply (tactic {* rtac (thm "HKleymanAdapt00") 1 *})
*)

lemma (in nipconst_flat_example) 
   "\<Turnstile> {(z,s). s<n> = z<n> }
	nipconstBody
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
apply vcg1_simp
apply clarsimp
oops
(* schematic variables left over *)

(* FAILED EXPERIMENTS FROM HERE ON ------------------------------ *)

subsection {* Nip_const *}

locale nipconst_example =
  fixes    n         :: iname
    and	   q         :: iname
    and    nipconst     :: funame
    and	   nipconstBody :: expr
    and    nipconst'     :: funame
    and	   nipconst'Body :: expr
 defines   "nipconstBody \<equiv> LET
                         q =  n :0?
                       IN 
                         IF q
                           THEN n\<^sup>I
                           ELSE LET
                                  n = n :-- 
                                IN
                                  CALL nipconst'
                                END
                       END"
    and   "nipconst'Body \<equiv> LET
                          n = n:++
                        IN 
                          n\<^sup>I
                        END"
  assumes  vardistinct: "distinct [n,q]"
      (* function tables *)
      and  nipconst_fnbdy:  "funtable nipconst  = nipconstBody "
      and  nipconst'_fnbdy: "funtable nipconst' = nipconst'Body "
      (* measures *)
      and  nipconst_wfmeasure:  "fun_wfmeasure_table nipconst  = {}"
      and  nipconst'_wfmeasure: "fun_wfmeasure_table nipconst' = {}"
      (*
      and  nipconst_inv: "fun_assn_table nipconst = (
             {(z, s). s<n>=z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)},
             {(z, s, v). v = IVal z \<and> s<n>=z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and>
             s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)} )"
      *)
      (* invariants *)
      and  nipconst_preinv:  "fun_preassn_table  nipconst  == {}"
      and  nipconst_postinv: "fun_postassn_table nipconst  == {}"
      and  nipconst'preinv:  "fun_preassn_table  nipconst' == {(z,s). s<n> = z<n>}"
      and  nipconst'postinv: "fun_postassn_table nipconst' == {(z,s,v). v = IVal (z<n> + 1) \<and> s<n> = z<n> + 1}"
      and  nipconst_inv_holds: "\<Turnstile> (fun_preassn_table nipconst) (CALL nipconst) (fun_postassn_table nipconst)"

declare (in nipconst_example) nipconstBody_def[simp]
declare (in nipconst_example) nipconst_fnbdy[simp]
declare (in nipconst_example) nipconst_wfmeasure[simp]
declare (in nipconst_example) nipconst'_wfmeasure[simp]
declare (in nipconst_example) nipconst'Body_def[simp]
declare (in nipconst_example) nipconst'_fnbdy[simp]
declare (in nipconst_example) nipconst_preinv[simp]
declare (in nipconst_example) nipconst_postinv[simp]
declare (in nipconst_example) nipconst'preinv[simp]
declare (in nipconst_example) nipconst'postinv[simp]

lemma (in nipconst_example) 
   "\<Turnstile> {(z,s). s<n> = z<n>}
	nipconst'Body
      {(z,s,v). v = IVal (z<n> + 1) \<and> s<n> = z<n> + 1}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
apply vcg1_simp
done

lemma (in nipconst_example) 
   "\<Turnstile> {(z,s). s<n> = z<n> }
	nipconstBody
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
apply vcg1_simp
apply clarsimp
oops

(*
defer 1
apply rule
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule_tac x="z" in allE)
apply (rotate_tac -1)
defer 1
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule_tac x="z" in allE)
apply auto
oops
*)

lemma (in nipconst_example) 
   "\<Turnstile> {(z,s). s<n> = z<n> }
       nipconstBody
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
(* apply hoare2_simp  *)
apply vcg_step
defer 1
apply vcg_step
defer 1
apply vcg_step
defer 1
(* apply (tactic {* assume_tac 1 *}) *)
(* ORELSE *)
(* apply (tactic {* rtac (thm "HSP") 1 *}) *)
apply (tactic {* rtac (thm "HKleymanAdapt1") 1 *})
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HSP") 1 *})
apply (tactic {* rtac (thm "HCallAux2") 1 *})
apply (tactic {* rtac allI 1 *})
apply simp
apply auto
apply vcg_step
defer 1
apply vcg_step
defer 1
apply vcg_step
defer 1
apply vcg_step
defer 1
apply vcg_step
defer 1
apply vcg_step
defer 1
apply (tactic {* all_tac *})
apply clarsimp
defer 1
apply clarsimp
defer 1
apply rule
defer 1
apply (rule allI)+
apply (rule impI)
apply (rule conjI)
apply fastsimp
oops

(* a higher-order pathetic property *)
lemma (in nipconst_example) 
   "\<Turnstile> {(z,s). s<n> = z<n> }
	nipconstBody
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
(* 
apply hoare2_simp 
apply (tactic {* all_tac *})
apply auto
*)
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
apply simp
apply hoare2_step
defer 1
apply hoare2_step
defer 1
defer 1
apply hoare2_step
defer 1
apply hoare2_step
apply hoare2_step
apply hoare2_step
apply auto

apply hoare2_step
apply simp
(* fail on lookup *)
oops
(*
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
apply simp
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
apply hoare2_step
apply hoare2_step
apply clarsimp
defer 1
apply simp
apply simp
apply auto
oops
*)
(* rec *)
lemma (in nipconst_example) 
   "\<Turnstile> {(z,s). s<n> = z }
	nipconstBody
      {(z,s,v). v = IVal z \<and> s<n> = z}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
apply hoare_rec_simp 
oops

apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply simp
defer 1
apply simp
defer 1
apply simp
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply hoare_rec_step
defer 1
apply clarsimp
defer 1
defer 1
apply clarsimp
defer 1
defer 1
defer 1
apply (rule subsetI)
apply simp
defer 1
oops

end
