(*  
   File:        $RCSfile: ToyVCGex.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGex.thy,v 1.4 2003/05/24 22:09:47 a1hloidl Exp $

   Cleaned up VCG examples: swap, factorial

   non-rec versions run through with just a vcg_simp (and maybe some arith and more simp)
   rec version leaves ex quant formulae behind, that need inst
*)

theory ToyVCGex = ToyVCG + ToyPrelude + ToyHLbasic:
(* theory ToyVCGex = ToyHLVCG + ToyPrelude + ToyHLRules:*)

section {* VCG examples *}

(* --------------------------------------------------------------------------- *)
subsection {* \texttt{swap}: testing GetFi and PutFi *}

locale swap_example =
  fixes    m :: iname
    and	   n :: iname
    and	   q :: iname
    and	   z1 :: iname
    and	   z2 :: iname
    and	   lesser    :: ifldname
    and	   greater   :: ifldname
    and	   swap      :: funame
    and    SwapClass :: cname
    and	   swapBody  :: expr
    and    l1 :: locn
    and    M :: int    
    and    N :: int    
    and    M' :: int    
    and    N' :: int    
    and    curr_obj :: "int => int => obj"
  defines "swapBody \<equiv>  LET 
                m  = self\<bullet>lesser ;
                n  = self\<bullet>greater ;
                q  = m :> n
              IN
                IF q 
                  THEN LET
                         z1 = self\<bullet>lesser := n ; 
                         z2 = self\<bullet>greater := m 
                       IN
                         1\<^sup>z
                       END 
                  ELSE 0\<^sup>z
              END"
      and  "curr_obj x y == (SwapClass, (emptyi(lesser:=x))(greater:=y), emptyr)"
  assumes  swapfnbdy: "funtable swap = swapBody"
      and  swapClass: "classtable SwapClass = \<lparr> iflds = [lesser,greater], rflds = [], meths = \<lambda> mn. K mn \<rparr>"
      and  vardistinct: "distinct [m,n,q,z1,z2]"
      and  flddistinct: "distinct [lesser,greater]"

declare (in swap_example) swapBody_def [simp]
declare (in swap_example) swapfnbdy   [simp]

(* case distinction in post-condition *)
lemma (in swap_example) 
   "\<Turnstile> {(z,s). clock s = clock z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj M N)}	
	swapBody
      {(z,s,v). s\<lfloor>self\<rfloor> = Ref l1 \<and> 
                (M<N \<longrightarrow> fmap_lookup (heap s) l1 = Some (curr_obj M N)) \<and> 
                (N<M \<longrightarrow> fmap_lookup (heap s) l1 = Some (curr_obj N M)) \<and> 
                (N=M \<longrightarrow> fmap_lookup (heap s) l1 = Some (curr_obj N N))}"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def)
apply vcg_simp
done

lemma (in swap_example) 
   "\<Turnstile> {(z,s). clock s = clock z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj M N)}	
	swapBody
      {(z,s,v). clock s < clock z + 99}"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def)
apply vcg_simp
done
(* 99 is an upper bound on exec time *)

lemma (in swap_example) 
   "\<Turnstile> {(z,s). clock s = clock z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> fmap_lookup (heap s) l1 = Some (curr_obj M N)}	
	swapBody
      {(z,s,v). clock z + 1 < clock s}"
apply (insert vardistinct flddistinct)
apply (simp add: curr_obj_def)
apply vcg_simp
done
(* 1 is not an upper bound on exec time *)

(* --------------------------------------------------------------------------- *)
subsection {* Testing the VCGen: factorial *}

consts facspec :: "nat \<Rightarrow> nat"
primrec (* recdef   facspec "measure (\<lambda> n. n)" *)
 "facspec 0 = (1::nat)"
 "facspec (Suc n) = (facspec n) * (Suc n)"

(* ToDo: int version of facspec would be much easier to use *)
(*
consts facspec_int :: "int \<Rightarrow> int"
recdef facspec_int "measure (\<lambda> n. n)"
 "facspec_int = \<lambda> n . if (0 < n) then (n * (facspec_int (n - 1))) else (1::int)"
*)

locale fac_example =
 fixes n :: iname
  and  m :: iname
  and  q :: iname
  and  fac ::funame
  and  facBody :: expr
defines 
"facBody \<equiv> LET 
              m = m :* n ;
              n = n :-- ;
              q = n :0?
            IN 
              IF q
                THEN m\<^sup>I
                ELSE (CALL fac)
            END"
assumes vardistinct:   "distinct [n,m,q]"
    and bonzo22:       "m \<noteq> n" 
    and fac_fnbody:    "funtable fac == facBody"
    and fac_wfmeasure: "fun_wfmeasure_table fac == inv_image less_than (\<lambda>s . nat (s<n>))"
(*
    and fac_preinv:    "fun_preassn_table fac == {(z,s). 0 < z<m> \<and> 0 < z<n> \<and> s<m>=z<m> \<and> s<n>=z<n>}"
    and fac_postinv:   "fun_postassn_table fac == {(z,s,v). v = IVal ((z<m>) * (int (facspec (nat (z<n>)))))}"

declare (in fac_example) fac_preinv    [simp]
declare (in fac_example) fac_postinv   [simp]
*)
declare (in fac_example) fac_fnbody    [simp]
declare (in fac_example) facBody_def   [simp]
declare (in fac_example) fac_wfmeasure [simp]

lemma (in fac_example) 
 bonzo13: "wf (inv_image less_than (\<lambda>s. nat (s<n>)))"
by (rule wf_inv_image, rule wf_less_than)

subsubsection {* abstracted over input *}

(* 
 stupid lemmas needed for nat-int conversion
 unproven so far
*)

lemma (in fac_example) bonzo_1066:

 "[| 0 < N ; 0 < M |] ==>
  M * N * int (facspec (nat (N - 1))) = M * int (facspec (nat N))"
sorry

lemma (in fac_example) bonzo_1067:
 "[| 0 < (N::int) ; 0 < M |] ==> 0 < M * N"
sorry

lemma (in fac_example) bonzo_1068:
 "[| 0 < (N::int) ; N - 1 \<noteq> 0 |] ==> 0 < N - 1"

apply arith
done

lemma (in fac_example) fact_is_cool2:
   "\<Turnstile> {(z,s). 0 < z<n> \<and> s<n> = z<n> \<and> s<m> = z<m> \<and> 0 < z<m>}
	(CALL fac)
      {(z,s,v). v = IVal ((z<m>) * int (facspec (nat (z<n>))))}"
apply (insert vardistinct bonzo22)
apply simp
apply vcg_simp
apply auto
apply (erule_tac x="tickn 14
                     (ivarupdate
                      (ivarupdate (ivarupdate (incrcallcount s') m ((z<m>) * (z<n>))) n
                       (z<n> - 1))
                      q 0)" in allE)
apply clarsimp
defer 1
apply (rule_tac x="tickn 14
                     (ivarupdate
                      (ivarupdate (ivarupdate (incrcallcount s') m ((z<m>) * (z<n>))) n
                       (z<n> - 1))
                      q 0)" in exI)
apply clarsimp
apply (rule_tac x="tickn 14
                     (ivarupdate
                      (ivarupdate (ivarupdate (incrcallcount s') m ((z<m>) * (z<n>))) n
                       (z<n> - 1))
                      q 0)" in exI)
apply clarsimp
apply rule
apply (rotate_tac 1)
apply (erule thin_rl)
apply (simp add: bonzo_1068)
apply rule
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (simp add: bonzo_1067)
apply (simp add: inv_image_def)
apply (subgoal_tac "(tickn 14
             (ivarupdate
               (ivarupdate (ivarupdate (incrcallcount s') m ((z<m>) * (z<n>))) n
                 (z<n> - 1))
               q 0),
            s')
           \<in> inv_image less_than (\<lambda> s. nat (s<n>))")
apply (drule mp)
apply clarsimp
apply rule
apply (simp add: bonzo_1068)
apply (simp add: bonzo_1067)
apply (simp add: bonzo_1066)
apply (simp add: inv_image_def)
done
(* hurrayy *)

subsubsection {* resource properties *}

lemma (in fac_example) 
(*    "[| \<Turnstile> (fun_preassn_table fac) (CALL fac) (fun_postassn_table fac) |] ==> *)
    "relTakestimelt (emptyState (|istore := (fun_upd (fun_upd (istore emptyState) n 5) m 1)|))	99 (CALL fac)"
apply (insert vardistinct)
apply (simp add: relTakestimelt_def)
apply vcg_simp
apply clarsimp
apply (tactic {* all_tac *})
(* needs instantiation of z similar to above proof *)
oops


end
