(*  
   File:        ToyVCGtest5.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: T.thy,v 1.2 2003/05/29 11:46:07 a1hloidl Exp $

   More tests of the VCG (Nipkow-constant).

   Bottom line:
   using vcg1 and doing single stepping, the ind hyp is discharged, i.e. adaptation
   rule succeeds here
   result still has schematic variables (ToDo: compare with vcg_simp where rules differ)
   vcg1_simp doesn't use the same route (ToDo: compare order of single stepping with full tactic)
*)

(* theory ToyVCGtest5 = ToyHLVCG + ToyPrelude + ToyHLRules: *)
theory T = ToyVCG + ToyPrelude + ToyHLbasic:

section {* Testing the VCGen *}

subsection {* konst *}

locale konst_meth_example =
  fixes    n         :: iname
    and	   m         :: iname
    and	   q         :: iname
    and	   z         :: iname
    and    l1        :: locn
    and    count     :: ifldname
    and    konst     :: mname
    and	   konstBody :: expr
    and    konstMBody :: methbody
    and    Konst      :: cname
    and   a_cool_heap :: "int => state => bool"
 defines  "konstBody \<equiv> LET
                         n = GetFi self count ;
                         q =  n :0?
                       IN 
                         IF q
                           THEN n\<^sup>I
                           ELSE LET
                                  n = GetFi self count ;
                                  n = n :--   ;
                                  z = PutFi self count n ;
                                  z = [class Konst]\<bullet>konst(self) ;
                                  n = GetFi self count ;
                                  n = n :++  ;
                                  z = PutFi self count n
                                IN 
                                  n\<^sup>I
                                END
                       END"
      and  "konstMBody \<equiv> (({n,z,q},{}), konstBody)"
      and  "a_cool_heap N s == (s\<lfloor>self\<rfloor> = Ref l1) \<and> (s\<lless>l1\<ggreater> = Some (Konst, emptyi(count := N), emptyr))"
  assumes  vardistinct: "distinct [n,m,q,z]"
      (* function tables *)
      (* and  konst_methbdy:  "methtable konst  = konstMBody " *)
      (* measures *)
      (* and  konst_wfmeasure:  "fun_wfmeasure_table konst = inv_image less_than (\<lambda>s . nat (s<n>))" *)
      and  konstclassmtable [simp]: "konstClassmtable konst = konstMBody"
      and  konst_class:  "classtable KonstClass == \<lparr> iflds = [count], rflds = [], 
						      meths = konstClassmtable \<rparr>"
      (* invariants *)
(*
      and  konst_preinv:  "fun_preassn_table  konst == {(z,s). s<n> = z<n>}"
      and  konst_postinv: "fun_postassn_table konst == {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
      and  konst_inv_holds: "\<Turnstile> (fun_preassn_table konst) (CALL konst) (fun_postassn_table konst)"
*)

declare (in konst_meth_example) konstBody_def[simp]
declare (in konst_meth_example) konstMBody_def[simp]
declare (in konst_meth_example) konstclassmtable[simp]
declare (in konst_meth_example) konst_class[simp]
declare (in konst_meth_example) a_cool_heap_def [simp]

lemma (in konst_meth_example) 
   "\<Turnstile> {(z,s). a_cool_heap N s}
	[class Konst]\<bullet>konst(self)
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = N}"
apply (insert vardistinct)
apply (simp)
(* apply vcg1_simp *)
apply vcg1_step
(* 
apply (tactic {* HoareRecWFInvokestatic 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HInvokeStatic") 1 *})
apply (tactic {* rtac allI 1 *})  
*)
apply simp
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
defer 1
apply vcg1_step
apply vcg1_step
(* rec invoke *)
apply (rule "HWC")
apply assumption
defer 1
apply vcg1_step
defer 1
defer 1
apply clarsimp
apply (rule_tac x="l1" in exI)
apply (rule conjI)
defer 1
apply (rule conjI)
defer 1
apply (rule_tac x="Konst" in exI)
apply (rule_tac x="emptyi(count := N)" in exI)
apply (rule conjI)
apply (rule_tac x="emptyr" in exI)
defer 1
apply (rule_tac x="l1" in exI)
apply (rule conjI)
defer 1
apply (rule conjI)
apply (rule_tac x="Konst" in exI)
apply (rule_tac x="emptyi(count := N)" in exI)
apply (rule_tac x="emptyr" in exI)
defer 1
apply (rule conjI)
defer 1
defer 1
apply clarsimp
apply (rule_tac x="l1" in exI)





apply (tactic {* all_tac *})
oops

subsection {* konst *}

locale konst_example =
  fixes    n         :: iname
    and	   m         :: iname
    and	   q         :: iname
    and	   z         :: iname
    and    konst     :: funame
    and	   konstBody :: expr
 defines  "konstBody \<equiv> LET
                         q =  n :0?
                       IN 
                         IF q
                           THEN n\<^sup>I
                           ELSE LET
                                  n = n :--  ;
                                  m = m :++  ;
                                  z = CALL konst 
                                IN 
                                  m\<^sup>I
                                END
                       END"
  assumes  vardistinct: "distinct [n,m,q,z]"
      (* function tables *)
      and  konst_fnbdy:  "funtable konst  = konstBody "
      (* measures *)
      and  konst_wfmeasure:  "fun_wfmeasure_table konst = inv_image less_than (\<lambda>s . nat (s<n>))"
      (* invariants *)
(*
      and  konst_preinv:  "fun_preassn_table  konst == {(z,s). s<n> = z<n>}"
      and  konst_postinv: "fun_postassn_table konst == {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
      and  konst_inv_holds: "\<Turnstile> (fun_preassn_table konst) (CALL konst) (fun_postassn_table konst)"
*)

declare (in konst_example) konstBody_def[simp]
declare (in konst_example) konst_fnbdy[simp]
declare (in konst_example) konst_wfmeasure[simp]
(*
declare (in konst_example) konst_preinv[simp]
declare (in konst_example) konst_postinv[simp]
*)

lemma (in konst_example) 
   "\<Turnstile> {(z,s). 0 < z<n> \<and> s<n> = z<n>}
	(CALL konst)
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
apply (insert vardistinct)
apply (simp)
apply vcg1_simp
apply (tactic {* all_tac *})
oops

(* vcg1_simp until recursive call  *)
lemma (in konst_example) 
   "\<Turnstile> {(z,s). 0 < z<n> \<and> s<n> = z<n> \<and> s<m> = 0}
	(CALL konst)
      {(z,s,v). v = IVal (z<n>) \<and> s<m> = z<n>}"
apply (insert vardistinct)
apply (simp)
(* apply vcg1_simp *)
apply (tactic {* all_tac *})
(* single stepping  *)
apply vcg1_step
apply simp
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
defer 1
apply vcg1_step
defer 1
apply vcg1_step
apply vcg1_step
apply vcg1_step
(* CALL *)
(** apply vcg1_step *)
(*** apply (tactic {* HoareRecWFCall3 1 *}) *)
apply (tactic {* res_inst_tac [("r","fun_wfmeasure_table " ^ "konst")] (thm "HRecWF'") 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HSP") 1 *})
apply (tactic {* rtac (thm "HKleymanAdapt00") 1 *})
apply simp
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
defer 1
defer 1
defer 1
defer 1
defer 1
defer 1
apply vcg1_step
defer 1
apply vcg1_step
apply vcg1_step
apply vcg1_step
(* CALL: tying the knot *)
apply (rule "HWC")
apply assumption
defer 1
apply vcg1_step
apply simp
defer 1
apply simp
defer 1
apply simp
defer 1
apply simp
defer 1
apply simp
defer 1
apply simp
defer 1
apply (rule subsetI)
apply simp
defer 1
apply (rule subsetI)
apply simp
defer 1
defer 1
apply (rule subsetI)
apply simp
defer 1
apply fastsimp
(* VCs w/ some schematic vars *)
oops


(* CALL
apply (tactic {* HoareRecWFCall3 1 *})
apply (tactic {* res_inst_tac [("r","fun_wfmeasure_table " ^ "konst")] (thm "HRecWF'") 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HSP") 1 *})
apply (tactic {* rtac (thm "HKleymanAdapt00") 1 *})
*)


lemma (in konst_example) 
   "\<Turnstile> {(z,s). s<n> = z<n> }
	konstBody
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
apply vcg1_simp
apply clarsimp
oops
(* schematic variables left over *)

(* FAILED EXPERIMENTS FROM HERE ON ------------------------------ *)

subsection {* Nip_const *}

locale konst_example =
  fixes    n         :: iname
    and	   q         :: iname
    and    konst     :: funame
    and	   konstBody :: expr
    and    konst'     :: funame
    and	   konst'Body :: expr
 defines   "konstBody \<equiv> LET
                         q =  n :0?
                       IN 
                         IF q
                           THEN n\<^sup>I
                           ELSE LET
                                  n = n :-- 
                                IN
                                  CALL konst'
                                END
                       END"
    and   "konst'Body \<equiv> LET
                          n = n:++
                        IN 
                          n\<^sup>I
                        END"
  assumes  vardistinct: "distinct [n,q]"
      (* function tables *)
      and  konst_fnbdy:  "funtable konst  = konstBody "
      and  konst'_fnbdy: "funtable konst' = konst'Body "
      (* measures *)
      and  konst_wfmeasure:  "fun_wfmeasure_table konst  = {}"
      and  konst'_wfmeasure: "fun_wfmeasure_table konst' = {}"
      (*
      and  konst_inv: "fun_assn_table konst = (
             {(z, s). s<n>=z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)},
             {(z, s, v). v = IVal z \<and> s<n>=z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and>
             s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)} )"
      *)
      (* invariants *)
      and  konst_preinv:  "fun_preassn_table  konst  == {}"
      and  konst_postinv: "fun_postassn_table konst  == {}"
      and  konst'preinv:  "fun_preassn_table  konst' == {(z,s). s<n> = z<n>}"
      and  konst'postinv: "fun_postassn_table konst' == {(z,s,v). v = IVal (z<n> + 1) \<and> s<n> = z<n> + 1}"
      and  konst_inv_holds: "\<Turnstile> (fun_preassn_table konst) (CALL konst) (fun_postassn_table konst)"

declare (in konst_example) konstBody_def[simp]
declare (in konst_example) konst_fnbdy[simp]
declare (in konst_example) konst_wfmeasure[simp]
declare (in konst_example) konst'_wfmeasure[simp]
declare (in konst_example) konst'Body_def[simp]
declare (in konst_example) konst'_fnbdy[simp]
declare (in konst_example) konst_preinv[simp]
declare (in konst_example) konst_postinv[simp]
declare (in konst_example) konst'preinv[simp]
declare (in konst_example) konst'postinv[simp]

lemma (in konst_example) 
   "\<Turnstile> {(z,s). s<n> = z<n>}
	konst'Body
      {(z,s,v). v = IVal (z<n> + 1) \<and> s<n> = z<n> + 1}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
apply vcg1_simp
done

lemma (in konst_example) 
   "\<Turnstile> {(z,s). s<n> = z<n> }
	konstBody
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
apply vcg1_simp
apply clarsimp
oops

(*
defer 1
apply rule
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule_tac x="z" in allE)
apply (rotate_tac -1)
defer 1
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule_tac x="z" in allE)
apply auto
oops
*)

lemma (in konst_example) 
   "\<Turnstile> {(z,s). s<n> = z<n> }
       konstBody
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
(* apply hoare2_simp  *)
apply vcg_step
defer 1
apply vcg_step
defer 1
apply vcg_step
defer 1
(* apply (tactic {* assume_tac 1 *}) *)
(* ORELSE *)
(* apply (tactic {* rtac (thm "HSP") 1 *}) *)
apply (tactic {* rtac (thm "HKleymanAdapt1") 1 *})
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HSP") 1 *})
apply (tactic {* rtac (thm "HCallAux2") 1 *})
apply (tactic {* rtac allI 1 *})
apply simp
apply auto
apply vcg_step
defer 1
apply vcg_step
defer 1
apply vcg_step
defer 1
apply vcg_step
defer 1
apply vcg_step
defer 1
apply vcg_step
defer 1
apply (tactic {* all_tac *})
apply clarsimp
defer 1
apply clarsimp
defer 1
apply rule
defer 1
apply (rule allI)+
apply (rule impI)
apply (rule conjI)
apply fastsimp
oops

(* a higher-order pathetic property *)
lemma (in konst_example) 
   "\<Turnstile> {(z,s). s<n> = z<n> }
	konstBody
      {(z,s,v). v = IVal (z<n>) \<and> s<n> = z<n>}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
(* 
apply hoare2_simp 
apply (tactic {* all_tac *})
apply auto
*)
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
apply simp
apply hoare2_step
defer 1
apply hoare2_step
defer 1
defer 1
apply hoare2_step
defer 1
apply hoare2_step
apply hoare2_step
apply hoare2_step
apply auto

apply hoare2_step
apply simp
(* fail on lookup *)
oops
(*
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
apply simp
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
defer 1
apply hoare2_step
apply hoare2_step
apply hoare2_step
apply clarsimp
defer 1
apply simp
apply simp
apply auto
oops
*)
(* rec *)
lemma (in konst_example) 
   "\<Turnstile> {(z,s). s<n> = z }
	konstBody
      {(z,s,v). v = IVal z \<and> s<n> = z}"
apply (insert vardistinct)
apply (simp) (* unfold body *)
apply hoare_rec_simp 
oops

apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply simp
defer 1
apply simp
defer 1
apply simp
defer 1
apply hoare_rec_step
defer 1
apply hoare_rec_step
apply hoare_rec_step
defer 1
apply clarsimp
defer 1
defer 1
apply clarsimp
defer 1
defer 1
defer 1
apply (rule subsetI)
apply simp
defer 1
oops

end
