theory ExampleKonst = ToyVCG + ToyPrelude + ToyHLbasic:


locale nipconst_flat_example =
  fixes    n         :: iname
    and	   q         :: iname
    and	   z         :: iname
    and    nipconst     :: funame
 assumes funtablenip[simp]:
  "funtable nipconst = (LET
                         q =  Primop (\<lambda> x y. if x<0 then 1 else 0) n n
                       IN 
                         IF q
                           THEN n\<^sup>I
                           ELSE LET
                                  n = n :--  ;
                                  z = CALL nipconst ;
                                  n = n:++
                                IN 
                                  n\<^sup>I
                                END
                       END)" (*  :: int expr)" *)
  assumes  vardistinct: "distinct [n,q,z]"


lemma (in nipconst_flat_example) 
   "\<Turnstile> {(z,s). s<n> =  z<n>}
	(CALL nipconst)
      {(z,s,v). s<n> =  z<n>}"
apply (insert vardistinct)
(* apply vcg1_simp *)
apply (tactic {* HoareRecWFCall3 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HSP") 1 *})
apply (tactic {* rtac (thm "HKleymanAdapt00") 1 *})
apply simp
apply (rule "HLetI")
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1
apply vcg1_step
defer 1

(*
lemma HLetI: "\<lbrakk> \<Turnstile> R e' Q;
	        \<Turnstile> P e {(z,s,v). (z,ivarupdate (tick s) x  (theival v)) \<in> R} \<rbrakk> 
       \<Longrightarrow> \<Turnstile> P (LET x=e IN e' END) Q"
by (simp add: hoare_valid_def, fastsimp elim: evalLeti_cases)
*)

lemma constadapt:  "\<Turnstile> {(N,s). s<n> =  N} (CALL nipconst) {(N,s,v). s<n> =  N} \<Longrightarrow> 
                    \<Turnstile> {(N,s). s<n> + 1 =  N} (CALL nipconst) {(N,s,v). s<n> + 1 =  N}"
apply (erule HConseq)
apply auto
done


lemma HRec: "(\<Turnstile> P (CALL fn) Q \<Longrightarrow> \<Turnstile> (apsnd (tickn 1 o incrcallcount) ` P) (funtable fn) Q) \<Longrightarrow> \<Turnstile> P (CALL fn) Q"
sorry



lemma (in nipconst_flat_example) 
   "\<Turnstile> {(N,s). s<n> =  N}
	(CALL nipconst)
      {(N,s,v). s<n> =  N}"
apply (insert vardistinct)
apply (rule HRec)
apply simp
apply (rule HSP)
apply (rule HLetI)
apply (rule HIf)
apply (rule HVar)
apply (rule HLetI)
apply (rule HLetI)
apply (rule HLetI)
apply (rule hoarebasics)
apply (rule hoarebasics)
apply clarsimp
apply (rule constadapt)
apply assumption
apply (rule hoarebasics)
apply (rule subset_refl)
apply (rule hoarebasics)
apply auto
done

end
